/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.pipeline;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.Info;
import com.cognos.portal.schemas.fragments.Meta;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RequestMetaProcess
extends Stage {
    private ServiceLogger logger;

    public RequestMetaProcess(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(RequestMetaProcess.class) : null;
    }

    @Override
    public void executeImpl(StageContext context) throws PipelineException {
        block12: {
            Parameters controller = context.getControllerParams();
            if (controller != null) {
                String target = controller.getValue("frag-target");
                Parameters params = new Parameters();
                params.add("frag-directive", "meta-only");
                if (target.indexOf("://") == -1) {
                    String application = controller.getValue("frag-application");
                    target = "bus://" + application + target;
                    params.add("frag-debug", "src");
                }
                try {
                    Fragment fragment = context.getFragment();
                    if (fragment == null) break block12;
                    InputStream in = context.getEnv().getTargetStream(target, params);
                    XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(in);
                    Meta meta = null;
                    Info info = null;
                    while (xsr.hasNext()) {
                        int event = xsr.next();
                        if (event == 1) {
                            String localName = xsr.getLocalName();
                            if ("meta".equals(localName)) {
                                meta = new Meta();
                                meta.read(xsr);
                                fragment.setMeta(meta);
                            } else if ("info".equals(localName)) {
                                info = new Info();
                                info.read(xsr);
                                fragment.setInfo(info);
                            }
                        }
                        if (info == null || meta == null) continue;
                        break;
                    }
                }
                catch (DashboardException ex) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("execute failure", ex);
                    }
                    throw new PipelineException("error while requesting fragment stream", ex);
                }
                catch (XMLStreamException ex) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("execute failure", ex);
                    }
                    throw new PipelineException("error while reading/writing stream", ex);
                }
            }
        }
    }

    @Override
    public boolean canShare() {
        return true;
    }
}

