/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.pipeline.helper;

import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.server.document.DashboardDocument;
import com.cognos.portal.fragment.server.pipeline.helper.CMParseUtils;
import com.cognos.portal.fragment.server.pipeline.helper.DeploymentReferences;
import com.cognos.portal.fragment.server.pipeline.helper.NavHelper;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.MessagesManager;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

abstract class BaseFragmentObject {
    static final String FRAG_HEADER = "frag-header";
    static final String FRAG_HEADERPAGEEDIT = "frag-headerPageEdit";
    protected String context;
    protected DeploymentReferences deploymentReferences;
    protected String id;
    protected String searchPath;
    protected String name;
    protected String type;
    protected boolean showPageEdit = false;
    protected boolean showHeader = false;
    protected PipelineContext currentContext;
    protected Environment env;
    protected Parameters parameters;

    public BaseFragmentObject(PipelineContext currentContext) {
        String hideHeaderProperty;
        this.currentContext = currentContext;
        this.env = currentContext.getEnv();
        this.parameters = (Parameters)currentContext.getParam("params");
        String headerParam = this.parameters.getValue(FRAG_HEADER);
        if (headerParam != null && Boolean.valueOf(headerParam).booleanValue() && ((hideHeaderProperty = (String)this.env.getProperty("hideDefaultHeader")) == null || !Boolean.valueOf(hideHeaderProperty).booleanValue())) {
            this.showHeader = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public void read(XMLStreamReader xsr) throws XMLStreamException {
        int level = 0;
        this.type = this.readType(xsr);
        while (xsr.hasNext()) {
            int event = xsr.next();
            switch (event) {
                case 1: {
                    if (level == 0) {
                        String localName = xsr.getLocalName();
                        if ("defaultName".equals(localName)) {
                            this.name = CMParseUtils.readCMValue(xsr, "value");
                            break;
                        }
                        if ("storeID".equals(localName)) {
                            this.id = CMParseUtils.readCMValue(xsr, "value");
                            break;
                        }
                        if ("searchPath".equals(localName)) {
                            this.searchPath = CMParseUtils.readCMValue(xsr, "value");
                            break;
                        }
                        if (this.readItem(xsr, localName)) break;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level >= 0) break;
                    return;
                }
            }
        }
    }

    protected abstract boolean readItem(XMLStreamReader var1, String var2) throws XMLStreamException;

    public abstract void write(XMLStreamWriter var1) throws XMLStreamException;

    protected void writeMessageFragment(String instanceId, String messageId, String preferredTitle, XMLStreamWriter xsw) throws XMLStreamException {
        if (instanceId != null) {
            xsw.writeStartElement("fragmentInstance");
            xsw.writeAttribute("id", instanceId);
        } else {
            xsw.writeStartElement("fragmentReference");
        }
        xsw.writeAttribute("href", "/displayMessage");
        xsw.writeStartElement("custom");
        if (preferredTitle != null) {
            xsw.writeStartElement("param");
            xsw.writeAttribute("name", "title");
            xsw.writeCharacters(preferredTitle);
            xsw.writeEndElement();
        }
        xsw.writeStartElement("param");
        xsw.writeAttribute("name", "message");
        xsw.writeCharacters(MessagesManager.getInstance().getMessage(this.env.getProductLocale(), messageId));
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndElement();
    }

    protected void writeCustomProperties(XMLStreamWriter xsw) throws XMLStreamException {
        if (this.context != null && this.context.length() > 0) {
            xsw.writeStartElement("custom");
            XMLStreamReader contextReader = XMLStreamFactory.createXMLStreamReader(new StringReader(this.context));
            String portletState = null;
            String instancePortletHandle = null;
            String wsrpExternalRefExtension = null;
            while (contextReader.hasNext()) {
                int event = contextReader.next();
                if (event != 1) continue;
                String _localName = contextReader.getLocalName();
                String _namespaceURI = contextReader.getNamespaceURI();
                if ("portletState".equals(_localName)) {
                    portletState = contextReader.getElementText();
                    continue;
                }
                if ("portletHandle".equals(_localName)) {
                    instancePortletHandle = contextReader.getElementText();
                    continue;
                }
                if (!"state".equals(_localName) || !"http://developer.cognos.com/schemas/cps/wsrp/extensions/1/".equals(_namespaceURI)) continue;
                StringWriter writer = new StringWriter();
                StaxUtils.copyCurrentElement(contextReader, XMLStreamFactory.createXMLStreamWriter(writer));
                wsrpExternalRefExtension = writer.getBuffer().toString();
            }
            if (portletState != null && portletState.length() > 0) {
                Parameters customs = DashboardDocument.decodeCustoms(portletState);
                if (customs != null) {
                    for (Parameters.NameValuePair nvp : customs) {
                        DeploymentReferences.DeploymentReference cmDeployementRefValue;
                        String name = nvp.getName();
                        String value = nvp.getValue();
                        xsw.writeStartElement("param");
                        xsw.writeAttribute("name", name);
                        if (this.deploymentReferences != null && (cmDeployementRefValue = (DeploymentReferences.DeploymentReference)this.deploymentReferences.get(name)) != null && cmDeployementRefValue.storeID != null && cmDeployementRefValue.searchPath != null) {
                            value = value != null && value.startsWith("storeID(\"") ? "storeID(\"" + cmDeployementRefValue.storeID + "\")" : (value != null && value.startsWith("storeID('") ? "storeID('" + cmDeployementRefValue.storeID + "')" : (value != null && value.startsWith("/") ? cmDeployementRefValue.searchPath : cmDeployementRefValue.storeID));
                        }
                        if (value != null) {
                            xsw.writeCharacters(value);
                        }
                        xsw.writeEndElement();
                    }
                } else {
                    xsw.writeStartElement("param");
                    xsw.writeAttribute("name", "wsrp_portlet_context");
                    xsw.writeCharacters(portletState);
                    xsw.writeEndElement();
                    xsw.writeStartElement("param");
                    xsw.writeAttribute("name", "wsrp_portlet_handle");
                    xsw.writeCharacters(instancePortletHandle);
                    xsw.writeEndElement();
                    if (wsrpExternalRefExtension != null && this.deploymentReferences != null) {
                        this.writeWSRPStateExtension(wsrpExternalRefExtension, xsw);
                    }
                }
            }
            xsw.writeEndElement();
        }
    }

    private void writeWSRPStateExtension(String wsrpExternalRefExtension, XMLStreamWriter xsw) throws XMLStreamException {
        XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(new StringReader(wsrpExternalRefExtension));
        StringBuffer externalRefsExtension = null;
        while (xsr.hasNext()) {
            String navIdFormSearchPath;
            String navIdFormStoreId;
            int event = xsr.next();
            if (event != 1 || !"externalRef".equals(xsr.getLocalName())) continue;
            String name = xsr.getAttributeValue("", "name");
            String type = xsr.getAttributeValue("", "type");
            String value = xsr.getElementText();
            DeploymentReferences.DeploymentReference deploymentRef = (DeploymentReferences.DeploymentReference)this.deploymentReferences.get(name);
            if (deploymentRef == null) continue;
            String newValue = null;
            if (type != null && "cm".equals(type)) {
                String cmValue = value != null && value.startsWith("storeID(\"") ? "storeID(\"" + deploymentRef.storeID + "\")" : (value != null && value.startsWith("storeID('") ? "storeID('" + deploymentRef.storeID + "')" : (value != null && value.startsWith("/") ? deploymentRef.searchPath : deploymentRef.storeID));
                if (!cmValue.equals(value)) {
                    newValue = cmValue;
                }
            } else {
                navIdFormStoreId = NavHelper.getNavIdFromCMId(deploymentRef.storeID);
                if (navIdFormStoreId != null && !navIdFormStoreId.equals(value) && (navIdFormSearchPath = NavHelper.getNavIdFromCMSearchPath(deploymentRef.searchPath)) != null && !navIdFormSearchPath.equals(value)) {
                    newValue = navIdFormStoreId;
                }
            }
            if (newValue != null) {
                if (externalRefsExtension == null) {
                    externalRefsExtension = new StringBuffer();
                }
                externalRefsExtension.append("<cpsext:externalRef name=\"");
                EncodingUtils.xmlEncode(name, externalRefsExtension);
                externalRefsExtension.append("\">");
                EncodingUtils.xmlEncode(newValue, externalRefsExtension);
                externalRefsExtension.append("</cpsext:externalRef>");
            }
            if ((navIdFormStoreId = NavHelper.getNavIdFromCMId(deploymentRef.storeID)) == null || navIdFormStoreId.equals(value) || (navIdFormSearchPath = NavHelper.getNavIdFromCMSearchPath(deploymentRef.searchPath)) == null || navIdFormSearchPath.equals(value)) continue;
            if (externalRefsExtension == null) {
                externalRefsExtension = new StringBuffer();
            }
            externalRefsExtension.append("<cpsext:externalRef name=\"");
            EncodingUtils.xmlEncode(name, externalRefsExtension);
            externalRefsExtension.append("\">");
            EncodingUtils.xmlEncode(navIdFormStoreId, externalRefsExtension);
            externalRefsExtension.append("</cpsext:externalRef>");
        }
        if (externalRefsExtension != null) {
            xsw.writeStartElement("param");
            xsw.writeAttribute("name", "wsrp_portlet_state_extension");
            xsw.writeCharacters("<cpsext:state xmlns:cpsext=\"http://developer.cognos.com/schemas/cps/wsrp/extensions/1/\">" + externalRefsExtension.toString() + "</cpsext:state>");
            xsw.writeEndElement();
        }
    }

    protected void writeBannerLayout(XMLStreamWriter xsw) throws XMLStreamException {
        if (!this.showHeader) {
            return;
        }
        xsw.writeStartElement("row");
        xsw.writeStartElement("column");
        xsw.writeAttribute("width", "100%");
        xsw.writeStartElement("fragment");
        xsw.writeAttribute("refid", "banner");
        xsw.writeStartElement("layoutProperties");
        xsw.writeStartElement("param");
        xsw.writeAttribute("name", "caption");
        xsw.writeCharacters("false");
        xsw.writeEndElement();
        xsw.writeStartElement("param");
        xsw.writeAttribute("name", "borders");
        xsw.writeCharacters("false");
        xsw.writeEndElement();
        xsw.writeStartElement("param");
        xsw.writeAttribute("name", "overflow");
        xsw.writeCharacters("hidden");
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndElement();
    }

    protected void writeBannerFragment(XMLStreamWriter xsw) throws XMLStreamException {
        if (!this.showHeader) {
            return;
        }
        xsw.writeStartElement("fragmentInstance");
        xsw.writeAttribute("id", "banner");
        xsw.writeAttribute("href", "/fragmentproducer/utilities/banner");
        xsw.writeStartElement("custom");
        xsw.writeStartElement("param");
        xsw.writeAttribute("name", "bannerOptions");
        xsw.writeStartElement("value");
        xsw.writeCharacters("HRB");
        xsw.writeEndElement();
        xsw.writeStartElement("value");
        xsw.writeCharacters("HMM");
        xsw.writeEndElement();
        xsw.writeStartElement("value");
        xsw.writeCharacters("HHM");
        xsw.writeEndElement();
        xsw.writeEndElement();
        if (this.searchPath != null) {
            xsw.writeStartElement("param");
            xsw.writeAttribute("name", "pageSearchPath");
            xsw.writeCharacters(this.searchPath);
            xsw.writeEndElement();
        }
        if (this.name != null) {
            xsw.writeStartElement("param");
            xsw.writeAttribute("name", "displayText");
            xsw.writeCharacters(this.name);
            xsw.writeEndElement();
        }
        xsw.writeStartElement("param");
        xsw.writeAttribute("name", "mode");
        xsw.writeCharacters("page");
        xsw.writeEndElement();
        if (this.showPageEdit) {
            xsw.writeStartElement("param");
            xsw.writeAttribute("name", "pageId");
            xsw.writeCharacters(this.id);
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
        xsw.writeEndElement();
    }

    protected void writeFragmentStart(XMLStreamWriter xsw) throws XMLStreamException {
        if (this.showHeader) {
            xsw.writeStartElement("page");
            xsw.writeStartElement("layout");
            xsw.writeAttribute("version", "2.0");
            this.writeBannerLayout(xsw);
            xsw.writeStartElement("row");
            xsw.writeStartElement("column");
            xsw.writeAttribute("width", "100%");
            xsw.writeStartElement("fragment");
            xsw.writeAttribute("refid", "body");
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            this.writeBannerFragment(xsw);
            xsw.writeStartElement("fragmentInstance");
            xsw.writeAttribute("id", "body");
        } else {
            xsw.writeStartElement("fragmentReference");
        }
    }

    protected void writeFragmentEnd(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeEndElement();
        if (this.showHeader) {
            xsw.writeEndElement();
        }
    }

    protected void writeInfo(XMLStreamWriter xsw) throws XMLStreamException {
        if (this.name != null) {
            xsw.writeStartElement("info");
            xsw.writeStartElement("title");
            xsw.writeCharacters(this.name);
            xsw.writeEndElement();
            xsw.writeEndElement();
        }
    }

    private String readType(XMLStreamReader xsr) {
        int sep;
        String cmType = xsr.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (cmType != null && (sep = cmType.indexOf(58)) > 0) {
            cmType = cmType.substring(sep + 1);
        }
        return cmType;
    }
}

