/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.pipeline.helper;

import com.cognos.portal.fragment.server.pipeline.helper.BaseFragmentObject;
import com.cognos.portal.fragment.server.pipeline.helper.CMParseUtils;
import com.cognos.portal.fragment.server.pipeline.helper.DeploymentReferences;
import com.cognos.portal.fragment.server.producer.CacheFault;
import com.cognos.portal.fragment.server.producer.PortletProducerCache;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class Fragment
extends BaseFragmentObject {
    private String producerId;
    private String permissions;
    private boolean disabled;
    private boolean locked;
    private String handle;

    public Fragment(PipelineContext currentContext) {
        super(currentContext);
    }

    String getId() {
        return this.id;
    }

    String getProducerId() {
        return this.producerId;
    }

    void buildHref(StringBuffer href) {
        if (this.type == null || "portlet".equals(this.type)) {
            href.append("/cmprovider");
            href.append('/').append(this.producerId);
            href.append('/').append(this.id);
        } else {
            href.append('/').append(this.type);
            href.append('/').append(this.id);
        }
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    boolean isDisabled() {
        return this.disabled;
    }

    boolean isLocked() {
        return this.locked;
    }

    boolean canEdit() {
        return this.permissions != null && this.permissions.indexOf("write") != -1;
    }

    boolean hasCapabilities() {
        try {
            String requiredCapabilities = null;
            if (this.producerId != null && this.handle != null) {
                requiredCapabilities = PortletProducerCache.getInstance().getPortletProperty(this.producerId, this.handle, "requiredCapabilities", this.currentContext);
            }
            return this.env.hasCapabilities(requiredCapabilities);
        }
        catch (CacheFault e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    boolean canShow() {
        return this.hasCapabilities() && this.permissions != null && this.permissions.indexOf("execute") != -1 && this.permissions.indexOf("read") != -1;
    }

    public void setContext(String context) {
        this.context = context;
    }

    @Override
    public void write(XMLStreamWriter xsw) throws XMLStreamException {
        if (!this.canShow()) {
            this.writeMessageFragment(null, "pf.fragment.cmprovider.fragment.insufficient.permissions", null, xsw);
        } else if (this.isDisabled()) {
            this.writeMessageFragment(null, "pf.fragment.cmprovider.fragment.disabled", this.name, xsw);
        } else {
            this.writeFragmentStart(xsw);
            StringBuffer href = new StringBuffer();
            this.buildHref(href);
            href.append('/').append(this.id);
            xsw.writeAttribute("href", href.toString());
            this.writeInfo(xsw);
            this.writeCustomProperties(xsw);
            this.writeFragmentEnd(xsw);
        }
    }

    public String getHandle() {
        return this.handle;
    }

    public Parameters getCustomParameters() throws XMLStreamException {
        StringWriter sw = new StringWriter();
        XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(sw);
        xsw.writeStartDocument();
        xsw.writeStartElement("custom");
        this.writeCustomProperties(xsw);
        xsw.writeEndElement();
        xsw.writeEndDocument();
        xsw.flush();
        xsw.close();
        XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(new StringReader(sw.toString()));
        Parameters customs = new Parameters();
        while (xsr.hasNext()) {
            String _localName;
            int event = xsr.next();
            if (event != 1 || !"param".equals(_localName = xsr.getLocalName())) continue;
            customs.add(xsr.getAttributeValue("", "name"), xsr.getElementText());
        }
        xsr.close();
        return customs;
    }

    private static String readParentId(XMLStreamReader xsr) throws XMLStreamException {
        int level = 0;
        String id = null;
        while (xsr.hasNext()) {
            int event = xsr.next();
            switch (event) {
                case 1: {
                    String localName = xsr.getLocalName();
                    if ("storeID".equals(localName)) {
                        id = CMParseUtils.readCMValue(xsr, "value");
                        break;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level >= 0) break;
                    return id;
                }
            }
        }
        return id;
    }

    @Override
    protected boolean readItem(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if ("permissions".equals(localName)) {
            this.permissions = CMParseUtils.readCMValue(xsr, "item");
            return true;
        }
        if ("context".equals(localName)) {
            this.context = CMParseUtils.readCMValue(xsr, "value");
            return true;
        }
        if ("handle".equals(localName)) {
            this.handle = CMParseUtils.readCMValue(xsr, "value");
            return true;
        }
        if ("parent".equals(localName)) {
            this.producerId = Fragment.readParentId(xsr);
            return true;
        }
        if ("disabled".equals(localName)) {
            this.disabled = "true".equals(CMParseUtils.readCMValue(xsr, "value"));
            return true;
        }
        if ("canCustomize".equals(localName)) {
            this.locked = "false".equals(CMParseUtils.readCMValue(xsr, "value"));
            return true;
        }
        if ("deploymentReferences".equals(localName)) {
            this.deploymentReferences = new DeploymentReferences();
            this.deploymentReferences.read(xsr);
            return true;
        }
        return false;
    }
}

