/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.pipeline.helper;

import com.cognos.portal.fragment.server.pipeline.helper.BaseFragmentObject;
import com.cognos.portal.fragment.server.pipeline.helper.CMParseUtils;
import com.cognos.portal.fragment.server.pipeline.helper.DeploymentReferences;
import com.cognos.portal.fragment.server.pipeline.helper.Fragment;
import com.cognos.portal.fragment.server.pipeline.helper.Page;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.stream.StaxUtils;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class FragmentInstance
extends BaseFragmentObject {
    private Page page;
    private boolean disabled;
    private boolean locked;
    private Fragment fragment;
    private boolean instanceAsReference;

    public FragmentInstance(PipelineContext currentContext) {
        super(currentContext);
        String instanceFilter = this.parameters.getValue("query");
        if (instanceFilter != null) {
            this.instanceAsReference = true;
        }
    }

    public void setPage(Page page) {
        this.page = page;
    }

    @Override
    protected boolean readItem(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if ("disabled".equals(localName)) {
            this.disabled = "true".equals(CMParseUtils.readCMValue(xsr, "value"));
            return true;
        }
        if ("canCustomize".equals(localName)) {
            this.locked = "false".equals(CMParseUtils.readCMValue(xsr, "value"));
            return true;
        }
        if ("context".equals(localName)) {
            this.context = CMParseUtils.readCMValue(xsr, "value");
            return true;
        }
        if ("portlet".equals(localName)) {
            if (StaxUtils.moveToChildElement("item", xsr)) {
                this.fragment = new Fragment(this.currentContext);
                this.fragment.read(xsr);
                StaxUtils.moveToEndElement("portlet", xsr);
            }
            return true;
        }
        if ("parent".equals(localName)) {
            if (this.page == null) {
                if (StaxUtils.moveToChildElement("item", xsr)) {
                    this.instanceAsReference = true;
                    this.page = new Page(this.currentContext);
                    this.page.read(xsr);
                    StaxUtils.moveToEndElement("parent", xsr);
                }
                return true;
            }
        } else if ("deploymentReferences".equals(localName)) {
            this.deploymentReferences = new DeploymentReferences();
            this.deploymentReferences.read(xsr);
            return true;
        }
        return false;
    }

    String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    void setName(String name) {
        this.name = name;
    }

    private boolean isDisabled() {
        return !this.instanceAsReference && this.disabled || this.fragment != null && this.fragment.isDisabled();
    }

    private boolean isLocked() {
        return this.locked || this.fragment != null && this.fragment.isLocked();
    }

    private boolean canShow() {
        return this.fragment != null && this.fragment.canShow() && this.page != null && this.page.hasExecuteAccess();
    }

    public boolean canEdit() {
        return this.canShow() && !this.isDisabled() && !this.isLocked() && this.page.hasWriteAccess();
    }

    @Override
    public void write(XMLStreamWriter xsw) throws XMLStreamException {
        if (!this.canShow()) {
            this.writeMessageFragment(this.instanceAsReference ? null : this.getName(), "pf.fragment.cmprovider.fragment.insufficient.permissions", null, xsw);
        } else if (this.isDisabled()) {
            this.writeMessageFragment(this.instanceAsReference ? null : this.getName(), "pf.fragment.cmprovider.fragment.disabled", this.fragment != null ? this.fragment.getName() : null, xsw);
        } else {
            if (this.instanceAsReference) {
                xsw.writeStartElement("fragmentReference");
            } else {
                xsw.writeStartElement("fragmentInstance");
                xsw.writeAttribute("id", this.name);
            }
            StringBuffer href = new StringBuffer();
            this.fragment.buildHref(href);
            href.append('/').append(this.id);
            xsw.writeAttribute("href", href.toString());
            this.fragment.writeInfo(xsw);
            if (this.context != null && this.context.length() > 0 && !this.isLocked()) {
                this.writeCustomProperties(xsw);
            } else if (this.fragment != null) {
                this.fragment.writeCustomProperties(xsw);
            }
            xsw.writeEndElement();
        }
    }
}

