/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.pipeline.helper;

import com.cognos.portal.fragment.server.pipeline.helper.BaseFragmentObject;
import com.cognos.portal.fragment.server.pipeline.helper.CMParseUtils;
import com.cognos.portal.fragment.server.pipeline.helper.FragmentInstance;
import com.cognos.portal.utils.capability.RequiredCapabilities;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.ibm.cognos.i18n.util.Bidi;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class Page
extends BaseFragmentObject {
    private static final String TITLE_INSTRUCTION_VIEWER_HREF = "/fragmentproducer/utilities/richtext-viewer";
    static final String XML_LANG_NAMESPACEURI = "http://www.w3.org/XML/1998/namespace";
    static final String XML_LANG_NAMESPACEPRFIX = "xml";
    static final String XML_LANG = "lang";
    private String layout;
    private String requiredCapabilities = null;
    private LocalizedRichText title;
    private LocalizedRichText instructions;
    private String permissions;
    private List fragmentInstances;
    private boolean isBannerWritten = false;

    public Page(PipelineContext currentContext) {
        super(currentContext);
    }

    public void addFragmentInstance(FragmentInstance instance) {
        if (this.fragmentInstances == null) {
            this.fragmentInstances = new ArrayList();
        }
        this.fragmentInstances.add(instance);
        instance.setPage(this);
    }

    private FragmentInstance getFragmentInstance(String name) {
        if (this.fragmentInstances != null) {
            for (FragmentInstance fi : this.fragmentInstances) {
                if (!name.equals(fi.getName())) continue;
                return fi;
            }
        }
        return null;
    }

    boolean hasCapabilities() {
        return this.env.hasCapabilities(this.requiredCapabilities);
    }

    boolean hasReadAccess() {
        return this.permissions != null && this.permissions.indexOf("read") != -1;
    }

    boolean hasExecuteAccess() {
        return this.permissions != null && this.permissions.indexOf("execute") != -1;
    }

    boolean hasWriteAccess() {
        return this.permissions != null && this.permissions.indexOf("write") != -1;
    }

    boolean hasTraverseAccess() {
        return this.permissions != null && this.permissions.indexOf("traverse") != -1;
    }

    @Override
    protected boolean readItem(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if ("permissions".equals(localName)) {
            this.permissions = CMParseUtils.readCMValue(xsr, "item");
            return true;
        }
        if ("layout".equals(localName)) {
            this.layout = CMParseUtils.readCMValue(xsr, "value");
            return true;
        }
        if ("metadata".equals(localName)) {
            this.requiredCapabilities = RequiredCapabilities.parseRequiredCapabilities(CMParseUtils.readCMValue(xsr, "value"));
            return true;
        }
        return false;
    }

    @Override
    public void write(XMLStreamWriter xsw) throws XMLStreamException {
        String addID;
        String instanceFilter = this.parameters.getValue("query");
        if (instanceFilter != null) {
            Iterator it;
            if (this.fragmentInstances != null && (it = this.fragmentInstances.iterator()) != null) {
                while (it.hasNext()) {
                    FragmentInstance instance = (FragmentInstance)it.next();
                    if (!instance.id.equals(instanceFilter)) continue;
                    instance.write(xsw);
                    return;
                }
            }
            this.writeMessageFragment(null, "pf.fragment.cmprovider.fragment.insufficient.permissions", null, xsw);
        }
        if ((addID = this.parameters.getValue("add")) != null) {
            if (!this.hasExecuteAccess()) {
                this.writeMessageFragment(null, "pf.fragment.cmprovider.fragment.insufficient.permissions", null, xsw);
            } else {
                this.writeFragmentStart(xsw);
                StringBuffer href = new StringBuffer();
                href.append("/cm");
                href.append('/').append(addID);
                xsw.writeAttribute("href", href.toString());
                this.writeFragmentEnd(xsw);
            }
            return;
        }
        xsw.writeStartElement("page");
        this.writeInfo(xsw);
        if (!this.hasExecuteAccess() || !this.hasCapabilities()) {
            xsw.writeStartElement("layout");
            this.writeBannerLayout(xsw);
            this.writeMessageLayoutRow(xsw);
            xsw.writeEndElement();
            this.writeBannerFragment(xsw);
            this.writeMessageFragment(xsw, "pf.fragment.cmprovider.page.insufficient.permissions");
        } else {
            String pageEditParam = this.parameters.getValue("frag-headerPageEdit");
            if ((pageEditParam == null || Boolean.valueOf(pageEditParam).booleanValue()) && this.hasWriteAccess() && this.hasReadAccess() && this.hasTraverseAccess()) {
                this.showPageEdit = true;
            }
            this.copyLayout(xsw);
            this.writeBannerFragment(xsw);
            this.writeTitleAndInstructionsFragment(xsw);
            if (this.fragmentInstances == null || this.fragmentInstances.size() == 0) {
                this.writeMessageFragment(xsw, "pf.fragment.cmprovider.page.empty");
            } else {
                this.copyFragments(xsw);
            }
        }
        xsw.writeEndElement();
    }

    private void writeMessageLayoutRow(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("row");
        xsw.writeStartElement("column");
        xsw.writeStartElement("fragment");
        xsw.writeAttribute("refid", "message");
        xsw.writeStartElement("layoutProperties");
        xsw.writeStartElement("param");
        xsw.writeAttribute("name", "borders");
        xsw.writeCharacters("false");
        xsw.writeEndElement();
        xsw.writeStartElement("param");
        xsw.writeAttribute("name", "caption");
        xsw.writeCharacters("false");
        xsw.writeEndElement();
        xsw.writeStartElement("param");
        xsw.writeAttribute("name", "noedit");
        xsw.writeCharacters("true");
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndElement();
    }

    private void writeMessageFragment(XMLStreamWriter xsw, String message) throws XMLStreamException {
        this.writeMessageFragment("message", message, null, xsw);
    }

    private void copyFragments(XMLStreamWriter xsw) throws XMLStreamException {
        Iterator it;
        if (this.fragmentInstances != null && (it = this.fragmentInstances.iterator()) != null) {
            while (it.hasNext()) {
                FragmentInstance instance = (FragmentInstance)it.next();
                instance.write(xsw);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void copyLayout(XMLStreamWriter xsw) throws XMLStreamException {
        block40: {
            block39: {
                if (this.layout == null || this.layout.length() <= 0) break block39;
                reader = XMLStreamFactory.createXMLStreamReader(new StringReader(this.layout));
                level = 0;
                hideBorder = null;
                hideTitleBars = null;
                hideEditMode = null;
                hideMargins = null;
                hidePaddings = null;
                hasRows = false;
                rowAdded = false;
                isTitleAndInstructionLayoutWritten = false;
                while (reader.hasNext()) {
                    event = reader.next();
                    switch (event) {
                        case 1: {
                            if (!"layout".equals(reader.getLocalName())) ** GOTO lbl25
                            version = reader.getAttributeValue("", "version");
                            v0 = dVersion = version != null ? Double.valueOf(version) : 1.0;
                            if (dVersion < 2.0) {
                                xsw.writeStartElement("layout");
                                xsw.writeAttribute("version", "2.0");
                            } else {
                                StaxUtils.copyCurrentElement(reader, xsw);
                                return;
lbl25:
                                // 1 sources

                                if ("layoutProperties".equals(reader.getLocalName())) {
                                    StaxUtils.copyCurrentElement(reader, xsw);
                                    break;
                                }
                                if (!this.isBannerWritten) {
                                    this.writeBannerLayout(xsw);
                                    this.isBannerWritten = true;
                                }
                                if ("title".equals(reader.getLocalName())) {
                                    hidden = reader.getAttributeValue("", "hidden");
                                    if (hidden == null || !hidden.equals("true")) {
                                        this.title = new LocalizedRichText();
                                        this.title.read(reader);
                                        if (this.title.hasValues() && !isTitleAndInstructionLayoutWritten) {
                                            this.writeTitleAndInstructionLayout(xsw);
                                            isTitleAndInstructionLayoutWritten = true;
                                        }
                                    }
                                } else if ("instructions".equals(reader.getLocalName())) {
                                    hidden = reader.getAttributeValue("", "hidden");
                                    if (hidden == null || !hidden.equals("true")) {
                                        this.instructions = new LocalizedRichText();
                                        this.instructions.read(reader);
                                        if (this.instructions.hasValues() && !isTitleAndInstructionLayoutWritten) {
                                            this.writeTitleAndInstructionLayout(xsw);
                                            isTitleAndInstructionLayoutWritten = true;
                                        }
                                    }
                                } else if ("portletOptions".equals(reader.getLocalName())) {
                                    hideBorder = reader.getAttributeValue("", "hideBorders");
                                    hideTitleBars = reader.getAttributeValue("", "hideTitleBars");
                                    hideEditMode = reader.getAttributeValue("", "hideEditMode");
                                    hideMargins = reader.getAttributeValue("", "hideMargins");
                                    hidePaddings = reader.getAttributeValue("", "hidePaddings");
                                } else if ("row".equals(reader.getLocalName())) {
                                    xsw.writeStartElement("row");
                                    hasRows = true;
                                } else if ("column".equals(reader.getLocalName())) {
                                    if (!hasRows && !rowAdded) {
                                        xsw.writeStartElement("row");
                                        rowAdded = true;
                                    }
                                    xsw.writeStartElement("column");
                                    width = reader.getAttributeValue("", "width");
                                    if (width != null && width.length() > 0) {
                                        xsw.writeAttribute("width", width + "%");
                                    }
                                } else if ("portlet".equals(reader.getLocalName())) {
                                    xsw.writeStartElement("fragment");
                                    refid = reader.getAttributeValue("", "id");
                                    if (refid != null && refid.length() > 0) {
                                        xsw.writeAttribute("refid", refid);
                                    }
                                    if ((instance = this.getFragmentInstance(refid)) == null) {
                                        instance = new FragmentInstance(this.currentContext);
                                        instance.setName(refid);
                                        this.addFragmentInstance(instance);
                                    }
                                    hasWrite = instance.canEdit();
                                    xsw.writeStartElement("layoutProperties");
                                    if (hideBorder != null) {
                                        xsw.writeStartElement("param");
                                        xsw.writeAttribute("name", "borders");
                                        xsw.writeCharacters("true".equals(hideBorder) != false ? "false" : "true");
                                        xsw.writeEndElement();
                                    }
                                    if (hideTitleBars != null) {
                                        xsw.writeStartElement("param");
                                        xsw.writeAttribute("name", "caption");
                                        xsw.writeCharacters("true".equals(hideTitleBars) != false ? "false" : "true");
                                        xsw.writeEndElement();
                                    }
                                    if (hideEditMode != null || !hasWrite) {
                                        xsw.writeStartElement("param");
                                        xsw.writeAttribute("name", "noedit");
                                        if (!hasWrite) {
                                            xsw.writeCharacters("true");
                                        } else {
                                            xsw.writeCharacters(hideEditMode);
                                        }
                                        xsw.writeEndElement();
                                    }
                                    if (hideMargins != null) {
                                        xsw.writeStartElement("param");
                                        xsw.writeAttribute("name", "margins");
                                        xsw.writeCharacters("true".equals(hideMargins) != false ? "false" : "true");
                                        xsw.writeEndElement();
                                    }
                                    if (hidePaddings != null) {
                                        xsw.writeStartElement("param");
                                        xsw.writeAttribute("name", "paddings");
                                        xsw.writeCharacters("true".equals(hidePaddings) != false ? "false" : "true");
                                        xsw.writeEndElement();
                                    }
                                    xsw.writeEndElement();
                                }
                            }
                            ++level;
                            break;
                        }
                        case 2: {
                            if (--level < 0) {
                                if (rowAdded) {
                                    xsw.writeEndElement();
                                }
                                xsw.writeEndElement();
                                return;
                            }
                            if (!"column".equals(reader.getLocalName()) && !"portlet".equals(reader.getLocalName()) && !"row".equals(reader.getLocalName())) break;
                            xsw.writeEndElement();
                        }
                    }
                }
                if (rowAdded) {
                    xsw.writeEndElement();
                }
                break block40;
            }
            xsw.writeStartElement("layout");
            xsw.writeAttribute("version", "2.0");
            this.writeBannerLayout(xsw);
        }
        if (this.fragmentInstances == null || this.fragmentInstances.size() == 0) {
            this.writeMessageLayoutRow(xsw);
        }
        xsw.writeEndElement();
    }

    private void writeTitleAndInstructionLayout(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("row");
        xsw.writeStartElement("column");
        xsw.writeAttribute("width", "100%");
        xsw.writeStartElement("fragment");
        xsw.writeAttribute("refid", "title");
        xsw.writeStartElement("layoutProperties");
        xsw.writeStartElement("param");
        xsw.writeAttribute("name", "caption");
        xsw.writeCharacters("false");
        xsw.writeEndElement();
        xsw.writeStartElement("param");
        xsw.writeAttribute("name", "borders");
        xsw.writeCharacters("false");
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndElement();
    }

    private void writeTitleAndInstructionsFragment(XMLStreamWriter xsw) throws XMLStreamException {
        if (!(this.title != null && this.title.hasValues() || this.instructions != null && this.instructions.hasValues())) {
            return;
        }
        xsw.writeStartElement("fragmentInstance");
        xsw.writeAttribute("id", "title");
        xsw.writeAttribute("href", TITLE_INSTRUCTION_VIEWER_HREF);
        xsw.writeStartElement("custom");
        if (this.title != null) {
            xsw.writeStartElement("param");
            xsw.writeAttribute("name", "style1");
            xsw.writeCharacters(this.title.getStyle());
            xsw.writeEndElement();
            xsw.writeStartElement("param");
            xsw.writeAttribute("name", "text1");
            this.title.writeValues(xsw);
            xsw.writeEndElement();
        }
        if (this.instructions != null) {
            xsw.writeStartElement("param");
            xsw.writeAttribute("name", "style2");
            xsw.writeCharacters(this.instructions.getStyle());
            xsw.writeEndElement();
            xsw.writeStartElement("param");
            xsw.writeAttribute("name", "text2");
            this.instructions.writeValues(xsw);
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
        xsw.writeEndElement();
    }

    class LocalizedRichText {
        Map values;
        boolean bold;
        boolean underline;
        boolean italic;
        String font;
        String size;
        String color;
        String align;

        LocalizedRichText() {
        }

        boolean hasValues() {
            return this.values != null && this.values.size() > 0;
        }

        String getStyle() {
            StringBuffer style = new StringBuffer();
            if (this.font != null && this.font.length() > 0) {
                style.append("font-family:").append(this.font).append(";");
            }
            if (this.size != null && this.size.length() > 0) {
                style.append("font-size:").append(this.size).append(";");
            }
            if (this.color != null && this.color.length() > 0) {
                style.append("color:").append(this.color).append(";");
            }
            if (this.bold) {
                style.append("font-weight:bold;");
            }
            if (this.italic) {
                style.append("font-style:italic;");
            }
            if (this.underline) {
                style.append("text-decoration:underline;");
            }
            if (this.align != null && this.align.length() > 0) {
                style.append("text-align:").append(this.align).append(";");
            }
            return style.toString();
        }

        void writeValues(XMLStreamWriter xsw) throws XMLStreamException {
            String isBidiEnabled = "false";
            String textDirection = "auto";
            String productLocale = "en";
            if (Page.this.currentContext.getEnv() != null) {
                if (Page.this.currentContext.getEnv().getUserPreference("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#biDirectionalFeaturesEnabled") != null) {
                    isBidiEnabled = Page.this.currentContext.getEnv().getUserPreference("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#biDirectionalFeaturesEnabled");
                }
                if (Page.this.currentContext.getEnv().getUserPreference("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#baseTextDirection") != null) {
                    textDirection = Page.this.currentContext.getEnv().getUserPreference("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#baseTextDirection");
                    textDirection = textDirection.substring(textDirection.lastIndexOf("#") + 1).toLowerCase();
                }
                if (Page.this.currentContext.getEnv().getProductLocale() != null) {
                    productLocale = Page.this.currentContext.getEnv().getProductLocale();
                }
            }
            if (this.values != null) {
                for (Map.Entry entry : this.values.entrySet()) {
                    xsw.writeStartElement("value");
                    xsw.writeAttribute(Page.XML_LANG_NAMESPACEPRFIX, Page.XML_LANG_NAMESPACEURI, Page.XML_LANG, (String)entry.getKey());
                    if ("true".equals(isBidiEnabled)) {
                        xsw.writeCharacters(Bidi.enforceBTD((String)((String)entry.getValue()), (String)textDirection, (String)productLocale));
                    } else {
                        xsw.writeCharacters((String)entry.getValue());
                    }
                    xsw.writeEndElement();
                }
            }
        }

        void read(XMLStreamReader reader) throws XMLStreamException {
            this.align = reader.getAttributeValue("", "align");
            this.font = reader.getAttributeValue("", "font");
            this.color = reader.getAttributeValue("", "colour");
            this.size = reader.getAttributeValue("", "size");
            this.bold = Boolean.valueOf(reader.getAttributeValue("", "bold"));
            this.italic = Boolean.valueOf(reader.getAttributeValue("", "italic"));
            this.underline = Boolean.valueOf(reader.getAttributeValue("", "underline"));
            this.values = new HashMap();
            int level = 0;
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        String localName = reader.getLocalName();
                        if ("value".equals(localName)) {
                            String language = reader.getAttributeValue(Page.XML_LANG_NAMESPACEURI, Page.XML_LANG);
                            String value = reader.getElementText();
                            if (value.trim().length() <= 0) break;
                            this.values.put(language, value);
                            break;
                        }
                        ++level;
                        break;
                    }
                    case 2: {
                        if (--level >= 0) break;
                        return;
                    }
                }
            }
        }
    }
}

