/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.producer;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.server.pipeline.helper.CMParseUtils;
import com.cognos.portal.fragment.server.producer.CacheFault;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionFactory;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.soap.impl.bus.cm.Query;
import com.cognos.portal.utils.Cache;
import com.cognos.portal.utils.ReadWriteLock;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.stream.PathIterator;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class PortletProducerCache {
    private Cache producerCache;
    private static ReadWriteLock mutex = new ReadWriteLock();
    private ServiceLogger logger;
    private static PortletProducerCache _instance = new PortletProducerCache(null);

    private PortletProducerCache(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(PortletProducerCache.class) : null;
        this.producerCache = new Cache(0L, 0L, 0);
    }

    public static PortletProducerCache getInstance() {
        return _instance;
    }

    public String getPortletProperty(String producerId, String portletName, String propertyName, PipelineContext pipelineContext) throws CacheFault {
        Producer producer = this.getProducer(producerId, pipelineContext);
        return producer != null ? producer.getPortletProperty(portletName, propertyName) : null;
    }

    private boolean isProducerCached(String producerId) {
        return this.producerCache.containsKey(producerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Producer getProducer(String producerId, PipelineContext pipelineContext) throws CacheFault {
        block6: {
            try {
                mutex.acquireReadLock();
                try {
                    if (this.isProducerCached(producerId)) {
                        Producer producer = (Producer)this.producerCache.get(producerId);
                        return producer;
                    }
                }
                finally {
                    mutex.releaseReadLock();
                }
            }
            catch (InterruptedException e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) break block6;
                this.logger.error("an exception was encountered when attempting acquire read lock in the pipeline", e);
            }
        }
        this.addProducer(producerId, pipelineContext);
        return (Producer)this.producerCache.get(producerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProducer(String producerId, PipelineContext pipelineContext) throws CacheFault {
        block6: {
            try {
                mutex.acquireWriteLock();
                try {
                    if (!this.isProducerCached(producerId)) {
                        Query query = new Query();
                        query.setSearchPath("storeID(\"" + producerId + "\")");
                        query.addProperty("serviceDescription");
                        Object header = pipelineContext.getParam("busHeader");
                        query.setBusHeader(header != null ? header.toString() : null);
                        query.setResponseBodyHandler(new ResultHandler(producerId, this.producerCache));
                        this.sendCMRequest(query, pipelineContext);
                    }
                }
                finally {
                    mutex.releaseWriteLock();
                }
            }
            catch (InterruptedException e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) break block6;
                this.logger.error("an exception was encountered when attempting acquire write lock in the pipeline", e);
            }
        }
    }

    private void sendCMRequest(SOAPMessage message, PipelineContext pipelineContext) throws CacheFault {
        try {
            SOAPConnection connection = ((SOAPConnectionFactory)pipelineContext.getEnv().getProperty("trustedSoapConnectionFactory")).createConnection(pipelineContext.getEnv().getLogger());
            connection.execute(message, (String)pipelineContext.getEnv().getProperty("contentManager"));
        }
        catch (MalformedURLException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("bad url.", e);
            }
            throw new CacheFault("pf.fragment.server.executionfailed", null, e);
        }
        catch (SOAPFault e) {
            String detail = e.getDetail();
            if (detail != null && detail.indexOf("CM-REQ-4159") != -1) {
                throw new InvalidCredentialsFault("pf.fragment.server.invalidcredentials", null, e);
            }
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Content Manager returned a fault in the response.", e);
            }
            throw new CacheFault("pf.fragment.server.executionfailed", null, e);
        }
        catch (IOException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Encountered an IO exception while retrieving the object from cm.", e);
            }
            throw new CacheFault("pf.fragment.server.executionfailed", null, e);
        }
        catch (XMLStreamException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Encountered an xml stream exception while retrieving the object from cm.", e);
            }
            throw new CacheFault("pf.fragment.server.executionfailed", null, e);
        }
    }

    public final class ResultHandler
    implements IXMLHandler {
        String producerId;
        Cache producerCache;
        private final String[] PORTLET_PROP_PATH = new String[]{"/serviceDescription/offeredPortlets/portletHandle", "/serviceDescription/offeredPortlets/extensions/meta/requiredCapabilities"};

        public ResultHandler(String producerId, Cache producerCache) {
            this.producerId = producerId;
            this.producerCache = producerCache;
        }

        @Override
        public void handle(XMLStreamReader xsr) throws XMLStreamException {
            String serviceDescription;
            Producer producer = null;
            if (StaxUtils.moveToElement("serviceDescription", xsr) && !"".equals(serviceDescription = CMParseUtils.readCMValue(xsr, "value"))) {
                int index;
                XMLStreamReader reader = XMLStreamFactory.createXMLStreamReader(new StringReader(serviceDescription.toString()));
                PathIterator it = new PathIterator(reader, this.PORTLET_PROP_PATH);
                producer = new Producer();
                Portlet portlet = null;
                while ((index = it.moveToNextPath()) != -1) {
                    switch (index) {
                        case 0: {
                            portlet = new Portlet();
                            String portletHandle = it.getElementText();
                            portlet.addProperty("portletHandle", portletHandle);
                            producer.addPortlet(portletHandle, portlet);
                            break;
                        }
                        case 1: {
                            String requiredCapabilities = it.getElementText();
                            if (portlet == null) break;
                            portlet.addProperty("requiredCapabilities", requiredCapabilities);
                        }
                    }
                }
            }
            this.producerCache.put(this.producerId, producer);
        }
    }

    private class Portlet {
        private Map properties = new HashMap();

        Portlet() {
        }

        public String getProperty(String propertyName) {
            return (String)this.properties.get(propertyName);
        }

        public void addProperty(String propertyName, String propertyValue) {
            this.properties.put(propertyName, propertyValue);
        }
    }

    private class Producer {
        private Map portlets = new HashMap();

        Producer() {
        }

        public String getPortletProperty(String portletName, String propertyName) {
            Portlet portlet = (Portlet)this.portlets.get(portletName);
            return portlet != null ? portlet.getProperty(propertyName) : null;
        }

        public void addPortlet(String portletHandle, Portlet portlet) {
            this.portlets.put(portletHandle, portlet);
        }
    }
}

