/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.rewriters;

import com.cognos.portal.fragment.server.rewriters.URLRewriteException;
import com.cognos.portal.fragment.server.rewriters.URLRewriteHandler;
import com.cognos.portal.utils.Boyer;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.stream.XMLTransactionalStreamWriter;
import javax.xml.stream.XMLStreamException;

public final class URLRewriter {
    private static final String SEARCH_PATTERN = "_THIS";
    private static final String SEARCH_PATTERN_END = "THIS_";
    private URLRewriteHandler urlHandler = null;

    public URLRewriter(URLRewriteHandler urlHandler) {
        this.urlHandler = urlHandler;
    }

    public void rewrite(char[] dataIn, int offset, int count, XMLTransactionalStreamWriter dataOut) throws URLRewriteException {
        Boyer boyerStart = new Boyer(dataIn, offset, count);
        Boyer boyerEnd = new Boyer(dataIn, offset, count);
        int debugIDCount = 0;
        int debugUrlCount = 0;
        int search = 0;
        int currentpos = 0;
        try {
            while ((search = boyerStart.indexOf(SEARCH_PATTERN, search)) >= 0) {
                if (search < 0) continue;
                dataOut.writeCharacters(dataIn, offset + currentpos, search - currentpos);
                int starturlpos = offset + (search += SEARCH_PATTERN.length());
                if (dataIn[starturlpos] == '_') {
                    this.urlHandler.generateUniqueFragmentId(dataOut);
                    ++debugIDCount;
                } else {
                    int endurlpos;
                    if (dataIn[starturlpos] != '?') {
                        throw new URLRewriteException("pf.fragment.server.rewritefailed");
                    }
                    if ((endurlpos = boyerEnd.indexOf(SEARCH_PATTERN_END, ++search)) <= 0) {
                        throw new URLRewriteException("pf.fragment.server.rewritefailed");
                    }
                    if (dataIn[offset + endurlpos - 1] != '/') {
                        throw new URLRewriteException("pf.fragment.server.rewritefailed");
                    }
                    this.callURLHandler(dataIn, starturlpos + 1, endurlpos - search - 1, dataOut);
                    ++debugUrlCount;
                    search = endurlpos + SEARCH_PATTERN.length();
                }
                currentpos = ++search;
            }
            dataOut.writeCharacters(dataIn, offset + currentpos, count - currentpos);
        }
        catch (XMLStreamException e) {
            throw new URLRewriteException("pf.fragment.server.rewritefailed", e);
        }
    }

    private void callURLHandler(char[] dataIn, int offset, int count, XMLTransactionalStreamWriter dataOut) throws URLRewriteException {
        int currentpos;
        Parameters urlParams = new Parameters();
        int equalspos = 0;
        int namestart = currentpos = 0;
        while (currentpos < count) {
            for (equalspos = namestart; equalspos < count && dataIn[offset + equalspos] != '='; ++equalspos) {
            }
            if (equalspos >= count) {
                throw new URLRewriteException("pf.fragment.server.rewritefailed");
            }
            while (currentpos < count && dataIn[offset + currentpos] != '&') {
                ++currentpos;
            }
            urlParams.setValue(new String(dataIn, offset + namestart, equalspos - namestart), new String(dataIn, offset + equalspos + 1, currentpos - equalspos - 1));
            namestart = ++currentpos;
        }
        this.urlHandler.generateURL(urlParams, dataOut);
    }
}

