/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.service;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerMultipleQueryCommand;
import com.cognos.portal.utils.EncodingUtils;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

class ContentManagerQuerySession
extends ContentManagerMultipleQueryCommand {
    private String sessionValue;
    private String contentLocale;
    static String[][] capabilities = new String[][]{{"canUseAdministrationPortal", "a"}, {"canUseReportStudio", "r"}, {"canUseReportStudioFileManagement", "m"}, {"canUseQueryStudio", "q"}, {"canUseQueryStudioFileManagement", "m"}, {"canUseDirectoryTool", "b"}, {"canUseCapabilitiesTool", "c"}, {"canUseContentStoreTool", "d"}, {"canUseServerAdministrationTool", "e"}, {"canUsePortalAdministrationTool", "f"}, {"canUseAnalysisStudio", "g"}, {"canUseEventStudio", "h"}, {"canUseSpecifications", "j"}, {"canUseScheduling", "l"}, {"canUseSchedulingPriority", "F"}, {"canUseMetricStudio", "n"}, {"canUseMetricsManagerAdministration", "o"}, {"canUseCognosViewerRunWithOptions", "s"}, {"canUsePlanningAdministration", "t"}, {"canUsePlanningContributor", "u"}, {"canUseCognosViewer", "v"}, {"canUseControllerStudio", "w"}, {"canUseCognosViewerSelection", "x"}, {"canUseCognosViewerToolbar", "y"}, {"canUseCognosViewerContextMenu", "z"}, {"canUseConditionalSubscriptions", "A"}, {"canUseIndexSearch", "I"}};

    public ContentManagerQuerySession(String contentLocale) {
        super(null);
        this.contentLocale = contentLocale;
    }

    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
        Element requests = this.createRequestsElement(bodyElement);
        this.addPublicFolderQuery(requests);
        this.addMyFolderQuery(requests);
        this.addUserPreferencesQuery(requests);
        this.addUserCapabilitiesQuery(requests);
        this.addNamespacesQuery(requests);
    }

    private void addPublicFolderQuery(Element requests) {
        String queryObjectName = "/content";
        String[] queryProperties = new String[]{"defaultName", "storeID"};
        this.addQueryElement(requests, queryObjectName, queryProperties);
    }

    private void addMyFolderQuery(Element requests) {
        String queryObjectName = "~/folder";
        String[] queryProperties = new String[]{"defaultName", "storeID", "searchPath"};
        this.addQueryElement(requests, queryObjectName, queryProperties);
    }

    private void addUserPreferencesQuery(Element requests) {
        String queryObjectName = "~";
        String[] queryProperties = new String[]{"portalPages", "options", "searchPath", "defaultName", "permissions"};
        this.addQueryElement(requests, queryObjectName, queryProperties);
    }

    private void addUserCapabilitiesQuery(Element requests) {
        String queryObjectName = "~~";
        String[] queryProperties = new String[]{"userCapabilities", "identity"};
        this.addQueryElement(requests, queryObjectName, queryProperties);
    }

    private void addNamespacesQuery(Element requests) {
        String queryObjectName = "/directory/*[@objectClass='namespace'][permission(\"read\") or permission(\"write\") or permission(\"execute\") or permission(\"traverse\") or permission(\"setPolicy\")]";
        String[] queryProperties = new String[]{"defaultName", "permissions", "active"};
        this.addQueryElement(requests, queryObjectName, queryProperties);
    }

    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
        List results = bodyElement.selectNodes("//queryResult");
        Element content = ContentManagerQuerySession.getElement((Element)results.get(0), "item");
        Element myfolder = ContentManagerQuerySession.getElement((Element)results.get(1), "item");
        Element account = ContentManagerQuerySession.getElement((Element)results.get(2), "item");
        Element session = ContentManagerQuerySession.getElement((Element)results.get(3), "item");
        Element namespaces = (Element)results.get(4);
        StringBuffer sb = new StringBuffer();
        ContentManagerQuerySession.addValue(sb, "s_cc", "");
        ContentManagerQuerySession.addValue(sb, "s_ms", "");
        ContentManagerQuerySession.addValue(sb, "s_conf", "na");
        ContentManagerQuerySession.addValue(sb, "s_sch", "td");
        ContentManagerQuerySession.addValue(sb, "s_hd", "sa");
        ContentManagerQuerySession.addValue(sb, "s_serv", "na");
        ContentManagerQuerySession.addValue(sb, "s_disp", "na");
        ContentManagerQuerySession.addValue(sb, "s_set", "");
        ContentManagerQuerySession.addValue(sb, "s_dep", "na");
        ContentManagerQuerySession.addValue(sb, "s_dir", "na");
        ContentManagerQuerySession.addValue(sb, "s_sms", "dd");
        ContentManagerQuerySession.addValue(sb, "s_ct", "sa");
        ContentManagerQuerySession.addValue(sb, "s_cs", "sa");
        ContentManagerQuerySession.addValue(sb, "s_so", "sa");
        ContentManagerQuerySession.addValue(sb, "e_hp", ContentManagerQuerySession.getElementValueText(account, "searchPath"));
        ContentManagerQuerySession.addValue(sb, "e_proot", ContentManagerQuerySession.getElementValueText(content, "defaultName"));
        ContentManagerQuerySession.addValue(sb, "prootid", ContentManagerQuerySession.getElementValueText(content, "storeID"));
        ContentManagerQuerySession.addValue(sb, "e_mroot", ContentManagerQuerySession.getElementValueText(myfolder, "defaultName"));
        ContentManagerQuerySession.addValue(sb, "mrootid", ContentManagerQuerySession.getElementValueText(myfolder, "storeID"));
        ContentManagerQuerySession.addValue(sb, "e_mrootpath", ContentManagerQuerySession.getElementValueText(myfolder, "searchPath"));
        ContentManagerQuerySession.addValue(sb, "e_user", ContentManagerQuerySession.getElementValueText(account, "defaultName"));
        ContentManagerQuerySession.addValue(sb, "cl", this.contentLocale);
        ContentManagerQuerySession.addValue(sb, "dcid", ContentManagerQuerySession.getElementValueText(ContentManagerQuerySession.getElement(ContentManagerQuerySession.getElement(ContentManagerQuerySession.getElement(account, "portalPages"), "value"), "item"), "storeID"));
        ContentManagerQuerySession.addValue(sb, "show_logon", ContentManagerQuerySession.isLogonEnabled(namespaces));
        ContentManagerQuerySession.addValue(sb, "ucap", ContentManagerQuerySession.generateUserCapabilities(session));
        ContentManagerQuerySession.addValue(sb, "uig", ContentManagerQuerySession.generateUIControlGroup(session));
        ContentManagerQuerySession.addValue(sb, "ui", "");
        ContentManagerQuerySession.addValue(sb, "write", String.valueOf(ContentManagerQuerySession.arrayContainsText(ContentManagerQuerySession.getElement(account, "permissions"), "write")));
        ContentManagerQuerySession.addValue(sb, "eom", "0");
        this.sessionValue = sb.toString();
    }

    private static Element getElement(Element element, String name) {
        if (element != null) {
            return element.element(name);
        }
        return null;
    }

    private static String getElementValueText(Element element, String name) {
        Element child;
        if (element != null && (child = element.element(name)) != null) {
            return child.elementText("value");
        }
        return "";
    }

    private static void addValue(StringBuffer sb, String name, String value) {
        if (sb.length() > 0) {
            sb.append('|');
        }
        sb.append(name).append(':');
        if (name.startsWith("e_")) {
            ContentManagerQuerySession.mangle(sb, EncodingUtils.urlencode(value, "UTF-8", false));
        } else {
            sb.append(value);
        }
    }

    private static void mangle(StringBuffer sb, String src) {
        int l = src.length();
        block4: for (int i = 0; i < l; ++i) {
            char c = src.charAt(i);
            switch (c) {
                case '*': {
                    sb.append('*');
                    sb.append('*');
                    continue block4;
                }
                case '%': {
                    sb.append('*');
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    private static String isLogonEnabled(Element namespaces) {
        Iterator it = namespaces.elementIterator("item");
        int countActive = 0;
        int countTraverse = 0;
        while (it.hasNext()) {
            Element item = (Element)it.next();
            if ("true".equals(ContentManagerQuerySession.getElementValueText(item, "active"))) {
                ++countActive;
            }
            if (!ContentManagerQuerySession.arrayContainsText(ContentManagerQuerySession.getElement(item, "permissions"), "traverse")) continue;
            ++countTraverse;
        }
        return String.valueOf(countActive > countTraverse);
    }

    private static String generateUserCapabilities(Element session) {
        StringBuffer sb = new StringBuffer();
        Element userCapabilities = ContentManagerQuerySession.getElement(session, "userCapabilities");
        if (userCapabilities != null) {
            for (int i = 0; i < capabilities.length; ++i) {
                if (!ContentManagerQuerySession.arrayContainsText(userCapabilities, capabilities[i][0])) continue;
                sb.append(capabilities[i][1].charAt(0));
            }
        }
        return sb.toString();
    }

    private static String generateUIControlGroup(Element session) {
        Element identity = ContentManagerQuerySession.getElement(session, "identity");
        if (identity != null) {
            // empty if block
        }
        return "";
    }

    private static boolean arrayContainsText(Element element, String text) {
        if (element != null) {
            Element value = element.element("value");
            Iterator it = value.elementIterator("item");
            while (it.hasNext()) {
                Element item = (Element)it.next();
                if (!text.equals(item.getText())) continue;
                return true;
            }
        }
        return false;
    }

    public String getSessionValue() {
        return this.sessionValue;
    }
}

