/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.service;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.BIBusEnvelopeUtils;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.fragment.ResourceLoader;
import com.cognos.portal.fragment.ResourceLoaderImpl;
import com.cognos.portal.fragment.routing.DynamicProducerRoutingTable;
import com.cognos.portal.fragment.routing.RoutingTable;
import com.cognos.portal.fragment.routing.RoutingUtils;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.DashboardProcessor;
import com.cognos.portal.fragment.server.document.DocumentFactoryImpl;
import com.cognos.portal.fragment.service.InternalFragmentService;
import com.cognos.portal.fragment.service.ServiceEnvironment;
import com.cognos.portal.fragment.validation.ValidationManager;
import com.cognos.portal.soap.impl.BusConnectionImpl;
import com.cognos.portal.soap.impl.SOAPConnectionFactoryImpl;
import com.cognos.portal.soap.impl.TrustedSOAPConnectionFactoryImpl;
import com.cognos.portal.thread.DefaultRerunnable;
import com.cognos.portal.thread.ThreadPool;
import com.cognos.portal.utils.ContextImpl;
import com.cognos.portal.utils.DebugHelper;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.NavSystem;
import com.cognos.portal.utils.NumberUtils;
import com.cognos.portal.utils.ReadWriteLock;
import com.cognos.portal.utils.RecordingHelper;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.internet.InternetHeaders;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.httpclient.Cookie;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class DashboardService
extends BasicHandler {
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(DashboardService.class.getName());
    private static ThreadPool THREAD_POOL;
    private static int THREAD_POOL_SIZE;
    private static int THREAD_POOL_CLEANUP_TIME;
    private static int THREAD_POOL_REF_COUNT;
    private ICCLConfiguration cclConfiguration;
    private DashboardProcessor dashboard;
    private IContext context;
    private ServiceLogger logger = new ServiceLoggerImpl(DashboardService.class);
    private PogoEngine engine;
    private RecordingHelper recordingHelper = null;
    private static ReadWriteLock mutex;
    private RoutingTable routingTable = null;
    private Date portalModificationTime = null;
    private InternalFragmentService internalFragmentService = new InternalFragmentService();

    private static synchronized int addThreadPoolRef() {
        return ++THREAD_POOL_REF_COUNT;
    }

    private static synchronized int removeThreadPoolRef() {
        return --THREAD_POOL_REF_COUNT;
    }

    private static synchronized ThreadPool getThreadPool(IContext context, ServiceLogger logger) throws LocalizableException {
        int poolSize = NumberUtils.parse((String)context.getProperty("portal.threadpool.initsize"), 5);
        int cleanupTime = NumberUtils.parse((String)context.getProperty("portal.threadpool.cleanup"), 3600) * 1000;
        if (THREAD_POOL == null) {
            THREAD_POOL_SIZE = poolSize;
            THREAD_POOL_CLEANUP_TIME = cleanupTime;
            THREAD_POOL = DashboardService.createThreadPool(poolSize, cleanupTime, logger);
        } else if (THREAD_POOL_SIZE != poolSize || THREAD_POOL_CLEANUP_TIME != cleanupTime) {
            if (logger.isDebugEnabled()) {
                logger.debug("Thread pool configuration changed. Terminating and creating a new one.");
                logger.debug("Old pool size: " + THREAD_POOL_SIZE);
                logger.debug("Old cleanup time (in millisec): " + THREAD_POOL_CLEANUP_TIME);
                logger.debug("Pool size: " + poolSize);
                logger.debug("Cleanup time (in millisec): " + cleanupTime);
            }
            THREAD_POOL.terminate();
            THREAD_POOL_SIZE = poolSize;
            THREAD_POOL_CLEANUP_TIME = cleanupTime;
            THREAD_POOL = DashboardService.createThreadPool(poolSize, cleanupTime, logger);
        }
        return THREAD_POOL;
    }

    private static synchronized void terminatePool(ServiceLogger logger) {
        if (THREAD_POOL != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Terminating fragment thread pool.");
            }
            THREAD_POOL.terminate();
            THREAD_POOL = null;
        }
    }

    private static ThreadPool createThreadPool(int poolSize, int cleanupTime, ServiceLogger logger) throws LocalizableException {
        if (logger.isDebugEnabled()) {
            logger.debug("creating thread pool to be used by page rendering");
            logger.debug("Pool size: " + THREAD_POOL_SIZE);
            logger.debug("Cleanup time (in millisec): " + THREAD_POOL_CLEANUP_TIME);
        }
        ThreadPool threadpool = new ThreadPool("portal");
        threadpool.initialize(poolSize, "fragmentrequest", cleanupTime, DefaultRerunnable.class.getName());
        return threadpool;
    }

    public DashboardService() {
        super(category);
    }

    public DashboardService(Logger logger) {
        super(logger);
    }

    public void initialize() {
        block2: {
            try {
                DashboardService.addThreadPoolRef();
                this.dashboard = new DashboardProcessor(this.logger);
                this.dashboard.init(this.context);
            }
            catch (DashboardException e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) break block2;
                this.logger.error("cannot initialize dashboard processor", e);
            }
        }
    }

    public void dispose() {
        block10: {
            try {
                mutex.acquireWriteLock();
                try {
                    if (this.dashboard != null) {
                        this.dashboard.terminate();
                    }
                    this.dashboard = null;
                    if (DashboardService.removeThreadPoolRef() <= 0) {
                        DashboardService.terminatePool(this.logger);
                    }
                }
                catch (DashboardException e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("cannot terminate dashboard processor", e);
                    }
                }
                finally {
                    mutex.releaseWriteLock();
                }
            }
            catch (InterruptedException e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) break block10;
                this.logger.error("an exception was encountered when attempting acquire write lock to terminate the dashboard service", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration config) {
        block22: {
            try {
                mutex.acquireWriteLock();
                try {
                    Properties props;
                    ResourceLoaderImpl resourceLoader;
                    block21: {
                        this.internalFragmentService.configure(config, this.engine);
                        this.cclConfiguration = config.getICCLConfiguration();
                        this.context = new ContextImpl();
                        String application = this.getRequiredAttribute(category, "application");
                        String webinfRootPath = "/WEB-INF/fragments";
                        this.context.setProperty("internalFragmentService", (Object)this.internalFragmentService);
                        this.context.setProperty("xslt.xmlashtml", "xmlashtml.xslt");
                        this.context.setProperty("xslt.page", "page.xslt");
                        this.context.setProperty("xslt.pagelet", "pagelet.xslt");
                        this.context.setProperty("xslt.script", "script.xslt");
                        this.context.setProperty("xslt.css", "cssstyles.xslt");
                        this.context.setProperty("xslt.messageasjs", "messageasjs.xslt");
                        this.context.setProperty("xslt.message", "messages/pfmessages.xml");
                        String rootAppPath = webinfRootPath + "/applications/" + application;
                        this.context.setProperty("application", application);
                        this.context.setProperty("application.path", rootAppPath);
                        this.context.setProperty("css.skin", "corporate");
                        this.context.setProperty("dispatcherPath", new URL(this.cclConfiguration.getValue("internalDispatcher", true)).getFile());
                        String dispatcherUrlOverride = this.cclConfiguration.getValue("portal.fragment.dispatcher.override", true);
                        if (dispatcherUrlOverride != null && dispatcherUrlOverride.length() > 0) {
                            this.context.setProperty("internalDispatcher", dispatcherUrlOverride);
                        } else {
                            this.context.setProperty("internalDispatcher", BusConnectionImpl.BUS_DISPATCHER);
                        }
                        this.context.setProperty("portal.fragment.response.pattern", this.cclConfiguration.getValue("portal.fragment.response.pattern", true));
                        this.context.setProperty("cookieSecure", this.cclConfiguration.getValue("cookieSecure", true));
                        this.context.setProperty("fragment.token.check.disabled", this.cclConfiguration.getValue("fragment.token.check.disabled", true));
                        this.context.setProperty("cmPath", new URL(this.cclConfiguration.getValue("contentManager", true)).getFile());
                        this.context.setProperty("contentManager", BusConnectionImpl.BUS_CM);
                        this.context.setProperty("popoEngine", this.engine);
                        this.context.setProperty("FragmentDocumentFactory", new DocumentFactoryImpl());
                        this.context.setProperty("SoapConnectionFactory", new SOAPConnectionFactoryImpl(this.context));
                        this.context.setProperty("trustedSoapConnectionFactory", new TrustedSOAPConnectionFactoryImpl(this.context, "CPS"));
                        this.context.setProperty("consumerTrustedSoapConnectionFactory", new TrustedSOAPConnectionFactoryImpl(this.context, "CPSConsumer"));
                        Date newPortalModificationTime = RoutingUtils.getPortalModificationTime(this.context, this.logger);
                        if (this.portalModificationTime == null || newPortalModificationTime.compareTo(this.portalModificationTime) > 0 || this.routingTable == null) {
                            this.routingTable = this.createRoutingTable();
                            this.portalModificationTime = newPortalModificationTime;
                        }
                        this.context.setProperty("routingTable", this.routingTable);
                        this.context.setProperty("hideDefaultHeader", this.cclConfiguration.getValue("hideDefaultPageHeader", true));
                        resourceLoader = new ResourceLoaderImpl(this.engine, "/WEB-INF/fragments", application);
                        this.context.setProperty("resourceLoader", resourceLoader);
                        Collection paramNames = this.cclConfiguration.getParameterNames();
                        for (String name : paramNames) {
                            if (!name.startsWith("portal.")) continue;
                            this.context.setProperty(name, this.cclConfiguration.getValue(name, true));
                        }
                        if (!"false".equals(this.context.getProperty("portal.page.concurrentrequests"))) {
                            this.context.setProperty("portal.threadpool", DashboardService.getThreadPool(this.context, this.logger));
                        }
                        props = null;
                        try {
                            InputStream stream = DashboardService.class.getClassLoader().getResourceAsStream("pf.properties");
                            props = new Properties();
                            props.load(stream);
                        }
                        catch (Exception e) {
                            if (this.logger == null || !this.logger.isErrorEnabled()) break block21;
                            this.logger.error("an exception was encountered when attempting to read the pf.properties file", e);
                        }
                    }
                    ValidationManager validationManager = ValidationManager.getInstance();
                    this.context.setProperty("validationManager", validationManager);
                    if (props != null) {
                        if ("true".equals(props.getProperty("record.pipeline"))) {
                            if (this.recordingHelper == null) {
                                this.recordingHelper = new RecordingHelper();
                            }
                            this.context.setProperty("record.pipeline", "true");
                            this.context.setProperty("record.pipeline.location", props.getProperty("record.pipeline.location"));
                        }
                        this.context.setProperty("portal.help.path", props.getProperty("portal.help.path"));
                        this.context.setProperty("portal.help.supportedLangs", props.getProperty("portal.help.supportedLangs"));
                        this.context.setProperty("portal.help.defaultBook", props.getProperty("portal.help.defaultBook"));
                        this.context.setProperty("controller.debug", props.getProperty("controller.debug"));
                        this.context.setProperty("controller.debug.file", props.getProperty("controller.debug.file"));
                        this.context.setProperty("controller.debug.IELite.file", props.getProperty("controller.debug.IELite.file"));
                        this.context.setProperty("controller.debug.IELite.level", props.getProperty("controller.debug.IELite.level"));
                        if (this.context.getProperty("portal.remote.debug") == null) {
                            this.context.setProperty("portal.remote.debug", props.getProperty("portal.remote.debug"));
                        }
                        this.context.setProperty("enable.validation", props.getProperty("enable.validation"));
                        HashMap<String, String> map = new HashMap<String, String>();
                        int sepIndex = -1;
                        String[] dbgObjects = props.getProperty("controller.debug.objects").split("\\s");
                        for (int i = 0; i < dbgObjects.length; ++i) {
                            sepIndex = dbgObjects[i].indexOf(":");
                            if (sepIndex == -1) continue;
                            map.put(dbgObjects[i].substring(0, sepIndex), dbgObjects[i].substring(sepIndex + 1));
                        }
                        this.context.setProperty("controller.debug.objects", map);
                        this.context.setProperty("fragment.token.checklist", props.getProperty("fragment.token.checklist"));
                    }
                    if (!validationManager.isInitialized()) {
                        validationManager.initialize(props != null ? "true".equals(this.context.getProperty("enable.validation")) : false, this.logger, resourceLoader);
                    }
                    this.registerApplicationValidator(validationManager, resourceLoader);
                    DebugHelper.getInstance().initialize(this.context);
                    NavSystem.initialize();
                }
                catch (Throwable e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("an exception was encountered when attempting to configure the dashboard service", e);
                    }
                }
                finally {
                    mutex.releaseWriteLock();
                }
            }
            catch (InterruptedException e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) break block22;
                this.logger.error("an exception was encountered when attempting acquire write lock to configure the dashboard service", e);
            }
        }
    }

    public void reconfigure(Configuration config) {
        this.configure(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        try {
            mutex.acquireReadLock();
            try {
                ServiceEnvironment env;
                Object overallTimer;
                block14: {
                    ServiceLoggerImpl.setRequestId(mc.getStrProperty("requestID"));
                    ServiceLoggerImpl.setSessionId(mc.getStrProperty("auth.passportid"));
                    overallTimer = null;
                    if (this.logger.isPerfLevelEnabled(0)) {
                        overallTimer = this.logger.startTimer(0, "invokeImpl", "Request Time", null);
                    }
                    env = new ServiceEnvironment(mc, this.context, this.logger);
                    if ("true".equals(this.context.getProperty("record.pipeline"))) {
                        try {
                            this.recordingHelper.writeToFile(env.getEnvelope().getAsString(), RecordingHelper.getCompleteDirectory(this.logger, (String)this.context.getProperty("record.pipeline.location"), env.getBusHeader()) + "/soapEnvelope", "-soapEnvelope.xml", this.logger);
                        }
                        catch (IOException e) {
                            if (this.logger == null || !this.logger.isErrorEnabled()) break block14;
                            this.logger.error("Problem writing soap envelope to output file", e);
                        }
                    }
                }
                SharedByteArrayOutputStream out = new SharedByteArrayOutputStream(4096);
                env.setOutputStream(out);
                this.dashboard.process(env);
                BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
                BIBusEnvelope responseEnvelope = new BIBusEnvelope();
                responseEnvelope.setBIBusHeader(requestEnvelope.getBIBusHeader().createCopy());
                BIBusEnvelopeUtils.copyNamespacesTo((BIBusEnvelope)requestEnvelope, (BIBusEnvelope)responseEnvelope);
                Map<String, String> cookies = env.getSetCookieList();
                for (Map.Entry<String, String> cookie : cookies.entrySet()) {
                    Cookie aCookie = new Cookie();
                    aCookie.setName(cookie.getKey());
                    aCookie.setValue(cookie.getValue());
                    responseEnvelope.addSetCookie(aCookie);
                }
                mc.setResponseName("response");
                mc.setProperty("response.envelope", (Object)responseEnvelope);
                mc.setProperty("response.status_code", (Object)Integer.toString(env.getResponseStatus()));
                if (env.getResponseStatus() != 304) {
                    if (env.getResponseEtag() != null) {
                        InternetHeaders headers = new InternetHeaders();
                        headers.addHeader("Etag", env.getResponseEtag());
                        mc.setProperty("response.headers", (Object)headers);
                    }
                    String header = "Content-Type: " + env.getResponseContentType() + "\r\n\r\n";
                    SequenceInputStream inStream = new SequenceInputStream(new ByteArrayInputStream(header.getBytes()), out.toStream());
                    ArrayList<SequenceInputStream> attachments = new ArrayList<SequenceInputStream>();
                    attachments.add(inStream);
                    mc.setProperty("response.attachments", attachments.iterator());
                    mc.setProperty("response.boundary", (Object)"---=_MIME_BOUNDARY_Q739K9UU82UDLK73");
                }
                if (overallTimer != null) {
                    this.logger.stopTimer(overallTimer);
                }
            }
            finally {
                mutex.releaseReadLock();
            }
        }
        catch (InterruptedException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("an exception was encountered when attempting acquire read lock to handle request", e);
            }
            throw new PogoException(e.getMessage());
        }
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        try {
            mutex.acquireWriteLock();
            try {
                this.engine = engine;
                super.compose_impl(engine);
            }
            finally {
                mutex.releaseWriteLock();
            }
        }
        catch (InterruptedException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("an exception was encountered when attempting acquire write lock to compose the dashboard service", e);
            }
            throw new PogoException(e.getMessage());
        }
    }

    private RoutingTable createRoutingTable() {
        RoutingTable routingTable;
        block4: {
            routingTable = new RoutingTable();
            try {
                String application;
                InputStream in = this.engine.getContext().getResourceAsStream("/WEB-INF/fragments/routing.xml");
                if (in != null) {
                    XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(in);
                    routingTable.addRoutingsFromStream(xsr);
                    xsr.close();
                    in.close();
                }
                if ((application = (String)this.context.getProperty("application")) != null && (in = this.engine.getContext().getResourceAsStream("/WEB-INF/fragments/applications/" + application + "/routing.xml")) != null) {
                    XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(in);
                    routingTable.addRoutingsFromStream(xsr);
                    xsr.close();
                    in.close();
                }
                this.addCMProducerRoutings(routingTable);
            }
            catch (Exception e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) break block4;
                this.logger.error("malformed url for connection", e);
            }
        }
        return routingTable;
    }

    private void registerApplicationValidator(ValidationManager validationManager, ResourceLoader resourceLoader) throws DashboardException {
        if (validationManager.isValidationEnabled()) {
            String applicationPath = (String)this.context.getProperty("application.path");
            try {
                XMLStreamReader reader;
                InputStream in = this.engine.getContext().getResourceAsStream(applicationPath + "/" + "application.xml");
                if (in != null && StaxUtils.moveToElement("validator", reader = XMLStreamFactory.createXMLStreamReader(in))) {
                    String namespace = reader.getAttributeValue("", "namespace");
                    String namespace_alias = reader.getAttributeValue("", "namespace-alias");
                    String href = reader.getAttributeValue("", "href");
                    String application = (String)this.context.getProperty("application");
                    validationManager.registerApplicationValidator(application, namespace, namespace_alias, href, resourceLoader);
                }
            }
            catch (Throwable e) {
                throw new DashboardException("pf.fragment.validation.initfailed", e);
            }
        }
    }

    private void addCMProducerRoutings(RoutingTable routingTable) {
        RoutingTable cmProvider = new RoutingTable("cmprovider", "");
        routingTable.addRouting(cmProvider);
        RoutingUtils.addProducerRoutings(routingTable, cmProvider, "/portal//portletProducer", this.context, this.logger);
        cmProvider.addRouting(new DynamicProducerRoutingTable(routingTable, this.context, this.logger));
    }

    static {
        THREAD_POOL_REF_COUNT = 0;
        mutex = new ReadWriteLock();
    }
}

