/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.service;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.BIBusEnvelopeUtils;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.ResourceLoaderImpl;
import com.cognos.portal.fragment.XSLTFactory;
import com.cognos.portal.fragment.producer.bseries.xts.XTSProcessorWrapper;
import com.cognos.portal.fragment.service.DashboardService;
import com.cognos.portal.fragment.service.ServiceEnvironment;
import com.cognos.portal.fragment.validation.ValidationManager;
import com.cognos.portal.soap.impl.BusConnectionImpl;
import com.cognos.portal.soap.impl.SOAPConnectionFactoryImpl;
import com.cognos.portal.soap.impl.TrustedSOAPConnectionFactoryImpl;
import com.cognos.portal.utils.ContextImpl;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.MessagesManager;
import com.cognos.portal.utils.NavSystem;
import com.cognos.portal.utils.ReadWriteLock;
import com.cognos.portal.xml.i18n.LocalizationManager;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineFactory;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.OutputDetails;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class FragmentService
extends BasicHandler {
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(FragmentService.class.getName());
    protected ServiceLogger logger = new ServiceLoggerImpl(FragmentService.class);
    private ICCLConfiguration cclConfiguration;
    protected IContext context;
    protected PogoEngine engine;
    private static ReadWriteLock mutex = new ReadWriteLock();

    public FragmentService() {
        super(category);
    }

    public FragmentService(Logger logger) {
        super(logger);
    }

    public void initialize() {
    }

    public void dispose() {
    }

    protected String getRequiredAttribute(Logger category, String name) throws PogoException {
        return super.getRequiredAttribute(category, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration config) {
        block17: {
            try {
                mutex.acquireWriteLock();
                try {
                    Properties props;
                    ResourceLoaderImpl resourceLoader;
                    block16: {
                        this.cclConfiguration = config.getICCLConfiguration();
                        this.context = new ContextImpl();
                        String application = this.getRequiredAttribute(category, "application");
                        String rootPath = "/WEB-INF/fragments";
                        String rootAppPath = rootPath + "/producers";
                        this.context.setProperty("application", application);
                        this.context.setProperty("application.path", rootAppPath);
                        this.context.setProperty("dispatcherPath", new URL(this.cclConfiguration.getValue("internalDispatcher", true)).getFile());
                        String dispatcherUrlOverride = this.cclConfiguration.getValue("portal.fragment.dispatcher.override", true);
                        if (dispatcherUrlOverride != null && dispatcherUrlOverride.length() > 0) {
                            this.context.setProperty("internalDispatcher", dispatcherUrlOverride);
                        } else {
                            this.context.setProperty("internalDispatcher", BusConnectionImpl.BUS_DISPATCHER);
                        }
                        this.context.setProperty("popoEngine", this.engine);
                        this.context.setProperty("cmPath", new URL(this.cclConfiguration.getValue("contentManager", true)).getFile());
                        this.context.setProperty("contentManager", BusConnectionImpl.BUS_CM);
                        this.context.setProperty("SoapConnectionFactory", new SOAPConnectionFactoryImpl(this.context));
                        this.context.setProperty("trustedSoapConnectionFactory", new TrustedSOAPConnectionFactoryImpl(this.context, "CPS"));
                        this.context.setProperty("consumerTrustedSoapConnectionFactory", new TrustedSOAPConnectionFactoryImpl(this.context, "CPSConsumer"));
                        this.context.setProperty("xts", new XTSProcessorWrapper(this.logger));
                        Class<?> foundClass = FragmentService.class.getClassLoader().loadClass("com.cognos.cps.bseries.xts.common.utils.HttpSOAPConnectionFactoryImpl");
                        Constructor<?> constructor = foundClass.getConstructor(new Class[0]);
                        this.context.setProperty("httpSoapConnectionFactory", constructor.newInstance(new Object[0]));
                        resourceLoader = new ResourceLoaderImpl(this.engine, "/WEB-INF/fragments/producers", null);
                        this.context.setProperty("resourceLoader", resourceLoader);
                        Collection paramNames = this.cclConfiguration.getParameterNames();
                        for (String name : paramNames) {
                            if (!name.startsWith("portal.")) continue;
                            this.context.setProperty(name, this.cclConfiguration.getValue(name, true));
                        }
                        props = null;
                        try {
                            InputStream stream = DashboardService.class.getClassLoader().getResourceAsStream("pf.properties");
                            props = new Properties();
                            props.load(stream);
                        }
                        catch (Exception e) {
                            if (this.logger == null || !this.logger.isErrorEnabled()) break block16;
                            this.logger.error("an exception was encountered when attempting to read the pf.properties file", e);
                        }
                    }
                    ValidationManager validationManager = ValidationManager.getInstance();
                    this.context.setProperty("validationManager", validationManager);
                    if (props != null) {
                        if ("true".equals(props.getProperty("record.pipeline"))) {
                            this.context.setProperty("record.pipeline", "true");
                            this.context.setProperty("record.pipeline.location", props.getProperty("record.pipeline.location"));
                        }
                        this.context.setProperty("producer.debug", props.getProperty("producer.debug"));
                        this.context.setProperty("producer.debug.stages.dir", props.getProperty("producer.debug.stages.dir"));
                    }
                    this.context.setProperty("hideDefaultHeader", this.cclConfiguration.getValue("hideDefaultPageHeader", true));
                    if (!validationManager.isInitialized()) {
                        validationManager.initialize(props != null ? "true".equals(this.context.getProperty("enable.validation")) : false, this.logger, resourceLoader);
                    }
                    NavSystem.initialize();
                }
                catch (Throwable e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("could not configure the service", e);
                    }
                }
                finally {
                    mutex.releaseWriteLock();
                }
            }
            catch (InterruptedException e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) break block17;
                this.logger.error("an exception was encountered when attempting acquire write lock to configure the dashboard service", e);
            }
        }
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        try {
            mutex.acquireWriteLock();
            try {
                this.engine = engine;
                super.compose_impl(engine);
            }
            finally {
                mutex.releaseWriteLock();
            }
        }
        catch (InterruptedException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("an exception was encountered when attempting acquire write lock to compose the dashboard service", e);
            }
            throw new PogoException(e.getMessage());
        }
    }

    public void reconfigure(Configuration config) {
        this.configure(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        try {
            mutex.acquireReadLock();
            try {
                ServiceLoggerImpl.setRequestId(mc.getStrProperty("requestID"));
                ServiceLoggerImpl.setSessionId(mc.getStrProperty("auth.passportid"));
                Object overallTimer = null;
                if (this.logger.isPerfLevelEnabled(0)) {
                    overallTimer = this.logger.startTimer(0, "invokeImpl", "Request Time", null);
                }
                ServiceEnvironment env = new ServiceEnvironment(mc, this.context, this.logger);
                try {
                    String debugParam = ((Environment)env).getParameter("frag-debug");
                    if (debugParam != null && debugParam.indexOf("restart") != -1) {
                        LocalizationManager.getInstance().initialize();
                        XSLTFactory.reinitialize();
                        PipelineFactory.reinitialize();
                    }
                    Pipeline pipeline = PipelineFactory.getInstance().createPipeline("producer:/" + ((Environment)env).getTarget(), env);
                    if (debugParam != null) {
                        pipeline.getRuntimeTrace().setDebugMode(debugParam);
                    }
                    if (pipeline == null) {
                        throw new PogoException("could not find producer '" + ((Environment)env).getTarget() + "'");
                    }
                    BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
                    IPipelineOutput result = pipeline.execute();
                    BIBusEnvelope responseEnvelope = new BIBusEnvelope();
                    responseEnvelope.setBIBusHeader(requestEnvelope.getBIBusHeader().createCopy());
                    BIBusEnvelopeUtils.copyNamespacesTo((BIBusEnvelope)requestEnvelope, (BIBusEnvelope)responseEnvelope);
                    mc.setResponseName("response");
                    mc.setProperty("response.envelope", (Object)responseEnvelope);
                    mc.setProperty("response.status_code", (Object)"200");
                    if (result != null) {
                        OutputDetails details = result.getOutputDetails();
                        String contentType = details != null ? details.getContentType() : "text/xml";
                        InputStream in = result.toInputStream();
                        String header = "Content-Type: " + contentType + "\r\n\r\n";
                        SequenceInputStream inStream = new SequenceInputStream(new ByteArrayInputStream(header.getBytes()), in);
                        ArrayList<SequenceInputStream> attachments = new ArrayList<SequenceInputStream>();
                        attachments.add(inStream);
                        mc.setProperty("response.attachments", attachments.iterator());
                        mc.setProperty("response.boundary", (Object)"---=_MIME_BOUNDARY_Q739K9UU82UDLK73");
                    }
                }
                catch (LocalizableException e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("cannot create producer", e);
                    }
                    throw new PogoException(MessagesManager.getInstance().getMessage(((Environment)env).getProductLocale(), e.getKey()), (Exception)e);
                }
                catch (Exception e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("cannot create producer", e);
                    }
                    throw new PogoException(MessagesManager.getInstance().getMessage(((Environment)env).getProductLocale(), "pf.fragment.producer.executionfailed"), e);
                }
                if (overallTimer != null) {
                    this.logger.stopTimer(overallTimer);
                }
            }
            finally {
                mutex.releaseReadLock();
            }
        }
        catch (InterruptedException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("an exception was encountered when attempting acquire read lock to handle request", e);
            }
            throw new PogoException(e.getMessage());
        }
    }
}

