/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.service;

import com.cognos.pogo.impl.MessageContextImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.service.FragmentService;
import com.cognos.portal.fragment.service.ServiceEnvironment;
import com.cognos.portal.soap.impl.stream.bus.BiBusParamsUpdater;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineFactory;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class InternalFragmentService
extends FragmentService {
    public InternalFragmentService() {
        super(null);
    }

    public InputStream handleRequest(String soapAction, String pathInfo, Parameters parameters, Element originalHeader) throws LocalizableException {
        try {
            String debugParam = null;
            if (parameters != null) {
                debugParam = parameters.getValue("frag-debug");
            }
            Object timer = null;
            if (this.logger.isPerfLevelEnabled(0)) {
                timer = this.logger.startTimer(0, "fragmentService.internalCall", "internal fragment service call", null);
            }
            MessageContextImpl mc = new MessageContextImpl();
            StringWriter writer = new StringWriter();
            XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(writer);
            XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(new StringReader(originalHeader.asXML()));
            BiBusParamsUpdater csr = new BiBusParamsUpdater(xsr, parameters, pathInfo);
            StaxUtils.copyCurrentElement(csr, xsw);
            Document busHeaderDoc = DocumentHelper.parseText((String)writer.getBuffer().toString());
            BIBusEnvelope envelope = new BIBusEnvelope();
            envelope.setBIBusHeader(busHeaderDoc.getRootElement());
            mc.setProperty("request.envelope", (Object)envelope);
            mc.setProperty("request.soapaction", (Object)soapAction);
            mc.setProperty("path_info", (Object)pathInfo);
            ServiceEnvironment env = new ServiceEnvironment((MessageContext)mc, this.context, this.logger);
            Pipeline pipeline = PipelineFactory.getInstance().createPipeline("producer:/" + ((Environment)env).getTarget(), env);
            if (pipeline == null) {
                throw new PogoException("could not find producer '" + ((Environment)env).getTarget() + "'");
            }
            if (debugParam != null) {
                pipeline.getRuntimeTrace().setDebugMode(debugParam);
            }
            IPipelineOutput result = pipeline.execute();
            if (timer != null) {
                this.logger.stopTimer(timer);
            }
            return result.toInputStream();
        }
        catch (Exception e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("cannot create producer", e);
            }
            throw new LocalizableException("pf.fragment.producer.executionfailed", e);
        }
    }

    public void configure(Configuration config, PogoEngine engine) {
        this.engine = engine;
        super.configure(config);
        this.context.setProperty("internalFragmentService", (Object)this);
    }

    @Override
    protected String getRequiredAttribute(Logger category, String name) throws PogoException {
        return "fragments";
    }
}

