/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.service;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.StringUtils;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.fragment.ResourceLoaderImpl;
import com.cognos.portal.fragment.routing.DynamicProducerRoutingTable;
import com.cognos.portal.fragment.routing.RoutingTable;
import com.cognos.portal.fragment.routing.RoutingUtils;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.service.ServiceEnvironment;
import com.cognos.portal.fragment.service.schema.Fragment;
import com.cognos.portal.schemas.QName;
import com.cognos.portal.schemas.fragments.FragmentInstance;
import com.cognos.portal.schemas.fragments.Layout;
import com.cognos.portal.schemas.fragments.LayoutColumn;
import com.cognos.portal.schemas.fragments.LayoutFragment;
import com.cognos.portal.schemas.fragments.LayoutProperties;
import com.cognos.portal.schemas.fragments.LayoutRow;
import com.cognos.portal.schemas.fragments.Meta;
import com.cognos.portal.schemas.fragments.Page;
import com.cognos.portal.soap.impl.SOAPConnectionFactoryImpl;
import com.cognos.portal.soap.impl.TrustedSOAPConnectionFactoryImpl;
import com.cognos.portal.utils.ContextImpl;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.MessagesManager;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.ReadWriteLock;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.InternetHeaders;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class RemoteFragment
extends BasicHandler {
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(RemoteFragment.class.getName());
    private static ReadWriteLock mutex = new ReadWriteLock();
    private Map ContextMap = new HashMap();
    private ServiceLogger serviceLogger = new ServiceLoggerImpl(RemoteFragment.class);
    private ICCLConfiguration cclConfiguration;
    private PogoEngine engine;
    private RoutingTable routingTable = null;
    private Date portalModificationTime = null;

    public RemoteFragment() {
        this(category);
    }

    public RemoteFragment(Logger logger) {
        super(logger);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        block5: {
            try {
                mutex.acquireWriteLock();
                try {
                    this.engine = engine;
                    super.compose_impl(engine);
                }
                finally {
                    mutex.releaseWriteLock();
                }
            }
            catch (InterruptedException e) {
                if (this.serviceLogger == null || !this.serviceLogger.isErrorEnabled()) break block5;
                this.serviceLogger.error("an exception was encountered when attempting acquire write lock to 'compose_impl' the remote fragment service", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration config) {
        block9: {
            try {
                mutex.acquireWriteLock();
                try {
                    this.cclConfiguration = config.getICCLConfiguration();
                    for (Map.Entry entry : this.ContextMap.entrySet()) {
                        this.configureContext((String)entry.getKey(), (IContext)entry.getValue(), "en");
                    }
                }
                catch (Exception e) {
                    if (this.serviceLogger != null && this.serviceLogger.isErrorEnabled()) {
                        this.serviceLogger.error("an exception was encountered when attempting to configure the remote fragment service", e);
                    }
                }
                finally {
                    mutex.releaseWriteLock();
                }
            }
            catch (InterruptedException e) {
                if (this.serviceLogger == null || !this.serviceLogger.isErrorEnabled()) break block9;
                this.serviceLogger.error("an exception was encountered when attempting acquire write lock to configure the remote fragment service", e);
            }
        }
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        RequestInfo requestInfo = this.getRequestInfo(mc);
        InputStream input = null;
        try {
            if (requestInfo.application != null && requestInfo.application.length() > 0) {
                String resolvedTarget;
                this.impersonateService(requestInfo, mc);
                IContext context = this.getContext(requestInfo);
                ServiceEnvironment env = new ServiceEnvironment(mc, context, this.serviceLogger);
                Parameters requestParams = env.createParameters();
                String mode = env.getParameter("frag-mode");
                if (mode != null && mode.equals(env.getParameter("frag-delegate"))) {
                    String curTarget = env.getRoutingInfo(requestInfo.pathInfo);
                    requestParams.add("frag-originaltarget", requestInfo.pathInfo);
                    requestParams.add("frag-target", curTarget);
                    requestParams.add("frag-application", "dashboard");
                    resolvedTarget = "/delegate/" + mode;
                } else {
                    resolvedTarget = requestInfo.pathInfo;
                }
                input = env.getTargetStream(env.getRoutingInfo(resolvedTarget), requestParams);
                String hrefPrefix = "/" + requestInfo.soapAction + "/" + requestInfo.application;
                input = this.rewriteFragment(input, hrefPrefix);
            }
        }
        catch (DashboardException e) {
            if (!"pf.fragment.server.notargetdocument".equals(e.getKey())) {
                input = this.excpetionToFragmentError(e, requestInfo);
            }
        }
        catch (Exception e) {
            input = this.excpetionToFragmentError(e, requestInfo);
        }
        if (input != null) {
            this.createSuccessResponse(mc, "text/xml", input);
        } else {
            this.createNotFoundResponse(mc);
        }
    }

    private InputStream excpetionToFragmentError(Throwable throwable, RequestInfo requestInfo) {
        InputStream input;
        if (this.serviceLogger.isErrorEnabled()) {
            this.serviceLogger.error("Error while retreiving target. Request :" + requestInfo != null ? requestInfo.toString() : "null", throwable);
        }
        if (throwable instanceof FragmentError) {
            input = ((FragmentError)throwable).toInputStream();
        } else {
            FragmentError error = new FragmentError("fragment.remote.err5", MessagesManager.getInstance().getMessage(requestInfo.locale, "pf.fragment.server.executionfailed"), throwable);
            input = error.toInputStream();
        }
        return input;
    }

    public void reconfigure(Configuration config) {
        this.configure(config);
    }

    private IContext getContext(RequestInfo requestInfo) throws FragmentError {
        IContext context = this.getContextFromCache(requestInfo);
        if (context == null) {
            context = new ContextImpl();
            this.configureContext(requestInfo.application, context, requestInfo.locale);
            this.storeContextInCache(requestInfo, context);
        }
        return context;
    }

    private void storeContextInCache(RequestInfo requestInfo, IContext context) throws FragmentError {
        try {
            mutex.acquireWriteLock();
            try {
                this.ContextMap.put(requestInfo.application, context);
            }
            finally {
                mutex.releaseWriteLock();
            }
        }
        catch (InterruptedException e) {
            if (this.serviceLogger != null && this.serviceLogger.isErrorEnabled()) {
                this.serviceLogger.error("an exception was encountered when attempting to cache context for application '" + requestInfo.application + "'", e);
            }
            throw new FragmentError("fragment.remote.err1", MessagesManager.getInstance().getMessage(requestInfo.locale, "pf.fragment.server.executionfailed"), e);
        }
    }

    private IContext getContextFromCache(RequestInfo requestInfo) throws FragmentError {
        IContext context = null;
        try {
            mutex.acquireReadLock();
            try {
                context = (IContext)this.ContextMap.get(requestInfo.application);
            }
            finally {
                mutex.releaseReadLock();
            }
        }
        catch (InterruptedException e) {
            if (this.serviceLogger != null && this.serviceLogger.isErrorEnabled()) {
                this.serviceLogger.error("an exception was encountered when attempting acquire read lock to handle request", e);
            }
            throw new FragmentError("fragment.remote.err2", MessagesManager.getInstance().getMessage(requestInfo.locale, "pf.fragment.server.executionfailed"), e);
        }
        return context;
    }

    private void configureContext(String application, IContext context, String locale) throws FragmentError {
        try {
            context.setProperty("dispatcherPath", new URL(this.cclConfiguration.getValue("internalDispatcher", true)).getFile());
            context.setProperty("internalDispatcher", "bus://dispatcher");
            String gateway = this.cclConfiguration.getValue("gateway", true);
            context.setProperty("gateway", gateway);
            context.setProperty("cmPath", new URL(this.cclConfiguration.getValue("contentManager", true)).getFile());
            context.setProperty("contentManager", "bus://cm");
            context.setProperty("SoapConnectionFactory", new SOAPConnectionFactoryImpl(context));
            context.setProperty("trustedSoapConnectionFactory", new TrustedSOAPConnectionFactoryImpl(context, "CPS"));
            context.setProperty("consumerTrustedSoapConnectionFactory", new TrustedSOAPConnectionFactoryImpl(context, "CPSConsumer"));
            String webinfRootPath = "/WEB-INF/fragments";
            String rootAppPath = webinfRootPath + "/applications/" + application;
            context.setProperty("application", application);
            context.setProperty("application.path", rootAppPath);
            ResourceLoaderImpl resourceLoader = new ResourceLoaderImpl(this.engine, webinfRootPath, application);
            context.setProperty("resourceLoader", resourceLoader);
            context.setProperty("popoEngine", this.engine);
            Date newPortalModificationTime = RoutingUtils.getPortalModificationTime(context, this.serviceLogger);
            if (this.portalModificationTime == null || newPortalModificationTime.compareTo(this.portalModificationTime) > 0 || this.routingTable == null) {
                this.routingTable = this.createRoutingTable(application, context);
                this.portalModificationTime = newPortalModificationTime;
            }
            context.setProperty("routingTable", this.routingTable);
        }
        catch (Exception e) {
            if (this.serviceLogger != null && this.serviceLogger.isErrorEnabled()) {
                this.serviceLogger.error("an exception was encountered while create a context for application '" + application + "'", e);
            }
            throw new FragmentError("fragment.remote.err3", MessagesManager.getInstance().getMessage(locale, "pf.fragment.server.executionfailed"), e);
        }
    }

    private InputStream rewriteFragment(InputStream input, String hrefPrefix) throws XMLStreamException {
        XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(input, "UTF-8");
        InputStream rewrittenStream = null;
        if (xsr.nextTag() != -1) {
            String tagName = xsr.getLocalName();
            rewrittenStream = "fragment".equals(tagName) ? this.rewriteFragment(xsr, hrefPrefix) : ("page".equals(tagName) ? this.rewritePage(xsr, hrefPrefix) : this.copyStream(xsr));
        }
        return rewrittenStream;
    }

    private InputStream copyStream(XMLStreamReader xsr) throws XMLStreamException {
        SharedByteArrayOutputStream output = new SharedByteArrayOutputStream(4112);
        XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(output);
        StaxUtils.copyCurrentElement(xsr, xsw);
        xsw.close();
        return output.toStream();
    }

    private InputStream rewritePage(XMLStreamReader xsr, String hrefPrefix) throws XMLStreamException {
        Page page = new Page();
        page.read(xsr);
        this.removeEditFromLayout(page);
        int count = page.getFragmentInstanceCount();
        for (int i = 0; i < count; ++i) {
            FragmentInstance instance = page.getFragmentInstance(i);
            instance.setInfo(null);
        }
        SharedByteArrayOutputStream output = new SharedByteArrayOutputStream(4112);
        XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(output);
        page.write(xsw);
        xsw.close();
        return output.toStream();
    }

    private void removeEditFromLayout(Page page) {
        Layout layout = page.getLayout();
        this.removeEditFromProperties(layout.getLayoutProperties());
        int rowCount = layout.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            LayoutRow row = layout.getRow(i);
            this.removeEditFromRow(row);
        }
    }

    private void removeEditFromRow(LayoutRow row) {
        LayoutProperties properties = row.getLayoutProperties();
        this.removeEditFromProperties(properties);
        int columnCount = row.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            LayoutColumn column = row.getColumn(i);
            this.removeEditFromColumn(column);
        }
    }

    private void removeEditFromColumn(LayoutColumn column) {
        this.removeEditFromProperties(column.getLayoutProperties());
        int rowCount = column.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            LayoutRow row = column.getRow(i);
            this.removeEditFromRow(row);
        }
        int fragmentCount = column.getFragmentCount();
        for (int i = 0; i < fragmentCount; ++i) {
            LayoutFragment fragment = column.getFragment(i);
            this.removeEditFromProperties(fragment.getLayoutProperties());
        }
    }

    private void removeEditFromProperties(LayoutProperties properties) {
        if (properties != null) {
            boolean added = false;
            int paramCount = properties.getParamCount();
            for (int j = 0; j < paramCount; ++j) {
                LayoutProperties.Param parameter = properties.getParam(j);
                if (!"noedit".equals(parameter.getName())) continue;
                parameter.setValue("true");
                added = true;
                break;
            }
            if (!added) {
                LayoutProperties.Param parameter = new LayoutProperties.Param(properties);
                parameter.setName("noedit");
                parameter.setValue("true");
                properties.addParam(parameter);
            }
        }
    }

    private InputStream rewriteFragment(XMLStreamReader xsr, String hrefPrefix) throws XMLStreamException {
        Fragment fragment = new Fragment();
        fragment.read(xsr);
        this.addMode(fragment, "edit");
        SharedByteArrayOutputStream output = new SharedByteArrayOutputStream(4112);
        XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(output);
        fragment.write(xsw);
        xsw.close();
        return output.toStream();
    }

    private void addMode(Fragment fragment, String mode) {
        Meta meta = fragment.getMeta();
        if (meta == null) {
            meta = new Meta();
            fragment.setMeta(meta);
        }
        int modesCount = meta.getModesCount();
        boolean modeExists = false;
        for (int i = 0; i < modesCount; ++i) {
            QName qName = meta.getModes(i);
            if (!mode.equals(qName.getLocalPart())) continue;
            modeExists = true;
            break;
        }
        if (!modeExists) {
            meta.addModes(new QName("", mode, ""));
        }
    }

    private RequestInfo getRequestInfo(MessageContext mc) {
        String soapAction = this.getSoapAction(mc);
        String pathInfo = this.getPathInfo(mc, soapAction);
        String application = null;
        if (pathInfo.length() > 0) {
            int index = pathInfo.indexOf(47, 1);
            if (index != -1) {
                application = pathInfo.substring(0, index);
                pathInfo = pathInfo.substring(index);
            } else {
                application = pathInfo;
                pathInfo = "";
            }
            if (application.charAt(0) == '/') {
                application = application.substring(1);
            }
        }
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.application = application;
        requestInfo.pathInfo = pathInfo;
        requestInfo.soapAction = soapAction;
        requestInfo.locale = this.getLocale(mc);
        return requestInfo;
    }

    private String getLocale(MessageContext mc) {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        String locale = envelope.getUserPreferenceValue("productLocale");
        if (locale == null) {
            locale = "en";
        }
        return locale;
    }

    private String getPathInfo(MessageContext mc, String soapAction) {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        String pathInfo = (String)mc.getProperty("path_info");
        if (pathInfo != null) {
            String startPath = "/" + soapAction;
            if (pathInfo.startsWith(startPath)) {
                pathInfo = pathInfo.substring(startPath.length());
            }
        } else {
            pathInfo = "";
        }
        if ("".equals(pathInfo) && (pathInfo = envelope.getFormValue("pathinfo")) == null) {
            pathInfo = "";
        }
        return pathInfo;
    }

    private String getSoapAction(MessageContext mc) {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        String soapAction = envelope.getDispatcherTransportValue("originalSOAPAction");
        if (soapAction == null || soapAction.length() == 0) {
            soapAction = (String)mc.getProperty("request.soapaction");
        }
        return soapAction;
    }

    private void impersonateService(RequestInfo requestInfo, MessageContext mc) {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        envelope.setDispatcherTransport("originalSOAPAction", requestInfo.application);
        mc.setProperty("path_info", (Object)requestInfo.pathInfo);
    }

    private String rewriteHref(String href, String prefix) {
        return prefix + href;
    }

    private void createNotFoundResponse(MessageContext mc) {
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        mc.setProperty("response.envelope", (Object)responseEnvelope);
        mc.setProperty("response.status_code", (Object)"404");
    }

    private void createSuccessResponse(MessageContext mc, String ctype, InputStream stream) {
        StringBuffer header = new StringBuffer(32);
        header.append("Content-Type: ").append(ctype).append("\r\n");
        header.append("\r\n");
        mc.setProperty("response.status_code", (Object)"200");
        mc.setProperty("response.status_msg", (Object)"OK");
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Type", "text/xml; charset=utf-8");
        mc.setProperty(".responseheaders", (Object)headers);
        BIBusEnvelope env = new BIBusEnvelope();
        mc.setProperty("response.envelope", (Object)env);
        ArrayList<SequenceInputStream> attachments = new ArrayList<SequenceInputStream>();
        attachments.add(new SequenceInputStream(new ByteArrayInputStream(header.toString().getBytes()), stream));
        mc.setProperty("response.boundary", (Object)StringUtils.getUniqueValue());
        mc.setProperty("response.attachments", attachments.iterator());
    }

    private RoutingTable createRoutingTable(String application, IContext context) {
        RoutingTable routingTable;
        block4: {
            routingTable = new RoutingTable();
            try {
                XMLStreamReader xsr;
                InputStream in = this.engine.getContext().getResourceAsStream("/WEB-INF/fragments/routing.xml");
                if (in != null) {
                    xsr = XMLStreamFactory.createXMLStreamReader(in);
                    routingTable.addRoutingsFromStream(xsr);
                    xsr.close();
                    in.close();
                }
                if (application != null && (in = this.engine.getContext().getResourceAsStream("/WEB-INF/fragments/applications/" + application + "/routing.xml")) != null) {
                    xsr = XMLStreamFactory.createXMLStreamReader(in);
                    routingTable.addRoutingsFromStream(xsr);
                    xsr.close();
                    in.close();
                }
                this.addCMProducerRoutings(routingTable, context);
            }
            catch (Exception e) {
                if (this.serviceLogger == null || !this.serviceLogger.isErrorEnabled()) break block4;
                this.serviceLogger.error("malformed url for connection", e);
            }
        }
        return routingTable;
    }

    private void addCMProducerRoutings(RoutingTable routingTable, IContext context) {
        RoutingTable cmProvider = new RoutingTable("cmprovider", "");
        routingTable.addRouting(cmProvider);
        RoutingUtils.addProducerRoutings(routingTable, cmProvider, "/portal//portletProducer", context, this.serviceLogger);
        cmProvider.addRouting(new DynamicProducerRoutingTable(routingTable, context, this.serviceLogger));
    }

    private class FragmentError
    extends Exception {
        private String code;
        private String message;
        private Throwable rootCause;

        public FragmentError(String code, String message, Throwable rootCause) {
            this.code = code;
            this.message = message;
            this.rootCause = rootCause;
        }

        public InputStream toInputStream() {
            StringBuffer buffer = new StringBuffer(128);
            buffer.append("<fragment><error>");
            if (this.code != null) {
                buffer.append("<code>");
                EncodingUtils.xmlEncode((String)this.code, (StringBuffer)buffer);
                buffer.append("</code>");
            }
            if (this.message != null) {
                buffer.append("<message>");
                EncodingUtils.xmlEncode((String)this.message, (StringBuffer)buffer);
                buffer.append("</message>");
            }
            if (this.rootCause != null) {
                buffer.append("<details>");
                EncodingUtils.xmlEncode((String)this.rootCause.getMessage(), (StringBuffer)buffer);
                buffer.append("</details>");
            }
            buffer.append("</error></fragment>");
            try {
                return new ByteArrayInputStream(buffer.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                if (RemoteFragment.this.serviceLogger.isErrorEnabled()) {
                    RemoteFragment.this.serviceLogger.error("unsupporeted encoding error while create a fragment error", e);
                }
                return new ByteArrayInputStream(buffer.toString().getBytes());
            }
        }
    }

    private class RequestInfo {
        private transient String application;
        private transient String pathInfo;
        private transient String soapAction;
        private transient String locale;

        private RequestInfo() {
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(80);
            buffer.append("application=");
            buffer.append(this.application);
            buffer.append(",pathInfo=");
            buffer.append(this.pathInfo);
            buffer.append(",soapAction=");
            buffer.append(this.soapAction);
            return buffer.toString();
        }
    }
}

