/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.service;

import com.cognos.caf.CAFLibrary;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.meta.Cookie;
import com.cognos.portal.fragment.meta.Meta;
import com.cognos.portal.fragment.server.DashboardContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.SOAPFaultException;
import com.cognos.portal.fragment.service.InternalFragmentService;
import com.cognos.portal.fragment.validation.Validator;
import com.cognos.portal.fragment.validation.ValidatorCacheEntry;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionFactory;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.impl.bus.cm.FormPost;
import com.cognos.portal.soap.impl.xml.XMLAttachmentHandler;
import com.cognos.portal.utils.DebugHelper;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.MessagesManager;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.capability.UserCapabilities;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.xml.stream.PathIterator;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.xts.ext.XTSExt;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Element;

public class ServiceEnvironment
extends Environment {
    private static final String TARGET_PROTOCOL_BUS = "bus://";
    private static final String TARGET_PROTOCOL_INTERNAL = "internal://";
    protected MessageContext mc;
    protected BIBusEnvelope envelope;
    protected Parameters requestParams;
    private String soapAction;
    private String requestMethod;
    private Parameters sessionParams;
    Map<String, String> setCookieMap;
    private List excludedParameters;
    private ServiceLogger logger;
    private String gateway;
    private String webContent;

    public ServiceEnvironment(MessageContext mc, IContext context, ServiceLogger logger) {
        boolean isCCSessionValid;
        String session;
        block5: {
            super(context, logger);
            this.excludedParameters = Arrays.asList("encoding", "b_action", "pathinfo");
            this.logger = logger != null ? logger.cloneForClass(ServiceEnvironment.class) : null;
            this.mc = mc;
            this.envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
            this.soapAction = this.envelope.getDispatcherTransportValue("originalSOAPAction");
            if (this.soapAction == null || this.soapAction.length() == 0) {
                this.soapAction = (String)mc.getProperty("request.soapaction");
            }
            this.requestMethod = this.envelope.getEnvironmentValue("REQUEST_METHOD");
            this.userCapabilities = new UserCapabilities();
            this.userCapabilities.processUserCapabilityCache(this.envelope.getOptionalUserCapabilitiesCache(), this.envelope.getPassportID());
            this.requestParams = this.createParameters(true);
            session = this.envelope.getCookieValue("cc_session");
            isCCSessionValid = false;
            try {
                isCCSessionValid = XTSExt.isCCSessionValid((String)session, (String)this.getPassportID(), (String)"|", (String)":");
            }
            catch (Exception e) {
                if (logger == null || !logger.isErrorEnabled()) break block5;
                logger.error("Exception trying to validate the cc_session cookie" + e.getMessage());
            }
        }
        if (!isCCSessionValid) {
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("The cc_session cookie is not valid, cc_session cookie is: " + session);
            }
            session = null;
        }
        this.sessionParams = session != null ? ServiceEnvironment.parseSessionCookie(session) : this.createSessionCookie();
    }

    @Override
    public String getTarget() {
        String pathInfo = (String)this.mc.getProperty("path_info");
        if (pathInfo != null) {
            String startPath = "/" + this.soapAction;
            if (pathInfo.startsWith(startPath)) {
                pathInfo = pathInfo.substring(startPath.length());
            }
        } else {
            pathInfo = "";
        }
        if ("".equals(pathInfo) && (pathInfo = this.requestParams.getValue("pathinfo")) == null) {
            pathInfo = "";
        }
        if (pathInfo.contains("://")) {
            if (this.logger.isErrorEnabled()) {
                this.logger.debug("getTarget() called with absolute URL: " + pathInfo + " resetting to empty string");
            }
            pathInfo = "";
        }
        return pathInfo;
    }

    @Override
    public String getSoapAction() {
        return this.soapAction;
    }

    @Override
    public String getRequestMethod() {
        return this.requestMethod;
    }

    @Override
    public String getDefaultTarget(DashboardContext context) {
        InputStream in = null;
        PogoEngine engine = (PogoEngine)this.context.getProperty("popoEngine");
        if (engine != null) {
            in = engine.getContext().getResourceAsStream(this.getRealPath("/application.xml"));
        }
        if (in != null) {
            return this.getParsedDefaultTarget(in);
        }
        return null;
    }

    @Override
    public String getParameter(String name) {
        return this.requestParams.getValue(name);
    }

    private void setParameter(String name, String value) {
        this.requestParams.setValue(name, value);
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.requestParams.getValues(name);
    }

    @Override
    public Enumeration getParameterNames() {
        return new NamesEnumerator(this.requestParams);
    }

    @Override
    public String getRealPath(String path) {
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = "/" + path;
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(path + " --> " + this.getProperty("application.path") + path);
        }
        return this.getProperty("application.path") + path;
    }

    @Override
    public String getWebContent() {
        if (this.webContent == null) {
            this.webContent = this.getParameter("frag-webcontent");
            if (this.webContent == null) {
                this.webContent = this.envelope.getEnvironmentValue("WEB_CONTENT_ROOT");
            }
            if (this.webContent == null) {
                this.webContent = "..";
            }
        }
        return this.webContent;
    }

    @Override
    public String getGatewayURI() {
        if (this.gateway == null) {
            this.gateway = this.getParameter("frag-gateway");
            if (this.gateway == null) {
                this.gateway = this.envelope.getEnvironmentValue("SCRIPT_NAME");
            }
        }
        return this.gateway;
    }

    @Override
    public void setBrowser() {
        String useragent = this.envelope.getEnvironmentValue("HTTP_USER_AGENT");
        super.setBrowser(useragent);
    }

    @Override
    public String getApplicationGatewayURI() {
        return this.envelope.getEnvironmentValue("SCRIPT_NAME") + "/" + this.soapAction;
    }

    @Override
    public String getUserID() {
        String value = this.sessionParams.getValue("e_hp");
        return value != null ? value : "__unknown__";
    }

    @Override
    public String getUserName() {
        String value = this.sessionParams.getValue("e_user");
        return value != null ? value : "Anonymous";
    }

    @Override
    public String getRequestEtag() {
        String etag = this.envelope.getEnvironmentValue("IF-NONE-MATCH");
        if (etag != null && !"".equals(etag) && etag.charAt(0) == '\"' && etag.charAt(etag.length() - 1) == '\"') {
            etag = etag.substring(1, etag.length() - 1);
        }
        return etag;
    }

    @Override
    public String getSkin() {
        String skin = this.getParameter("skin");
        if (skin != null && !"".equals(skin)) {
            return skin;
        }
        return this.envelope.getUserPreferenceValue("skin");
    }

    @Override
    public String getProductLocale() {
        String locale = this.envelope.getUserPreferenceValue("productLocale");
        if (locale == null) {
            locale = "en";
        }
        return locale;
    }

    @Override
    public String getContentLocale() {
        String locale = this.envelope.getUserPreferenceValue("contentLocale");
        if (locale == null) {
            locale = "en-us";
        }
        return locale;
    }

    @Override
    public String getUserPreference(String name) {
        return this.envelope.getUserPreferenceValue(name);
    }

    @Override
    public void proxyResource(String url) throws DashboardException {
        throw new DashboardException("pf.fragment.server.executionfailed");
    }

    @Override
    protected InputStream getLocalTargetStream(String target, Parameters parameters) throws DashboardException {
        InputStream in;
        if (target.startsWith(TARGET_PROTOCOL_INTERNAL)) {
            return this.getInternalFragmentTargetStream(target, parameters);
        }
        if (target.startsWith(TARGET_PROTOCOL_BUS)) {
            return this.getBiBusTargetStream(target, parameters);
        }
        PogoEngine engine = (PogoEngine)this.context.getProperty("popoEngine");
        if (engine != null && (in = engine.getContext().getResourceAsStream(this.getRealPath(target))) != null) {
            return in;
        }
        throw new DashboardException("pf.fragment.server.notargetdocument");
    }

    @Override
    protected InputStream getRemoteTargetStream(URL targetURL, Parameters parameters) throws DashboardException {
        try {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("getRemoteTargetStream::Opening a url connection '" + targetURL.toExternalForm() + "' with parameters '" + parameters.toString() + "'");
            }
            HttpURLConnection uc = (HttpURLConnection)targetURL.openConnection();
            String userAgent = this.envelope.getEnvironmentValue("HTTP_USER_AGENT");
            if (userAgent != null) {
                uc.setRequestProperty("User-Agent", userAgent);
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("User-Agent: " + userAgent);
                }
            }
            uc.setRequestProperty("Accept", "text/xml,application/xml");
            String acceptLanguage = this.envelope.getEnvironmentValue("HTTP_ACCEPT_LANGUAGE");
            if (acceptLanguage != null) {
                uc.setRequestProperty("Accept-Language", acceptLanguage);
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Accept-Language: " + acceptLanguage);
                }
            }
            ArrayList cookies = new ArrayList();
            this.createCookieList(cookies);
            StringBuffer sb = new StringBuffer();
            ServiceEnvironment.buildCookies(sb, cookies);
            if (sb.length() > 0) {
                uc.setRequestProperty("Cookie", sb.toString());
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Cookie: " + sb.toString());
                }
            }
            if (parameters != null && parameters.size() > 0) {
                uc.setDoOutput(true);
                uc.setRequestMethod("POST");
                uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                parameters.writeAsFormUrlEncoded(uc.getOutputStream());
            } else {
                uc.connect();
            }
            if (uc.getResponseCode() == 200) {
                InputStream input = uc.getInputStream();
                String respContentType = uc.getContentType();
                if (respContentType != null && this.isFragmentContentType(respContentType)) {
                    return input;
                }
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    this.logger.error("received content-type: " + respContentType);
                    byte[] b = new byte[4096];
                    int l = input.read(b, 0, 4096);
                    String s = new String(b, 0, l);
                    this.logger.error("received stream (first 4096 bytes): " + s);
                }
                Object[] args = new String[]{respContentType};
                throw new DashboardException("pf.fragment.server.expectingxmldocument", args);
            }
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("received http response code: " + uc.getResponseCode());
            }
            throw new DashboardException("pf.fragment.server.executionfailed");
        }
        catch (IOException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("io exception: " + e.getMessage());
            }
            throw new DashboardException("pf.fragment.server.executionfailed", e);
        }
    }

    private boolean isFragmentContentType(String contentType) {
        return contentType.indexOf("text/xml") != -1 || contentType.indexOf("application/xml") != -1 || contentType.indexOf("application/x-fragment+xml") != -1;
    }

    private Parameters parseTargetContext(String protocol, String target) {
        String reqSoapAction;
        String pathInfo = target.substring(protocol.length());
        int sep = pathInfo.indexOf(35);
        if (sep != -1) {
            pathInfo = pathInfo.substring(0, sep);
        }
        if (pathInfo.length() > 0 && pathInfo.charAt(0) == '/') {
            pathInfo = pathInfo.substring(1);
        }
        sep = pathInfo.indexOf(47, 0);
        int query = pathInfo.indexOf(63);
        if (sep == -1) {
            sep = query;
        } else if (query < sep && query != -1) {
            sep = query;
        }
        if (sep == -1) {
            reqSoapAction = pathInfo;
            pathInfo = "";
        } else {
            reqSoapAction = pathInfo.substring(0, sep);
            pathInfo = pathInfo.substring(sep);
        }
        String queryString = "";
        query = pathInfo.indexOf(63);
        if (query != -1) {
            queryString = pathInfo.substring(query + 1);
            pathInfo = pathInfo.substring(0, query);
        }
        if (pathInfo.length() > 0 && pathInfo.charAt(0) != '/') {
            pathInfo = "/" + pathInfo;
        }
        Parameters targetContext = new Parameters();
        targetContext.add("soap-action", reqSoapAction);
        targetContext.add("pathInfo", pathInfo);
        targetContext.add("query", queryString);
        return targetContext;
    }

    private InputStream getBiBusTargetStream(String target, Parameters parameters) throws DashboardException {
        Parameters targetContext = this.parseTargetContext(TARGET_PROTOCOL_BUS, target);
        String reqSoapAction = targetContext.getValue("soap-action");
        String pathInfo = targetContext.getValue("pathInfo");
        parameters.add(Parameters.parse(targetContext.getValue("query")));
        try {
            SOAPConnection connection = ((SOAPConnectionFactory)this.getProperty("SoapConnectionFactory")).createConnection(this.logger);
            FormPost post = new FormPost();
            XMLAttachmentHandler handler = new XMLAttachmentHandler();
            post.setBusHeader(this.envelope.getBIBusHeader());
            post.setResponseAttachmentHandler(handler);
            BusHeaderHandler busHeaderHandler = new BusHeaderHandler(this);
            post.setResponseHeaderHandler(busHeaderHandler);
            post.setSOAPAction(reqSoapAction);
            post.setFormParams(parameters);
            post.setPathInfo(pathInfo);
            String dispatcherUrl = (String)this.getProperty("internalDispatcher");
            connection.execute(post, dispatcherUrl + pathInfo);
            return handler.getInputStream();
        }
        catch (MalformedURLException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("malformed url", e);
            }
            throw new DashboardException("pf.fragment.server.notargetdocument", null, e);
        }
        catch (SOAPFault e) {
            String code;
            String detail = e.getDetail();
            String string = code = e.getFaultCode() != null ? e.getFaultCode().getLocalPart() : null;
            if (detail != null && detail.indexOf("CM-REQ-4159") != -1 || "nav:InvalidCredentials".equals(code) || "InvalidCredentials".equals(code)) {
                throw new InvalidCredentialsFault("pf.fragment.server.invalidcredentials", null, e);
            }
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("got a fault response", e);
            }
            Object[] args = new String[]{e.getFaultString()};
            throw new SOAPFaultException("pf.fragment.server.receivedfault", args, e);
        }
        catch (IOException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("got an input/output error", e);
            }
            Object[] args = new String[]{e.getLocalizedMessage()};
            throw new DashboardException("pf.fragment.server.receivedfault", args, e);
        }
        catch (XMLStreamException e) {
            Location loc = e.getLocation();
            if (loc != null) {
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    StringBuffer sb = new StringBuffer("got an xml stream error");
                    sb.append(" (Line=").append(loc.getLineNumber());
                    sb.append(", Column=").append(loc.getColumnNumber());
                    sb.append(", Offset=").append(loc.getCharacterOffset());
                    sb.append(")");
                    this.logger.error(sb.toString(), e);
                }
                Object[] args = new String[]{Integer.toString(loc.getLineNumber()), Integer.toString(loc.getColumnNumber()), Integer.toString(loc.getCharacterOffset())};
                throw new DashboardException("pf.fragment.server.invalidxmldocument.details", args, e);
            }
            throw new DashboardException("pf.fragment.server.invalidxmldocument", null, e);
        }
    }

    private InputStream getInternalFragmentTargetStream(String target, Parameters parameters) throws DashboardException {
        Parameters targetContext = this.parseTargetContext(TARGET_PROTOCOL_INTERNAL, target);
        String reqSoapAction = targetContext.getValue("soap-action");
        String pathInfo = targetContext.getValue("pathInfo");
        parameters.add(Parameters.parse(targetContext.getValue("query")));
        try {
            InternalFragmentService ifs = (InternalFragmentService)((Object)this.context.getProperty("internalFragmentService"));
            return ifs.handleRequest(reqSoapAction, pathInfo, parameters, this.envelope.getBIBusHeader());
        }
        catch (LocalizableException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Error while calling the internal fragment service", e);
            }
            throw new DashboardException("pf.fragment.server.notargetdocument", null, e);
        }
    }

    @Override
    protected boolean acceptParameterName(String name) {
        if (this.excludedParameters.contains(name)) {
            return false;
        }
        return super.acceptParameterName(name);
    }

    private Parameters createParameters(boolean acceptAllParameters) {
        Parameters parameters = new Parameters();
        Element item = this.envelope.getFormFieldVars();
        for (Element itemElement : item.elements()) {
            Element anElement = itemElement.element("name");
            if (anElement == null) continue;
            String name = anElement.getText();
            anElement = itemElement.element("value");
            if ("frag-debug".equals(name) && !DebugHelper.getInstance().isRemoteDebugEnabled(this.envelope)) continue;
            if ("frag-producer".equals(name)) {
                String value = null;
                if (anElement != null) {
                    try {
                        value = this.getValidationManager().staticUnsign(anElement.getText());
                    }
                    catch (DashboardException dashboardException) {
                        // empty catch block
                    }
                }
                parameters.add(name, value == null ? "+++PRODUCER_IS_INVALID+++" : value);
                continue;
            }
            if (!acceptAllParameters && !this.acceptParameterName(name)) continue;
            parameters.add(name, anElement != null ? anElement.getText() : null);
        }
        if (parameters.getValue("frag-agent") == null && this.envelope.getEnvironmentValue("HTTP_USER_AGENT") != null) {
            parameters.setValue("frag-agent", this.envelope.getEnvironmentValue("HTTP_USER_AGENT"));
        }
        return parameters;
    }

    @Override
    public void discardParameters(String target) {
        this.discardParameter(target, "frag-id");
        this.discardParameter(target, "skin");
        this.webContent = null;
        this.discardParameter(target, "frag-webcontent");
        this.gateway = null;
        this.discardParameter(target, "frag-gateway");
    }

    private void discardParameter(String target, String paramName) {
        String value = this.getParameter(paramName);
        if (value != null) {
            Parameters tempParams = new Parameters();
            tempParams.add(paramName, value);
            try {
                this.verify(target, tempParams, true);
            }
            catch (DashboardException e) {
                this.setParameter(paramName, null);
            }
        }
    }

    private static void buildCookies(StringBuffer sb, List cookies) {
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (sb.length() > 0) {
                    sb.append(';');
                    sb.append(' ');
                }
                sb.append(c.getName()).append('=').append(c.getValue());
            }
        }
    }

    private static void buildCookies(List cookies, Element cookiesVars) {
        if (cookiesVars != null) {
            Iterator cookiesIterator = cookiesVars.elementIterator();
            while (cookiesIterator.hasNext()) {
                Element item = (Element)cookiesIterator.next();
                Element nameElement = item.element("name");
                String name = nameElement.getTextTrim();
                Iterator it = cookies.iterator();
                while (it.hasNext()) {
                    Cookie c = (Cookie)it.next();
                    if (!c.getName().equals(name)) continue;
                    it.remove();
                    break;
                }
                Element valueElement = item.element("value");
                Cookie cookie = new Cookie(nameElement.getText(), valueElement.getText());
                cookies.add(cookie);
            }
        }
    }

    private static Parameters parseSessionCookie(String cookieValue) {
        Parameters params = new Parameters();
        if (cookieValue != null) {
            int i = cookieValue.indexOf(124);
            while (i >= 0) {
                String temp = cookieValue.substring(0, i);
                ServiceEnvironment.parseSessionValue(params, temp);
                cookieValue = cookieValue.substring(i + 1);
                i = cookieValue.indexOf(124);
            }
            ServiceEnvironment.parseSessionValue(params, cookieValue);
        }
        return params;
    }

    private static void parseSessionValue(Parameters params, String value) {
        int p = value.indexOf(58);
        if (p > 0) {
            params.add(value.substring(0, p), EncodingUtils.urldecode(value.substring(p + 1).replace('*', '%').replaceAll("%%", "*"), "UTF-8"));
        } else {
            params.add(value, (String)null);
        }
    }

    private Parameters createSessionCookie() {
        Parameters params = new Parameters();
        return params;
    }

    public BIBusEnvelope getEnvelope() {
        return this.envelope;
    }

    @Override
    public void createCookieList(List cookies) {
        ServiceEnvironment.buildCookies(cookies, this.envelope.getCookieVars());
        ServiceEnvironment.buildCookies(cookies, this.envelope.getSetCookieVars());
    }

    @Override
    public String getBusHeader() {
        return this.envelope.getBIBusHeader().asXML();
    }

    @Override
    public String getPassportID() {
        return this.envelope.getPassportID();
    }

    @Override
    public String getPassportCookie() {
        String camCookie = this.envelope.getSetCookieValue("cam_passport");
        if (camCookie != null && camCookie.length() > 0) {
            return camCookie;
        }
        return this.envelope.getCookieValue("cam_passport");
    }

    @Override
    public String getUserSessionIdCookie() {
        String userSessionIdCookie = this.envelope.getSetCookieValue("usersessionid");
        if (userSessionIdCookie != null && userSessionIdCookie.length() > 0) {
            return userSessionIdCookie;
        }
        return this.envelope.getCookieValue("usersessionid");
    }

    @Override
    public void verify(String target, boolean ignoreUnknownParams) throws DashboardException {
        this.verify(target, this.requestParams, ignoreUnknownParams);
    }

    @Override
    public void verify(String target, Parameters parameters, boolean ignoreUnknownParams) throws DashboardException {
        Validator validator;
        if (this.getValidationManager().isValidationEnabled() && parameters != null && parameters.size() > 0 && (validator = this.getValidationDocument(target, parameters)) != null) {
            validator.verify(this, parameters, ignoreUnknownParams);
        }
    }

    @Override
    public Validator createValidationDocument(String target, Parameters params) throws DashboardException {
        if (!this.getValidationManager().isValidationEnabled() || target == null || "".equals(target)) {
            return null;
        }
        if ("meta-only".equals(params.getValue("frag-directive"))) {
            return null;
        }
        if (this.getValidationManager().useDefaultValidation(target)) {
            Validator validator = this.getValidationManager().createValidatorFromNamespace(this, "urn:cognos:fragments:validator:page", target);
            if (validator != null) {
                validator.compile();
            }
            this.setValidationDocument(target, validator);
            return validator;
        }
        Validator validator = null;
        String fragValidator = params.getValue("frag-validator");
        if (fragValidator != null && !"".equals(fragValidator) && (validator = this.getValidationManager().createValidatorFromValidationBlob(this, fragValidator, target)) != null) {
            validator.compile();
            this.setValidationDocument(target, validator);
            params.remove("frag-validator");
            return validator;
        }
        String routingResolvedTarget = this.getRoutingInfo(target);
        String validatorCacheKey = this.getValidationManager().buildValidatorCacheKey(routingResolvedTarget, params);
        ValidatorCacheEntry validatorCacheEntry = this.getValidationManager().getCachedValidator(validatorCacheKey);
        if (validatorCacheEntry != null) {
            if (ValidatorCacheEntry.TYPE_NO_VALIDATOR == validatorCacheEntry.cacheType) {
                validator = null;
            } else if (ValidatorCacheEntry.TYPE_DEFAULTNAMESPACE == validatorCacheEntry.cacheType) {
                validator = this.getValidationManager().createValidatorFromNamespace(this, validatorCacheEntry.validatorNS, target);
            } else if (ValidatorCacheEntry.TYPE_VALIDATORXML == validatorCacheEntry.cacheType) {
                validator = this.getValidationManager().createValidatorFromValidatorXML(this, validatorCacheEntry.validatorNS, validatorCacheEntry.validatorXML, target);
            }
            if (validator != null) {
                validator.compile();
            }
            this.setValidationDocument(target, validator);
            return validator;
        }
        try {
            Parameters target_params = new Parameters();
            target_params.add("frag-directive", "meta-only");
            target_params.add("frag-id", "VAL_ID");
            for (Parameters.NameValuePair nvp : params) {
                String name = nvp.getName();
                if (!name.startsWith("frag-") && !name.startsWith("path") || "frag-validator".equals(name) || "frag-state".equals(name) || !this.acceptParameterName(name)) continue;
                target_params.add(name, nvp.getValues());
            }
            InputStream inStream = this.getTargetStream(routingResolvedTarget, target_params);
            XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(inStream);
            StaxUtils.moveToNextElement(xsr);
            String rootName = xsr.getLocalName();
            if ("page".equals(rootName)) {
                validator = this.getValidationManager().createValidatorFromNamespace(this, "urn:cognos:fragments:validator:page", target);
                this.getValidationManager().putCacheValidator(validatorCacheKey, ValidatorCacheEntry.TYPE_DEFAULTNAMESPACE, "urn:cognos:fragments:validator:page", null);
            } else if (StaxUtils.moveToElement("meta", xsr)) {
                String bypassAttr = xsr.getAttributeValue("", "bypassValidation");
                String validationNS = "true".equals(bypassAttr) ? "urn:cognos:fragments:validator:bypass" : null;
                validator = this.getValidationManager().createValidatorFromNamespace(this, validationNS, target);
                Meta meta = new Meta(validator);
                meta.read(xsr);
                String validatorXML = validator.getValidatorXML();
                this.getValidationManager().putCacheValidator(validatorCacheKey, ValidatorCacheEntry.TYPE_VALIDATORXML, validationNS, validatorXML);
            } else {
                this.getValidationManager().putCacheValidator(validatorCacheKey, ValidatorCacheEntry.TYPE_NO_VALIDATOR, null, null);
            }
            if (validator != null) {
                validator.compile();
            }
            this.setValidationDocument(target, validator);
            return validator;
        }
        catch (XMLStreamException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Error attempting to retrieve the target validator " + e.getMessage());
            }
            throw new DashboardException("pf.fragment.validation.metaretrievalerror", e);
        }
    }

    @Override
    public String sign(String target, String name, String value) throws DashboardException {
        Parameters params = new Parameters();
        params.add(name, value);
        this.sign(target, params);
        return params.getValue(name);
    }

    @Override
    public void sign(String target, Parameters inParams) throws DashboardException {
        Validator validator;
        if (this.getValidationManager().isValidationEnabled() && (validator = this.getValidationDocument(target, this.requestParams)) != null) {
            validator.sign(inParams);
        }
    }

    @Override
    public String unsign(String target, String name, String value) throws DashboardException {
        Validator validator;
        if (this.getValidationManager().isValidationEnabled() && (validator = this.getValidationDocument(target, this.requestParams)) != null) {
            return validator.unsign(name, value);
        }
        return value;
    }

    @Override
    public String secureLogError(String error) {
        String securedErrorMsg = null;
        try {
            securedErrorMsg = CAFLibrary.secureError((String)error, (BIBusEnvelope)this.getEnvelope());
            securedErrorMsg = securedErrorMsg != null ? MessagesManager.getInstance().getMessage(this.getProductLocale(), "pf.common.securelog.errormsg", (Object[])new String[]{securedErrorMsg}) : MessagesManager.getInstance().getMessage(this.getProductLocale(), "pf.common.securelog.errormsg.noid");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return securedErrorMsg;
    }

    @Override
    protected void copyParameter(String name, Parameters parameters) {
        for (Parameters.NameValuePair nvp : this.requestParams) {
            if (!nvp.getName().equals(name)) continue;
            parameters.add(name, nvp.getValues()).setFlag(nvp.getFlag());
            break;
        }
    }

    @Override
    public String getControllerAgent() {
        return this.envelope.getEnvironmentValue("X-Controller-Agent");
    }

    @Override
    public void addSetCookie(String name, String value) {
        if (this.setCookieMap == null) {
            this.setCookieMap = new HashMap<String, String>();
        }
        this.setCookieMap.put(name, value);
    }

    @Override
    public Map<String, String> getSetCookieList() {
        if (this.setCookieMap == null) {
            return Collections.emptyMap();
        }
        return this.setCookieMap;
    }

    @Override
    public String getSessionParameter(String name) {
        return this.sessionParams.getValue(name);
    }

    public static class BusHeaderHandler
    implements IXMLHandler {
        private Environment env;
        static String[] PATHARRAY = new String[]{"/Header/biBusHeader/hdrSession/setCookieVars/item/name", "/Header/biBusHeader/hdrSession/setCookieVars/item/value"};

        public BusHeaderHandler(Environment env) {
            this.env = env;
        }

        @Override
        public void handle(XMLStreamReader reader) throws XMLStreamException {
            int path;
            PathIterator pathIt = new PathIterator(reader, PATHARRAY);
            String name = null;
            String value = null;
            while ((path = pathIt.moveToNextPath()) != -1) {
                switch (path) {
                    case 0: {
                        name = pathIt.getElementText();
                        break;
                    }
                    case 1: {
                        if (name == null) break;
                        value = pathIt.getElementText();
                        this.env.addSetCookie(name, value);
                    }
                }
            }
        }
    }

    private class NamesEnumerator
    implements Enumeration {
        private Iterator it;

        NamesEnumerator(Parameters parameters) {
            this.it = parameters.iterator();
        }

        public Object nextElement() {
            return ((Parameters.NameValuePair)this.it.next()).getName();
        }

        @Override
        public boolean hasMoreElements() {
            return this.it.hasNext();
        }
    }
}

