/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.service;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.portal.fragment.service.ContentManagerQuerySession;
import com.cognos.portal.utils.ReadWriteLock;
import javax.servlet.http.Cookie;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class SessionHandler
extends BasicHandler {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(SessionHandler.class.getName());
    private ICCLConfiguration cclConfiguration;
    private static ReadWriteLock mutex = new ReadWriteLock();

    public SessionHandler() {
        super(cat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        block10: {
            try {
                mutex.acquireReadLock();
                try {
                    BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
                    String passportID = env.getPassportID();
                    String session = env.getCookieValue("cc_session");
                    if (passportID == null) {
                        break block10;
                    }
                    if (session != null) break block10;
                    ContentManagerQuerySession command = new ContentManagerQuerySession(env.getUserPreferenceValue("contentLocale"));
                    Element biBusHeader = env.getBIBusHeader();
                    command.setBIBusHeader(biBusHeader.createCopy());
                    try {
                        command.execute();
                        String value = command.getSessionValue();
                        if (value != null) {
                            Cookie cookie = new Cookie("cc_session", value);
                            cookie.setPath(this.cclConfiguration.getValue("webcontentRootURI", true));
                            mc.addCookie(cookie);
                        }
                    }
                    catch (CommandExecutionException e) {
                        BIBusEnvelope responseEnvelope = command.getResponseEnvelope();
                        env.setBIBusHeader(responseEnvelope.getBIBusHeader().createCopy());
                        mc.setFault(new Fault("PROBABLE_AUTHENTICATION_FAULT", (SOAPEnvelope)responseEnvelope));
                    }
                    catch (CCLConfigurationException cCLConfigurationException) {
                        // empty catch block
                    }
                }
                finally {
                    mutex.releaseReadLock();
                }
            }
            catch (InterruptedException e) {
                throw new PogoException(e.getMessage());
            }
        }
    }

    public void configure(Configuration configuration) {
        try {
            mutex.acquireWriteLock();
            try {
                this.cclConfiguration = configuration.getICCLConfiguration();
            }
            finally {
                mutex.releaseWriteLock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }
}

