/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.service;

import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.autoregistration.FragmentProducer;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.service.ServiceEnvironment;
import com.cognos.portal.fragment.validation.Validator;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.web.WebUtils;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WSRPEnvironment
extends ServiceEnvironment {
    private static final String BRIDGE_FRAGMENT_ID_PARAM = "bridge-fid";
    public static final String RESOURCE_PATH_INFO = "/wsrp/fragments/resource";
    private static final String REDIRECT_PATH_INFO = "/wsrp/fragments/resource/redirect";
    private String redirectURI;
    private String applicationGateway;
    private String gatewayOverride;
    private String webContentOverride;
    private boolean isSubFragmentParamsModified;
    private ServiceLogger logger;
    private List events;
    private String target;
    private String sessionId;
    private boolean isSoapRequest;

    public WSRPEnvironment(MessageContext mc, IContext context, ServiceLogger logger, boolean isSoapRequest) {
        super(mc, context, logger);
        this.logger = logger != null ? logger.cloneForClass(WSRPEnvironment.class) : null;
        this.isSoapRequest = isSoapRequest;
        if (isSoapRequest) {
            this.requestParams = new Parameters();
        } else {
            this.initializeEnvForHttpRequest();
        }
        this.isSubFragmentParamsModified = false;
    }

    private void initializeEnvForHttpRequest() {
        this.sessionId = this.getParameter(BRIDGE_FRAGMENT_ID_PARAM);
        if (this.sessionId != null) {
            this.requestParams.remove(BRIDGE_FRAGMENT_ID_PARAM);
        }
        this.gatewayOverride = this.getParameter("bridge-gatewayURL");
        if (this.gatewayOverride != null) {
            try {
                this.gatewayOverride = this.getValidationManager().staticUnsign(this.gatewayOverride);
            }
            catch (DashboardException e) {
                this.gatewayOverride = null;
            }
            this.requestParams.remove("bridge-gatewayURL");
        }
        this.webContentOverride = this.getParameter("bridge-webContentURL");
        if (this.webContentOverride != null) {
            try {
                this.webContentOverride = this.getValidationManager().staticUnsign(this.webContentOverride);
            }
            catch (DashboardException e) {
                this.webContentOverride = null;
            }
            this.requestParams.remove("bridge-webContentURL");
        }
    }

    public boolean isSoapRequest() {
        return this.isSoapRequest;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void addSubFragmentParam(String id, String name, String value) {
        this.isSubFragmentParamsModified = true;
        Parameters parameters = this.getParametersForSubFragment(id);
        if (parameters == null) {
            parameters = this.createSubFragmentParameters(id);
        }
        parameters.add(name, value);
    }

    private void saveSubfragmentParams() {
        if (this.subFragmentParameters != null) {
            this.requestParams.remove("frag-sub");
            for (Parameters p : this.subFragmentParameters.values()) {
                this.addParameter("frag-sub", p.toString());
            }
        }
        this.isSubFragmentParamsModified = false;
    }

    public FragmentProducer createProducerFragment(String path) {
        PogoEngine engine = (PogoEngine)this.context.getProperty("popoEngine");
        if (engine != null && engine.getContext() != null) {
            return new FragmentProducer(engine.getContext(), path, this.logger);
        }
        return null;
    }

    public void setWebContentOverride(String webContent) {
        this.webContentOverride = webContent;
    }

    public String getWebContentOverride() {
        return this.webContentOverride;
    }

    public void setGatewayOverride(String gateway) {
        this.gatewayOverride = gateway;
    }

    public String getGatewayOverride() {
        return this.gatewayOverride;
    }

    public void addParameter(String name, String value) {
        this.requestParams.add(name, value);
    }

    public void addParameters(String name, String[] values) {
        this.requestParams.add(name, values);
    }

    public void setParameter(String name, String value) {
        this.requestParams.setValue(name, value);
    }

    @Override
    public Parameters createParameters() {
        if (this.isSubFragmentParamsModified) {
            this.saveSubfragmentParams();
        }
        return super.createParameters();
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @Override
    public String getTarget() {
        if (this.target == null) {
            String startPath;
            String pathInfo = (String)this.mc.getProperty("path_info");
            if (pathInfo != null && pathInfo.startsWith(startPath = RESOURCE_PATH_INFO)) {
                this.target = pathInfo.substring(startPath.length());
            }
            if (this.target == null) {
                this.target = "";
            }
        }
        return this.target;
    }

    public String getRedirectURL() {
        if (this.redirectURI == null || this.redirectURI.length() == 0) {
            this.redirectURI = this.getGatewayURI() + REDIRECT_PATH_INFO;
        }
        return this.redirectURI;
    }

    @Override
    public String getApplicationGatewayURI() {
        if (this.applicationGateway == null || this.applicationGateway.length() == 0) {
            this.applicationGateway = this.getGatewayURI() + RESOURCE_PATH_INFO;
        }
        return this.applicationGateway;
    }

    @Override
    public String getGatewayURI() {
        if (this.gatewayOverride != null && this.gatewayOverride.length() > 0) {
            return this.gatewayOverride;
        }
        String portalAgent = this.getParameter("frag-portalAgent");
        if (portalAgent != null && (portalAgent.equals("cognos") || portalAgent.equals("cognosFragmentServer"))) {
            return super.getGatewayURI();
        }
        return (String)this.getProperty("gateway");
    }

    public String getWsdlURI(String path) {
        StringBuffer sb = new StringBuffer();
        sb.append("http://").append(this.envelope.getEnvironmentValue("SERVER_NAME"));
        String port = this.envelope.getEnvironmentValue("SERVER_PORT");
        if (port != null && !"".equals(port)) {
            sb.append(':').append(port);
        }
        sb.append(this.envelope.getEnvironmentValue("SCRIPT_NAME"));
        sb.append(path);
        return sb.toString();
    }

    @Override
    public String getWebContent() {
        if (this.webContentOverride != null) {
            return this.webContentOverride;
        }
        String portalAgent = this.getParameter("frag-portalAgent");
        if (portalAgent != null && (portalAgent.equals("cognos") || portalAgent.equals("cognosFragmentServer"))) {
            return super.getWebContent();
        }
        return WebUtils.getAbsoluteURI(super.getWebContent(), (String)this.getProperty("gateway"));
    }

    public String getBusHeaderString() {
        return this.envelope.getBIBusHeader().asXML();
    }

    public String getPathInfo() {
        return (String)this.mc.getProperty("path_info");
    }

    public void patchUserAgent(String agent) {
        this.envelope.setEnvironment("HTTP_USER_AGENT", agent);
    }

    public String getProducerXMLEndPoint() {
        String endpoint = null;
        String producerxml = WebUtils.getPathInfoParameter(this.getPathInfo(), "producerxml", '/');
        if (producerxml != null) {
            byte[] producerXMLBytes = EncodingUtils.web64decode(producerxml, true);
            try {
                endpoint = new String(producerXMLBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return endpoint;
    }

    public String getProducerHandle() {
        String handle = WebUtils.getPathInfoParameter(this.getPathInfo(), "handle", '/');
        if (handle != null) {
            return handle;
        }
        return "";
    }

    public boolean isGenericEdit() {
        String pathInfo = this.getPathInfo();
        return "generic".equals(WebUtils.getPathInfoParameter(pathInfo, "edit", ':')) || "generic".equals(WebUtils.getPathInfoParameter(pathInfo, "editmode", '/'));
    }

    public void setEvents(List eventsList) {
        this.events = eventsList;
        if (this.events != null) {
            for (String value : this.events) {
                this.addParameter("frag-event", value);
                Map subFragmentParams = this.getLoadedSubFragmentParameters();
                Set keys = subFragmentParams.keySet();
                Iterator keysIt = keys.iterator();
                while (keysIt.hasNext()) {
                    this.addSubFragmentParam((String)keysIt.next(), "frag-event", value);
                }
            }
        }
    }

    @Override
    public Parameters getParametersForSubFragment(String subFragmentId) {
        Parameters p = super.getParametersForSubFragment(subFragmentId);
        if (p == null) {
            p = this.createSubFragmentParameters(subFragmentId);
        }
        return p;
    }

    private Parameters createSubFragmentParameters(String subFragmentId) {
        Parameters p = new Parameters();
        p.setValue("frag-id", subFragmentId);
        if (this.events != null) {
            Iterator it = this.events.iterator();
            while (it.hasNext()) {
                p.add("frag-event", (String)it.next());
            }
        }
        this.getLoadedSubFragmentParameters().put(subFragmentId, p);
        return p;
    }

    private Map getLoadedSubFragmentParameters() {
        if (this.subFragmentParameters == null) {
            this.loadsubFragmentParameters();
        }
        return this.subFragmentParameters;
    }

    private boolean isFragmentParameter(String parameter) throws DashboardException {
        Validator validator = this.getValidationDocument(this.getTarget(), this.requestParams);
        return validator != null && validator.isParameter(parameter);
    }

    public void copyGatewayAndWebcontentOverrideToEnvParams() throws DashboardException {
        if (this.webContentOverride != null && this.isFragmentParameter("bridge-webContentURL")) {
            this.requestParams.add("bridge-webContentURL", this.getValidationManager().staticSign(this.webContentOverride));
        }
        if (this.gatewayOverride != null && this.isFragmentParameter("bridge-gatewayURL")) {
            this.requestParams.add("bridge-gatewayURL", this.getValidationManager().staticSign(this.gatewayOverride));
        }
    }
}

