/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.service;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.BIBusEnvelopeUtils;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.fragment.ResourceLoaderImpl;
import com.cognos.portal.fragment.routing.DynamicProducerRoutingTable;
import com.cognos.portal.fragment.routing.RoutingTable;
import com.cognos.portal.fragment.routing.RoutingUtils;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.DashboardProcessor;
import com.cognos.portal.fragment.service.DashboardService;
import com.cognos.portal.fragment.service.FragmentService;
import com.cognos.portal.fragment.service.InternalFragmentService;
import com.cognos.portal.fragment.service.WSRPEnvironment;
import com.cognos.portal.fragment.validation.ValidationManager;
import com.cognos.portal.fragment.wsrp.BridgeException;
import com.cognos.portal.fragment.wsrp.DocumentFactoryImpl;
import com.cognos.portal.fragment.wsrp.FragmentWSRPBridge;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.impl.BusConnectionImpl;
import com.cognos.portal.soap.impl.SOAPConnectionFactoryImpl;
import com.cognos.portal.soap.impl.TrustedSOAPConnectionFactoryImpl;
import com.cognos.portal.utils.ContextImpl;
import com.cognos.portal.utils.ExceptionExtension;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.MessagesManager;
import com.cognos.portal.utils.NavSystem;
import com.cognos.portal.utils.ReadWriteLock;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.mail.internet.InternetHeaders;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WSRPService
extends BasicHandler {
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(FragmentService.class.getName());
    protected IContext context;
    private ICCLConfiguration cclConfiguration;
    private DashboardProcessor dashboard;
    protected FragmentWSRPBridge bridge;
    private ServiceLogger logger = new ServiceLoggerImpl(WSRPService.class);
    private PogoEngine engine;
    private static ReadWriteLock mutex = new ReadWriteLock();
    private RoutingTable routingTable = null;
    private Date portalModificationTime = null;
    private InternalFragmentService internalFragmentService = new InternalFragmentService();

    public WSRPService() {
        super(category);
    }

    public WSRPService(Logger logger) {
        super(logger);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.engine = engine;
        super.compose_impl(engine);
    }

    public void initialize() {
        block2: {
            try {
                this.dashboard = new DashboardProcessor(this.logger);
                this.dashboard.init(this.context);
                this.bridge = new FragmentWSRPBridge(this.dashboard, this.logger);
                this.bridge.init(this.context);
            }
            catch (LocalizableException e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) break block2;
                this.logger.error("cannot initialize dashboard processor or WSRP bridge", e);
            }
        }
    }

    public void dispose() {
        block9: {
            try {
                mutex.acquireWriteLock();
                try {
                    if (this.dashboard != null) {
                        this.dashboard.terminate();
                    }
                    this.dashboard = null;
                }
                catch (DashboardException e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("cannot terminate dashboard processor", e);
                    }
                }
                finally {
                    mutex.releaseWriteLock();
                }
            }
            catch (InterruptedException e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) break block9;
                this.logger.error("an exception was encountered when attempting acquire write lock to terminate the dashboard service", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration config) {
        block18: {
            try {
                mutex.acquireWriteLock();
                try {
                    Properties props;
                    ResourceLoaderImpl resourceLoader;
                    block17: {
                        this.internalFragmentService.configure(config, this.engine);
                        this.cclConfiguration = config.getICCLConfiguration();
                        this.context = new ContextImpl();
                        String application = this.getRequiredAttribute(category, "application");
                        String webinfRootPath = "/WEB-INF/fragments";
                        this.context.setProperty("internalFragmentService", (Object)this.internalFragmentService);
                        this.context.setProperty("xslt.xmlashtml", "xmlashtml.xslt");
                        this.context.setProperty("xslt.page", "page.xslt");
                        this.context.setProperty("xslt.pagelet", "pagelet.xslt");
                        this.context.setProperty("xslt.script", "script.xslt");
                        this.context.setProperty("xslt.css", "cssstyles.xslt");
                        this.context.setProperty("xslt.messageasjs", "messageasjs.xslt");
                        this.context.setProperty("xslt.message", "messages/pfmessages.xml");
                        String rootAppPath = webinfRootPath + "/applications/" + application;
                        this.context.setProperty("application", application);
                        this.context.setProperty("application.path", rootAppPath);
                        this.context.setProperty("css.skin", "corporate");
                        this.context.setProperty("dispatcherPath", new URL(this.cclConfiguration.getValue("internalDispatcher", true)).getFile());
                        String dispatcherUrlOverride = this.cclConfiguration.getValue("portal.fragment.dispatcher.override", true);
                        if (dispatcherUrlOverride != null && dispatcherUrlOverride.length() > 0) {
                            this.context.setProperty("internalDispatcher", dispatcherUrlOverride);
                        } else {
                            this.context.setProperty("internalDispatcher", BusConnectionImpl.BUS_DISPATCHER);
                        }
                        this.context.setProperty("portal.fragment.response.pattern", this.cclConfiguration.getValue("portal.fragment.response.pattern", true));
                        this.context.setProperty("cookieSecure", this.cclConfiguration.getValue("cookieSecure", true));
                        String gateway = this.cclConfiguration.getValue("gateway", true);
                        this.context.setProperty("gateway", gateway);
                        this.context.setProperty("cmPath", new URL(this.cclConfiguration.getValue("contentManager", true)).getFile());
                        this.context.setProperty("contentManager", BusConnectionImpl.BUS_CM);
                        this.context.setProperty("popoEngine", this.engine);
                        this.context.setProperty("FragmentDocumentFactory", new DocumentFactoryImpl());
                        this.context.setProperty("trustedSoapConnectionFactory", new TrustedSOAPConnectionFactoryImpl(this.context, "CPS"));
                        this.context.setProperty("consumerTrustedSoapConnectionFactory", new TrustedSOAPConnectionFactoryImpl(this.context, "CPSConsumer"));
                        this.context.setProperty("SoapConnectionFactory", new SOAPConnectionFactoryImpl(this.context));
                        Date newPortalModificationTime = RoutingUtils.getPortalModificationTime(this.context, this.logger);
                        if (this.portalModificationTime == null || newPortalModificationTime.compareTo(this.portalModificationTime) > 0 || this.routingTable == null) {
                            this.routingTable = this.createRoutingTable();
                            this.portalModificationTime = newPortalModificationTime;
                        }
                        this.context.setProperty("routingTable", this.routingTable);
                        resourceLoader = new ResourceLoaderImpl(this.engine, "/WEB-INF/fragments", application);
                        this.context.setProperty("resourceLoader", resourceLoader);
                        props = null;
                        try {
                            InputStream stream = DashboardService.class.getClassLoader().getResourceAsStream("pf.properties");
                            props = new Properties();
                            props.load(stream);
                        }
                        catch (Exception e) {
                            if (this.logger == null || !this.logger.isErrorEnabled()) break block17;
                            this.logger.error("an exception was encountered when attempting to read the pf.properties file", e);
                        }
                    }
                    ValidationManager validationManager = ValidationManager.getInstance();
                    this.context.setProperty("validationManager", validationManager);
                    if (props != null) {
                        if ("true".equals(props.getProperty("record.pipeline"))) {
                            this.context.setProperty("record.pipeline", "true");
                            this.context.setProperty("record.pipeline.location", props.getProperty("record.pipeline.location"));
                        }
                        this.context.setProperty("portal.help.path", props.getProperty("portal.help.path"));
                        this.context.setProperty("portal.help.supportedLangs", props.getProperty("portal.help.supportedLangs"));
                        this.context.setProperty("portal.help.defaultBook", props.getProperty("portal.help.defaultBook"));
                        this.context.setProperty("controller.debug", props.getProperty("controller.debug"));
                        this.context.setProperty("controller.debug.file", props.getProperty("controller.debug.file"));
                        this.context.setProperty("controller.debug.IELite.file", props.getProperty("controller.debug.IELite.file"));
                        this.context.setProperty("controller.debug.IELite.level", props.getProperty("controller.debug.IELite.level"));
                        this.context.setProperty("enable.validation", props.getProperty("enable.validation"));
                        HashMap<String, String> map = new HashMap<String, String>();
                        int sepIndex = -1;
                        String[] dbgObjects = props.getProperty("controller.debug.objects").split("\\s");
                        for (int i = 0; i < dbgObjects.length; ++i) {
                            sepIndex = dbgObjects[i].indexOf(":");
                            if (sepIndex == -1) continue;
                            map.put(dbgObjects[i].substring(0, sepIndex), dbgObjects[i].substring(sepIndex + 1));
                        }
                        this.context.setProperty("controller.debug.objects", map);
                    }
                    this.context.setProperty("hideDefaultHeader", this.cclConfiguration.getValue("hideDefaultPageHeader", true));
                    if (!validationManager.isInitialized()) {
                        validationManager.initialize(props != null ? "true".equals(this.context.getProperty("enable.validation")) : false, this.logger, resourceLoader);
                    }
                    NavSystem.initialize();
                }
                catch (Throwable e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("an exception was encountered when attempting to configure the WSRP service", e);
                    }
                }
                finally {
                    mutex.releaseWriteLock();
                }
            }
            catch (InterruptedException e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) break block18;
                this.logger.error("an exception was encountered when attempting acquire write lock to configure the dashboard service", e);
            }
        }
    }

    private RoutingTable createRoutingTable() {
        RoutingTable routingTable;
        block4: {
            routingTable = new RoutingTable();
            try {
                String application;
                InputStream in = this.engine.getContext().getResourceAsStream("/WEB-INF/fragments/routing.xml");
                if (in != null) {
                    XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(in);
                    routingTable.addRoutingsFromStream(xsr);
                    xsr.close();
                    in.close();
                }
                if ((application = (String)this.context.getProperty("application")) != null && (in = this.engine.getContext().getResourceAsStream("/WEB-INF/fragments/applications/" + application + "/routing.xml")) != null) {
                    XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(in);
                    routingTable.addRoutingsFromStream(xsr);
                    xsr.close();
                    in.close();
                }
                this.addCMProducerRoutings(routingTable);
            }
            catch (Exception e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) break block4;
                this.logger.error("malformed url for connection", e);
            }
        }
        return routingTable;
    }

    private void addCMProducerRoutings(RoutingTable routingTable) {
        RoutingTable cmProvider = new RoutingTable("cmprovider", "");
        routingTable.addRouting(cmProvider);
        RoutingUtils.addProducerRoutings(routingTable, cmProvider, "/portal//portletProducer", this.context, this.logger);
        cmProvider.addRouting(new DynamicProducerRoutingTable(routingTable, this.context, this.logger));
    }

    public void reconfigure(Configuration config) {
        this.configure(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        try {
            mutex.acquireReadLock();
            try {
                BIBusEnvelope requestEnvelope;
                List elements;
                ServiceLoggerImpl.setRequestId(mc.getStrProperty("requestID"));
                ServiceLoggerImpl.setSessionId(mc.getStrProperty("auth.passportid"));
                Object overallTimer = null;
                if (this.logger.isPerfLevelEnabled(0)) {
                    overallTimer = this.logger.startTimer(0, "invokeImpl", "Request Time", null);
                }
                Element wsrpOp = (elements = (requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope")).getBody().elements()).size() > 0 ? (Element)elements.get(0) : null;
                BIBusEnvelope responseEnvelope = new BIBusEnvelope();
                responseEnvelope.setBIBusHeader(requestEnvelope.getBIBusHeader().createCopy());
                BIBusEnvelopeUtils.copyNamespacesTo((BIBusEnvelope)requestEnvelope, (BIBusEnvelope)responseEnvelope);
                if (wsrpOp != null) {
                    this.handleSOAPRequest(mc, requestEnvelope, responseEnvelope, wsrpOp);
                } else {
                    this.handleHttpRequest(mc, requestEnvelope, responseEnvelope);
                }
                mc.setResponseName("response");
                mc.setProperty("response.envelope", (Object)responseEnvelope);
                if (overallTimer != null) {
                    this.logger.stopTimer(overallTimer);
                }
            }
            finally {
                mutex.releaseReadLock();
            }
        }
        catch (InterruptedException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("an exception was encountered when attempting acquire read lock to handle request", e);
            }
            throw new PogoException(e.getMessage());
        }
    }

    private void handleHttpRequest(MessageContext mc, BIBusEnvelope requestEnvelope, BIBusEnvelope responseEnvelope) throws PogoException {
        try {
            WSRPEnvironment env = new WSRPEnvironment(mc, this.context, this.logger, false);
            SharedByteArrayOutputStream output = new SharedByteArrayOutputStream(4096);
            String pathInfo = (String)mc.getProperty("path_info");
            if (pathInfo.endsWith("wsdl")) {
                this.bridge.getWSDL(env, output);
            } else if (pathInfo.endsWith("redirect")) {
                this.handleRedirect(responseEnvelope, env, output, mc);
            } else {
                String fragId = env.getParameter("frag-id");
                if (fragId != null && fragId.length() > 0) {
                    try {
                        this.bridge.getFragmentXML(env, output);
                    }
                    catch (InvalidCredentialsFault invalidCredentialsFault) {}
                } else {
                    this.bridge.handleHttpRequest(env, output);
                }
            }
            mc.setProperty("response.status_code", (Object)Integer.toString(env.getResponseStatus()));
            if (env.getResponseStatus() != 304) {
                if (env.getResponseEtag() != null) {
                    InternetHeaders headers = new InternetHeaders();
                    headers.addHeader("Etag", env.getResponseEtag());
                    mc.setProperty("response.headers", (Object)headers);
                }
                String header = "Content-Type: " + env.getResponseContentType() + "\r\n\r\n";
                SequenceInputStream inStream = new SequenceInputStream(new ByteArrayInputStream(header.getBytes()), output.toStream());
                ArrayList<SequenceInputStream> attachments = new ArrayList<SequenceInputStream>();
                attachments.add(inStream);
                mc.setProperty("response.attachments", attachments.iterator());
                mc.setProperty("response.boundary", (Object)"---=_MIME_BOUNDARY_Q739K9UU82UDLK73");
            }
        }
        catch (Exception e) {
            Locale locale = null;
            String productLocale = requestEnvelope.getUserPreferenceValue("productLocale");
            locale = productLocale != null && productLocale.length() > 0 ? MessagesManager.createLocale(productLocale) : Locale.ENGLISH;
            String message = e instanceof LocalizableException ? ((LocalizableException)e).getLocalizedMsgString(locale) : MessagesManager.getInstance().getMessage(locale, "pf.fragment.bridge.executionfailed");
            throw new PogoException(message, e);
        }
    }

    private void handleSOAPRequest(MessageContext mc, BIBusEnvelope requestEnvelope, BIBusEnvelope responseEnvelope, Element wsrpOp) throws PogoException {
        try {
            WSRPEnvironment env = new WSRPEnvironment(mc, this.context, this.logger, true);
            StringWriter writer = new StringWriter();
            if ("initCookie".equals(wsrpOp.getName())) {
                this.bridge.initCookies(requestEnvelope.getBIBusHeader(), writer, env, responseEnvelope);
            } else if ("getMarkup".equals(wsrpOp.getName())) {
                this.bridge.getMarkup(env, wsrpOp, writer);
            } else if ("performBlockingInteraction".equals(wsrpOp.getName())) {
                this.bridge.performBlockingInteraction(env, wsrpOp, writer);
            } else if ("getServiceDescription".equals(wsrpOp.getName())) {
                this.bridge.getServiceDescription(env, writer);
            } else if ("register".equals(wsrpOp.getName())) {
                this.bridge.register(env, wsrpOp, writer);
            }
            Document document = DocumentHelper.parseText((String)writer.getBuffer().toString());
            Element rootElem = document.getRootElement();
            rootElem.detach();
            responseEnvelope.getBody().add(rootElem);
        }
        catch (Exception e) {
            Locale locale = null;
            String productLocale = requestEnvelope.getUserPreferenceValue("productLocale");
            locale = productLocale != null && productLocale.length() > 0 ? MessagesManager.createLocale(productLocale) : Locale.ENGLISH;
            SOAPFault fault = new SOAPFault();
            InvalidCredentialsFault invalidCredentialsFault = this.getInvalidCredentialFault(e, 0);
            if (invalidCredentialsFault != null) {
                fault.setFaultCode(new QName("urn:oasis:names:tc:wsrp:v1:types", "InvalidCookie", "wsrp"));
                fault.setDetail("<wsrp:InvalidCookie xmlns:wsrp=\"urn:oasis:names:tc:wsrp:v1:types\"/>");
                fault.setFaultString(invalidCredentialsFault.getMessage());
            } else {
                fault.setFaultCode(new QName("urn:oasis:names:tc:wsrp:v1:types", "OperationFailed", "wsrp"));
                if (e instanceof BridgeException) {
                    fault.setFaultString(MessagesManager.getInstance().getMessage(locale, "pf.fragment.bridge.wsrp.operationfailed"));
                    fault.setDetail(((BridgeException)e).toXML(locale));
                } else {
                    fault.setFaultString(e.getMessage());
                }
            }
            try {
                Document document = DocumentHelper.parseText((String)fault.toString());
                Element rootElem = document.getRootElement();
                rootElem.detach();
                responseEnvelope.getBody().add(rootElem);
            }
            catch (Exception ex) {
                throw new PogoException(MessagesManager.getInstance().getMessage(locale, "pf.fragment.bridge.executionfailed"), e);
            }
        }
        mc.setProperty("response.status_code", (Object)"200");
    }

    private InvalidCredentialsFault getInvalidCredentialFault(Throwable throwable, int level) {
        Throwable rootCause;
        if (throwable instanceof InvalidCredentialsFault) {
            return (InvalidCredentialsFault)throwable;
        }
        if (level < 50 && throwable instanceof ExceptionExtension && (rootCause = ((ExceptionExtension)((Object)throwable)).getRootCause()) != null) {
            return this.getInvalidCredentialFault(rootCause, level++);
        }
        return null;
    }

    protected void handleRedirect(BIBusEnvelope responseEnvelope, WSRPEnvironment env, OutputStream output, MessageContext mc) throws BridgeException, IOException {
        String productLocale;
        responseEnvelope.getUserPreferenceVars().detach();
        String contentLocale = env.getParameter("m_contentLocale");
        if (contentLocale != null && contentLocale.length() > 0) {
            responseEnvelope.setUserPreference("contentLocale", contentLocale);
        }
        if ((productLocale = env.getParameter("m_productLocale")) != null && productLocale.length() > 0) {
            responseEnvelope.setUserPreference("productLocale", productLocale);
        }
        ArrayList cookies = new ArrayList();
        String location = this.bridge.handleRedirect(responseEnvelope.getBIBusHeader(), env, responseEnvelope);
        if (location != null) {
            output.write("redirecting.".getBytes());
            ((HttpServletResponse)mc.getProperty("servlet.response")).addHeader("Location", location);
            Iterator it = cookies.iterator();
            while (it.hasNext()) {
                responseEnvelope.addSetCookieServlet((Cookie)it.next());
            }
        }
    }
}

