/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.servlet;

import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.DashboardProcessor;
import com.cognos.portal.fragment.servlet.ServletEnvironment;
import com.cognos.portal.utils.ContextImpl;
import com.cognos.portal.utils.IContext;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DashboardServlet
extends HttpServlet {
    private static final long serialVersionUID = 7817731089203652216L;
    private boolean _isServletAPI22;
    private boolean _error;
    private boolean _warn;
    private boolean _info;
    private boolean _debug;
    private DashboardProcessor dashboard;
    private IContext context;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._error = Boolean.valueOf(this.getInitParameter("log.error"));
        this._warn = Boolean.valueOf(this.getInitParameter("log.warn"));
        this._info = Boolean.valueOf(this.getInitParameter("log.info"));
        this._debug = Boolean.valueOf(this.getInitParameter("log.debug"));
        ServletContext servletContext = this.getServletContext();
        double version = (double)servletContext.getMajorVersion() + (double)servletContext.getMinorVersion() / 10.0;
        if (version < 2.2) {
            throw new ServletException("Unsupported Servlet API version: " + version);
        }
        if (version == 2.2) {
            this._isServletAPI22 = true;
        }
        try {
            this.dashboard = new DashboardProcessor(null);
            this.context = new ContextImpl();
            this.context.setProperty("xslt.xmlashtml", this.getInitParameter("xslt.xmlashtml"));
            this.context.setProperty("xslt.page", this.getInitParameter("xslt.page"));
            this.context.setProperty("xslt.pagelet", this.getInitParameter("xslt.pagelet"));
            this.context.setProperty("xslt.script", this.getInitParameter("xslt.script"));
            this.context.setProperty("xslt.css", this.getInitParameter("xslt.css"));
            this.context.setProperty("xslt.messageasjs", this.getInitParameter("xslt.messageasjs"));
            this.context.setProperty("xslt.message", this.getInitParameter("xslt.message"));
            this.context.setProperty("application", this.getInitParameter("application"));
            this.context.setProperty("application.path", this.getInitParameter("application.path"));
            this.context.setProperty("css.skin", this.getInitParameter("css.skin"));
            this.dashboard.init(this.context);
        }
        catch (DashboardException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        super.destroy();
        if (this.dashboard != null) {
            try {
                this.dashboard.terminate();
            }
            catch (DashboardException dashboardException) {
                // empty catch block
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this._isServletAPI22) {
            request.setCharacterEncoding("UTF-8");
        }
        ServletEnvironment env = new ServletEnvironment(request, response, this.getServletContext(), this.context, null);
        env.setOutputStream((OutputStream)response.getOutputStream());
        this.dashboard.process(env);
    }
}

