/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.servlet;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.FragmentWrapper;
import com.cognos.portal.fragment.service.ServiceEnvironment;
import com.cognos.portal.fragment.servlet.LocalResponse;
import com.cognos.portal.fragment.validation.Validator;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletEnvironment
extends Environment {
    private static final String[] HEADER_FIELDS = new String[]{"ETag", "Last-Modified"};
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletContext servletContext;
    private ServiceLogger logger;

    ServletEnvironment(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, IContext context, ServiceLogger logger) {
        super(context, logger);
        this.request = request;
        this.response = response;
        this.servletContext = servletContext;
        this.logger = logger != null ? logger.cloneForClass(ServiceEnvironment.class) : null;
    }

    @Override
    public void setResponseContentType(String contentType) {
        super.setResponseContentType(contentType);
        this.response.setContentType(contentType);
    }

    @Override
    public String getTarget() {
        String pathInfo = this.request.getPathInfo();
        if (pathInfo == null || "".equals(pathInfo)) {
            pathInfo = this.request.getParameter("pathinfo");
        }
        return pathInfo != null ? pathInfo : "";
    }

    @Override
    public String getSoapAction() {
        return "";
    }

    @Override
    public String getRequestMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    @Override
    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    @Override
    public String getRealPath(String path) {
        String realPath;
        try {
            if (path.charAt(0) != '/') {
                path = "/" + path;
            }
            realPath = new File(this.servletContext.getRealPath("WEB-INF/dashboard" + path)).getCanonicalPath();
        }
        catch (IOException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("could not create real path using path: " + path, e);
            }
            realPath = null;
        }
        System.out.println(path + " --> " + realPath);
        return realPath;
    }

    @Override
    public String getWebContent() {
        return this.request.getContextPath();
    }

    @Override
    public String getGatewayURI() {
        return this.getApplicationGatewayURI();
    }

    @Override
    public void setBrowser() {
        String useragent = this.request.getHeader("User-Agent");
        super.setBrowser(useragent);
    }

    @Override
    public String getApplicationGatewayURI() {
        String path = this.request.getRequestURI();
        String servlet = this.request.getServletPath();
        int i = path.indexOf(servlet);
        return path.substring(0, i + servlet.length());
    }

    @Override
    public String getUserID() {
        return "ENT\\rodrigud";
    }

    @Override
    public String getUserName() {
        return "Daniel Rodrigue";
    }

    @Override
    public String getRequestEtag() {
        String etag = this.request.getHeader("etag");
        return etag;
    }

    @Override
    public String getSkin() {
        return "fx-skin";
    }

    @Override
    public String getUserPreference(String name) {
        return null;
    }

    @Override
    public String getProductLocale() {
        return "en";
    }

    @Override
    public String getContentLocale() {
        return "en";
    }

    @Override
    public void setResponseEtag(String etag) {
        super.setResponseEtag(etag);
        this.response.setHeader("Etag", etag);
    }

    @Override
    public void setResponseStatus(int status) {
        super.setResponseStatus(status);
        this.response.setStatus(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proxyResource(String target) {
        InputStream input = null;
        OutputStream out = null;
        try {
            int bytesRead;
            URL url = new URL(target);
            URLConnection uc = url.openConnection();
            Enumeration headers = this.request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String name = ((String)headers.nextElement()).toLowerCase();
                if (!name.startsWith("accept") && !name.startsWith("if-") && !name.equals("cache-control") && !name.equals("user-agent")) continue;
                uc.setRequestProperty(name, this.request.getHeader(name));
            }
            uc.connect();
            if (uc instanceof HttpURLConnection) {
                HttpURLConnection httpUC = (HttpURLConnection)uc;
                int status = httpUC.getResponseCode();
                this.response.setStatus(status);
                if (status == 200) {
                    this.response.setContentType(httpUC.getContentType());
                    for (int i = 0; i < HEADER_FIELDS.length; ++i) {
                        String value = httpUC.getHeaderField(HEADER_FIELDS[i]);
                        if (value == null) continue;
                        this.response.setHeader(HEADER_FIELDS[i], value);
                    }
                }
            }
            input = uc.getInputStream();
            out = this.response.getOutputStream();
            byte[] buf = new byte[4096];
            while ((bytesRead = input.read(buf)) != -1) {
                out.write(buf, 0, bytesRead);
            }
        }
        catch (MalformedURLException e) {
            this.response.setStatus(404);
        }
        catch (IOException e) {
            this.response.setStatus(404);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    @Override
    protected InputStream getLocalTargetStream(String target, Parameters parameters) throws DashboardException {
        if (target.endsWith(".jsp")) {
            return this.dispatchJSP(target);
        }
        return super.getLocalTargetStream(target, parameters);
    }

    @Override
    protected InputStream getRemoteTargetStream(URL targetURL, Parameters parameters) throws DashboardException {
        try {
            HttpURLConnection uc = (HttpURLConnection)targetURL.openConnection();
            Enumeration headers = this.request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String name = (String)headers.nextElement();
                String lowername = name.toLowerCase();
                if (!lowername.startsWith("accept-") && !lowername.equals("user-agent")) continue;
                uc.setRequestProperty(name, this.request.getHeader(name));
            }
            uc.setRequestProperty("Accept", "text/xml,application/xml");
            StringBuffer cookies = new StringBuffer();
            this.buildCookies(cookies, this.request.getCookies());
            if (cookies.length() > 0) {
                uc.setRequestProperty("Cookie", cookies.toString());
            }
            if (parameters != null && parameters.size() > 0) {
                uc.setDoOutput(true);
                uc.setRequestMethod("POST");
                uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                parameters.writeAsFormUrlEncoded(uc.getOutputStream());
            } else {
                uc.connect();
            }
            if (uc.getResponseCode() == 200) {
                InputStream input = uc.getInputStream();
                String contentType = uc.getContentType();
                if (contentType != null && contentType.startsWith("text/xml")) {
                    return input;
                }
                return new FragmentWrapper(input);
            }
            throw new DashboardException("pf.fragment.server.executionfailed");
        }
        catch (IOException e) {
            throw new DashboardException("pf.fragment.server.executionfailed", e);
        }
    }

    private InputStream dispatchJSP(String target) throws DashboardException {
        LocalResponse jspResponse = new LocalResponse(this.response);
        try {
            String realPath = "/WEB-INF/dashboard" + target;
            System.out.println(target + " --> " + realPath);
            this.servletContext.getRequestDispatcher(realPath).include((ServletRequest)this.request, (ServletResponse)jspResponse);
        }
        catch (ServletException e) {
            throw new DashboardException("pf.fragment.server.executionfailed", e);
        }
        catch (IOException e) {
            throw new DashboardException("pf.fragment.server.executionfailed", e);
        }
        return jspResponse.getResponseInputStream(this.logger);
    }

    private void buildCookies(StringBuffer cookies, Cookie[] cookiesVars) {
        if (cookiesVars != null) {
            for (int i = 0; i < cookiesVars.length; ++i) {
                if (cookies.length() > 0) {
                    cookies.append("; ");
                }
                cookies.append(cookiesVars[i].getName()).append('=').append(cookiesVars[i].getValue());
            }
        }
    }

    @Override
    public void createCookieList(List cookies) {
        Cookie[] cookiesArray = this.request.getCookies();
        if (cookiesArray != null) {
            for (int i = 0; i < cookiesArray.length; ++i) {
                Cookie c = cookiesArray[i];
                Cookie cookie = new Cookie(c.getName(), c.getValue());
                cookies.add(cookie);
            }
        }
    }

    @Override
    public Parameters createParameters() {
        Parameters params = super.createParameters();
        String userAgent = this.request.getHeader("User-Agent");
        if (params.getValue("frag-agent") == null && userAgent != null) {
            params.setValue("frag-agent", userAgent);
        }
        return params;
    }

    @Override
    public String getBusHeader() {
        return "";
    }

    @Override
    public String getPassportID() {
        return "";
    }

    @Override
    public String getPassportCookie() {
        return "";
    }

    @Override
    public String getUserSessionIdCookie() {
        return "";
    }

    @Override
    public void verify(String target, boolean ignoreUnknownParams) throws DashboardException {
    }

    @Override
    public void verify(String target, Parameters parameters, boolean ignoreUnknownParams) throws DashboardException {
    }

    @Override
    public String sign(String target, String name, String value) throws DashboardException {
        return null;
    }

    @Override
    public void sign(String target, Parameters inParams) throws DashboardException {
    }

    @Override
    public String unsign(String target, String name, String value) throws DashboardException {
        return null;
    }

    @Override
    public Validator createValidationDocument(String target, Parameters parameters) throws DashboardException {
        return null;
    }

    @Override
    public String secureLogError(String error) {
        return null;
    }

    @Override
    public String getControllerAgent() {
        return null;
    }

    @Override
    public void addSetCookie(String name, String value) {
    }

    @Override
    public Map<String, String> getSetCookieList() {
        return null;
    }

    @Override
    public String getSessionParameter(String name) {
        return null;
    }
}

