/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.validation;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.ResourceLoader;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.validation.ApplicationValidator;
import com.cognos.portal.fragment.validation.ImportResolver;
import com.cognos.portal.fragment.validation.Validator;
import com.cognos.portal.fragment.validation.ValidatorCacheEntry;
import com.cognos.portal.utils.Cache;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.Parameters;
import com.cognos.validator.api.IImportResolver;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.ValidatorFactory;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class ValidationManager {
    private static final String VALIDATION_PROPERTIES_FILE = "validation.properties";
    private static boolean enableValidation = false;
    private static ValidatorFactory factory;
    private static ServiceLogger logger;
    private static Map appValidators;
    private static Map defaultValidationList;
    private boolean initialized;
    private ResourceLoader resourceLoader;
    private static String staticSign_genericName;
    private static String staticSign_validatorDocXML;
    private static volatile Validator staticSign_validator;
    private static ValidationManager _instance;
    private static Map cachedValidatorTargetKeyDefinitions;
    private static int CACHEDVALIDATOR_MAX_SIZE;
    private static int CACHEDVALIDATOR_EXPIRY_1_WEEK;
    private static int CACHEDVALIDATOR_CLEANUP_INTERVAL_1_DAY;
    private static Cache validatorCache;

    public static ValidationManager getInstance() {
        return _instance;
    }

    public void enableValidation(boolean value) {
        enableValidation = value;
    }

    public boolean isValidationEnabled() {
        return enableValidation;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void initialize(boolean enableValidationValue, ServiceLogger logger, ResourceLoader resourceLoader) throws DashboardException {
        block10: {
            try {
                Properties props;
                block11: {
                    if (this.initialized) break block10;
                    enableValidation = enableValidationValue;
                    this.resourceLoader = resourceLoader;
                    if (!enableValidation) {
                        return;
                    }
                    ValidationManager.logger = logger;
                    props = null;
                    try {
                        InputStream is = resourceLoader.getResourceAsStream(0, "/validation/validation.properties");
                        if (is != null) {
                            props = new Properties();
                            props.load(is);
                        }
                        if (props != null) {
                            String v = props.getProperty("validator.page.targets");
                            StringTokenizer t = new StringTokenizer(v, ",");
                            while (t.hasMoreTokens()) {
                                String str = t.nextToken();
                                defaultValidationList.put(str, Boolean.TRUE);
                            }
                        }
                        Enumeration<?> e = props.propertyNames();
                        while (e.hasMoreElements()) {
                            String n = (String)e.nextElement();
                            if (!n.startsWith("cached.validator.target.keydef")) continue;
                            String v = props.getProperty(n);
                            this.parseCachedValidatorTargetKeyDefinitions(v);
                        }
                    }
                    catch (Exception e) {
                        if (logger == null || !logger.isErrorEnabled()) break block11;
                        logger.error("an exception was encountered when attempting to read the validation.properties file", e);
                    }
                }
                factory = ValidatorFactory.newInstance();
                factory.put(0, this.getBoolProperty(props, "validator.parameters.requireValidationRule", false));
                factory.put(1, this.getBoolProperty(props, "validator.documents.cacheTargets", true));
                factory.put(2, this.getBoolProperty(props, "validator.documents.validateWithSchema", true));
                factory.addImportResolver((IImportResolver)new ImportResolver("urn:cognos:fragments:validator", "/validation/validator.xml", resourceLoader, 0));
                factory.addImportResolver((IImportResolver)new ImportResolver("urn:cognos:fragments:validator:page", "/validation/page-validator.xml", resourceLoader, 0));
                this.initialized = true;
            }
            catch (ValidatorException e) {
                String explain = "\n" + e.getMessage();
                this.log("pf.fragment.validation.initfailed" + explain, (Exception)((Object)e));
                throw new DashboardException("pf.fragment.validation.initfailed", e);
            }
            catch (Exception e) {
                this.log("pf.fragment.validation.initgeneralerror", e);
                throw new DashboardException("pf.fragment.validation.initgeneralerror", e);
            }
        }
    }

    private boolean getBoolProperty(Properties props, String key, boolean defaultValue) {
        String value = props.getProperty(key, Boolean.toString(defaultValue));
        return Boolean.valueOf(value);
    }

    public synchronized void registerApplicationValidator(String application, String namespace, String namespace_alias, String path, ResourceLoader resourceLoader) throws DashboardException {
        try {
            if (!enableValidation) {
                return;
            }
            if (namespace == null || namespace.length() == 0) {
                if (logger.isErrorEnabled()) {
                    logger.error("Invalid validator namespace. Validator was not registered for application : " + application);
                }
                return;
            }
            if (namespace_alias == null || namespace_alias.length() == 0) {
                if (logger.isErrorEnabled()) {
                    logger.error("Invalid validator namespace_alias. Validator was not registered for application : " + application);
                }
                return;
            }
            if (path == null || path.length() == 0) {
                if (logger.isErrorEnabled()) {
                    logger.error("Invalid validator path. Validator was not registered for application : " + application);
                }
                return;
            }
            appValidators.put(application, new ApplicationValidator(namespace, namespace_alias));
            factory.addImportResolver((IImportResolver)new ImportResolver(namespace, path, resourceLoader, 1));
        }
        catch (ValidatorException e) {
            throw new DashboardException("pf.fragment.validation.initfailed", e);
        }
    }

    public Validator createValidatorFromNamespace(Environment env, String namespace, String target) throws DashboardException {
        if (!enableValidation) {
            return null;
        }
        target = this.calValidationTargetString(target);
        Validator validator = new Validator(this, factory, target);
        validator.loadFromNamespace(env, namespace);
        return validator;
    }

    public Validator createValidatorFromValidationBlob(Environment env, String validatorBlob, String target) throws DashboardException {
        if (!enableValidation) {
            return null;
        }
        if (!this.matchesTarget(validatorBlob, target = this.calValidationTargetString(target))) {
            return null;
        }
        Validator validator = new Validator(this, factory, target);
        validator.loadFromValidationBlob(env, validatorBlob);
        return validator;
    }

    public Validator createValidatorFromValidatorXML(Environment env, String namespace, String validatorXML, String target) throws DashboardException {
        if (!enableValidation) {
            return null;
        }
        target = this.calValidationTargetString(target);
        Validator validator = new Validator(this, factory, target);
        validator.loadFromValidationXML(env, namespace, validatorXML);
        return validator;
    }

    public boolean useDefaultValidation(String target) {
        int idx = target.indexOf(47, 1);
        target = idx != -1 ? target.substring(0, idx) : target;
        return defaultValidationList.containsKey(target);
    }

    public Map getCachedValidatorTargetsKeyDefinitions() {
        return cachedValidatorTargetKeyDefinitions;
    }

    public void log(String msg, Exception e) {
        if (logger != null && logger.isErrorEnabled()) {
            logger.error(msg, e);
        }
        if (logger != null && logger.isAuditLevelEnabled(0)) {
            String explain = e != null ? "\n[message(001)]" + e.getMessage() : "";
            logger.logAudit(0, 2, msg + explain);
        }
    }

    public Map getApplicationValidators() {
        return appValidators;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String staticSign(String value) throws DashboardException {
        try {
            if (this.hasStaticValidator()) {
                return staticSign_validator.sign(staticSign_genericName, value);
            }
        }
        catch (Exception e) {
            throw new DashboardException("pf.fragment.validation.signerror", e);
        }
        return value;
    }

    public String staticUnsign(String value) throws DashboardException {
        try {
            if (this.hasStaticValidator()) {
                return staticSign_validator.unsign(staticSign_genericName, value);
            }
        }
        catch (Exception e) {
            throw new DashboardException("pf.fragment.validation.unsignerror", e);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasStaticValidator() throws DashboardException {
        block7: {
            try {
                if (!enableValidation || staticSign_validator != null) break block7;
                ValidationManager validationManager = this;
                synchronized (validationManager) {
                    if (!this.initialized) {
                        throw new DashboardException("pf.fragment.validation.initfailed");
                    }
                    if (staticSign_validator == null) {
                        Validator validator = new Validator(this, factory, this.calValidationTargetString("staticSign_validator"));
                        validator.loadFromXML(staticSign_validatorDocXML);
                        staticSign_validator = validator;
                    }
                }
            }
            catch (Exception e) {
                throw new DashboardException("pf.fragment.validation.compilegeneralerror", e);
            }
        }
        return staticSign_validator != null;
    }

    private String calValidationTargetString(String target) {
        int idx = target.indexOf(63);
        target = idx != -1 ? target.substring(0, idx) : target;
        return target;
    }

    private boolean matchesTarget(String validatorBlob, String target) {
        if (validatorBlob == null || target == null) {
            return false;
        }
        return validatorBlob.startsWith(EncodingUtils.web64encode(target.getBytes(), true) + "|");
    }

    private void parseCachedValidatorTargetKeyDefinitions(String cachedTarget) {
        if (cachedTarget == null || "".equals(cachedTarget)) {
            return;
        }
        String key = null;
        String queries = "";
        int pipe = cachedTarget.indexOf(124);
        if (pipe != -1) {
            key = cachedTarget.substring(0, pipe);
            queries = cachedTarget.substring(pipe + 1);
        } else {
            key = cachedTarget;
        }
        cachedValidatorTargetKeyDefinitions.put(key, Parameters.parse(queries));
    }

    public String buildValidatorCacheKey(String target, Parameters envParams) {
        Map keyDefs = this.getCachedValidatorTargetsKeyDefinitions();
        for (Map.Entry e : keyDefs.entrySet()) {
            String[] values;
            String k = (String)e.getKey();
            if (!target.startsWith(k)) continue;
            Parameters targetParams = null;
            int q = target.indexOf(63);
            if (q != -1) {
                String targetQuery = target.substring(q + 1);
                target = target.substring(0, q);
                targetParams = Parameters.parse(targetQuery);
            }
            String extraInfo = "";
            Parameters keyParams = (Parameters)e.getValue();
            if (keyParams != null && keyParams.getValue("IGNOREQUERY") == null && keyParams.getValue("PARAM") != null && (values = keyParams.getValues("PARAM")) != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (targetParams != null && targetParams.getValue(values[i]) != null) {
                        extraInfo = extraInfo + "|" + targetParams.getValue(values[i]);
                        continue;
                    }
                    if (envParams == null || envParams.getValue(values[i]) == null) continue;
                    extraInfo = extraInfo + "|" + envParams.getValue(values[i]);
                }
            }
            return target + extraInfo;
        }
        return target;
    }

    public ValidatorCacheEntry getCachedValidator(String key) {
        return (ValidatorCacheEntry)validatorCache.get(key);
    }

    public ValidatorCacheEntry putCacheValidator(String key, int cacheType, String validatorNS, String validatorXML) {
        ValidatorCacheEntry vce = null;
        if (!validatorCache.containsKey(key)) {
            vce = new ValidatorCacheEntry(cacheType, validatorNS, validatorXML);
            validatorCache.put(key, vce);
        }
        return vce;
    }

    static {
        logger = null;
        appValidators = new HashMap();
        defaultValidationList = new HashMap();
        staticSign_genericName = "staticSign_genericParamName";
        staticSign_validatorDocXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><validator     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"     xsi:schemaLocation=\"http://developer.cognos.com/schemas/validator/1/ ../../schemas/validator.xsd\"     xmlns=\"http://developer.cognos.com/schemas/validator/1/\"     namespace=\"urn:cognos:fragments:validator-staticSign\" version=\"1.0\"><parameter skipJavaScript=\"true\"><name>" + staticSign_genericName + "</name><sign/></parameter>" + "</validator>";
        staticSign_validator = null;
        _instance = new ValidationManager();
        cachedValidatorTargetKeyDefinitions = new HashMap();
        CACHEDVALIDATOR_MAX_SIZE = 128;
        CACHEDVALIDATOR_EXPIRY_1_WEEK = 604800;
        CACHEDVALIDATOR_CLEANUP_INTERVAL_1_DAY = 86400;
        validatorCache = new Cache(CACHEDVALIDATOR_CLEANUP_INTERVAL_1_DAY, CACHEDVALIDATOR_EXPIRY_1_WEEK, CACHEDVALIDATOR_MAX_SIZE);
    }
}

