/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.validation;

import com.cognos.cps.common.io.CharArrayReaderWriter;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.validation.ApplicationValidator;
import com.cognos.portal.fragment.validation.HashMapParameterReader;
import com.cognos.portal.fragment.validation.ImportResolver;
import com.cognos.portal.fragment.validation.ValidationManager;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.validator.api.Document;
import com.cognos.validator.api.IParameterUpdater;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.ValidatorFactory;
import com.cognos.validator.api.VerifyException;
import com.cognos.validator.api.VerifySession;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class Validator {
    public static final String VALIDATOR_BASE = "urn:cognos:fragments:validator";
    public static final String VALIDATOR_PAGE = "urn:cognos:fragments:validator:page";
    public static final String VALIDATOR_BYPASS = "urn:cognos:fragments:validator:bypass";
    public static final String USER_PROP_BYPASS_FLAG = "user_prop_bypass";
    public static final String VALIDATOR_BLOB_TARGET_SEP = "|";
    private static final String VALIDATOR_NAMESPACE_URI = "http://developer.cognos.com/schemas/validator/1/";
    private static final String VALIDATOR_NAMESPACE_PREFIX = "val";
    private ValidatorFactory factory;
    private String target;
    private String compile = null;
    private String clientValidationData = null;
    private XMLStreamWriter xsw = null;
    private String validatorXML_buf = null;
    private CharArrayReaderWriter validatorXML_rw = null;
    private boolean bWriteEndDocumentSeen = true;
    private boolean bypass = false;
    private Document doc = null;
    private boolean docError = false;
    private ValidationManager validationManager;
    private static final Map VALIDATOR_DATATYPE_MAP = new HashMap();

    public Validator(ValidationManager validationManager, ValidatorFactory factory, String target) throws DashboardException {
        try {
            this.factory = factory;
            this.validationManager = validationManager;
            this.target = target;
            this.doc = factory.createDocument();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadFromNamespace(Environment env, String namespace) throws DashboardException {
        try {
            this.bypass = VALIDATOR_BYPASS.equals(namespace);
            if (this.bypass) {
                namespace = null;
            }
            if (namespace != null && this.doc.loadFromNamespace(namespace)) {
                return;
            }
            this.validatorXML_rw = new CharArrayReaderWriter(4096);
            this.xsw = XMLStreamFactory.createXMLStreamWriter((Writer)this.validatorXML_rw);
            this.writeStartDocument(env, namespace);
        }
        catch (Exception e) {
            this.validationManager.log("pf.fragment.validation.compilegeneralerror", e);
            throw new DashboardException("pf.fragment.validation.compilegeneralerror", e);
        }
    }

    public void loadFromValidationXML(Environment env, String namespace, String validationXML) throws DashboardException {
        try {
            this.bypass = VALIDATOR_BYPASS.equals(namespace);
            if (this.bypass) {
                namespace = null;
            }
            if (namespace != null && this.doc.loadFromNamespace(namespace)) {
                return;
            }
            this.doc.loadFromXML((Reader)new StringReader(validationXML));
        }
        catch (Exception e) {
            this.validationManager.log("pf.fragment.validation.compilegeneralerror", e);
            throw new DashboardException("pf.fragment.validation.compilegeneralerror", e);
        }
    }

    public void loadFromValidationBlob(Environment env, String validatorBlob) throws DashboardException {
        try {
            int idx = validatorBlob.indexOf(VALIDATOR_BLOB_TARGET_SEP);
            if (idx != -1) {
                validatorBlob = validatorBlob.substring(idx + VALIDATOR_BLOB_TARGET_SEP.length(), validatorBlob.length());
            }
            this.doc.loadFromCompile(validatorBlob, this.target);
            this.compile = validatorBlob;
            this.bypass = "true".equals(this.doc.getUserProperty(USER_PROP_BYPASS_FLAG));
        }
        catch (Exception e) {
            this.validationManager.log("pf.fragment.validation.compilegeneralerror", e);
            throw new DashboardException("pf.fragment.validation.compilegeneralerror", e);
        }
    }

    public void loadFromXML(String validatorXML) throws DashboardException {
        try {
            this.doc.loadFromXML((Reader)new StringReader(validatorXML));
            this.compile = this.doc.compile(this.target);
        }
        catch (Exception e) {
            this.validationManager.log("pf.fragment.validation.compilegeneralerror", e);
            throw new DashboardException("pf.fragment.validation.compilegeneralerror", e);
        }
    }

    public String getValidatorXML() throws DashboardException {
        if (this.validatorXML_buf == null) {
            this.compile();
        }
        return this.validatorXML_buf;
    }

    public String compile() throws DashboardException {
        if (!this.validationManager.isValidationEnabled() || this.docError) {
            return "";
        }
        try {
            if (this.compile == null) {
                this.writeEndDocument();
                if (this.validatorXML_rw != null) {
                    this.validatorXML_buf = this.validatorXML_rw.toString();
                    this.doc.loadFromXML((Reader)this.validatorXML_rw.convert());
                }
                if (this.bypass) {
                    this.doc.setUserProperty(USER_PROP_BYPASS_FLAG, "true");
                }
                this.compile = this.doc.compile(this.target);
                this.clientValidationData = this.doc.asJavaScript();
            }
            return this.compile;
        }
        catch (ValidatorException e) {
            this.docError = true;
            String explain = "\n" + e.getMessage();
            explain = explain + "\nValidation document=";
            if (this.validatorXML_rw != null) {
                explain = explain + new String(this.validatorXML_rw.getBuf(), 0, this.validatorXML_rw.getBufSize());
            }
            this.validationManager.log("pf.fragment.validation.compilefailed" + explain, (Exception)((Object)e));
            throw new DashboardException("pf.fragment.validation.compilefailed", e);
        }
        catch (Exception e) {
            this.docError = true;
            this.validationManager.log("pf.fragment.validation.compilegeneralerror", e);
            throw new DashboardException("pf.fragment.validation.compilegeneralerror", e);
        }
    }

    public String getCompiledString() throws DashboardException {
        try {
            return EncodingUtils.web64encode(this.target.getBytes(), true) + VALIDATOR_BLOB_TARGET_SEP + this.compile();
        }
        catch (Exception e) {
            this.validationManager.log("pf.fragment.validation.compileconversionfailed", e);
            throw new DashboardException("pf.fragment.validation.compileconversionfailed", e);
        }
    }

    public String getClientValidationData() {
        return this.clientValidationData != null ? this.clientValidationData : null;
    }

    private void sign(HashMapParameterReader inParams) throws DashboardException {
        try {
            if (!this.validationManager.isValidationEnabled() || this.docError) {
                return;
            }
            this.compile();
            VerifySession vs = this.factory.createVerifySession(this.doc);
            vs.prepare((IParameterUpdater)inParams);
        }
        catch (ValidatorException e) {
            String explain = "\n" + e.getMessage();
            explain = explain + "\nValidation document=";
            if (this.validatorXML_rw != null) {
                explain = explain + new String(this.validatorXML_rw.getBuf(), 0, this.validatorXML_rw.getBufSize());
            }
            this.validationManager.log("pf.fragment.validation.signerror" + explain, (Exception)((Object)e));
            throw new DashboardException("pf.fragment.validation.signerror", e);
        }
        catch (Exception e) {
            this.validationManager.log("pf.fragment.validation.signgeneralerror", e);
            throw new DashboardException("pf.fragment.validation.signgeneralerror", e);
        }
    }

    public void sign(Parameters inParams) throws DashboardException {
        HashMapParameterReader hmpr = new HashMapParameterReader("sign::" + this.target);
        hmpr.add(inParams);
        this.sign(hmpr);
    }

    public String sign(String name, String value) throws DashboardException {
        Parameters inParams = new Parameters();
        inParams.add(name, value);
        this.sign(inParams);
        return inParams.getValue(name);
    }

    public String unsign(String name, String value) throws DashboardException {
        try {
            if (!this.validationManager.isValidationEnabled() || this.docError) {
                return value;
            }
            Parameters inParams = new Parameters();
            inParams.add(name, value);
            this.compile();
            HashMapParameterReader input_data = new HashMapParameterReader("unsign::" + this.target);
            input_data.add(inParams);
            VerifySession vs = this.factory.createVerifySession(this.doc);
            vs.put(0, true);
            vs.verify((IParameterUpdater)input_data);
            return inParams.getValue(name);
        }
        catch (Exception e) {
            this.validationManager.log("pf.fragment.validation.unsignerror", e);
            throw new DashboardException("pf.fragment.validation.unsignerror", e);
        }
    }

    public void verify(Environment env, Parameters parameters, boolean ignoreUnknownParams) throws DashboardException {
        if (!this.validationManager.isValidationEnabled() || this.docError) {
            return;
        }
        try {
            this.compile();
            HashMapParameterReader input_data = new HashMapParameterReader("verify::" + this.target);
            input_data.add(parameters);
            VerifySession vs = this.factory.createVerifySession(this.doc);
            if (ignoreUnknownParams || this.bypass) {
                vs.put(0, true);
            }
            vs.verify((IParameterUpdater)input_data);
        }
        catch (VerifyException e) {
            String explain = "\n[failure details]" + e.getFailureDetails() + "\n[validator details]" + e.getValidatorDetails();
            this.validationManager.log("pf.fragment.validation.verifyfailed" + explain, (Exception)((Object)e));
            throw new DashboardException("pf.fragment.validation.verifyfailed", e);
        }
        catch (ValidatorException e) {
            String explain = "\n" + e.getMessage();
            this.validationManager.log("pf.fragment.validation.verifyerror" + explain, (Exception)((Object)e));
            throw new DashboardException("pf.fragment.validation.verifyerror", e);
        }
        catch (Exception e) {
            this.validationManager.log("pf.fragment.validation.verifygeneralerror", e);
            throw new DashboardException("pf.fragment.validation.verifygeneralerror", e);
        }
    }

    private void writeStartDocument(Environment env, String namespace) throws XMLStreamException, DashboardException {
        if (namespace != null && VALIDATOR_PAGE.equals(namespace)) {
            this.writeStaticDocument(namespace);
        } else {
            ApplicationValidator av = (ApplicationValidator)this.validationManager.getApplicationValidators().get(env.getProperty("application"));
            this.xsw.writeStartDocument();
            this.xsw.writeStartElement("validator");
            this.xsw.writeAttribute("version", "1.0");
            this.xsw.writeDefaultNamespace(VALIDATOR_NAMESPACE_URI);
            this.xsw.writeNamespace(VALIDATOR_NAMESPACE_PREFIX, VALIDATOR_NAMESPACE_URI);
            this.xsw.writeNamespace("fragment", VALIDATOR_BASE);
            if (av != null) {
                this.xsw.writeNamespace(av.getNamespaceAlias(), av.getNamespace());
            }
            this.bWriteEndDocumentSeen = false;
            if (namespace != null) {
                this.xsw.writeAttribute("namespace", namespace);
            }
            if (av != null) {
                this.xsw.writeStartElement("import");
                this.xsw.writeAttribute("parameter", "true");
                this.xsw.writeAttribute("namespace", av.getNamespace());
                this.xsw.writeEndElement();
            }
            this.xsw.writeStartElement("import");
            this.xsw.writeAttribute("parameter", "true");
            this.xsw.writeAttribute("namespace", VALIDATOR_BASE);
            this.xsw.writeEndElement();
        }
    }

    private void writeEndDocument() throws XMLStreamException {
        if (this.bWriteEndDocumentSeen) {
            return;
        }
        this.bWriteEndDocumentSeen = true;
        this.xsw.writeEndElement();
        this.xsw.writeEndDocument();
        this.xsw.flush();
    }

    private void writeStaticDocument(String namespace) throws DashboardException {
        Reader reader = new ImportResolver(VALIDATOR_PAGE, "/validation/page-validator.xml", this.validationManager.getResourceLoader(), 0).xmlDocument(namespace);
        if (reader == null) {
            throw new DashboardException("pf.fragment.validation.filereaderror");
        }
        try {
            char[] buf = new char[4096];
            int charsRead = reader.read(buf, 0, 4096);
            while (charsRead != -1) {
                this.validatorXML_rw.write(buf, 0, charsRead);
                charsRead = reader.read(buf, 0, 4096);
            }
            this.validatorXML_rw.flush();
            reader.close();
        }
        catch (Throwable e) {
            throw new DashboardException("pf.fragment.validation.filereaderror", e);
        }
    }

    public void readValidatorParam(XMLStreamReader reader) throws XMLStreamException {
        if (this.bypass) {
            StaxUtils.moveToNextSibling(reader);
            return;
        }
        StaxUtils.copyChildren(reader, this.xsw);
    }

    public void addValidatorForProperty(String name, QName dataType, XMLStreamReader validateParamReader) throws XMLStreamException {
        if (this.bypass || validateParamReader == null) {
            if (this.bypass) {
                dataType = null;
            }
            if (validateParamReader != null) {
                StaxUtils.moveToNextSibling(validateParamReader);
            }
            this.addValidateAnyRule(name, dataType);
            return;
        }
        this.readValidateParams(validateParamReader);
    }

    private void readValidateParams(XMLStreamReader reader) throws XMLStreamException {
        this.xsw.writeStartElement("parameter");
        String value = reader.getAttributeValue("", "skipJavaScript");
        if ("true".equals(value)) {
            this.xsw.writeAttribute("skipJavaScript", "true");
        }
        StaxUtils.copyChildren(reader, this.xsw);
        this.xsw.writeEndElement();
    }

    public void readMarkupValidatorParam(XMLStreamReader reader) throws XMLStreamException {
        if (this.bypass) {
            StaxUtils.moveToNextSibling(reader);
            return;
        }
        int level = 0;
        int event = reader.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = reader.getLocalName();
                    if ("validate".equals(localName)) {
                        this.readValidateParams(reader);
                        break;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level >= 0) break;
                    return;
                }
            }
            event = reader.next();
        }
    }

    public boolean isParameter(String name) throws DashboardException {
        this.compile();
        try {
            return this.doc.isParameter(name);
        }
        catch (ValidatorException e) {
            this.validationManager.log("validator error", (Exception)((Object)e));
            throw new DashboardException("pf.fragment.server.executionfailed", e);
        }
    }

    private void addValidateAnyRule(String name, QName dataType) throws XMLStreamException {
        this.xsw.writeStartElement("parameter");
        this.xsw.writeAttribute("skipJavaScript", "true");
        this.xsw.writeNamespace(VALIDATOR_NAMESPACE_PREFIX, VALIDATOR_NAMESPACE_URI);
        this.xsw.writeStartElement(VALIDATOR_NAMESPACE_PREFIX, "name", VALIDATOR_NAMESPACE_URI);
        this.xsw.writeCharacters(name);
        this.xsw.writeEndElement();
        this.xsw.writeStartElement(VALIDATOR_NAMESPACE_PREFIX, "rule", VALIDATOR_NAMESPACE_URI);
        this.xsw.writeStartElement(VALIDATOR_NAMESPACE_PREFIX, "type", VALIDATOR_NAMESPACE_URI);
        this.xsw.writeStartElement(VALIDATOR_NAMESPACE_PREFIX, this.getValidatorType(dataType), VALIDATOR_NAMESPACE_URI);
        this.xsw.writeEndElement();
        this.xsw.writeEndElement();
        this.xsw.writeEndElement();
        this.xsw.writeEndElement();
    }

    private String getValidatorType(QName dataType) {
        String value;
        if (dataType != null && (value = (String)VALIDATOR_DATATYPE_MAP.get(dataType.getLocalPart())) != null) {
            return value;
        }
        return "string";
    }

    static {
        VALIDATOR_DATATYPE_MAP.put("int", "int");
        VALIDATOR_DATATYPE_MAP.put("integer", "int");
        VALIDATOR_DATATYPE_MAP.put("boolean", "int");
        VALIDATOR_DATATYPE_MAP.put("long", "long");
        VALIDATOR_DATATYPE_MAP.put("unsignedint", "unsignedInt");
    }
}

