/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.wsrp;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.service.WSRPEnvironment;
import com.cognos.portal.fragment.wsrp.BridgeException;
import com.cognos.portal.utils.AddRuntimeState;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.Parameters;
import com.cognos.xts.XTSException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ApplicationState {
    public static final String WSRP_BRIDGE_APP_STATE = "CPS_WSRP_BRIDGE_APP_STATE";
    private Parameters transients;

    public Parameters getTransient() {
        return this.transients;
    }

    public void setTransients(Parameters transients) {
        this.transients = transients;
    }

    public void saveToDataStorage(WSRPEnvironment env, ServiceLogger logger) throws BridgeException {
        if (this.transients != null) {
            AddRuntimeState addRuntimeState = new AddRuntimeState();
            StringBuffer buffer = new StringBuffer();
            buffer.append("<appState><transients>");
            EncodingUtils.xmlEncode(this.transients.toString(), buffer);
            buffer.append("</transients></appState>");
            addRuntimeState.addState(WSRP_BRIDGE_APP_STATE, buffer.toString());
            try {
                addRuntimeState.saveToDataStorage(env.getPassportID());
            }
            catch (XTSException e) {
                throw new BridgeException("TDS error", e);
            }
        }
    }

    public void read(XMLStreamReader xsr) throws XMLStreamException {
        int level = 0;
        while (xsr.hasNext()) {
            int event = xsr.next();
            switch (event) {
                case 1: {
                    String localName = xsr.getLocalName();
                    if ("transients".equals(localName)) {
                        this.transients = Parameters.parse(xsr.getElementText());
                        break;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level >= 0) break;
                    return;
                }
            }
        }
    }
}

