/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.wsrp;

import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.LocalizableException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;

public class BridgeException
extends LocalizableException {
    private static final long serialVersionUID = -6024128825734938100L;
    private String detail;

    public BridgeException(String key) {
        super(key);
    }

    public BridgeException(String key, Throwable rootCause) {
        super(key, rootCause);
    }

    public BridgeException(String key, String detail) {
        super(key);
        this.detail = detail;
    }

    public BridgeException(String key, Object[] args) {
        super(key, args);
    }

    public BridgeException(String key, Object[] args, Throwable rootCause) {
        super(key, args, rootCause);
    }

    public String toXML(Locale locale) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<error>");
        buffer.append("<message>");
        EncodingUtils.xmlEncode(this.getLocalizedMsgString(locale), buffer);
        buffer.append("</message>");
        Throwable rootCause = this.getRootCause();
        if (rootCause != null || this.detail != null) {
            buffer.append("<details>");
            if (rootCause != null) {
                EncodingUtils.xmlEncode(rootCause.toString(), buffer);
            } else {
                EncodingUtils.xmlEncode(this.detail, buffer);
            }
            buffer.append("</details>");
        }
        buffer.append("<trace>");
        StringWriter s = new StringWriter();
        this.printStackTrace(new PrintWriter(s));
        EncodingUtils.xmlEncode(s.getBuffer().toString(), buffer);
        buffer.append("</trace>");
        buffer.append("</error>");
        return buffer.toString();
    }
}

