/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.wsrp;

import com.cognos.portal.fragment.server.rewriters.URLRewriteException;
import com.cognos.portal.fragment.service.WSRPEnvironment;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.stream.XMLTransactionalStreamWriter;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;

public class DashboardURLRewriterImpl
extends com.cognos.portal.fragment.server.DashboardURLRewriterImpl {
    private WSRPEnvironment env;

    @Override
    protected void rewriteGatewayURLType(String urlType, Parameters urlParams, XMLTransactionalStreamWriter result) throws URLRewriteException {
        if (this.isCognosAgent()) {
            super.rewriteGatewayURLType(urlType, urlParams, result);
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.gateway);
        urlParams.remove("frag-urlType");
        if (urlParams.size() > 0) {
            Iterator it = urlParams.iterator();
            boolean firstParam = true;
            while (it.hasNext()) {
                Parameters.NameValuePair nvp = (Parameters.NameValuePair)it.next();
                String[] values = nvp.getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (firstParam) {
                        buffer.append("?");
                        firstParam = false;
                    } else {
                        buffer.append("&");
                    }
                    buffer.append(nvp.getName());
                    buffer.append("=");
                    buffer.append(values[i]);
                }
            }
        }
        try {
            if ("gatewayproxy".equals(urlType)) {
                this.writeProxyUrl(result, buffer.toString());
            } else {
                result.writeCharacters(this.env.getRedirectURL());
                result.writeCharacters("?url=");
                result.writeCharacters(EncodingUtils.urlencode(buffer.toString(), "UTF-8", false));
                result.writeCharacters("&m_passportID=");
                result.writeCharacters(EncodingUtils.urlencode(this.env.getPassportCookie(), "UTF-8", false));
                result.writeCharacters("&m_contentLocale=");
                result.writeCharacters(EncodingUtils.urlencode(this.env.getContentLocale(), "UTF-8", false));
                result.writeCharacters("&m_productLocale=");
                result.writeCharacters(EncodingUtils.urlencode(this.env.getProductLocale(), "UTF-8", false));
            }
        }
        catch (XMLStreamException e) {
            throw new URLRewriteException("pf.fragment.server.rewritefailed", null, e);
        }
    }

    private void writeProxyUrl(XMLTransactionalStreamWriter result, String url) throws XMLStreamException {
        result.writeCharacters("wsrp_rewrite?wsrp-urlType=resource&wsrp-url=" + EncodingUtils.urlencode(url, "UTF-8", false) + "/wsrp_rewrite");
    }

    @Override
    protected void rewriteResourceURLType(String urlResource, XMLTransactionalStreamWriter result, boolean isProxy) throws URLRewriteException {
        if (this.isCognosAgent()) {
            super.rewriteResourceURLType(urlResource, result, isProxy);
            return;
        }
        try {
            StringBuilder buffer = new StringBuilder();
            if (urlResource.startsWith("http://")) {
                buffer.append(this.appGateway);
                buffer.append("?");
                buffer.append("frag-resource");
                buffer.append("=");
                buffer.append(EncodingUtils.urlencode(urlResource, "UTF-8", true));
            } else {
                buffer.append(this.webContent);
                if (urlResource.length() > 0 && urlResource.charAt(0) != '/') {
                    buffer.append("/");
                }
                buffer.append(urlResource);
            }
            if (isProxy) {
                this.writeProxyUrl(result, buffer.toString());
            } else {
                result.writeCharacters(buffer.toString());
            }
        }
        catch (XMLStreamException e) {
            throw new URLRewriteException("pf.fragment.server.rewritefailed", null, e);
        }
    }

    private boolean isCognosAgent() {
        String portalAgent = this.env.getParameter("frag-portalAgent");
        return "cognos".equals(portalAgent) || "cognosFragmentServer".equals(portalAgent);
    }

    public DashboardURLRewriterImpl(String uniqueID, WSRPEnvironment env) {
        super(uniqueID, env.getGatewayURI(), env.getApplicationGatewayURI(), env.getWebContent());
        this.env = env;
    }
}

