/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.wsrp;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.meta.Meta;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.DashboardProcessor;
import com.cognos.portal.fragment.service.WSRPEnvironment;
import com.cognos.portal.fragment.wsrp.BridgeException;
import com.cognos.portal.fragment.wsrp.PortletState;
import com.cognos.portal.fragment.wsrp.WSRPRequestHelper;
import com.cognos.portal.utils.JSONObject;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import com.cognos.portal.xml.stream.CopyStreamFilter;
import com.cognos.portal.xml.stream.PathIterator;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class Fragment {
    private static Pattern SESSIONID_PATTERN = Pattern.compile("[A-Z0-9]{32}", 2);
    public static final String BRIDGE_FRAGMENT_GATEWAY_PARAM = "bridge-gatewayURL";
    public static final String BRIDGE_FRAGMENT_WEBCONTENT_PARAM = "bridge-webContentURL";
    private static final List CONTROLLER_JAVACSCRIPT = new ArrayList();
    private static final String PARENT_ID = "parent_id_4462494718858036181";
    private static final Iterator EMPTY_ITERATOR;
    private WSRPEnvironment env;
    private WSRPRequestHelper wsrpRequest;
    private String markup;
    private String mimeType;
    private String customUpdate;
    private PortletState fragmentState;
    private List libraries;
    private List styles;
    private String newMode;
    private String newWindowState;
    private String preferredTitle;
    private String fragmentId;
    private Meta meta;
    private JSONObject transientUpdates;
    private ServiceLogger logger;
    private List controllerJavaScript;
    public static final int PARSE_GETMARKUP = 0;
    public static final int PARSE_PERFROMBLOCKINGINTERACTION = 1;
    private static final String[] GET_MARKUP_PATHS;
    private static final String[] PERFOM_BLOCKING_INTERACTION_PATHS;
    private static final String[] ERROR_PATHS;
    private static final String[][] PARSE_PATHS;

    public Fragment(WSRPEnvironment env, WSRPRequestHelper wsrpRequest, ServiceLogger logger) {
        this.env = env;
        this.wsrpRequest = wsrpRequest;
        this.calculateFragmentId();
        this.logger = logger != null ? logger.cloneForClass(Fragment.class) : null;
    }

    public void execute(DashboardProcessor processor, int parseFlag) throws BridgeException {
        try {
            this.fragmentState = new PortletState(this.getPortletSessionId());
            this.fragmentState.loadFromDataStorage(this.env, this.logger);
            this.updateEnvironmentForSOAPRequest();
            this.styles = new ArrayList();
            String skin = this.env.getSkin();
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.env.getWebContent());
            buffer.append("/skins/");
            if (skin != null) {
                buffer.append(skin);
            } else {
                buffer.append("corporate");
            }
            buffer.append("/fragments/portlet.css");
            this.styles.add(buffer.toString());
            SharedByteArrayOutputStream out = new SharedByteArrayOutputStream(4096);
            this.env.setOutputStream(out);
            processor.process(this.env);
            this.parseResponse(XMLStreamFactory.createXMLStreamReader(out.toStream()), parseFlag);
            this.fragmentState.setWindowState(this.fragmentId, this.getWindowState());
            this.fragmentState.setMode(this.fragmentId, this.getMode());
        }
        catch (XMLStreamException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Error while handling http request", e);
            }
            throw new BridgeException("pf.fragment.bridge.xml.error", e);
        }
        catch (DashboardException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Error while handling soap request", e);
            }
            throw new BridgeException("pf.fragment.bridge.executionfailed", e);
        }
    }

    public void executeAjaxRequest(DashboardProcessor processor, OutputStream output) throws BridgeException {
        try {
            this.fragmentState = new PortletState(this.getPortletSessionId());
            this.updateEnvironmentForHttpRequest();
            SharedByteArrayOutputStream out = new SharedByteArrayOutputStream(4096);
            this.env.setOutputStream(out);
            processor.process(this.env);
            XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(output);
            this.handleResource(XMLStreamFactory.createXMLStreamReader(out.toStream()), xsw);
            xsw.close();
            this.fragmentState.setWindowState(this.fragmentId, this.getWindowState());
            this.fragmentState.setMode(this.fragmentId, this.getMode());
        }
        catch (XMLStreamException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Error while handling http request", e);
            }
            throw new BridgeException("pf.fragment.bridge.xml.error", e);
        }
        catch (DashboardException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Error while handling http request", e);
            }
            throw new BridgeException("pf.fragment.bridge.executionfailed", e);
        }
    }

    private void handleResource(XMLStreamReader fragmentResponseXMLReader, XMLStreamWriter resourceResponseXMLWriter) throws BridgeException {
        try {
            fragmentResponseXMLReader = XMLStreamFactory.createFilteredReader(fragmentResponseXMLReader, new CopyStreamFilter(resourceResponseXMLWriter));
            StringBuffer buffer = null;
            Stack<String> idStack = new Stack<String>();
            idStack.push(this.fragmentId);
            boolean seenFragmentId = false;
            while (fragmentResponseXMLReader.hasNext()) {
                int event = fragmentResponseXMLReader.next();
                switch (event) {
                    case 1: {
                        if ("state".equals(fragmentResponseXMLReader.getLocalName())) {
                            if (buffer != null) break;
                            buffer = new StringBuffer();
                            break;
                        }
                        if ("newWindowState".equals(fragmentResponseXMLReader.getLocalName())) {
                            if (buffer != null) break;
                            buffer = new StringBuffer();
                            break;
                        }
                        if ("newMode".equals(fragmentResponseXMLReader.getLocalName())) {
                            if (buffer != null) break;
                            buffer = new StringBuffer();
                            break;
                        }
                        if ("remote".equals(fragmentResponseXMLReader.getLocalName())) {
                            if (buffer != null) break;
                            buffer = new StringBuffer();
                            break;
                        }
                        if ("id".equals(fragmentResponseXMLReader.getLocalName())) {
                            if (buffer != null) break;
                            buffer = new StringBuffer();
                            break;
                        }
                        if (!"fragment".equals(fragmentResponseXMLReader.getLocalName())) break;
                        seenFragmentId = false;
                        break;
                    }
                    case 2: {
                        if (buffer != null) {
                            if ("state".equals(fragmentResponseXMLReader.getLocalName())) {
                                String state = buffer.toString();
                                if (idStack.empty()) {
                                    if (this.logger.isErrorEnabled()) {
                                        this.logger.error("Fragment id is missing while saving the fragment state");
                                    }
                                    throw new BridgeException("pf.fragment.bridge.xml.error");
                                }
                                this.fragmentState.setState((String)idStack.peek(), state);
                            } else if ("remote".equals(fragmentResponseXMLReader.getLocalName())) {
                                String validator = buffer.toString();
                                if (idStack.empty()) {
                                    if (this.logger.isErrorEnabled()) {
                                        this.logger.error("Fragment id is missing while saving the fragment validator blob");
                                    }
                                    throw new BridgeException("pf.fragment.bridge.xml.error");
                                }
                                this.fragmentState.setValidator((String)idStack.peek(), validator);
                            } else if ("newWindowState".equals(fragmentResponseXMLReader.getLocalName())) {
                                this.newWindowState = buffer.toString();
                            } else if ("newMode".equals(fragmentResponseXMLReader.getLocalName())) {
                                this.newMode = buffer.toString();
                            } else if ("id".equals(fragmentResponseXMLReader.getLocalName()) && !seenFragmentId) {
                                seenFragmentId = true;
                                idStack.push(buffer.toString());
                            }
                            buffer = null;
                        }
                        if (!"fragment".equals(fragmentResponseXMLReader.getLocalName())) break;
                        seenFragmentId = false;
                        if (idStack.empty()) {
                            if (this.logger.isErrorEnabled()) {
                                this.logger.error("Fragment id is missing when parsing end of fragment");
                            }
                            throw new BridgeException("pf.fragment.bridge.xml.error");
                        }
                        idStack.pop();
                        break;
                    }
                    case 4: {
                        if (buffer == null) break;
                        buffer.append(fragmentResponseXMLReader.getText());
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new BridgeException("pf.fragment.bridge.xml.error", e);
        }
    }

    private void parseResponse(XMLStreamReader xsr, int parseFlag) throws BridgeException, XMLStreamException {
        int index;
        PathIterator it = new PathIterator(xsr, PARSE_PATHS[parseFlag]);
        while ((index = it.moveToNextPath()) != -1) {
            switch (index) {
                case 0: {
                    it.setPathArray(ERROR_PATHS);
                    String message = null;
                    String detail = null;
                    String code = null;
                    while ((index = it.moveToNextPath()) != -1) {
                        switch (index) {
                            case 0: {
                                message = it.getElementText();
                                break;
                            }
                            case 1: {
                                detail = it.getElementText();
                                break;
                            }
                            case 2: {
                                code = it.getElementText();
                            }
                        }
                    }
                    if ("invalidCredentials".equals(code)) {
                        throw new InvalidCredentialsFault(message);
                    }
                    throw new BridgeException(message, detail);
                }
                case 1: {
                    this.mimeType = it.getElementText();
                    break;
                }
                case 2: {
                    this.markup = it.getElementText();
                    break;
                }
                case 3: {
                    if (this.libraries == null) {
                        this.libraries = new ArrayList();
                    }
                    String href = it.getAttributeValue("", "href");
                    if (this.getControllerJavascript().contains(href)) break;
                    this.libraries.add(href);
                    break;
                }
                case 4: {
                    this.styles.add(it.getAttributeValue("", "href"));
                    break;
                }
                case 5: {
                    this.preferredTitle = it.getElementText();
                    break;
                }
                case 6: {
                    this.fragmentState.setState(this.fragmentId, it.getElementText());
                    break;
                }
                case 7: {
                    this.readSubfragmentState(it);
                    break;
                }
                case 8: {
                    this.fragmentState.setValidator(this.fragmentId, it.getElementText());
                    break;
                }
                case 9: {
                    this.newMode = it.getElementText();
                    break;
                }
                case 10: {
                    this.newWindowState = it.getElementText();
                    break;
                }
                case 11: {
                    this.meta = new Meta();
                    this.meta.read(it);
                    break;
                }
                case 12: {
                    this.customUpdate = it.getElementText();
                    break;
                }
                case 13: {
                    if (this.transientUpdates == null) {
                        this.transientUpdates = new JSONObject();
                        this.transientUpdates.addArrayMember("array");
                    }
                    this.transientUpdates.addObject();
                    String name = it.getAttributeValue("", "name");
                    String value = it.getElementText();
                    String channel = it.getAttributeValue("", "channel");
                    String scope = it.getAttributeValue("", "scope");
                    this.transientUpdates.addMember("name", name);
                    this.transientUpdates.addMember("value", value);
                    if (channel != null) {
                        this.transientUpdates.addMember("channel", channel);
                    }
                    if (scope != null) {
                        this.transientUpdates.addMember("scope", scope);
                    }
                    this.transientUpdates.endObject();
                }
            }
        }
        if (this.transientUpdates != null) {
            this.transientUpdates.endArray();
        }
    }

    private void readSubfragmentState(XMLStreamReader reader) throws XMLStreamException {
        int level = 0;
        String subFragmentId = null;
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if ("id".equals(reader.getLocalName())) {
                        subFragmentId = reader.getElementText();
                        break;
                    }
                    if ("state".equals(reader.getLocalName())) {
                        if (subFragmentId != null) {
                            this.fragmentState.setState(subFragmentId, reader.getElementText());
                            break;
                        }
                    } else if ("remote".equals(reader.getLocalName())) {
                        if (subFragmentId != null) {
                            this.fragmentState.setValidator(subFragmentId, reader.getElementText());
                            break;
                        }
                    } else if ("subfragment".equals(reader.getLocalName())) {
                        this.readSubfragmentState(reader);
                        break;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level >= 0) break;
                    return;
                }
            }
        }
    }

    private void updateEnvironmentForHttpRequest() throws DashboardException {
        this.env.copyGatewayAndWebcontentOverrideToEnvParams();
    }

    private void updateEnvironmentForSOAPRequest() throws DashboardException {
        this.copySavedStateToEnvironment();
        this.env.setTarget(this.buildFragmentProducerURI());
        this.env.addParameter("frag-mode", this.wsrpRequest.getMode());
        this.env.addParameter("frag-windowState", this.wsrpRequest.getWindowState());
        this.env.addParameter("frag-agent", this.wsrpRequest.getUserAgent());
        this.env.addParameter("frag-portalAgent", this.wsrpRequest.getPortalAgent());
        this.env.patchUserAgent(this.wsrpRequest.getUserAgent());
        this.env.addParameter("frag-id", this.fragmentId);
        this.env.setWebContentOverride(this.wsrpRequest.getWebContentURL());
        this.env.setGatewayOverride(this.wsrpRequest.getGatewayURL());
        this.env.copyGatewayAndWebcontentOverrideToEnvParams();
        if (("edit".equals(this.wsrpRequest.getMode()) || "config".equals(this.wsrpRequest.getMode())) && (this.wsrpRequest.getPortletHandle().indexOf("#noedit") != -1 || this.env.isGenericEdit())) {
            this.env.addParameter("frag-delegate", this.wsrpRequest.getMode());
        }
        Parameters wsrpInteractions = this.wsrpRequest.getWSRPInteractionParams();
        this.addInteractionParameters(wsrpInteractions);
        this.env.setEvents(this.wsrpRequest.getEventsList());
        String state = this.wsrpRequest.getPortletState();
        if (state != null && state.length() > 0) {
            this.env.setParameter("frag-custom", this.env.sign(this.env.getTarget(), "frag-custom", state));
        }
    }

    private void copySavedStateToEnvironment() {
        Parameters applicationScopeTransients = this.fragmentState.getApplicationScopeTransients();
        if (applicationScopeTransients != null) {
            for (Parameters.NameValuePair transientEntry : applicationScopeTransients) {
                this.env.setParameter(transientEntry.getName(), transientEntry.getValue());
            }
        }
        Iterator it = this.fragmentState.getSubFragmentStateIterator();
        while (it.hasNext()) {
            PortletState.StateData stateData = (PortletState.StateData)it.next();
            String id = stateData.getId();
            if (stateData == null) continue;
            if (this.fragmentId.equals(id)) {
                if (stateData.getState() != null) {
                    this.env.setParameter("frag-state", stateData.getState());
                }
                if (stateData.getValidator() == null) continue;
                this.env.setParameter("frag-validator", stateData.getValidator());
                continue;
            }
            if (stateData.getState() != null) {
                this.env.addSubFragmentParam(id, "frag-state", stateData.getState());
            }
            if (stateData.getValidator() != null) {
                this.env.addSubFragmentParam(id, "frag-validator", stateData.getValidator());
            }
            if (stateData.getMode() != null) {
                this.env.addSubFragmentParam(id, "frag-mode", stateData.getMode());
            }
            if (stateData.getWindowState() == null) continue;
            this.env.addSubFragmentParam(id, "frag-windowState", stateData.getWindowState());
        }
    }

    private void addInteractionParameters(Parameters wsrpInteractions) {
        String subFragmentId = wsrpInteractions.getValue("subFragmentId");
        if (subFragmentId != null) {
            for (Parameters.NameValuePair nvp : wsrpInteractions) {
                String name = nvp.getName();
                if ("subFragmentId".equals(name)) continue;
                this.env.addSubFragmentParam(subFragmentId, name, nvp.getValue());
            }
        } else {
            for (Parameters.NameValuePair nvp : wsrpInteractions) {
                String name = nvp.getName();
                if (name.startsWith("frag-")) {
                    this.env.setParameter(name, nvp.getValue());
                    continue;
                }
                this.env.addParameters(name, nvp.getValues());
            }
        }
    }

    private String buildFragmentProducerURI() {
        StringBuffer fragProducer = new StringBuffer();
        String producerHandle = this.env.getProducerHandle();
        if (producerHandle.length() > 0 && producerHandle.charAt(0) != '/') {
            fragProducer.append('/');
        }
        fragProducer.append(producerHandle);
        String portletHandle = this.wsrpRequest.getPortletHandle();
        if (portletHandle.length() > 0) {
            int endIndex;
            if (portletHandle.charAt(0) != '/') {
                fragProducer.append('/');
            }
            if ((endIndex = portletHandle.indexOf(35)) != -1) {
                portletHandle = portletHandle.substring(0, endIndex);
            }
            if ((endIndex = portletHandle.indexOf(58)) != -1) {
                portletHandle = portletHandle.substring(0, endIndex);
            }
            fragProducer.append(portletHandle);
        }
        fragProducer.append("/reg/");
        fragProducer.append(this.wsrpRequest.getRegistrationHandle());
        return fragProducer.toString();
    }

    public Iterator getLibrariesIterator() {
        return this.libraries != null ? this.libraries.iterator() : EMPTY_ITERATOR;
    }

    public Iterator getStylesIterator() {
        return this.styles != null ? this.styles.iterator() : EMPTY_ITERATOR;
    }

    public String getMarkup() {
        return this.markup;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public PortletState getFragmentState() {
        return this.fragmentState;
    }

    public String getMode() {
        String mode = this.newMode;
        if (mode == null && (mode = this.env.getParameter("frag-mode")) == null) {
            if (this.wsrpRequest != null) {
                mode = this.wsrpRequest.getMode();
            }
            if (mode == null) {
                mode = "view";
            }
        }
        return mode;
    }

    public String getWindowState() {
        String windowState = this.newWindowState;
        if (windowState == null && (windowState = this.env.getParameter("frag-windowState")) == null) {
            if (this.wsrpRequest != null) {
                windowState = this.wsrpRequest.getWindowState();
            }
            if (windowState == null) {
                windowState = "normal";
            }
        }
        return windowState;
    }

    public String getPreferredTitle() {
        return this.preferredTitle;
    }

    public String getFragmentId() {
        return this.fragmentId;
    }

    private void calculateFragmentId() {
        boolean excludeParentId;
        this.fragmentId = this.wsrpRequest != null ? ((excludeParentId = this.wsrpRequest.isCallerFragmentServer()) ? this.wsrpRequest.getPortletInstanceKey() : PARENT_ID + this.wsrpRequest.getPortletInstanceKey()) : this.env.getParameter("frag-id");
    }

    public void saveStateToDataStorage() throws BridgeException {
        this.fragmentState.saveToDataStorage(this.env, this.logger);
    }

    private String getPortletSessionId() throws BridgeException {
        String sessionId = this.wsrpRequest != null ? this.wsrpRequest.getPortletSessionID() : this.env.getSessionId();
        if (!this.isSessionIdValid(sessionId)) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Validation failed for sessionId parameter '" + sessionId + "'");
            }
            throw new BridgeException("pf.fragment.validation.verifyfailed");
        }
        return sessionId;
    }

    private boolean isSessionIdValid(String sessionId) {
        if (sessionId == null) {
            return false;
        }
        return SESSIONID_PATTERN.matcher(sessionId).matches();
    }

    public Iterator getControllerJavascriptIterator() {
        return this.getControllerJavascript().iterator();
    }

    private List getControllerJavascript() {
        if (this.controllerJavaScript == null) {
            this.controllerJavaScript = new ArrayList();
            String webContent = this.env.getWebContent();
            for (String libRef : CONTROLLER_JAVACSCRIPT) {
                if (libRef.endsWith("/core.js")) {
                    if (!this.wsrpRequest.getPortalAgent().contains("cognos")) continue;
                    this.controllerJavaScript.add(webContent + libRef);
                    continue;
                }
                if (libRef.endsWith("/cpscore.js")) {
                    if (this.wsrpRequest.getPortalAgent().contains("cognos")) continue;
                    this.controllerJavaScript.add(webContent + libRef);
                    continue;
                }
                this.controllerJavaScript.add(webContent + libRef);
            }
        }
        return this.controllerJavaScript;
    }

    public String getCustomUpdate() {
        return this.customUpdate;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public String getParentId() {
        return PARENT_ID;
    }

    public JSONObject getTransientUpdates() {
        return this.transientUpdates;
    }

    static {
        CONTROLLER_JAVACSCRIPT.add("/camcrypto/base64.js");
        CONTROLLER_JAVACSCRIPT.add("/camcrypto/sha1.js");
        CONTROLLER_JAVACSCRIPT.add("/camcrypto/camcryptoutil.js");
        CONTROLLER_JAVACSCRIPT.add("/camcrypto/authtoken1.js");
        CONTROLLER_JAVACSCRIPT.add("/dojo16/dojo/dojo.js");
        CONTROLLER_JAVACSCRIPT.add("/fragments/xdojo/core.js");
        CONTROLLER_JAVACSCRIPT.add("/fragments/xdojo/cpscore.js");
        CONTROLLER_JAVACSCRIPT.add("/fragments/cps.core.js");
        CONTROLLER_JAVACSCRIPT.add("/common/framework/validator/CValidator.js");
        CONTROLLER_JAVACSCRIPT.add("/fragments/wsrp.js");
        EMPTY_ITERATOR = new Iterator(){

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                return null;
            }
        };
        GET_MARKUP_PATHS = new String[]{"/fragment/error", "/fragment/markup/mimeType", "/fragment/markup/markupString", "/fragment/library", "/fragment/css", "/fragment/preferredTitle", "/fragment/state", "/fragment/subfragment", "/fragment/validator/remote", "/fragment/newMode", "/fragment/newWindowState"};
        PERFOM_BLOCKING_INTERACTION_PATHS = new String[]{"/fragment/error", "/fragment/markup/mimeType", "/fragment/markup/markupString", "/fragment/library", "/fragment/css", "/fragment/preferredTitle", "/fragment/state", "/fragment/subfragment", "/fragment/validator/remote", "/fragment/newMode", "/fragment/newWindowState", "/fragment/meta", "/fragment/customUpdate", "/fragment/transientUpdate"};
        ERROR_PATHS = new String[]{"/fragment/error/message", "/fragment/error/details", "/fragment/error/code"};
        PARSE_PATHS = new String[2][];
        Fragment.PARSE_PATHS[0] = GET_MARKUP_PATHS;
        Fragment.PARSE_PATHS[1] = PERFOM_BLOCKING_INTERACTION_PATHS;
    }
}

