/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.wsrp;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.autoregistration.FragmentProducer;
import com.cognos.portal.fragment.meta.Meta;
import com.cognos.portal.fragment.meta.MetaProperty;
import com.cognos.portal.fragment.server.Constants;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.DashboardProcessor;
import com.cognos.portal.fragment.server.document.DashboardDocument;
import com.cognos.portal.fragment.service.WSRPEnvironment;
import com.cognos.portal.fragment.wsrp.ApplicationState;
import com.cognos.portal.fragment.wsrp.BridgeException;
import com.cognos.portal.fragment.wsrp.BusHeader;
import com.cognos.portal.fragment.wsrp.Fragment;
import com.cognos.portal.fragment.wsrp.MarkupRewriter;
import com.cognos.portal.fragment.wsrp.PortletState;
import com.cognos.portal.fragment.wsrp.WSRPRequestHelper;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionFactory;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.soap.impl.bus.cm.Query;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.WSRPParamUtils;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Element;

public class FragmentWSRPBridge {
    static final String CPS_EXT_NAMESPACE_URI = "http://developer.cognos.com/schemas/cps/wsrp/extensions/1/";
    static final String CPS_EXT_NAMESPACE_PREFIX = "cpsext";
    private static final String WSRP_PATH_INFO = "/wsrp/fragments";
    private static final String WSRP_NAMESPACE_URI = "urn:oasis:names:tc:wsrp:v1:types";
    private static final String WSRP_NAMESPACE_PREFIX = "wsrp";
    private static final String WSDL_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/";
    private static final String WSDL_NAMESPACE_PREFIX = "wsdl";
    private static final String BIND_NAMESPACE_URI = "urn:oasis:names:tc:wsrp:v1:bind";
    private static final String BIND_NAMESPACE_PREFIX = "bind";
    private static final String SOAP_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String SOAP_NAMESPACE_PREFIX = "soap";
    private static final String TARGET_NAMESPACE_URI = "urn:oasis:names:tc:wsrp:v1:wsdl";
    private String cmUrl;
    private DashboardProcessor dashboard;
    private MarkupRewriter markupRewriter;
    private ServiceLogger logger;

    public FragmentWSRPBridge(DashboardProcessor dashboard, ServiceLogger logger) {
        this.dashboard = dashboard;
        this.logger = logger != null ? logger.cloneForClass(FragmentWSRPBridge.class) : null;
        this.markupRewriter = new MarkupRewriter(this.logger);
    }

    public void init(IContext context) throws LocalizableException {
        this.cmUrl = (String)context.getProperty("contentManager");
        if (this.cmUrl == null) {
            throw new LocalizableException("Missing configuration parameters 'contentManager'");
        }
    }

    public void initCookies(Element busHeader, Writer wsrpResponseWriter, WSRPEnvironment env, BIBusEnvelope responseEnvelope) throws BridgeException {
        try {
            XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(wsrpResponseWriter);
            xsw.setPrefix(WSRP_NAMESPACE_PREFIX, WSRP_NAMESPACE_URI);
            xsw.writeStartElement(WSRP_NAMESPACE_URI, "initCookieResponse");
            xsw.writeNamespace(WSRP_NAMESPACE_PREFIX, WSRP_NAMESPACE_URI);
            xsw.writeEndElement();
            xsw.close();
        }
        catch (XMLStreamException e) {
            throw new BridgeException("pf.fragment.bridge.xml.error", e);
        }
        this.getCookies(busHeader, env, responseEnvelope);
    }

    private void getCookies(Element busHeader, WSRPEnvironment env, BIBusEnvelope responseEnvelope) throws BridgeException {
        String passport = busHeader.valueOf("*[local-name()='CAM']/CAMPassport/id");
        if (passport == null || passport.length() == 0) {
            Element eAction;
            Element camElement = busHeader.element("CAM");
            if (camElement == null) {
                camElement = busHeader.addElement("CAM");
            }
            if ((eAction = camElement.element("action")) == null) {
                eAction = camElement.addElement("action");
            }
            eAction.setText("logon");
        }
        Query queryState = new Query();
        queryState.setBusHeader(busHeader.asXML());
        queryState.setSearchPath("~~");
        BusHeader headerHandler = new BusHeader(responseEnvelope);
        queryState.setResponseHeaderHandler(headerHandler);
        FragmentWSRPBridge.sendCMRequest(queryState, env, this.logger);
    }

    public void getMarkup(WSRPEnvironment wsrpEnv, Element wsrpOp, Writer wsrpResponseWriter) throws BridgeException {
        try {
            WSRPRequestHelper wsrpRequestHelper = new WSRPRequestHelper(wsrpOp);
            Fragment fragment = new Fragment(wsrpEnv, wsrpRequestHelper, this.logger);
            fragment.execute(this.dashboard, 0);
            fragment.saveStateToDataStorage();
            XMLStreamWriter wsrpResponseXMLWriter = XMLStreamFactory.createXMLStreamWriter(wsrpResponseWriter);
            wsrpResponseXMLWriter.setPrefix(WSRP_NAMESPACE_PREFIX, WSRP_NAMESPACE_URI);
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "getMarkupResponse");
            wsrpResponseXMLWriter.writeNamespace(WSRP_NAMESPACE_PREFIX, WSRP_NAMESPACE_URI);
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "markupContext");
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "useCachedMarkup");
            wsrpResponseXMLWriter.writeCharacters("false");
            wsrpResponseXMLWriter.writeEndElement();
            String mimeType = fragment.getMimeType();
            if (mimeType != null) {
                wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "mimeType");
                wsrpResponseXMLWriter.writeCharacters(mimeType);
                wsrpResponseXMLWriter.writeEndElement();
            }
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "markupString");
            String markup = this.markupRewriter.getMarkup(fragment, wsrpRequestHelper, wsrpEnv);
            if (markup == null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("WSRP brdige GetMarkup did not receive a fragment markup.");
                }
                markup = "";
            }
            wsrpResponseXMLWriter.writeCharacters(markup);
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "requiresUrlRewriting");
            wsrpResponseXMLWriter.writeCharacters("true");
            wsrpResponseXMLWriter.writeEndElement();
            String preferredTitle = fragment.getPreferredTitle();
            if (preferredTitle != null) {
                wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "preferredTitle");
                wsrpResponseXMLWriter.writeCharacters(preferredTitle);
                wsrpResponseXMLWriter.writeEndElement();
            }
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "sessionContext");
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "sessionID");
            wsrpResponseXMLWriter.writeCharacters(wsrpRequestHelper.getPortletSessionID());
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "expires");
            wsrpResponseXMLWriter.writeCharacters("-1");
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.close();
        }
        catch (XMLStreamException e) {
            throw new BridgeException("pf.fragment.bridge.xml.error", e);
        }
        catch (DashboardException e) {
            throw new BridgeException("pf.fragment.bridge.xml.error", e);
        }
    }

    public void performBlockingInteraction(WSRPEnvironment wsrpEnv, Element wsrpOp, Writer wsrpResponseWriter) throws BridgeException {
        try {
            WSRPRequestHelper wsrpRequestHelper = new WSRPRequestHelper(wsrpOp);
            Fragment fragment = new Fragment(wsrpEnv, wsrpRequestHelper, this.logger);
            fragment.execute(this.dashboard, 1);
            fragment.saveStateToDataStorage();
            XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(wsrpResponseWriter);
            this.writeBlockingActionResponse(fragment, wsrpEnv, wsrpRequestHelper, xsw);
            xsw.close();
        }
        catch (XMLStreamException e) {
            throw new BridgeException("pf.fragment.bridge.xml.error", e);
        }
    }

    private void writeBlockingActionResponse(Fragment fragment, WSRPEnvironment env, WSRPRequestHelper wsrpRequestHelper, XMLStreamWriter wsrpResponseXMLWriter) throws BridgeException {
        try {
            String mode;
            String windowState;
            String markup;
            wsrpResponseXMLWriter.setPrefix(WSRP_NAMESPACE_PREFIX, WSRP_NAMESPACE_URI);
            wsrpResponseXMLWriter.setPrefix(CPS_EXT_NAMESPACE_PREFIX, CPS_EXT_NAMESPACE_URI);
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "performBlockingInteractionResponse");
            wsrpResponseXMLWriter.writeNamespace(WSRP_NAMESPACE_PREFIX, WSRP_NAMESPACE_URI);
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "updateResponse");
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "sessionContext");
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "sessionID");
            wsrpResponseXMLWriter.writeCharacters(wsrpRequestHelper.getPortletSessionID());
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "expires");
            wsrpResponseXMLWriter.writeCharacters("-1");
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.writeEndElement();
            String customUpdate = fragment.getCustomUpdate();
            if (customUpdate != null) {
                customUpdate = env.unsign(env.getTarget(), "frag-custom", customUpdate);
                wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "portletContext");
                wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "portletHandle");
                wsrpResponseXMLWriter.writeCharacters(wsrpRequestHelper.getPortletHandle());
                wsrpResponseXMLWriter.writeEndElement();
                wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "portletState");
                wsrpResponseXMLWriter.writeCharacters(customUpdate);
                wsrpResponseXMLWriter.writeEndElement();
                Parameters customs = DashboardDocument.decodeCustoms(customUpdate);
                Meta meta = fragment.getMeta();
                if (meta != null && customs != null) {
                    Enumeration enumeration = meta.getCustomProperties();
                    boolean foundExternalRef = false;
                    while (enumeration.hasMoreElements()) {
                        String value;
                        String name;
                        MetaProperty prop = (MetaProperty)enumeration.nextElement();
                        if (!Constants.FRAGMENT_CM_PROVIDER.CM_OBJECT_DATATYPE.equals(prop.getDataType()) || (name = prop.getName()) == null || (value = customs.getValue(name)) == null || value.length() <= 0) continue;
                        if (!foundExternalRef) {
                            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "extensions");
                            wsrpResponseXMLWriter.writeStartElement(CPS_EXT_NAMESPACE_PREFIX, "state", CPS_EXT_NAMESPACE_URI);
                            wsrpResponseXMLWriter.writeNamespace(CPS_EXT_NAMESPACE_PREFIX, CPS_EXT_NAMESPACE_URI);
                            foundExternalRef = true;
                        }
                        wsrpResponseXMLWriter.writeStartElement(CPS_EXT_NAMESPACE_PREFIX, "externalRef", CPS_EXT_NAMESPACE_URI);
                        wsrpResponseXMLWriter.writeAttribute("type", "cm");
                        wsrpResponseXMLWriter.writeAttribute("name", name);
                        wsrpResponseXMLWriter.writeCharacters(value);
                        wsrpResponseXMLWriter.writeEndElement();
                    }
                    if (foundExternalRef) {
                        wsrpResponseXMLWriter.writeEndElement();
                        wsrpResponseXMLWriter.writeEndElement();
                    }
                }
                wsrpResponseXMLWriter.writeEndElement();
            }
            if ((markup = this.markupRewriter.getMarkup(fragment, wsrpRequestHelper, env)) != null) {
                wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "markupContext");
                wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "useCachedMarkup");
                wsrpResponseXMLWriter.writeCharacters("false");
                wsrpResponseXMLWriter.writeEndElement();
                String mimeType = fragment.getMimeType();
                if (mimeType != null) {
                    wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "mimeType");
                    wsrpResponseXMLWriter.writeCharacters(mimeType);
                    wsrpResponseXMLWriter.writeEndElement();
                }
                wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "markupString");
                wsrpResponseXMLWriter.writeCharacters(markup);
                wsrpResponseXMLWriter.writeEndElement();
                wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "requiresUrlRewriting");
                wsrpResponseXMLWriter.writeCharacters("true");
                wsrpResponseXMLWriter.writeEndElement();
                String preferredTitle = fragment.getPreferredTitle();
                if (preferredTitle != null) {
                    wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "preferredTitle");
                    wsrpResponseXMLWriter.writeCharacters(preferredTitle);
                    wsrpResponseXMLWriter.writeEndElement();
                }
                wsrpResponseXMLWriter.writeEndElement();
            }
            if ((windowState = fragment.getWindowState()) != null && !windowState.equals(wsrpRequestHelper.getWindowState())) {
                windowState = WSRPParamUtils.WSRPWindowStateFromFragment(windowState);
                wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "newWindowState");
                wsrpResponseXMLWriter.writeCharacters(windowState);
                wsrpResponseXMLWriter.writeEndElement();
            }
            if ((mode = fragment.getMode()) != null && !mode.equals(wsrpRequestHelper.getMode())) {
                mode = WSRPParamUtils.WSRPModeFromFragment(mode);
                wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "newMode");
                wsrpResponseXMLWriter.writeCharacters(mode);
                wsrpResponseXMLWriter.writeEndElement();
            }
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new BridgeException("pf.fragment.bridge.xml.error", e);
        }
        catch (DashboardException e) {
            throw new BridgeException("pf.fragment.bridge.xml.error", e);
        }
    }

    public void register(WSRPEnvironment env, Element wsrpOp, Writer wsrpResponseWriter) throws BridgeException {
        String producerxml = env.getProducerXMLEndPoint();
        if (producerxml == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("register() - the parameter 'producerxml' is required");
            }
            throw new BridgeException("pf.fragment.bridge.executionfailed");
        }
        FragmentProducer fragmentProducer = env.createProducerFragment(producerxml);
        if (fragmentProducer == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("register() - could not create producer object");
            }
            throw new BridgeException("pf.fragment.bridge.executionfailed");
        }
        try {
            XMLStreamWriter wsrpResponseXMLWriter = XMLStreamFactory.createXMLStreamWriter(wsrpResponseWriter);
            wsrpResponseXMLWriter.setPrefix(WSRP_NAMESPACE_PREFIX, WSRP_NAMESPACE_URI);
            wsrpResponseXMLWriter.setPrefix(CPS_EXT_NAMESPACE_PREFIX, CPS_EXT_NAMESPACE_URI);
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_PREFIX, "registerResponse", WSRP_NAMESPACE_URI);
            wsrpResponseXMLWriter.writeNamespace(WSRP_NAMESPACE_PREFIX, WSRP_NAMESPACE_URI);
            StaxUtils.writeTextElement(wsrpResponseXMLWriter, WSRP_NAMESPACE_URI, "registrationHandle", String.valueOf(System.currentTimeMillis()));
            StaxUtils.writeTextElement(wsrpResponseXMLWriter, WSRP_NAMESPACE_URI, "registrationState", this.getRegistrationState(wsrpOp));
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "extensions");
            wsrpResponseXMLWriter.writeStartElement(CPS_EXT_NAMESPACE_PREFIX, "info", CPS_EXT_NAMESPACE_URI);
            wsrpResponseXMLWriter.writeNamespace(CPS_EXT_NAMESPACE_PREFIX, CPS_EXT_NAMESPACE_URI);
            String identifier = fragmentProducer.getIdentifier() + ":" + String.valueOf(System.currentTimeMillis());
            StaxUtils.writeTextElement(wsrpResponseXMLWriter, CPS_EXT_NAMESPACE_URI, "identifier", identifier);
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.close();
        }
        catch (XMLStreamException e) {
            throw new BridgeException("pf.fragment.bridge.xml.error", e);
        }
    }

    private String getRegistrationState(Element wsrpOp) throws BridgeException {
        wsrpOp.addNamespace(WSRP_NAMESPACE_PREFIX, WSRP_NAMESPACE_URI);
        StringBuffer buffer = new StringBuffer();
        String consumerAgent = wsrpOp.valueOf("./wsrp:consumerAgent");
        consumerAgent = consumerAgent.indexOf("WebSphere") != -1 ? "websphere" : (consumerAgent.indexOf("Plumtree") != -1 ? "plumtree" : (consumerAgent.indexOf("SAP") != -1 ? "sap" : (consumerAgent.indexOf("Cognos") != -1 ? "cognos" : "default")));
        buffer.append("<param name=\"consumerAgent\">" + consumerAgent + "</param>");
        List properties = wsrpOp.selectNodes("./wsrp:registrationProperties");
        for (Element e : properties) {
            String name = e.attributeValue("name");
            if (name == null) continue;
            String value = e.valueOf("./wsrp:stringValue");
            buffer.append("<param name=\"" + name + "\">" + value + "</param>");
        }
        try {
            return EncodingUtils.base64encode(buffer.toString().getBytes("UTF-8"), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new BridgeException("pf.fragment.bridge.executionfailed");
        }
    }

    public void getServiceDescription(WSRPEnvironment wsrpEnv, Writer wsrpResponseWriter) throws BridgeException {
        try {
            FragmentProducer fragmentProducer;
            SharedByteArrayOutputStream out = new SharedByteArrayOutputStream(4096);
            wsrpEnv.setOutputStream(out);
            wsrpEnv.addParameter("frag-id", "id1");
            String producerxml = wsrpEnv.getProducerXMLEndPoint();
            if (producerxml != null) {
                fragmentProducer = wsrpEnv.createProducerFragment(producerxml);
                if (fragmentProducer == null) {
                    throw new BridgeException("pf.fragment.bridge.executionfailed");
                }
            } else {
                throw new BridgeException("pf.fragment.bridge.executionfailed");
            }
            XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(wsrpResponseWriter);
            fragmentProducer.writeServiceDescriptionResponse(xsw);
            xsw.close();
        }
        catch (XMLStreamException e) {
            throw new BridgeException("pf.fragment.bridge.xml.error", e);
        }
    }

    public void getWSDL(WSRPEnvironment env, OutputStream output) throws BridgeException {
        try {
            env.setResponseContentType("text/xml;charset=UTF-8");
            String producerxml = env.getParameter("producerxml");
            if (producerxml == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("getWSDL:: fragment producerxml is missing");
                }
                throw new BridgeException("pf.fragment.bridge.executionfailed");
            }
            FragmentProducer fragmentProducer = env.createProducerFragment(producerxml);
            if (fragmentProducer == null || fragmentProducer.isError()) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("getWSDL:: could not create fragment producer");
                    if (fragmentProducer != null) {
                        this.logger.error(fragmentProducer.getError());
                    }
                }
                throw new BridgeException("pf.fragment.bridge.executionfailed");
            }
            fragmentProducer.setWSRPEndpointBaseURI(env.getWsdlURI(WSRP_PATH_INFO));
            XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(output);
            xsw.setPrefix(WSDL_NAMESPACE_PREFIX, WSDL_NAMESPACE_URI);
            xsw.writeStartElement(WSDL_NAMESPACE_URI, "definitions");
            xsw.writeNamespace(WSDL_NAMESPACE_PREFIX, WSDL_NAMESPACE_URI);
            xsw.setPrefix(BIND_NAMESPACE_PREFIX, BIND_NAMESPACE_URI);
            xsw.writeNamespace(BIND_NAMESPACE_PREFIX, BIND_NAMESPACE_URI);
            xsw.setPrefix(SOAP_NAMESPACE_PREFIX, SOAP_NAMESPACE_URI);
            xsw.writeNamespace(SOAP_NAMESPACE_PREFIX, SOAP_NAMESPACE_URI);
            xsw.writeAttribute("targetNamespace", TARGET_NAMESPACE_URI);
            xsw.writeStartElement(WSDL_NAMESPACE_URI, "import");
            xsw.writeAttribute("namespace", BIND_NAMESPACE_URI);
            xsw.writeAttribute("location", "http://www.oasis-open.org/committees/wsrp/specifications/version1/wsrp_v1_bindings.wsdl");
            xsw.writeEndElement();
            xsw.writeStartElement(WSDL_NAMESPACE_URI, "service");
            xsw.writeAttribute("name", "WSRPService");
            fragmentProducer.writeRouting(xsw);
            xsw.writeStartElement(WSDL_NAMESPACE_URI, "port");
            xsw.writeAttribute("binding", "bind:WSRP_v1_Markup_Binding_SOAP");
            xsw.writeAttribute("name", "WSRPBaseService");
            xsw.writeStartElement(SOAP_NAMESPACE_URI, "address");
            xsw.writeAttribute("location", fragmentProducer.getWSRPMarkupEndpoint());
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement(WSDL_NAMESPACE_URI, "port");
            xsw.writeAttribute("binding", "bind:WSRP_v1_ServiceDescription_Binding_SOAP");
            xsw.writeAttribute("name", "WSRPServiceDescriptionService");
            xsw.writeStartElement(SOAP_NAMESPACE_URI, "address");
            xsw.writeAttribute("location", fragmentProducer.getWSRPDescriptionEndpoint());
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement(WSDL_NAMESPACE_URI, "port");
            xsw.writeAttribute("binding", "bind:WSRP_v1_Registration_Binding_SOAP");
            xsw.writeAttribute("name", "WSRPRegistrationService");
            xsw.writeStartElement(SOAP_NAMESPACE_URI, "address");
            xsw.writeAttribute("location", fragmentProducer.getWSRPRegistrationEndpoint());
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.setPrefix(WSDL_NAMESPACE_PREFIX, WSDL_NAMESPACE_URI);
            xsw.writeStartElement(WSDL_NAMESPACE_URI, "port");
            xsw.writeAttribute("binding", "bind:WSRP_v1_PortletManagement_Binding_SOAP");
            xsw.writeAttribute("name", "WSRPPortletManagementService");
            xsw.writeStartElement(SOAP_NAMESPACE_URI, "address");
            xsw.writeAttribute("location", fragmentProducer.getWSRPManagementEndpoint());
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.flush();
            xsw.close();
        }
        catch (XMLStreamException e) {
            throw new BridgeException("pf.fragment.bridge.xml.error", e);
        }
    }

    public void handleHttpRequest(WSRPEnvironment env, OutputStream output) throws BridgeException {
        String[] destroyIds = env.getParameterValues("bridge-destroy");
        if (destroyIds != null && destroyIds.length > 0) {
            PortletState portletState = new PortletState(env.getSessionId());
            for (int i = 0; i < destroyIds.length; ++i) {
                portletState.destroy(destroyIds[i], env, this.logger);
            }
            try {
                output.write(("<count>" + String.valueOf(destroyIds.length) + "</count").getBytes());
            }
            catch (IOException e) {
                throw new BridgeException("pf.fragment.bridge.executionfailed", e);
            }
        } else {
            String applicationScopeTransients = env.getParameter("bridge-appTransients");
            if (applicationScopeTransients != null) {
                ApplicationState state = new ApplicationState();
                Parameters transients = Parameters.parse(applicationScopeTransients);
                state.setTransients(transients);
                state.saveToDataStorage(env, this.logger);
            } else {
                env.setOutputStream(output);
                this.dashboard.process(env);
            }
        }
    }

    public void getFragmentXML(WSRPEnvironment env, OutputStream output) throws BridgeException {
        Fragment fragment = new Fragment(env, null, this.logger);
        fragment.executeAjaxRequest(this.dashboard, output);
        fragment.saveStateToDataStorage();
    }

    public String handleRedirect(Element busHeader, WSRPEnvironment env, BIBusEnvelope responseEnvelope) throws BridgeException {
        String url = env.getParameter("url");
        if (url != null && url.length() > 0) {
            Query queryState = new Query();
            queryState.setBusHeader(busHeader.asXML());
            queryState.setSearchPath("~~");
            BusHeader headerHandler = new BusHeader(responseEnvelope);
            queryState.setResponseHeaderHandler(headerHandler);
            boolean includePassportID = false;
            try {
                FragmentWSRPBridge.sendCMRequest(queryState, env, this.logger);
            }
            catch (InvalidCredentialsFault e) {
                includePassportID = true;
            }
            StringBuffer redirectResponse = new StringBuffer();
            redirectResponse.append(url);
            boolean hasQuery = url.indexOf(63) != -1;
            Enumeration parametersNames = env.getParameterNames();
            while (parametersNames.hasMoreElements()) {
                String name = (String)parametersNames.nextElement();
                if ("url".equals(name) || "m_passportID".equals(name) && !includePassportID || "m_contentLocale".equals(name) || "m_productLocale".equals(name) || name.startsWith("frag-")) continue;
                String[] values = env.getParameterValues(name);
                for (int i = 0; i < values.length; ++i) {
                    if (hasQuery) {
                        redirectResponse.append('&');
                    } else {
                        hasQuery = true;
                        redirectResponse.append('?');
                    }
                    redirectResponse.append(EncodingUtils.urlencode(name, "UTF-8", false));
                    redirectResponse.append('=');
                    if (values[i] == null) continue;
                    redirectResponse.append(EncodingUtils.urlencode(values[i], "UTF-8", false));
                }
            }
            env.setResponseStatus(302);
            env.setResponseContentType("text/html");
            return redirectResponse.toString();
        }
        throw new BridgeException("pf.fragment.bridge.executionfailed");
    }

    static void sendCMRequest(SOAPMessage message, Environment env, ServiceLogger logger) throws BridgeException {
        try {
            SOAPConnection connection = ((SOAPConnectionFactory)env.getProperty("SoapConnectionFactory")).createConnection(logger);
            connection.execute(message, (String)env.getProperty("contentManager"));
        }
        catch (MalformedURLException e) {
            throw new BridgeException("invalid url", e);
        }
        catch (IOException e) {
            throw new BridgeException("pf.fragment.bridge.io.error", e);
        }
        catch (XMLStreamException e) {
            throw new BridgeException("pf.fragment.bridge.xml.error", e);
        }
        catch (SOAPFault e) {
            String detail = e.getDetail();
            if (detail != null && detail.indexOf("CM-REQ-4159") != -1) {
                throw new InvalidCredentialsFault("pf.fragment.server.invalidcredentials", null, e);
            }
            throw new BridgeException("pf.fragment.bridge.executionfailed", e);
        }
    }
}

