/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.wsrp;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.service.WSRPEnvironment;
import com.cognos.portal.fragment.wsrp.Fragment;
import com.cognos.portal.fragment.wsrp.PortletState;
import com.cognos.portal.fragment.wsrp.WSRPRequestHelper;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.JSONObject;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.WSRPParamUtils;
import java.util.Iterator;
import java.util.Map;

public class MarkupRewriter {
    private ServiceLogger logger;

    public MarkupRewriter(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(MarkupRewriter.class) : null;
    }

    public String getMarkup(Fragment fragment, WSRPRequestHelper wsrpRequest, WSRPEnvironment env) throws DashboardException {
        String markup = fragment.getMarkup();
        if (markup == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String fragmentId = fragment.getFragmentId();
        if (wsrpRequest.isCallerFragmentServer()) {
            this.addJavaScriptAndCSS(fragment, wsrpRequest, env, buffer);
            buffer.append("<div id=\"").append(fragmentId).append("content\" class=\"portlet-font\"/>");
            buffer.append(markup);
            buffer.append("</div>");
        } else {
            this.addPrototypeOverrideScripts(fragment, wsrpRequest, env, buffer);
            this.addJavaScriptAndCSS(fragment, wsrpRequest, env, buffer);
            String parentId = fragment.getParentId();
            buffer.append("<script type=\"text/javascript\">\n");
            buffer.append("if (!window.").append(parentId).append("){\n");
            buffer.append("window.").append(parentId).append("=_F_attach({ title: \"\", id: \"").append(parentId).append("\" , page: true});\n");
            buffer.append("window.").append(parentId).append(".setOnloadHandler(ui_init);");
            Parameters applicationScopeTransients = fragment.getFragmentState().getApplicationScopeTransients();
            if (applicationScopeTransients != null) {
                JSONObject globalTransients = new JSONObject();
                for (Parameters.NameValuePair prop : applicationScopeTransients) {
                    globalTransients.addMember(prop.getName(), prop.getValue());
                }
                buffer.append("fragment.prototype.transientGlobal=");
                globalTransients.write(buffer);
                buffer.append(";\n");
            }
            buffer.append("var ").append(fragment.getParentId()).append("distributionList = new Array();");
            buffer.append("function ").append(fragment.getParentId()).append("distributor(evt) {");
            buffer.append("_F_Event.distribute(").append(fragment.getParentId()).append("distributionList, evt); }");
            buffer.append(fragment.getParentId()).append(".addEventListener(\"*\", \"").append(fragment.getParentId()).append("distributor\", true);");
            buffer.append("ui_error.prototype.template = \"\\<div role=\\\"alert\\\" id=\\\"_THIS_errormsg\\\"\\>\\<\"+\"/div\\>\\<div\\>\\<a id=\\\"_THIS_error_showdetails\\\"\\>\"+PFM.JS.IDS_JS_DETAILS+\"\\<\"+\"/a\\> | \\<a id=\\\"_THIS_error_retry\\\"\\>\"+PFM.JS.IDS_JS_RETRY+\"\\<\"+\"/a\\> | \\<a id=\\\"_THIS_error_hide\\\"\\>\"+PFM.JS.IDS_JS_HIDE+\"\\<\"+\"/a\\><\"+\"/div\\>\";\n");
            buffer.append("}\n");
            buffer.append(fragment.getParentId()).append("distributionList.push(\"").append(fragment.getFragmentId()).append("\");\n");
            if (!this.isThirdPartyPortal(wsrpRequest)) {
                buffer.append("document.write(\"<form id='cps_backjaxform' name='cps_backjaxform' aria-hidden='true' role='presentation'><input type='hidden' name='visited' value='false'></form>\")");
            }
            buffer.append("</script>");
            buffer.append("<div id=\"").append(fragmentId).append("content\" class=\"portlet-font\">");
            this.addFragmentInitScripts(fragment, wsrpRequest, env, buffer);
            buffer.append("</div>");
        }
        return buffer.toString();
    }

    private void addPrototypeOverrideScripts(Fragment fragment, WSRPRequestHelper wsrpRequest, WSRPEnvironment env, StringBuffer buffer) throws DashboardException {
        boolean addDebugJS;
        String webContentURL = env.getWebContent();
        boolean bl = addDebugJS = "controller".equals(env.getParameter("frag-debug")) || "true".equals(env.getProperty("controller.debug"));
        if (this.isThirdPartyPortal(wsrpRequest)) {
            buffer.append("<script type=\"text/javascript\">\n");
            buffer.append("var djConfig={scopeMap:[[\"dojo\",\"cpsdojo\"]]}\n");
            buffer.append("</script>");
        }
        buffer.append("<script type=\"text/javascript\">\n");
        buffer.append("if (window.fragments === undefined) {");
        buffer.append("window.portalAgent=\"");
        EncodingUtils.javascriptencode(wsrpRequest.getPortalAgent(), buffer);
        buffer.append("\";");
        buffer.append("window.resourceTemplate= new Object().href=\"wsrp_rewrite?wsrp-urlType=resource&wsrp-requiresRewrite=true&wsrp-url=_cpsresourceurl%3Acpsendmarker_/wsrp_rewrite\";\n");
        String messagelibUrl = env.getApplicationGatewayURI() + "/messages/messages/pfmessages?section=JS";
        String messageLibraryHref = this.getResourceURL(messagelibUrl, wsrpRequest, env);
        buffer.append("var wsrp_rewrite_obj = ");
        if (this.isRewritableResource(messagelibUrl, wsrpRequest, env)) {
            buffer.append("new Object().href=");
        }
        buffer.append("\"");
        EncodingUtils.javascriptencode(messageLibraryHref, buffer);
        buffer.append("\";");
        buffer.append(" document.write(\"<script language=\\\"javascript\\\" src=\\\"\"+wsrp_rewrite_obj+\"\\\"><\"+\"/script>\" );\n");
        Iterator it = fragment.getControllerJavascriptIterator();
        while (it.hasNext()) {
            String libraryHref = this.getResourceURL((String)it.next(), wsrpRequest, env);
            buffer.append("var wsrp_rewrite_obj = ");
            if (this.isRewritableResource(libraryHref, wsrpRequest, env)) {
                buffer.append("new Object().href=");
            }
            buffer.append("\"");
            EncodingUtils.javascriptencode(libraryHref, buffer);
            buffer.append("\";");
            buffer.append(" document.write(\"<script language=\\\"javascript\\\" src=\\\"\"+wsrp_rewrite_obj+\"\\\"><\"+\"/script>\" );\n");
        }
        if (addDebugJS) {
            buffer.append("if (navigator.userAgent.indexOf(\"Firefox\")== -1 && window.console === undefined) { ");
            buffer.append("var wsrp_rewrite_obj = new Object(); wsrp_rewrite_obj.href=\"");
            EncodingUtils.javascriptencode(env.getWebContent() + env.getProperty("controller.debug.IELite.file"), buffer);
            buffer.append("\";");
            buffer.append(" document.write(\"<script language=\\\"javascript\\\" src=\\\"\"+wsrp_rewrite_obj.href+\"\\\"><\"+\"/script>\" );}\n");
            buffer.append("var wsrp_rewrite_obj = new Object(); wsrp_rewrite_obj.href=\"");
            EncodingUtils.javascriptencode(env.getWebContent() + env.getProperty("controller.debug.file"), buffer);
            buffer.append("\";");
            buffer.append(" document.write(\"<script language=\\\"javascript\\\" src=\\\"\"+wsrp_rewrite_obj.href+\"\\\"><\"+\"/script>\" );\n");
        }
        buffer.append("}");
        buffer.append("</script>");
        buffer.append("<script type=\"text/javascript\">\n");
        if (addDebugJS) {
            buffer.append("window._F_Debug.enabled = true;");
            buffer.append("window._F_Debug.IELiteLevel = ").append(env.getProperty("controller.debug.IELite.level")).append(";");
            Map map = (Map)env.getProperty("controller.debug.objects");
            for (Map.Entry entry : map.entrySet()) {
                buffer.append("window._F_Debug.settings[\"").append(entry.getKey()).append("\"] = ").append(entry.getValue()).append(";");
            }
        }
        buffer.append("if (window._F_Config.gateway == null) {");
        buffer.append("window._F_Config.gateway=\"");
        EncodingUtils.javascriptencode(env.getGatewayURI(), buffer);
        buffer.append("\";");
        buffer.append("window._F_Config.productLocale=\"");
        EncodingUtils.javascriptencode(env.getProductLocale(), buffer);
        buffer.append("\";");
        buffer.append("window._F_Config.skin=\"");
        EncodingUtils.javascriptencode(env.getSkin(), buffer);
        buffer.append("\";");
        buffer.append("window._F_Config.webContent=\"");
        EncodingUtils.javascriptencode(env.getWebContent(), buffer);
        buffer.append("\";");
        buffer.append("window._F_Config.WSRPGateway=\"");
        EncodingUtils.javascriptencode(env.getValidationManager().staticSign(env.getGatewayOverride()), buffer);
        buffer.append("\";");
        if (env.getWebContentOverride() == null) {
            buffer.append("window._F_Config.WSRPWebContent=null;");
        } else {
            buffer.append("window._F_Config.WSRPWebContent=\"");
            EncodingUtils.javascriptencode(env.getValidationManager().staticSign(env.getWebContentOverride()), buffer);
            buffer.append("\";");
        }
        buffer.append("window._F_Config.application=\"");
        EncodingUtils.javascriptencode("/wsrp/fragments/resource", buffer);
        buffer.append("\";");
        buffer.append("window._F_Config.responsePattern=\"");
        EncodingUtils.javascriptencode((String)env.getProperty("portal.fragment.response.pattern"), buffer);
        buffer.append("\";");
        buffer.append("window._F_Config.cookieSecure=\"");
        EncodingUtils.javascriptencode((String)env.getProperty("cookieSecure"), buffer);
        buffer.append("\";");
        buffer.append('}');
        buffer.append("if (window._F_Config.help === undefined || window._F_Config.help == null) {");
        JSONObject configHelp = new JSONObject();
        configHelp.addMember("path", (String)env.getProperty("portal.help.path"));
        configHelp.addMember("langs", (String)env.getProperty("portal.help.supportedLangs"));
        configHelp.addMember("book", (String)env.getProperty("portal.help.defaultBook"));
        buffer.append("window._F_Config.help =");
        configHelp.write(buffer);
        buffer.append('}');
        buffer.append("</script>");
    }

    private void addJavaScriptAndCSS(Fragment fragment, WSRPRequestHelper wsrpRequest, WSRPEnvironment env, StringBuffer buffer) {
        if (wsrpRequest.isCallerFragmentServer()) {
            Iterator it = fragment.getLibrariesIterator();
            while (it.hasNext()) {
                String lib = this.getResourceURL((String)it.next(), wsrpRequest, env);
                buffer.append("<script type=\"text/javascript\" src=\"").append(lib).append("\"></script>");
            }
        } else {
            buffer.append("<script type=\"text/javascript\">\n");
            Iterator it = fragment.getLibrariesIterator();
            while (it.hasNext()) {
                String libraryHref = this.getResourceURL((String)it.next(), wsrpRequest, env);
                String suffix = "s" + String.valueOf(libraryHref.hashCode()).replace('-', '_');
                buffer.append("if ( window._F_libs['").append(suffix).append("'] === undefined){\n").append("window._F_libs['").append(suffix).append("'] = ");
                if (this.isRewritableResource(libraryHref, wsrpRequest, env)) {
                    buffer.append("new Object().href=");
                }
                buffer.append("\"");
                EncodingUtils.javascriptencode(libraryHref, buffer);
                buffer.append("\";\n");
                buffer.append("document.write(\"<script language=\\\"javascript\\\" src=\\\"\"+window._F_libs['").append(suffix).append("']+\"").append("\\\"><\"+\"/script>\" );\n}\n");
            }
            buffer.append("</script>");
        }
    }

    private void addFragmentInitScripts(Fragment fragment, WSRPRequestHelper wsrpRequest, WSRPEnvironment env, StringBuffer buffer) {
        String fragmentId = fragment.getFragmentId();
        buffer.append("<script type=\"text/javascript\">");
        Iterator it = fragment.getFragmentState().getSubFragmentStateIterator();
        while (it.hasNext()) {
            String validator;
            String state;
            String mode;
            PortletState.StateData stateData = (PortletState.StateData)it.next();
            String id = stateData.getId();
            if (stateData == null) continue;
            JSONObject inactiveFragment = new JSONObject();
            inactiveFragment.addMember("id", id);
            String windowState = stateData.getWindowState();
            if (windowState != null) {
                inactiveFragment.addMember("windowState", windowState);
            }
            if ((mode = stateData.getMode()) != null) {
                inactiveFragment.addMember("mode", mode);
            }
            if ((state = stateData.getState()) != null) {
                inactiveFragment.addMember("state", state);
            }
            if ((validator = stateData.getValidator()) != null && validator.length() > 0) {
                inactiveFragment.addObjectMember("validator");
                inactiveFragment.addMember("remote", stateData.getValidator());
                inactiveFragment.endObject();
            }
            buffer.append("window._F_inactiveFragments[\"");
            EncodingUtils.javascriptencode(id, buffer);
            buffer.append("\"] = ");
            inactiveFragment.write(buffer);
            buffer.append(';');
        }
        buffer.append("</script>");
        String markup = fragment.getMarkup();
        int index = markup.indexOf("var " + fragmentId);
        if (index != -1 && (index = markup.indexOf("</script>")) != -1) {
            buffer.append(markup.substring(0, index += "</script>".length()));
            this.appendFragmentInitScripts(fragment, wsrpRequest, buffer, env);
            buffer.append(markup.substring(index));
            return;
        }
        buffer.append(markup);
        this.appendFragmentInitScripts(fragment, wsrpRequest, buffer, env);
    }

    private void appendFragmentInitScripts(Fragment fragment, WSRPRequestHelper wsrpRequest, StringBuffer buffer, WSRPEnvironment env) {
        String fragmentId = fragment.getFragmentId();
        buffer.append("<script type=\"text/javascript\">");
        JSONObject baseFragmentProps = new JSONObject();
        baseFragmentProps.addScriptMember("WSRPActionUrlImpl", "wsrp_rewrite_actionUrlHolder");
        baseFragmentProps.addMember("WSRPRewritePrefixImpl", "wsrp_rewrite_");
        baseFragmentProps.addMember("instanceKeyImpl", wsrpRequest.getPortletSessionID());
        String windowState = WSRPParamUtils.WSRPWindowStateFromFragment(fragment.getWindowState());
        String mode = WSRPParamUtils.WSRPModeFromFragment(fragment.getMode());
        buffer.append("var wsrp_rewrite_actionUrlHolder= new Object();");
        buffer.append("wsrp_rewrite_actionUrlHolder['_current']= (new Object().href = \"wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-mode=");
        buffer.append(mode);
        buffer.append("&wsrp-windowState=");
        buffer.append(windowState);
        buffer.append("/wsrp_rewrite\");");
        buffer.append("wsrp_rewrite_actionUrlHolder['view']= (new Object().href = \"wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-mode=wsrp:view&wsrp-windowState=");
        buffer.append(windowState);
        buffer.append("/wsrp_rewrite\");");
        buffer.append("wsrp_rewrite_actionUrlHolder['edit']= (new Object().href = \"wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-mode=wsrp:edit&wsrp-windowState=");
        buffer.append(windowState);
        buffer.append("/wsrp_rewrite\");");
        buffer.append(fragmentId).append(".initializeBaseFragment(");
        baseFragmentProps.write(buffer);
        buffer.append(");");
        buffer.append(fragment.getFragmentId() + ".addEventListener(\"page.load\", new function(){");
        Iterator it = fragment.getStylesIterator();
        while (it.hasNext()) {
            String linkHref = (String)it.next();
            String link = this.getResourceURL(linkHref, wsrpRequest, env);
            buffer.append("_F_Resource.loadResource(\"LINK\",");
            if (this.isRewritableResource(linkHref, wsrpRequest, env)) {
                buffer.append("new Object().href =");
            }
            buffer.append("\"").append(link).append("\");\n");
        }
        buffer.append("});");
        JSONObject transientUpdates = fragment.getTransientUpdates();
        if (transientUpdates != null) {
            buffer.append("function ").append(fragmentId).append("_transientsUpdate(){").append(fragmentId).append(".transientUpdateList(");
            transientUpdates.write(buffer);
            buffer.append(".array, true);}");
            buffer.append(fragment.getParentId()).append(".addEventListener('page.load',").append(fragmentId).append("_transientsUpdate ,false)");
        }
        buffer.append("</script>");
    }

    private String getResourceURL(String url, WSRPRequestHelper wsrpRequestHelper, WSRPEnvironment env) {
        if (this.isRewritableResource(url, wsrpRequestHelper, env)) {
            return "wsrp_rewrite?wsrp-urlType=resource&wsrp-url=" + EncodingUtils.urlencode(url, "UTF-8", false) + "/wsrp_rewrite";
        }
        return url;
    }

    private boolean isRewritableResource(String url, WSRPRequestHelper wsrpRequestHelper, WSRPEnvironment env) {
        return this.isThirdPartyPortal(wsrpRequestHelper) && url.startsWith(env.getGatewayURI());
    }

    private boolean isThirdPartyPortal(WSRPRequestHelper wsrpRequestHelper) {
        return !wsrpRequestHelper.isCallerFragmentServer() && !"cognos".equals(wsrpRequestHelper.getPortalAgent());
    }
}

