/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.wsrp;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.service.WSRPEnvironment;
import com.cognos.portal.fragment.wsrp.ApplicationState;
import com.cognos.portal.fragment.wsrp.BridgeException;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.utils.AddRuntimeState;
import com.cognos.portal.utils.LocalizableRuntimeException;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.stream.PathIterator;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.xts.XTSException;
import com.cognos.xts.util.TDSStorageHelper;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class PortletState
implements IXMLHandler {
    private static final String[] STATE_PATH = new String[]{"/queryResponse/queryResult/item/state/value"};
    private static final String[] STATE_DELETE_COUNT_PATH = new String[]{"/deleteResponse/count"};
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        @Override
        public void remove() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }
    };
    private List subFragmentStates;
    private StateData lastAccessedState;
    private String sessionId;
    private ApplicationState applicationState;

    public PortletState(String id) {
        this.sessionId = id;
    }

    private StateData getStateData(String id) {
        if (this.lastAccessedState != null && this.lastAccessedState.id.equals(id)) {
            return this.lastAccessedState;
        }
        if (this.subFragmentStates == null) {
            this.subFragmentStates = new ArrayList();
        }
        StateData stateData = null;
        int size = this.subFragmentStates.size();
        for (int i = 0; i < size; ++i) {
            stateData = (StateData)this.subFragmentStates.get(i);
            if (!stateData.getId().equals(id)) continue;
            this.lastAccessedState = stateData;
            return this.lastAccessedState;
        }
        stateData = new StateData();
        stateData.setId(id);
        this.subFragmentStates.add(stateData);
        this.lastAccessedState = stateData;
        return this.lastAccessedState;
    }

    public Parameters getApplicationScopeTransients() {
        return this.applicationState != null ? this.applicationState.getTransient() : null;
    }

    public Iterator getSubFragmentStateIterator() {
        if (this.subFragmentStates != null) {
            return this.subFragmentStates.iterator();
        }
        return EMPTY_ITERATOR;
    }

    public void setMode(String id, String mode) {
        StateData data = this.getStateData(id);
        data.setMode(mode);
    }

    public void setWindowState(String id, String windowState) {
        StateData data = this.getStateData(id);
        data.setWindowState(windowState);
    }

    public void setState(String id, String state) {
        StateData data = this.getStateData(id);
        data.setState(state);
    }

    public void setValidator(String id, String validator) {
        StateData data = this.getStateData(id);
        data.setValidator(validator);
    }

    @Override
    public void handle(XMLStreamReader reader) throws XMLStreamException {
        this.subFragmentStates = new ArrayList();
        this.lastAccessedState = null;
        PathIterator it = new PathIterator(reader, STATE_PATH);
        while (it.moveToNextPath() != -1) {
            String stateXml = it.getElementText();
            if (stateXml.length() <= 0) continue;
            XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(new StringReader(stateXml));
            this.readState(xsr);
        }
    }

    private void readState(XMLStreamReader xsr) throws XMLStreamException {
        while (xsr.hasNext()) {
            int event = xsr.next();
            if (event != 1) continue;
            String localName = xsr.getLocalName();
            if ("data".equals(localName)) {
                StateData data = new StateData();
                data.read(xsr);
                this.subFragmentStates.add(data);
                continue;
            }
            if (!"appState".equals(localName)) continue;
            this.applicationState = new ApplicationState();
            this.applicationState.read(xsr);
        }
    }

    private void loadStateFromDataStorage(List<TDSStorageHelper.NameValue> vList) throws BridgeException {
        try {
            for (int i = 0; i < vList.size(); ++i) {
                TDSStorageHelper.NameValue nv = vList.get(i);
                if (nv.value == null) continue;
                XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(new StringReader(nv.value));
                this.readState(xsr);
            }
        }
        catch (XMLStreamException e) {
            throw new BridgeException("", e);
        }
    }

    public void loadFromDataStorage(WSRPEnvironment env, ServiceLogger logger) throws BridgeException {
        this.subFragmentStates = new ArrayList();
        this.lastAccessedState = null;
        try {
            List vList1 = TDSStorageHelper.instance.getMappedValueList(env.getPassportID(), "portlets", this.sessionId, "starts-with");
            this.loadStateFromDataStorage(vList1);
            List vList2 = TDSStorageHelper.instance.getMappedValueList(env.getPassportID(), "portlets", "CPS_WSRP_BRIDGE_APP_STATE", "starts-with");
            this.loadStateFromDataStorage(vList2);
        }
        catch (XTSException e) {
            throw new BridgeException("TDS error", e);
        }
    }

    public void saveToDataStorage(WSRPEnvironment env, ServiceLogger logger) throws BridgeException {
        boolean isModified = false;
        AddRuntimeState addRuntimeState = new AddRuntimeState();
        if (this.subFragmentStates != null) {
            for (StateData data : this.subFragmentStates) {
                if (!data.isModified()) continue;
                addRuntimeState.addState(this.sessionId + data.getId().hashCode(), data.toString());
                if (isModified) continue;
                isModified = true;
            }
        }
        if (isModified) {
            try {
                addRuntimeState.saveToDataStorage(env.getPassportID());
            }
            catch (XTSException e) {
                throw new BridgeException("TDS error", e);
            }
        }
    }

    public int destroy(String id, WSRPEnvironment env, ServiceLogger logger) throws BridgeException {
        try {
            TDSStorageHelper.instance.removeMappedValue(env.getPassportID(), "portlets", this.sessionId + id.hashCode());
            return 0;
        }
        catch (XTSException e) {
            throw new BridgeException("TDS error", e);
        }
    }

    public class StateData {
        private String id;
        private boolean isStateModified;
        private String mode;
        private String windowState;
        private String state;
        private String validator;

        public boolean isModified() {
            return this.isStateModified;
        }

        public String getMode() {
            return this.mode;
        }

        public String getId() {
            return this.id;
        }

        public String getWindowState() {
            return this.windowState;
        }

        public String getState() {
            return this.state;
        }

        public String getValidator() {
            return this.validator;
        }

        private void setId(String id) {
            this.id = id;
        }

        private void setMode(String mode) {
            if (!this.isStateModified) {
                this.isStateModified = this.mode == null || !this.mode.equals(mode);
            }
            this.mode = mode;
        }

        private void setWindowState(String windowState) {
            if (!this.isStateModified) {
                this.isStateModified = this.windowState == null || !this.windowState.equals(windowState);
            }
            this.windowState = windowState;
        }

        private void setValidator(String validator) {
            if (!this.isStateModified) {
                this.isStateModified = this.validator == null || !this.validator.equals(validator);
            }
            this.validator = validator;
        }

        private void setState(String state) {
            if (!this.isStateModified) {
                this.isStateModified = this.state == null || !this.state.equals(state);
            }
            this.state = state;
        }

        private void read(XMLStreamReader xsr) throws XMLStreamException {
            this.id = xsr.getAttributeValue("", "id");
            int level = 0;
            while (xsr.hasNext()) {
                int event = xsr.next();
                switch (event) {
                    case 1: {
                        String localName = xsr.getLocalName();
                        if ("state".equals(localName)) {
                            this.state = xsr.getElementText();
                            break;
                        }
                        if ("validator".equals(localName)) {
                            this.validator = xsr.getElementText();
                            break;
                        }
                        if ("windowState".equals(localName)) {
                            this.windowState = xsr.getElementText();
                            break;
                        }
                        if ("mode".equals(localName)) {
                            this.mode = xsr.getElementText();
                            break;
                        }
                        ++level;
                        break;
                    }
                    case 2: {
                        if (--level >= 0) break;
                        return;
                    }
                }
            }
        }

        private void toXML(XMLStreamWriter xsw) throws XMLStreamException {
            xsw.writeStartElement("data");
            if (this.id != null) {
                xsw.writeAttribute("id", this.id);
            }
            if (this.state != null) {
                xsw.writeStartElement("state");
                xsw.writeCharacters(this.state);
                xsw.writeEndElement();
            }
            if (this.validator != null) {
                xsw.writeStartElement("validator");
                xsw.writeCharacters(this.validator);
                xsw.writeEndElement();
            }
            if (this.windowState != null) {
                xsw.writeStartElement("windowState");
                xsw.writeCharacters(this.windowState);
                xsw.writeEndElement();
            }
            if (this.mode != null) {
                xsw.writeStartElement("mode");
                xsw.writeCharacters(this.mode);
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
        }

        public String toString() {
            try {
                StringWriter writer = new StringWriter();
                XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(writer);
                this.toXML(xsw);
                xsw.flush();
                xsw.close();
                return writer.getBuffer().toString();
            }
            catch (XMLStreamException e) {
                throw new LocalizableRuntimeException("pf.fragment.bridge.xml.error", e);
            }
        }
    }
}

