/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.wsrp;

import com.cognos.portal.fragment.server.document.DashboardDocument;
import com.cognos.portal.fragment.wsrp.BridgeException;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.RandomGUID;
import com.cognos.portal.utils.UnmodifiableParameters;
import com.cognos.portal.utils.WSRPParamUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

class WSRPRequestHelper {
    private static final Parameters EMPTY_PARAMETERS = new UnmodifiableParameters(new Parameters());
    private Parameters interactions;
    private String portletHandle;
    private String portletState;
    private String portletInstanceKey;
    private String portletSessionID;
    private String registrationHandle;
    private String namespacePrefix;
    private List locales;
    private String mode;
    private String windowState;
    private String userAgent;
    private String webContentURL;
    private String gatewayURL;
    private String navigationalState;
    private String portalAgent;
    private List events;

    public WSRPRequestHelper(Element wsrpOp) throws BridgeException {
        this.initialize(wsrpOp);
    }

    private void initialize(Element wsrpOp) throws BridgeException {
        List eventExtensions;
        wsrpOp.addNamespace("wsrp", "urn:oasis:names:tc:wsrp:v1:types");
        wsrpOp.addNamespace("cps", "http://developer.cognos.com/schemas/cps/asm/objects/1/");
        wsrpOp.addNamespace("cpsext", "http://developer.cognos.com/schemas/cps/wsrp/extensions/1/");
        this.portletHandle = wsrpOp.valueOf("./wsrp:portletContext/wsrp:portletHandle");
        this.readPortletState(wsrpOp);
        this.portletInstanceKey = wsrpOp.valueOf("./wsrp:runtimeContext/wsrp:portletInstanceKey");
        this.portletSessionID = wsrpOp.valueOf("./wsrp:runtimeContext/wsrp:sessionID");
        this.namespacePrefix = wsrpOp.valueOf("./wsrp:runtimeContext/wsrp:namespacePrefix");
        this.locales = wsrpOp.selectNodes("./wsrp:markupParams/wsrp:locales");
        this.mode = WSRPParamUtils.fragmentModeFromWSRP(wsrpOp.valueOf("./wsrp:markupParams/wsrp:mode"));
        this.windowState = WSRPParamUtils.fragmentWindowStateFromWSRP(wsrpOp.valueOf("./wsrp:markupParams/wsrp:windowState"));
        this.userAgent = wsrpOp.valueOf("./wsrp:markupParams/wsrp:clientData/wsrp:userAgent");
        Element webContentParam = (Element)wsrpOp.selectSingleNode("./wsrp:markupParams/wsrp:extensions/cps:portalContext/cps:param[@name='webContentURL']");
        this.webContentURL = webContentParam != null ? webContentParam.getTextTrim() : null;
        this.gatewayURL = wsrpOp.valueOf("./wsrp:markupParams/wsrp:extensions/cps:portalContext/cps:param[@name='gatewayURL']");
        this.portalAgent = wsrpOp.valueOf("./wsrp:markupParams/wsrp:extensions/cps:portalContext/cps:portalAgent");
        this.navigationalState = wsrpOp.valueOf("./wsrp:markupParams/wsrp:navigationalState");
        this.registrationHandle = wsrpOp.valueOf("./wsrp:registrationContext/wsrp:registrationHandle");
        List formParams = wsrpOp.selectNodes("./wsrp:interactionParams/wsrp:formParameters");
        Iterator iterator = formParams.iterator();
        if (iterator.hasNext()) {
            this.interactions = new Parameters();
            while (iterator.hasNext()) {
                Element e = (Element)iterator.next();
                this.interactions.add(e.valueOf("@name"), e.valueOf("./wsrp:value"));
            }
        }
        if ((iterator = (eventExtensions = wsrpOp.selectNodes("./wsrp:markupParams/wsrp:extensions/cpsext:events/cpsext:event")).iterator()).hasNext()) {
            this.events = new ArrayList();
            while (iterator.hasNext()) {
                Element e = (Element)iterator.next();
                this.events.add(e.getText());
            }
        }
    }

    private void readPortletState(Element wsrpOp) throws BridgeException {
        this.portletState = wsrpOp.valueOf("./wsrp:portletContext/wsrp:portletState");
        if (this.portletState != null && this.portletState.length() > 0) {
            Parameters customs = DashboardDocument.decodeCustoms(this.portletState);
            if (customs != null) {
                List extensionExternalRefs = wsrpOp.selectNodes("./wsrp:portletContext/wsrp:extensions/cpsext:state/cpsext:externalRef");
                customs = DashboardDocument.decodeCustoms(this.portletState);
                if (extensionExternalRefs != null && extensionExternalRefs.size() > 0) {
                    for (Element externalRef : extensionExternalRefs) {
                        String name = externalRef.attributeValue("name");
                        if (name == null) continue;
                        customs.setValue(name, externalRef.getTextTrim());
                    }
                    this.portletState = DashboardDocument.encodeCustoms(customs);
                }
            } else {
                customs = new Parameters();
                customs.add("wsrp_portlet_context", this.portletState);
                customs.add("wsrp_portlet_handle", this.portletHandle);
                Element externalRefElem = (Element)wsrpOp.selectSingleNode("./wsrp:portletContext/wsrp:extensions/cpsext:state");
                if (externalRefElem != null) {
                    try {
                        customs.add("wsrp_portlet_state_extension.xml", EncodingUtils.base64encode(externalRefElem.asXML().getBytes("UTF-8"), true));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new BridgeException("pf.fragment.bridge.executionfailed", e);
                    }
                }
                this.portletState = DashboardDocument.encodeCustoms(customs);
            }
        }
    }

    public String getPortletState() {
        return this.portletState;
    }

    public Parameters getWSRPInteractionParams() {
        return this.interactions != null ? this.interactions : EMPTY_PARAMETERS;
    }

    public List getEventsList() {
        return this.events;
    }

    public String getGatewayURL() {
        return this.gatewayURL;
    }

    public List getLocales() {
        return this.locales;
    }

    public String getMode() {
        return this.mode;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public String getNavigationaState() {
        return this.navigationalState;
    }

    public String getPortletHandle() {
        return this.portletHandle;
    }

    public String getPortletInstanceKey() {
        return this.portletInstanceKey;
    }

    public String getRegistrationHandle() {
        return this.registrationHandle;
    }

    public String getPortletSessionID() {
        if (this.portletSessionID == null || "".equals(this.portletSessionID)) {
            this.portletSessionID = new RandomGUID(true).toString();
        }
        return this.portletSessionID;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getWebContentURL() {
        return this.webContentURL;
    }

    public String getWindowState() {
        return this.windowState;
    }

    public String getPortalAgent() {
        return this.portalAgent;
    }

    public boolean isCallerFragmentServer() {
        return "cognosFragmentServer".equals(this.getPortalAgent());
    }
}

