/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.schemas;

import com.cognos.portal.xml.stream.IXMLSerializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class AnyAttributes
implements IXMLSerializable {
    private List attribs;

    public AnyAttributes() {
        this.init();
    }

    public void init() {
        this.attribs = new ArrayList();
    }

    @Override
    public void read(XMLStreamReader xsr) throws XMLStreamException {
        this.read(xsr, null, false, true);
    }

    public void read(XMLStreamReader xsr, String ns, boolean match, boolean unqualified) throws XMLStreamException {
        int c = xsr.getAttributeCount();
        for (int i = 0; i < c; ++i) {
            QName name = xsr.getAttributeName(i);
            String value = xsr.getAttributeValue(i);
            if (ns == null) {
                this.attribs.add(new Attribute(name, value));
                continue;
            }
            String attrNS = name.getNamespaceURI();
            if (match) {
                if (!ns.equals(attrNS) && (!"".equals(attrNS) || !unqualified)) continue;
                this.attribs.add(new Attribute(name, value));
                continue;
            }
            if (ns.equals(attrNS) || "".equals(attrNS) && unqualified) continue;
            this.attribs.add(new Attribute(name, value));
        }
    }

    @Override
    public void write(XMLStreamWriter xsw) throws XMLStreamException {
        for (Attribute attr : this.attribs) {
            String prefix = attr.name.getPrefix();
            String namespaceURI = attr.name.getNamespaceURI();
            if (!namespaceURI.equals(xsw.getNamespaceContext().getNamespaceURI(prefix))) {
                xsw.writeNamespace(prefix, namespaceURI);
            }
            xsw.writeAttribute(prefix, namespaceURI, attr.name.getLocalPart(), attr.value);
        }
    }

    private class Attribute {
        QName name;
        String value;

        public Attribute(QName name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

