/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.schemas.atom;

import com.cognos.portal.schemas.AnyElement;
import com.cognos.portal.schemas.atom.Date;
import com.cognos.portal.schemas.atom.Feed;
import com.cognos.portal.schemas.atom.Id;
import com.cognos.portal.schemas.atom.Link;
import com.cognos.portal.schemas.atom.Person;
import com.cognos.portal.schemas.atom.Text;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import javax.xml.stream.XMLStreamException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class PagerFeed {
    ArrayList<String> columns;
    int from;
    int to;
    Link firstPageURL = new Link();
    Link lastPageURL = new Link();
    Link nextPageURL = new Link();
    Link previousPageURL = new Link();
    Link gotoURL = new Link();
    Feed feed;

    public PagerFeed() {
        this.nextPageURL.setRel("nextPage");
        this.firstPageURL.setRel("firstPage");
        this.lastPageURL.setRel("lastPage");
        this.previousPageURL.setRel("previousPage");
        this.gotoURL.setRel("goto");
        this.from = 0;
        this.to = 0;
        this.columns = new ArrayList();
    }

    public PagerFeed(int[] fromTo, String[] pagerURLs, ArrayList<String> columns) {
        this();
        if (pagerURLs.length == 5) {
            this.firstPageURL.setHref(pagerURLs[0]);
            this.lastPageURL.setHref(pagerURLs[1]);
            this.nextPageURL.setHref(pagerURLs[2]);
            this.previousPageURL.setHref(pagerURLs[3]);
            this.gotoURL.setHref(pagerURLs[4]);
        }
        if (fromTo.length == 2) {
            this.from = fromTo[0];
            this.to = fromTo[1];
        }
        this.columns = columns;
    }

    public PagerFeed(int[] fromTo, String[] pagerURLs, ArrayList<String> columns, Feed aFeed) {
        this(fromTo, pagerURLs, columns);
        this.feed = aFeed;
    }

    public void addColumn(String name) {
        this.columns.add(name);
    }

    protected String getPagerXML() {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(new QName("pager", new Namespace("ps", "http://www.cognos.com/presentationservices")));
        root.addAttribute("rowSelect", "single");
        root.addAttribute("checkbox", "true");
        Element headers = root.addElement("pagerHeaders");
        for (int index = 0; index < this.columns.size(); ++index) {
            Element header = headers.addElement("header");
            header.setText(this.columns.get(index));
            header.addAttribute("index", Integer.toString(index));
        }
        return document.asXML();
    }

    public Feed getFeed() {
        if (this.feed == null) {
            this.feed = new Feed();
        }
        Text title = new Text();
        title.setValue("Pager Feed");
        this.feed.setTitle(title);
        Person anAuthor = new Person();
        anAuthor.setName("COGNOS 10");
        Date aDate = new Date();
        aDate.setValue(Calendar.getInstance());
        this.feed.setUpdated(aDate);
        this.feed.addAuthor(anAuthor);
        Id anId = new Id();
        anId.setValue("something");
        this.feed.setId(anId);
        this.feed.addLink(this.nextPageURL);
        this.feed.addLink(this.firstPageURL);
        this.feed.addLink(this.lastPageURL);
        this.feed.addLink(this.previousPageURL);
        this.feed.addLink(this.gotoURL);
        AnyElement anAny = new AnyElement();
        try {
            anAny.read(XMLStreamFactory.createXMLStreamReader(new StringReader(this.getPagerXML())));
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        this.feed.addValue14(anAny);
        return this.feed;
    }
}

