/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.service;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.stax.stream.PathIterator;
import com.cognos.pogo.util.StringUtils;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.SOAPFaultException;
import com.cognos.portal.service.IInputStreamRetriever;
import com.cognos.portal.service.InputStreamRetriever;
import com.cognos.portal.skin.SkinCache;
import com.cognos.portal.skin.tools.Skeleton;
import com.cognos.portal.skin.tools.SkeletonMap;
import com.cognos.portal.skin.tools.SkinGenerator;
import com.cognos.portal.skin.upgrade.SkinUpgradeException;
import com.cognos.portal.skin.upgrade.UpgradeManager;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionFactory;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.soap.impl.BusConnectionImpl;
import com.cognos.portal.soap.impl.SOAPConnectionFactoryImpl;
import com.cognos.portal.soap.impl.TrustedSOAPConnectionFactoryImpl;
import com.cognos.portal.soap.impl.bus.cm.Query;
import com.cognos.portal.utils.ContextImpl;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.JSONObject;
import com.cognos.portal.utils.ReadWriteLock;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.internet.InternetHeaders;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CssService
extends BasicHandler {
    public static final double CURRENT_SKIN_VERSION = 2.1;
    private static final String CSS_LOCATION_V2 = "/WEB-INF/css/blueprint/";
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(CssService.class.getName());
    private final ServiceLogger serviceLogger;
    private PogoEngine engine;
    private IInputStreamRetriever retriever;
    private IContext context;
    private UpgradeManager upgradeManager;
    private final ReadWriteLock mutex = new ReadWriteLock();

    public CssService() {
        this(category);
    }

    public CssService(Logger logger) {
        super(logger);
        this.serviceLogger = new ServiceLoggerImpl(CssService.class);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.engine = engine;
        this.retriever = new InputStreamRetriever(engine);
        this.upgradeManager = new UpgradeManager(this.retriever);
        UpgradeManager.registerDefaultUpgrade(this.upgradeManager);
        super.compose_impl(engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration configuration) {
        block9: {
            try {
                this.mutex.acquireWriteLock();
                try {
                    this.context = new ContextImpl();
                    ICCLConfiguration cclConfiguration = CCLConfigurationFactory.getInstance();
                    this.context.setProperty("dispatcherPath", new URL(cclConfiguration.getValue("internalDispatcher", true)).getFile());
                    this.context.setProperty("internalDispatcher", BusConnectionImpl.BUS_DISPATCHER);
                    this.context.setProperty("popoEngine", this.engine);
                    this.context.setProperty("cmPath", new URL(cclConfiguration.getValue("contentManager", true)).getFile());
                    this.context.setProperty("contentManager", BusConnectionImpl.BUS_CM);
                    this.context.setProperty("SoapConnectionFactory", new SOAPConnectionFactoryImpl(this.context));
                    this.context.setProperty("trustedSoapConnectionFactory", new TrustedSOAPConnectionFactoryImpl(this.context, "CPS"));
                    this.context.setProperty("consumerTrustedSoapConnectionFactory", new TrustedSOAPConnectionFactoryImpl(this.context, "CPSConsumer"));
                    Collection paramNames = cclConfiguration.getParameterNames();
                    for (String name : paramNames) {
                        if (!name.startsWith("portal.")) continue;
                        this.context.setProperty(name, cclConfiguration.getValue(name, true));
                    }
                    SkinCache.getInstance().init(this.context, this.serviceLogger);
                }
                catch (Throwable e) {
                    if (this.serviceLogger != null && this.serviceLogger.isErrorEnabled()) {
                        this.serviceLogger.error("could not configure the service", e);
                    }
                }
                finally {
                    this.mutex.releaseWriteLock();
                }
            }
            catch (InterruptedException e) {
                if (this.serviceLogger == null || !this.serviceLogger.isErrorEnabled()) break block9;
                this.serviceLogger.error("an exception was encountered when attempting acquire write lock to configure the dashboard service", e);
            }
        }
    }

    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        try {
            this.mutex.acquireReadLock();
            try {
                String statusMessage;
                String statusCode;
                String contentType;
                InputStream result;
                ArrayList<String> additionalHeaders;
                block32: {
                    BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
                    String skin = this.getRequestedValue("skin", envelope);
                    if (skin == null) {
                        skin = "corporate";
                    }
                    String skeleton = this.getRequestedValue("css", envelope);
                    String method = this.getRequestedValue("method", envelope);
                    String json = this.getRequestedValue("json", envelope);
                    String clearSkinCache = this.getRequestedValue("clearSkinCache", envelope);
                    String upgradeSkin = this.getRequestedValue("upgradeSkin", envelope);
                    String skeletonBase = this.getRequestedValue("skeletonBase", envelope);
                    String skinApp = this.getRequestedValue("skinApp", envelope);
                    String userAgent = envelope.getEnvironmentValue("HTTP_USER_AGENT");
                    additionalHeaders = new ArrayList<String>();
                    result = null;
                    contentType = null;
                    SkinInfoRequest skinInfoRequest = new SkinInfoRequest(skin, this.upgradeManager, envelope, this.context, this.serviceLogger);
                    skinInfoRequest.retrieveInfo();
                    SkinInfo skinInfo = null;
                    if (skinInfoRequest.skinInfoList.size() > 0) {
                        skinInfo = skinInfoRequest.skinInfoList.get(0);
                    }
                    statusCode = null;
                    statusMessage = null;
                    if (upgradeSkin != null) {
                        contentType = "application/json;charset=UTF-8";
                        String upgradedSpec = this.upgradeManager.upgrade(upgradeSkin, 2.1);
                        JSONObject skinJSON = new JSONObject();
                        if (upgradedSpec != null) {
                            skinJSON.addMember("upgradedSpec", upgradedSpec);
                            skinJSON.addMember("isUpgraded", true);
                        } else {
                            skinJSON.addMember("isUpgraded", false);
                        }
                        StringBuffer jsonResult = new StringBuffer();
                        skinJSON.write(jsonResult);
                        result = new ByteArrayInputStream(jsonResult.toString().getBytes("UTF-8"));
                    } else if (clearSkinCache != null && clearSkinCache.length() > 0) {
                        SkinCache.getInstance().resetSkinCache(clearSkinCache);
                        contentType = "application/json;charset=UTF-8";
                        result = new ByteArrayInputStream("{}".getBytes());
                    } else if ("download".equals(method) && skinInfoRequest.canWriteStyles && skinInfo != null) {
                        result = this.generateZipFile(skinInfo, envelope, mc, skeletonBase);
                        if (result != null) {
                            contentType = "application/zip";
                            String fileName = userAgent != null && userAgent.contains("MSIE") ? EncodingUtils.urlencode(skin, "UTF-8", false) : skin;
                            additionalHeaders.add("Content-disposition: attachment; filename=\"" + fileName + ".zip\"");
                        }
                    } else if ("getSkeletonMap".equals(method)) {
                        contentType = "text/javascript;charset=UTF-8";
                        result = this.writeCSS(skinInfo, skeleton, false, envelope, mc, this.getWebContent(envelope));
                    } else if (skeleton != null) {
                        contentType = "text/css;charset=UTF-8";
                        result = this.writeCSS(skinInfo, skeleton, true, envelope, mc, this.getWebContent(envelope));
                    } else if (skin != null) {
                        boolean bJSON = json != null && !json.equalsIgnoreCase("false");
                        contentType = bJSON ? "application/json;charset=UTF-8" : "text/xml;charset=UTF-8";
                        try {
                            if (bJSON) {
                                if (skinInfoRequest.errorCode != null || skinInfoRequest.errorMessage != null) {
                                    statusCode = "500";
                                    statusMessage = "Internal Server Error";
                                    result = this.getJSONError(skinInfoRequest);
                                } else {
                                    result = skin.length() == 0 ? this.getSkinListJSONStream(skinInfoRequest, skinApp) : this.getSkinJSONStream(skinInfoRequest);
                                }
                            } else {
                                result = this.getSkinXMLStream(skinInfo);
                            }
                        }
                        catch (IOException e) {
                            if (!this.serviceLogger.isErrorEnabled()) break block32;
                            this.serviceLogger.error("Failed to get resource, path=/skins/" + skin + ".xml", e);
                        }
                    }
                }
                if (result != null) {
                    if (statusCode == null) {
                        statusCode = "200";
                    }
                    if (statusMessage == null) {
                        statusMessage = "OK";
                    }
                    this.createSuccessResponse(mc, contentType, additionalHeaders, result, statusCode, statusMessage);
                } else {
                    this.createNotFoundResponse(mc);
                }
            }
            finally {
                this.mutex.releaseReadLock();
            }
        }
        catch (Exception e) {
            if (this.serviceLogger != null && this.serviceLogger.isErrorEnabled()) {
                this.serviceLogger.error("an exception was encountered when attempting acquire read lock to handle request", e);
            }
            throw new PogoException(e.getMessage());
        }
    }

    private InputStream generateZipFile(SkinInfo skinInfo, BIBusEnvelope envelope, MessageContext mc, String skeletonBase) {
        InputStream result;
        block4: {
            result = null;
            try {
                SharedByteArrayOutputStream out = new SharedByteArrayOutputStream(20480);
                ZipOutputStream zos = new ZipOutputStream(out);
                String location = CSS_LOCATION_V2;
                Set<String> appList = this.getResourcePaths(location);
                if (appList != null) {
                    Iterator<String> iterator = appList.iterator();
                    while (iterator.hasNext()) {
                        Set<String> skeletons;
                        String string;
                        String appPath = string = iterator.next();
                        int length = location.length();
                        if (length >= appPath.lastIndexOf("/")) continue;
                        String app = appPath.substring(length, appPath.lastIndexOf("/"));
                        if (skeletonBase != null && !skeletonBase.equals(app) || (skeletons = this.getResourcePaths(appPath)) == null) continue;
                        this.addCssFilesToZip(skinInfo, appPath, app, skeletons, envelope, mc, zos, 1);
                    }
                }
                zos.close();
                result = out.toStream();
            }
            catch (IOException e) {
                if (!this.serviceLogger.isErrorEnabled()) break block4;
                this.serviceLogger.error("Failed to create CSS zip file", e);
            }
        }
        return result;
    }

    private void addCssFilesToZip(SkinInfo skinInfo, String appPath, String app, Set<String> skeletons, BIBusEnvelope envelope, MessageContext mc, ZipOutputStream zos, int locationDepth) {
        block4: {
            try {
                for (String skelPath : skeletons) {
                    Set<String> children = this.getResourcePaths(skelPath);
                    if (children != null && children.size() > 0) {
                        this.addCssFilesToZip(skinInfo, appPath, app, children, envelope, mc, zos, locationDepth + 1);
                        continue;
                    }
                    this.addFileToZip(skinInfo, appPath, app, envelope, mc, zos, skelPath, locationDepth);
                }
            }
            catch (IOException e) {
                if (!this.serviceLogger.isErrorEnabled()) break block4;
                this.serviceLogger.error("Failed to create temporary CSS files", e);
            }
        }
    }

    private void addFileToZip(SkinInfo skinInfo, String appPath, String app, BIBusEnvelope envelope, MessageContext mc, ZipOutputStream zos, String skelPath, int locationDepth) throws IOException {
        String skeleton = skelPath.substring(appPath.length(), skelPath.lastIndexOf(".xml"));
        InputStream inputStream = this.writeCSS(skinInfo, app + "/" + skeleton, true, envelope, mc, this.calculateWebContent(locationDepth));
        ZipEntry entry = new ZipEntry(skinInfo.resourceLocation + File.separator + app + File.separator + skeleton + ".css");
        zos.putNextEntry(entry);
        byte[] buf = new byte[2156];
        int bytesIn = 0;
        while ((bytesIn = inputStream.read(buf)) != -1) {
            zos.write(buf, 0, bytesIn);
        }
        inputStream.close();
        zos.closeEntry();
    }

    private InputStream getSkinXMLStreamFromFile(String skin) throws IOException {
        return this.retriever.getInputStreamFromResource("/themes/" + skin + ".xml");
    }

    private InputStream getSkinXMLStream(SkinInfo skinInfo) throws IOException {
        InputStream result = this.getSkinXMLStreamFromFile(skinInfo.resourceLocation);
        if (result == null && skinInfo.specification != null && skinInfo.specification.length() > 0) {
            result = new ByteArrayInputStream(skinInfo.specification.getBytes());
        }
        return result;
    }

    protected InputStream getJSONError(SkinInfoRequest skinInfoRequest) throws IOException {
        JSONObject skinJSON = new JSONObject();
        skinJSON.addObjectMember("error");
        if (skinInfoRequest.errorCode != null) {
            skinJSON.addMember("code", skinInfoRequest.errorCode);
        }
        if (skinInfoRequest.errorMessage != null) {
            skinJSON.addMember("message", skinInfoRequest.errorMessage);
        }
        skinJSON.endObject();
        StringBuffer json = new StringBuffer();
        skinJSON.write(json);
        ByteArrayInputStream result = new ByteArrayInputStream(json.toString().getBytes("UTF-8"));
        return result;
    }

    protected InputStream getSkinJSONStream(SkinInfoRequest skinInfoRequest) throws IOException {
        SkinInfo skinInfo;
        JSONObject skinJSON = new JSONObject();
        if (skinInfoRequest.skinInfoList.size() > 0) {
            skinInfo = skinInfoRequest.skinInfoList.get(0);
        } else {
            skinInfo = new SkinInfo();
            skinInfo.skinName = skinInfoRequest.skinName;
            skinInfo.resourceLocation = skinInfoRequest.skinName;
        }
        this.addSkinInfoJson(skinInfo, skinJSON, true, false);
        StringBuffer json = new StringBuffer();
        skinJSON.write(json);
        ByteArrayInputStream result = new ByteArrayInputStream(json.toString().getBytes("UTF-8"));
        return result;
    }

    protected InputStream getSkinListJSONStream(SkinInfoRequest skinInfoRequest, String skinApp) throws IOException, XMLStreamException {
        JSONObject skinJSON = new JSONObject();
        skinJSON.addMember("canWriteStyles", skinInfoRequest.canWriteStyles);
        skinJSON.addArrayMember("skins");
        for (SkinInfo skinInfo : skinInfoRequest.skinInfoList) {
            String application = this.getSkinApplication(skinInfo);
            if (skinApp != null && !skinApp.equals(application)) continue;
            this.addSkinInfoJson(skinInfo, skinJSON, false, true);
        }
        skinJSON.endArray();
        StringBuffer json = new StringBuffer();
        skinJSON.write(json);
        ByteArrayInputStream result = new ByteArrayInputStream(json.toString().getBytes("UTF-8"));
        return result;
    }

    public void addSkinInfoJson(SkinInfo skinInfo, JSONObject skinJSON, boolean isIncludeSpec, boolean isNewJSONObject) throws IOException {
        InputStream skinXMLStream = this.getSkinXMLStream(skinInfo);
        if (skinXMLStream != null) {
            if (isNewJSONObject) {
                skinJSON.addObject();
            }
            skinJSON.addMember("skinName", skinInfo.skinName);
            skinJSON.addMember("resourceLocation", skinInfo.resourceLocation);
            if (isIncludeSpec) {
                String skinXML = new Scanner(skinXMLStream).useDelimiter("\\A").next();
                skinJSON.addMember("specification", skinXML);
            }
            skinJSON.addMember("published", skinInfo.published);
            skinJSON.addMember("isUpgraded", skinInfo.isUpgraded);
            boolean isOutOftheBox = this.getSkinXMLStreamFromFile(skinInfo.resourceLocation) != null;
            skinJSON.addMember("isShipped", isOutOftheBox);
            skinJSON.addMember("storeID", skinInfo.storeID);
            if (isNewJSONObject) {
                skinJSON.endObject();
            }
        }
    }

    public void setInputStreamRetriever(IInputStreamRetriever retriever) {
        this.retriever = retriever;
    }

    public void setEngine(PogoEngine engine) {
        this.engine = engine;
    }

    protected Document getSkeletonListAsXML(String dirPath) {
        Document doc = DocumentHelper.createDocument();
        Element rootElem = doc.addElement("skeletons");
        Set<String> appList = this.getResourcePaths(dirPath);
        if (appList != null) {
            for (String appPath : appList) {
                if (dirPath.length() >= appPath.lastIndexOf("/")) continue;
                String app = appPath.substring(dirPath.length(), appPath.lastIndexOf("/"));
                Element appElem = rootElem.addElement("app").addAttribute("name", app);
                Set<String> skeletons = this.getResourcePaths(appPath);
                if (skeletons == null) continue;
                Iterator<String> iterator = skeletons.iterator();
                while (iterator.hasNext()) {
                    String string;
                    String skelPath = string = iterator.next();
                    String skeleton = skelPath.substring(appPath.length(), skelPath.lastIndexOf(".xml"));
                    appElem.addElement("skeleton").addText(skeleton);
                }
            }
        }
        return doc;
    }

    private Set<String> getResourcePaths(String path) {
        Set result;
        block2: {
            result = null;
            try {
                result = this.engine.getContext().getResourcePaths(path);
            }
            catch (NoSuchMethodException e) {
                if (!this.serviceLogger.isErrorEnabled()) break block2;
                this.serviceLogger.error("Error while getting resource path list: " + path, e);
            }
        }
        return result;
    }

    private String getRequestedValue(String name, BIBusEnvelope envelope) {
        String value = null;
        value = envelope.getFormValue(name);
        return value;
    }

    protected InputStream writeCSS(SkinInfo skinInfo, String skeleton, boolean outputCSS, BIBusEnvelope envelope, MessageContext mc, String webcontent) {
        SharedByteArrayOutputStream out = new SharedByteArrayOutputStream(4096);
        try {
            String skeletonPath = "/blueprint/" + skeleton + ".xml";
            InputStream cssConnection = this.retriever.getInputStreamFromResource(skeletonPath);
            if (cssConnection == null) {
                return null;
            }
            if (outputCSS) {
                HashMap<String, String> macros = new HashMap<String, String>();
                macros.put("$SKIN$", skinInfo.resourceLocation);
                macros.put("$WEB$", webcontent);
                SkinGenerator sg = new SkinGenerator(this.getSkinXMLStream(skinInfo), macros);
                StringBuffer result = new StringBuffer();
                try {
                    ((InputStreamRetriever)this.retriever).setReferenceResourcePath(skeletonPath);
                    sg.setInputStreamRetriever(this.retriever);
                    sg.generateOutputFromSkeleton(new Skeleton(cssConnection), result);
                    ((InputStreamRetriever)this.retriever).setReferenceResourcePath(null);
                    out.write(result.toString().getBytes("UTF-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                SkeletonMap s = new SkeletonMap();
                try {
                    ((InputStreamRetriever)this.retriever).setReferenceResourcePath(skeletonPath);
                    String output = s.generateOutput(this.getSkinXMLStream(skinInfo), new InputStreamReader(cssConnection), this.retriever);
                    ((InputStreamRetriever)this.retriever).setReferenceResourcePath(null);
                    out.write(output.getBytes("UTF-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            out.close();
            return out.toStream();
        }
        catch (IOException e) {
            if (this.serviceLogger.isErrorEnabled()) {
                this.serviceLogger.error("encountered an IO error when trying to parse the stylesheet", e);
            }
            return out.toStream();
        }
    }

    protected String getWebContent(BIBusEnvelope envelope) {
        String webContent = envelope.getEnvironmentValue("WEB_CONTENT_ROOT");
        if (webContent == null) {
            webContent = "..";
        }
        return webContent;
    }

    protected String calculateWebContent(int locationDepth) {
        StringBuilder path = new StringBuilder();
        path.append("../..");
        for (int l = 0; l < locationDepth; ++l) {
            path.append("/..");
        }
        return path.toString();
    }

    private void createSuccessResponse(MessageContext mc, String ctype, List<String> additionalHeaders, InputStream stream, String statusCode, String statusMessage) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer(32);
        header.append("Content-Type: ").append(ctype).append("\r\n");
        if (additionalHeaders != null) {
            for (String value : additionalHeaders) {
                header.append(value).append("\r\n");
            }
        }
        header.append("\r\n");
        mc.setProperty("response.status_code", (Object)statusCode);
        mc.setProperty("response.status_msg", (Object)statusMessage);
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Type", "text/xml; charset=utf-8");
        mc.setProperty(".responseheaders", (Object)headers);
        BIBusEnvelope env = new BIBusEnvelope();
        mc.setProperty("response.envelope", (Object)env);
        ArrayList<SequenceInputStream> attachments = new ArrayList<SequenceInputStream>();
        attachments.add(new SequenceInputStream(new ByteArrayInputStream(header.toString().getBytes("UTF-8")), stream));
        mc.setProperty("response.boundary", (Object)StringUtils.getUniqueValue());
        mc.setProperty("response.attachments", attachments.iterator());
    }

    private void createNotFoundResponse(MessageContext mc) {
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        mc.setProperty("response.envelope", (Object)responseEnvelope);
        mc.setProperty("response.status_code", (Object)"404");
    }

    String getSkinApplication(SkinInfo skinInfo) throws IOException, XMLStreamException {
        XMLStreamReader xsr;
        String application = null;
        InputStream skinXMLStream = this.getSkinXMLStream(skinInfo);
        if (skinXMLStream != null && StaxUtils.moveToNextElement(xsr = XMLStreamFactory.createXMLStreamReader(skinXMLStream, "UTF-8"))) {
            application = xsr.getAttributeValue("", "application");
        }
        if (application == null) {
            application = "default";
        }
        return application;
    }

    public static class SkinInfo {
        public String skinName;
        public String specification;
        public String resourceLocation;
        public String storeID;
        public boolean published;
        public boolean isUpgraded;
    }

    public static class SkinInfoRequest
    implements IXMLHandler {
        private String skinName;
        private BIBusEnvelope requestEnvelope;
        private ServiceLogger serviceLogger;
        private IContext context;
        public List<SkinInfo> skinInfoList = new ArrayList<SkinInfo>();
        private SkinInfo currentSkin;
        boolean canWriteStyles;
        String errorMessage;
        String errorCode;
        private UpgradeManager upgradeManager;
        private static String[] PARSING_SPEC = new String[]{"/queryResponse/queryResult/item", "/queryResponse/queryResult/item/permissions/value/item", "/queryResponse/queryResult/item/specification/value", "/queryResponse/queryResult/item/published/value", "/queryResponse/queryResult/item/resourceLocation/value", "/queryResponse/queryResult/item/defaultName/value", "/queryResponse/queryResult/item/storeID/value"};

        public SkinInfoRequest(String skinName, UpgradeManager upgradeManager, BIBusEnvelope requestEnvelope, IContext context, ServiceLogger logger) {
            this.skinName = skinName;
            this.requestEnvelope = requestEnvelope;
            this.serviceLogger = logger;
            this.context = context;
            this.upgradeManager = upgradeManager;
        }

        public void retrieveInfo() {
            try {
                Query query = new Query();
                StringBuilder searchPath = new StringBuilder();
                searchPath.append("/portal/portalSkinFolder[@name='Styles']");
                searchPath.append("|/portal/portalSkinFolder[@name='Styles']/portalSkin");
                if (this.skinName != null && this.skinName.length() > 0) {
                    searchPath.append("[@name='");
                    searchPath.append(this.skinName);
                    searchPath.append("']");
                }
                query.setSearchPath(searchPath.toString());
                query.addProperty("storeID");
                query.addProperty("permissions");
                query.addProperty("specification");
                query.addProperty("published");
                query.addProperty("resourceLocation");
                query.addProperty("defaultName");
                Element header = this.requestEnvelope.getBIBusHeader();
                query.setBusHeader(header != null ? header.asXML() : null);
                query.setResponseBodyHandler(this);
                this.sendCMRequest(query);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void sendCMRequest(SOAPMessage message) throws DashboardException, SOAPFaultException {
            try {
                SOAPConnectionFactory soapFactory = (SOAPConnectionFactory)this.context.getProperty("SoapConnectionFactory");
                SOAPConnection connection = soapFactory.createConnection(this.serviceLogger);
                connection.execute(message, (String)this.context.getProperty("contentManager"));
            }
            catch (MalformedURLException e) {
                if (this.serviceLogger != null && this.serviceLogger.isErrorEnabled()) {
                    this.serviceLogger.error("malformed url", e);
                }
                this.errorMessage = e.getLocalizedMessage();
            }
            catch (SOAPFault e) {
                String detail;
                if (this.serviceLogger != null && this.serviceLogger.isErrorEnabled()) {
                    this.serviceLogger.error("got a fault response", e);
                }
                if ((detail = e.getDetail()) != null && detail.indexOf("CM-REQ-4159") != -1) {
                    this.errorCode = "CAM_PASSPORT_ERROR";
                }
                this.errorMessage = e.getFaultString();
            }
            catch (IOException e) {
                if (this.serviceLogger != null && this.serviceLogger.isErrorEnabled()) {
                    this.serviceLogger.error("got an input/output error", e);
                }
                this.errorMessage = e.getLocalizedMessage();
            }
            catch (XMLStreamException e) {
                Location loc = e.getLocation();
                if (loc != null) {
                    if (this.serviceLogger != null && this.serviceLogger.isErrorEnabled()) {
                        StringBuffer sb = new StringBuffer("got an xml stream error");
                        sb.append(" (Line=").append(loc.getLineNumber());
                        sb.append(", Column=").append(loc.getColumnNumber());
                        sb.append(", Offset=").append(loc.getCharacterOffset());
                        sb.append(")");
                        this.serviceLogger.error(sb.toString(), e);
                    }
                    Object[] args = new String[]{Integer.toString(loc.getLineNumber()), Integer.toString(loc.getColumnNumber()), Integer.toString(loc.getCharacterOffset())};
                    throw new DashboardException("pf.fragment.server.invalidxmldocument.details", args, e);
                }
                this.errorMessage = e.getLocalizedMessage();
            }
        }

        @Override
        public void handle(XMLStreamReader reader) throws XMLStreamException {
            int path;
            PathIterator pathIt = new PathIterator(reader, PARSING_SPEC);
            String type = null;
            while ((path = pathIt.moveToNextPath()) != -1) {
                switch (path) {
                    case 0: {
                        type = pathIt.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
                        if (type == null || !type.endsWith(":portalSkin")) break;
                        this.currentSkin = new SkinInfo();
                        this.skinInfoList.add(this.currentSkin);
                        break;
                    }
                    case 1: {
                        if (type == null || !type.endsWith(":portalSkinFolder") || this.canWriteStyles) break;
                        this.canWriteStyles = "write".equals(pathIt.getElementText());
                        break;
                    }
                    case 2: {
                        if (type == null || !type.endsWith(":portalSkin")) break;
                        String spec = pathIt.getElementText();
                        try {
                            String upgradedSpec = null;
                            if (this.upgradeManager != null) {
                                upgradedSpec = this.upgradeManager.upgrade(spec, 2.1);
                            }
                            if (upgradedSpec != null) {
                                this.currentSkin.isUpgraded = true;
                                this.currentSkin.specification = upgradedSpec;
                                break;
                            }
                            this.currentSkin.specification = spec;
                            break;
                        }
                        catch (SkinUpgradeException e) {
                            throw new XMLStreamException(e);
                        }
                    }
                    case 3: {
                        if (type == null || !type.endsWith(":portalSkin")) break;
                        this.currentSkin.published = "true".equalsIgnoreCase(pathIt.getElementText());
                        break;
                    }
                    case 4: {
                        if (type == null || !type.endsWith(":portalSkin")) break;
                        this.currentSkin.resourceLocation = pathIt.getElementText();
                        break;
                    }
                    case 5: {
                        if (type == null || !type.endsWith(":portalSkin")) break;
                        this.currentSkin.skinName = pathIt.getElementText();
                        break;
                    }
                    case 6: {
                        if (type == null || !type.endsWith(":portalSkin")) break;
                        this.currentSkin.storeID = pathIt.getElementText();
                    }
                }
            }
        }
    }
}

