/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.service;

import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.service.IInputStreamRetriever;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class InputStreamRetriever
implements IInputStreamRetriever {
    private ServiceLoggerImpl serviceLogger = new ServiceLoggerImpl(InputStreamRetriever.class);
    private PogoEngine engine;
    private final String retrieverBasePath = "/WEB-INF/css";
    private String referenceResourcePath = null;

    public void setReferenceResourcePath(String path) {
        this.referenceResourcePath = null != path ? new String(path).replaceAll("[\\\\]", "/") : null;
    }

    public InputStreamRetriever(PogoEngine engine) {
        this.engine = engine;
    }

    @Override
    public InputStream getInputStreamFromResource(String path) throws IOException {
        String usePath = path;
        if (null != this.referenceResourcePath && !usePath.startsWith("/")) {
            String referenceResourceParentPath = this.referenceResourcePath.substring(0, this.referenceResourcePath.lastIndexOf("/"));
            usePath = referenceResourceParentPath + "/" + path;
        }
        URLConnection connection = null;
        String currentResourcePath = "/WEB-INF/css" + (usePath.startsWith("/") ? "" : "/") + usePath;
        try {
            URL url = this.engine.getContext().getResource(currentResourcePath);
            if (url == null) {
                return null;
            }
            connection = url.openConnection();
            connection.connect();
        }
        catch (MalformedURLException e) {
            if (this.serviceLogger.isErrorEnabled()) {
                this.serviceLogger.error("Failed to get resource, path=" + currentResourcePath, e);
            }
        }
        catch (Exception e) {
            if (this.serviceLogger.isErrorEnabled()) {
                this.serviceLogger.error("Error loading resource for path=" + currentResourcePath, e);
            }
            return null;
        }
        return connection.getInputStream();
    }
}

