/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.skin;

import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.ccl4j.bibus.CAMCookieFactory;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.service.CssService;
import com.cognos.portal.utils.Cache;
import com.cognos.portal.utils.IContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class SkinCache {
    private static SkinCache m_instance = new SkinCache();
    private IContext m_context = null;
    private ServiceLogger m_serviceLogger = null;
    private static List<String> m_preinstalledSkins = null;
    private Cache m_skinSpecCache = new Cache(0L, 0L, 1024);
    private Cache m_skinPropertyCache = new Cache(0L, 0L, 1024);
    private List<String> disabledSkinProperties;

    private SkinCache() {
    }

    public static SkinCache getInstance() {
        return m_instance;
    }

    public void init(IContext context, ServiceLogger serviceLogger) {
        String disabledProps;
        this.m_context = context;
        this.m_serviceLogger = serviceLogger;
        this.m_skinSpecCache.clear();
        this.m_skinPropertyCache.clear();
        this.disabledSkinProperties = null;
        if (context != null && (disabledProps = (String)context.getProperty("portal.disabledskinproperty")) != null && disabledProps.length() > 0) {
            String[] props;
            this.disabledSkinProperties = new ArrayList<String>();
            for (String prop : props = disabledProps.split(",")) {
                this.disabledSkinProperties.add(prop.trim().toLowerCase());
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static String getSkinPropertyStatic(String skin, String property, String camPassportCookie) {
        String value = SkinCache.getInstance().getSkinProperty(skin, property, camPassportCookie);
        return value;
    }

    public void resetSkinCache(String skinName) {
        this.m_skinSpecCache.remove(skinName);
        this.m_skinPropertyCache.remove(skinName);
    }

    private boolean isDisabled(String property) {
        return this.disabledSkinProperties != null && this.disabledSkinProperties.contains(property.toLowerCase());
    }

    public String getSkinProperty(String skin, String property, String camPassportCookie) {
        Cache propertiesCache;
        if (this.isDisabled(property) || this.m_context == null || this.m_skinPropertyCache == null || this.isPreinstalledSkin(skin)) {
            return null;
        }
        if (!this.m_skinPropertyCache.containsKey(skin)) {
            this.initSkinPropertyCache(skin);
        }
        if ((propertiesCache = (Cache)this.m_skinPropertyCache.get(skin)).get(property) != null) {
            return (String)propertiesCache.get(property);
        }
        boolean success = this.retrieveSkinProperty(skin, property, camPassportCookie);
        if (success) {
            return (String)propertiesCache.get(property);
        }
        return null;
    }

    private void initSkinPropertyCache(String skin) {
        Cache propertiesCache = null;
        if (!this.m_skinPropertyCache.containsKey(skin)) {
            this.m_skinPropertyCache.put(skin, new Cache(0L, 0L, 1024));
            propertiesCache = (Cache)this.m_skinPropertyCache.get(skin);
            propertiesCache.clear();
        }
    }

    private boolean retrieveSkinProperty(String skin, String property, String camPassportCookie) {
        if (!this.m_skinSpecCache.containsKey(skin) && !this.retrieveSkinSpec(skin, camPassportCookie)) {
            return false;
        }
        Cache propertiesCache = (Cache)this.m_skinPropertyCache.get(skin);
        if (propertiesCache.get(property) != null) {
            return true;
        }
        Document skinSpecDoc = (Document)this.m_skinSpecCache.get(skin);
        Node node = skinSpecDoc.selectSingleNode(property);
        if (node != null) {
            String value = node.getStringValue();
            propertiesCache.put(property, value);
            return true;
        }
        return false;
    }

    private boolean retrieveSkinSpec(String skin, String camPassportCookie) {
        BIBusEnvelope envelope = this.createBIBusHeader(camPassportCookie);
        CssService.SkinInfoRequest skinInfo = new CssService.SkinInfoRequest(skin, null, envelope, this.m_context, this.m_serviceLogger);
        skinInfo.retrieveInfo();
        String skinSpec = null;
        if (skinInfo.skinInfoList.size() > 0) {
            skinSpec = skinInfo.skinInfoList.get((int)0).specification;
        }
        try {
            if (skinSpec == null || skinSpec.length() == 0) {
                return false;
            }
            Document skinSpecDoc = DocumentHelper.parseText((String)skinSpec);
            this.m_skinSpecCache.put(skin, skinSpecDoc);
            return true;
        }
        catch (DocumentException e) {
            if (this.m_serviceLogger != null && this.m_serviceLogger.isErrorEnabled()) {
                this.m_serviceLogger.error("Error while creating dom4j document from skin spec", e);
            }
            return false;
        }
    }

    private BIBusEnvelope createBIBusHeader(String camPassportCookie) {
        BIBusEnvelope envelope;
        block3: {
            envelope = new BIBusEnvelope();
            if (camPassportCookie == null || camPassportCookie.length() == 0) {
                return envelope;
            }
            CAMCookie cam = CAMCookieFactory.createCAMCookie((String)camPassportCookie);
            try {
                Element camElement = cam.asXML();
                envelope.setCAM(camElement);
            }
            catch (DocumentException e) {
                if (this.m_serviceLogger == null || !this.m_serviceLogger.isErrorEnabled()) break block3;
                this.m_serviceLogger.error("Error while creating CAMCookie from passport cookie", e);
            }
        }
        return envelope;
    }

    private boolean isPreinstalledSkin(String skinName) {
        return m_preinstalledSkins.contains(skinName);
    }

    static {
        m_preinstalledSkins = Arrays.asList("business", "classic", "classic", "corporate", "modern", "presentation");
    }
}

