/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.skin.tools;

import java.util.ArrayList;

public class CSSParser {
    static final int NO_WHERE = 0;
    static final int CLASS_NAME = 1;
    static final int CLASS_STYLE = 2;
    static final int ATTRIBUTE = 3;
    static final int ATTRIBUTE_VALUE = 4;
    static final int COMMENTS = 5;
    static final int PRAGMA = 6;
    static final int LINE_COMMENT = 7;

    private static boolean attributeIdentifier(char c) {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_".indexOf(c) >= 0;
    }

    private static boolean classIdentifier(char c) {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_!#.[]:>*=\"+;".indexOf(c) >= 0;
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\r' || c == '\n' || c == '\t';
    }

    private static void error(char c, int row, int col) {
        throw new RuntimeException("Unexpected character: '" + c + "' at line " + row + " column " + col + ".");
    }

    private static String getString(String string, boolean toLower) {
        String value = string.toString().trim();
        if (toLower) {
            value = value.toLowerCase();
        }
        return value;
    }

    public ArrayList<CSSCommon> scanCSS(String buf) {
        ArrayList<CSSCommon> classes = new ArrayList<CSSCommon>();
        int[] states = new int[10];
        int level = 0;
        CSSClass cssClass = null;
        CSSAttribute cssAttr = null;
        CSSCommon cssLastTag = null;
        StringBuffer token = new StringBuffer();
        StringBuffer comments = new StringBuffer();
        int col = 0;
        int row = 1;
        int bracket = 0;
        block10: for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c == '\t') {
                col = (col + 4) / 4 * 4;
            } else if (c == '\r' || c == '\n') {
                ++row;
                col = 0;
            } else {
                ++col;
            }
            if (level < 0) {
                CSSParser.error(c, row, col);
            }
            switch (states[level]) {
                case 0: {
                    if (CSSParser.isWhiteSpace(c)) continue block10;
                    if (CSSParser.classIdentifier(c)) {
                        states[++level] = 1;
                        --i;
                        --col;
                        continue block10;
                    }
                    if (c == '/' && buf.charAt(i + 1) == '*') {
                        states[++level] = 5;
                        ++i;
                        continue block10;
                    }
                    if (c == '@') {
                        states[++level] = 6;
                        continue block10;
                    }
                    CSSParser.error(c, row, col);
                    continue block10;
                }
                case 1: {
                    if (CSSParser.classIdentifier(c)) {
                        if (cssClass == null) {
                            cssClass = new CSSClass();
                            classes.add(cssClass);
                            cssLastTag = cssClass;
                        }
                        token.append(c);
                        continue block10;
                    }
                    if (CSSParser.isWhiteSpace(c)) {
                        if (c != ' ' || token.length() <= 0) continue block10;
                        token.append(c);
                        continue block10;
                    }
                    if (c == '/' && buf.charAt(i + 1) == '*') {
                        states[++level] = 5;
                        ++i;
                        continue block10;
                    }
                    if (c == ',' || c == '{') {
                        cssClass.names.add(this.normalizeSelector(CSSParser.getString(token.toString(), false)));
                        token.setLength(0);
                        if (c != '{') continue block10;
                        states[++level] = 2;
                        continue block10;
                    }
                    CSSParser.error(c, row, col);
                    continue block10;
                }
                case 2: {
                    if (c == '}') {
                        --level;
                        cssClass = null;
                        cssLastTag = null;
                        continue block10;
                    }
                    if (CSSParser.isWhiteSpace(c)) continue block10;
                    if (CSSParser.attributeIdentifier(c)) {
                        states[++level] = 3;
                        --i;
                        --col;
                        continue block10;
                    }
                    if (c == '#') {
                        states[++level] = 7;
                        continue block10;
                    }
                    if (c == '/' && buf.charAt(i + 1) == '*') {
                        states[++level] = 5;
                        continue block10;
                    }
                    if (c == ';') continue block10;
                    CSSParser.error(c, row, col);
                    continue block10;
                }
                case 3: {
                    if (CSSParser.attributeIdentifier(c)) {
                        if (cssAttr == null) {
                            cssAttr = new CSSAttribute();
                            cssClass.attributes.add(cssAttr);
                            cssLastTag = cssAttr;
                        }
                        token.append(c);
                        continue block10;
                    }
                    if (c == ':') {
                        cssAttr.name = CSSParser.getString(token.toString(), true);
                        token.setLength(0);
                        states[level] = 4;
                        continue block10;
                    }
                    if (CSSParser.isWhiteSpace(c)) continue block10;
                    CSSParser.error(c, row, col);
                    continue block10;
                }
                case 4: {
                    if (bracket <= 0 && (c == ';' || c == '}')) {
                        cssAttr.value = CSSParser.getString(token.toString(), true);
                        cssLastTag = cssAttr;
                        cssAttr = null;
                        token.setLength(0);
                        --level;
                        if (c != '}') continue block10;
                        --level;
                        continue block10;
                    }
                    if (c == '(') {
                        ++bracket;
                    } else if (c == ')') {
                        --bracket;
                    }
                    token.append(c);
                    continue block10;
                }
                case 5: {
                    if (c == '*' && buf.charAt(i + 1) == '/') {
                        if (cssLastTag != null) {
                            cssLastTag.comments = comments.toString().trim();
                            comments.setLength(0);
                        } else {
                            CSSComment cssComment = new CSSComment();
                            cssComment.comments = comments.toString().trim();
                            classes.add(cssComment);
                            comments.setLength(0);
                        }
                        --level;
                        ++i;
                        continue block10;
                    }
                    if (c == '=') continue block10;
                    comments.append(c);
                    continue block10;
                }
                case 6: {
                    if (c != '\r' && c != '\n') continue block10;
                    --level;
                    continue block10;
                }
                case 7: {
                    if (c != '\r' && c != '\n') continue block10;
                    --level;
                }
            }
        }
        return classes;
    }

    private String normalizeSelector(String selector) {
        return selector.replaceAll("\\s+", " ");
    }

    class CSSAttribute
    extends CSSCommon {
        String name;
        String value;

        CSSAttribute() {
        }

        public boolean equals(Object attr) {
            if (attr instanceof CSSAttribute) {
                CSSAttribute test = (CSSAttribute)attr;
                return test.name.equals(this.name) && test.value.equals(this.value);
            }
            return false;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    class CSSClass
    extends CSSCommon {
        ArrayList<String> names;
        ArrayList<CSSAttribute> attributes;
        ArrayList<String> uses;

        CSSClass() {
            this.names = new ArrayList();
            this.attributes = new ArrayList();
            this.uses = new ArrayList();
        }

        public boolean equals(Object o) {
            if (o instanceof CSSClass) {
                int i;
                CSSClass other = (CSSClass)o;
                for (i = 0; i < other.attributes.size(); ++i) {
                    if (this.attributes.contains(other.attributes.get(i))) continue;
                    return false;
                }
                for (i = 0; i < this.attributes.size(); ++i) {
                    if (other.attributes.contains(this.attributes.get(i))) continue;
                    return false;
                }
                for (i = 0; i < other.uses.size(); ++i) {
                    if (this.uses.contains(other.uses.get(i))) continue;
                    return false;
                }
                for (i = 0; i < this.uses.size(); ++i) {
                    if (other.uses.contains(this.uses.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return this.names.toString();
        }
    }

    class CSSComment
    extends CSSCommon {
        CSSComment() {
        }
    }

    class CSSBase
    implements Comparable<Object> {
        String name;
        ArrayList<CSSAttribute> attributes = new ArrayList();
        ArrayList<String> uses = new ArrayList();
        int refCount;

        CSSBase() {
        }

        @Override
        public int compareTo(Object o) {
            return this.name.compareTo(((CSSBase)o).name);
        }
    }

    class CSSCommon
    implements Comparable<Object> {
        String comments;

        CSSCommon() {
        }

        @Override
        public int compareTo(Object o) {
            if (o == null) {
                return -1;
            }
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return this.comments;
        }
    }
}

