/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.skin.tools;

import com.cognos.portal.skin.tools.CssUtils;
import com.cognos.portal.skin.tools.ISkinFunction;
import com.cognos.portal.skin.tools.SkinGenerator;
import com.cognos.portal.skin.tools.SkinParseState;
import com.cognos.portal.skin.tools.SkinValueFunction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.dom4j.Node;

public class CSSStylesFunction
implements ISkinFunction {
    private Map<String, String> macros;
    private String SkinValueName;

    public CSSStylesFunction() {
        SkinValueFunction skinValue = new SkinValueFunction();
        this.SkinValueName = skinValue.getName();
    }

    @Override
    public String execute(Element skinRootElement, Map<String, String> parameters, SkinParseState stateMap) {
        return this.executeImpl(skinRootElement, parameters, stateMap, null);
    }

    private String executeImpl(Element skinRootElement, Map<String, String> parameters, SkinParseState stateMap, List<SkinGenerator.VariableInfo> variables) {
        Node node;
        String path = parameters.get("path");
        Set<String> excludes = this.createExcludesSet(parameters.get("exclude"));
        StringBuilder result = new StringBuilder();
        if (path != null && (node = skinRootElement.selectSingleNode(path)) != null) {
            String padding;
            Element skinElement = (Element)node.selectSingleNode("background");
            if (skinElement != null && !excludes.contains("background")) {
                this.generateBackgroundCss(skinElement, skinRootElement, result, parameters, variables);
            }
            if ((skinElement = (Element)node.selectSingleNode("border")) != null && !excludes.contains("border")) {
                this.generateBorderCss(skinElement, skinRootElement, result, parameters, variables);
            }
            if ((skinElement = (Element)node.selectSingleNode("text")) != null && !excludes.contains("text")) {
                this.generateTextCss(skinElement, skinRootElement, result, parameters, variables);
            }
            if ((padding = this.getSkinValue((Element)node, "padding", skinRootElement, result, parameters, variables)) != null && !excludes.contains("padding")) {
                result.append("\tpadding: " + padding + ";\n");
            }
        }
        return result.toString();
    }

    private Set<String> createExcludesSet(String excludes) {
        HashSet<String> excludesSet = null;
        if (excludes != null) {
            String[] excludesArray = excludes.split(" ");
            excludesSet = new HashSet<String>(Arrays.asList(excludesArray));
        } else {
            excludesSet = new HashSet<String>();
        }
        return excludesSet;
    }

    private String createVariable(List<SkinGenerator.VariableInfo> variables, Map<String, String> parameters, String additionalPath) {
        HashMap<String, String> newParameters = new HashMap<String, String>();
        newParameters.put("path", parameters.get("path") + additionalPath);
        SkinGenerator.VariableInfo vi = new SkinGenerator.VariableInfo(this.SkinValueName, newParameters);
        variables.add(vi);
        String useVariable = "#" + vi.id;
        return useVariable;
    }

    private void generateTextCss(Element text, Element skinRootElement, StringBuilder result, Map<String, String> parameters, List<SkinGenerator.VariableInfo> variables) {
        String colorValue = this.getSkinColorValue(text, skinRootElement, result, parameters, variables);
        if (colorValue != null) {
            result.append("\tcolor: " + colorValue + ";\n");
        }
    }

    private void generateBorderCss(Element border, Element skinRootElement, StringBuilder result, Map<String, String> parameters, List<SkinGenerator.VariableInfo> variables) {
        String radiusValue;
        String baseAttrName = border.getName();
        String colorValue = this.getSkinColorValue(border, skinRootElement, result, parameters, variables);
        String width = this.getSkinValue(border, "width", skinRootElement, result, parameters, variables);
        String style = this.getSkinValue(border, "style", skinRootElement, result, parameters, variables);
        if (colorValue != null && width != null && style != null) {
            result.append("\t" + baseAttrName + ": " + colorValue + " " + width + " " + style + ";\n");
        } else {
            if (colorValue != null) {
                result.append("\t" + baseAttrName + "-color: " + colorValue + ";\n");
            }
            if (width != null) {
                result.append("\t" + baseAttrName + "-width: " + width + ";\n");
            }
            if (style != null) {
                result.append("\t" + baseAttrName + "-style: " + style + ";\n");
            }
        }
        if (baseAttrName.equalsIgnoreCase("border") && (radiusValue = this.getSkinValue(border, "radius", skinRootElement, result, parameters, variables)) != null) {
            result.append("\t-webkit-border-radius: " + radiusValue + ";\n");
            radiusValue = this.getSkinValue(border, "radius", skinRootElement, result, parameters, variables);
            result.append("\t-moz-border-radius: " + radiusValue + ";\n");
            radiusValue = this.getSkinValue(border, "radius", skinRootElement, result, parameters, variables);
            result.append("\tborder-radius: " + radiusValue + ";\n");
        }
    }

    private void generateBackgroundCss(Element background, Element skinRootElement, StringBuilder result, Map<String, String> parameters, List<SkinGenerator.VariableInfo> variables) {
        Element image;
        String colorValue = this.getSkinColorValue(background, skinRootElement, result, parameters, variables);
        if (colorValue != null) {
            result.append("\tbackground-color: " + colorValue + ";\n");
        }
        if ((image = (Element)background.selectSingleNode("image")) != null && CssUtils.isImageElement(image)) {
            if (variables != null) {
                result.append("\tbackground-image: " + this.createVariable(variables, parameters, "/" + background.getName() + "/image") + ";\n");
            } else {
                result.append(CssUtils.getImageCss(image, skinRootElement, this.macros, parameters));
                result.append("\n");
            }
        }
    }

    private String getSkinValue(Element element, String tagName, Element skinRootElement, StringBuilder result, Map<String, String> parameters, List<SkinGenerator.VariableInfo> variables) {
        Element e = (Element)element.selectSingleNode(tagName);
        String value = null;
        if (e != null) {
            value = variables != null ? this.createVariable(variables, parameters, "/" + element.getName() + "/" + tagName) : e.getText();
        }
        return value;
    }

    private String getSkinColorValue(Element element, Element skinRootElement, StringBuilder result, Map<String, String> parameters, List<SkinGenerator.VariableInfo> variables) {
        Element e = (Element)element.selectSingleNode("color");
        String value = null;
        if (e != null) {
            if (variables != null) {
                value = this.createVariable(variables, parameters, "/" + element.getName() + "/color");
            } else {
                HashSet<String> referenceChain = new HashSet<String>();
                value = CssUtils.getColor(e, skinRootElement, referenceChain);
            }
        }
        return value;
    }

    @Override
    public void setMacros(Map<String, String> macros) {
        this.macros = macros;
    }

    @Override
    public String parseText(String xmlStringFragment, SkinParseState stateMap) {
        return xmlStringFragment;
    }

    @Override
    public String generateSmuVariables(Element skinRootElement, Map<String, String> parameters, SkinParseState stateMap, List<SkinGenerator.VariableInfo> variables) {
        return this.executeImpl(skinRootElement, parameters, stateMap, variables);
    }

    @Override
    public String getName() {
        return "cssStyles";
    }
}

