/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.skin.tools;

import com.cognos.portal.skin.tools.SkinGenerator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.dom4j.Node;

public class CssUtils {
    public static String getColor(Element e, Element skinRootElement, Set<String> referenceChain) {
        String colorRef = e.attributeValue("ref");
        String colorValue = null;
        if (colorRef != null && colorRef.length() > 0) {
            String hValue = e.attributeValue("hOffset");
            String sValue = e.attributeValue("sOffset");
            String vValue = e.attributeValue("vOffset");
            float hsvHue = hValue != null && hValue.length() > 0 ? Float.parseFloat(hValue) : 0.0f;
            float hsvSaturation = sValue != null && sValue.length() > 0 ? Float.parseFloat(sValue) : 0.0f;
            float hsvValue = vValue != null && vValue.length() > 0 ? Float.parseFloat(vValue) : 0.0f;
            Element colorNode = (Element)skinRootElement.selectSingleNode(colorRef);
            if (colorNode != null) {
                String alpha = e.attributeValue("alpha");
                float alphaValue = 1.0f;
                if (alpha != null && alpha.length() > 0) {
                    alphaValue = Float.parseFloat(alpha);
                }
                if (colorNode.getName() != "namedColor") {
                    if (referenceChain.contains(colorRef)) {
                        throw new IllegalArgumentException("Skin specification contains a circular reference to " + colorRef);
                    }
                    referenceChain.add(colorRef);
                    colorValue = CssUtils.getColor(colorNode, skinRootElement, referenceChain);
                } else {
                    colorValue = colorNode.attributeValue("value");
                }
                SkinGenerator.RGBColor color = new SkinGenerator.RGBColor(colorValue, hsvHue, hsvSaturation, hsvValue, alphaValue);
                colorValue = color.toString();
            }
        }
        return colorValue;
    }

    public static String getImageCss(Element e, Element skinRootElement, Map<String, String> macros, Map<String, String> parameters) {
        boolean ie8compatible = false;
        List urlNodes = e.selectNodes("url");
        List colourNodes = e.selectNodes("gradient/color");
        String ie8compatibleValue = parameters.get("ie8compatible");
        if (ie8compatibleValue != null && "true".equalsIgnoreCase(ie8compatibleValue)) {
            ie8compatible = true;
        }
        StringBuffer urlCss = new StringBuffer();
        for (int i = 0; i < urlNodes.size(); ++i) {
            Element url = (Element)urlNodes.get(0);
            urlCss.append(SkinGenerator.expandMacros(url.getText(), macros));
            if (i >= urlNodes.size() - 1) continue;
            urlCss.append(" ,");
        }
        String css = null;
        if (colourNodes.size() > 0) {
            Element beginColourNode = (Element)colourNodes.get(0);
            Element endColourNode = (Element)(colourNodes.size() > 1 ? (Node)colourNodes.get(1) : (Node)colourNodes.get(0));
            String beginColourRef = beginColourNode.attributeValue("ref");
            String endColourRef = endColourNode.attributeValue("ref");
            if (beginColourRef != null && endColourRef != null) {
                HashSet<String> referenceChain = new HashSet<String>();
                String beginColourValue = CssUtils.getColor(beginColourNode, skinRootElement, referenceChain);
                referenceChain.clear();
                String endColourValue = CssUtils.getColor(endColourNode, skinRootElement, referenceChain);
                if (endColourValue == null) {
                    endColourValue = beginColourValue;
                }
                if (beginColourValue != null && endColourValue != null) {
                    if (urlCss.length() > 0) {
                        urlCss.append(", ");
                    }
                    String urlValue = urlCss.toString();
                    css = "\tbackground-image: " + urlValue + "-moz-linear-gradient(top, " + beginColourValue + " 0%, " + endColourValue + " 100%);\n\t" + "background-image: " + urlValue + "-webkit-gradient(linear, left top, left bottom, color-stop(0%," + beginColourValue + "), color-stop(100%," + endColourValue + "));\n\t" + "background-image: " + urlValue + "-webkit-linear-gradient(top, " + beginColourValue + " 0%, " + endColourValue + " 100%);\n\t" + "background-image: " + urlValue + "-o-linear-gradient(top, " + beginColourValue + " 0%, " + endColourValue + " 100%);\n\t" + "background-image: " + urlValue + "-ms-linear-gradient(top, " + beginColourValue + " 0%, " + endColourValue + " 100%);\n\t" + "background-image: " + urlValue + "linear-gradient(to bottom, " + beginColourValue + " 0%, " + endColourValue + " 100%);";
                    if (!ie8compatible) {
                        css = css + "\n\tfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr='" + beginColourValue + "', endColorstr='" + endColourValue + "',GradientType=0 );\n\t" + "zoom: 1;";
                    }
                }
            }
        } else {
            css = "\tbackground-image: " + urlCss.toString() + ";";
        }
        return css != null ? css : "";
    }

    public static boolean isImageElement(Element element) {
        List gradientColors = element.selectNodes("gradient/color");
        List url = element.selectNodes("url");
        return !gradientColors.isEmpty() || !url.isEmpty();
    }
}

