/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.skin.tools;

import com.cognos.portal.service.IInputStreamRetriever;
import com.cognos.portal.skin.tools.CSSParser;
import com.cognos.portal.skin.tools.Skeleton;
import com.cognos.portal.skin.tools.SkinGenerator;
import com.cognos.portal.utils.EncodingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SkeletonMap {
    public String generateOutput(InputStream skinSpec, Reader fileReader, IInputStreamRetriever retriever) throws IOException, Exception {
        SkinGenerator sg = new SkinGenerator(skinSpec);
        sg.setInputStreamRetriever(retriever);
        StringBuffer sb = new StringBuffer();
        sg.generateOutputFromSkeleton(new Skeleton(fileReader), sb);
        CSSParser parser = new CSSParser();
        ArrayList<CSSParser.CSSCommon> cssContent = parser.scanCSS(sb.toString());
        StringBuilder output = new StringBuilder();
        List<SkinGenerator.VariableInfo> variableList = sg.getVariables();
        output.append("[");
        boolean isFirst = true;
        for (CSSParser.CSSCommon cssCommon : cssContent) {
            if (!(cssCommon instanceof CSSParser.CSSClass)) continue;
            CSSParser.CSSClass cssClass = (CSSParser.CSSClass)cssCommon;
            if (!isFirst) {
                output.append(",");
            }
            output.append("{");
            output.append("selector:'");
            this.appendName(cssClass, output);
            output.append("',");
            output.append("styles:[");
            this.appendStyles(cssClass, output, variableList);
            output.append("]");
            output.append("}");
            isFirst = false;
        }
        output.append("]");
        return output.toString();
    }

    private void appendStyles(CSSParser.CSSClass cssClass, StringBuilder output, List<SkinGenerator.VariableInfo> variableList) {
        ArrayList<CSSParser.CSSAttribute> attributes = cssClass.attributes;
        boolean isFirst = true;
        for (CSSParser.CSSAttribute cssAttribute : attributes) {
            if (!isFirst) {
                output.append(",");
            }
            output.append("{");
            output.append("attribute:'");
            output.append(EncodingUtils.javascriptencode(cssAttribute.name));
            output.append("',");
            output.append("value:'");
            output.append(EncodingUtils.javascriptencode(cssAttribute.value));
            output.append("',");
            output.append("variables:{");
            boolean isFirstVariable = true;
            while (variableList.size() > 0) {
                SkinGenerator.VariableInfo nextVariable = variableList.get(0);
                if (cssAttribute.value.indexOf("#" + nextVariable.id) == -1) break;
                if (!isFirstVariable) {
                    output.append(",");
                }
                output.append("\"" + EncodingUtils.javascriptencode(nextVariable.id) + "\":");
                this.appendVariable(nextVariable, output);
                variableList.remove(0);
                isFirstVariable = false;
            }
            output.append("}");
            output.append("}");
            isFirst = false;
        }
    }

    private void appendVariable(SkinGenerator.VariableInfo variable, StringBuilder output) {
        output.append("{");
        output.append("name:'");
        output.append(EncodingUtils.javascriptencode(variable.id));
        output.append("',");
        output.append("type:'");
        output.append(EncodingUtils.javascriptencode(variable.functionName));
        output.append("',");
        output.append("parameters:{");
        if (variable.parameters != null) {
            boolean isFirst = true;
            for (Map.Entry<String, String> entry : variable.parameters.entrySet()) {
                if (!isFirst) {
                    output.append(",");
                }
                output.append(entry.getKey());
                output.append(":'");
                output.append(EncodingUtils.javascriptencode(entry.getValue()));
                output.append("'");
                isFirst = false;
            }
        }
        output.append("}");
        output.append("}");
    }

    private void appendName(CSSParser.CSSClass cssClass, StringBuilder output) {
        StringBuilder temp = new StringBuilder();
        ArrayList<String> names = cssClass.names;
        for (String string : names) {
            if (temp.length() > 0) {
                temp.append(", ");
            }
            temp.append(string);
        }
        output.append(EncodingUtils.javascriptencode(temp.toString()));
    }
}

