/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.skin.tools;

import com.cognos.portal.service.IInputStreamRetriever;
import com.cognos.portal.skin.tools.SkeletonXmlInsertFilter;
import com.cognos.portal.utils.IOUtils;
import com.cognos.portal.xml.stream.XmlPIFilter;
import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;

public class SkeletonXmlPIFilter
extends XmlPIFilter {
    private String includeRootPath = null;
    private IInputStreamRetriever inputStreamRetriever = null;

    public SkeletonXmlPIFilter(String xml) throws XMLStreamException {
        super(xml);
    }

    @Override
    protected void resolveProcessingInstruction() throws XMLStreamException {
        if (this.target == "skeleton-include") {
            this.resolveIncludePI();
        } else if (this.target == "skeleton-branding") {
            this.resolveBrandingPI();
        } else {
            this.writer.writeProcessingInstruction(this.target, this.data);
        }
    }

    private void resolveIncludePI() throws XMLStreamException {
        StringTokenizer dataLines = new StringTokenizer(this.data, "\n");
        int countDataLines = dataLines.countTokens();
        String formatLine = dataLines.nextToken();
        StringTokenizer formatLineWords = new StringTokenizer(formatLine);
        formatLineWords.nextToken();
        String source = formatLineWords.nextToken();
        if (!source.equals("filesystem")) {
            this.warnUnhandledPI();
            return;
        }
        this.handleFilesystemInclude(dataLines, countDataLines, formatLineWords);
    }

    private void handleFilesystemInclude(StringTokenizer dataLines, int countDataLines, StringTokenizer formatLineWords) throws XMLStreamException {
        String specFormat = formatLineWords.nextToken();
        if (!specFormat.equals("list")) {
            this.warnUnhandledPI();
            return;
        }
        this.handleFilesystemIncludeList(dataLines, countDataLines - 1);
    }

    private void handleFilesystemIncludeList(StringTokenizer dataLines, int countListItems) throws XMLStreamException {
        boolean success = true;
        for (int i = 0; i < countListItems; ++i) {
            String path = dataLines.nextToken().trim();
            success &= this.includeFileContents(path);
        }
        if (!success) {
            this.warnUnhandledPI();
        }
    }

    private boolean includeFileContents(String path) throws XMLStreamException {
        try {
            String xml = IOUtils.getInputStreamContents(this.getInputStream(path)).toString();
            SkeletonXmlInsertFilter filter = new SkeletonXmlInsertFilter(xml, this.writer);
            filter.process();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private InputStream getInputStream(String path) {
        try {
            if (null != this.inputStreamRetriever) {
                return this.inputStreamRetriever.getInputStreamFromResource(path);
            }
            if (null != this.includeRootPath) {
                return new FileInputStream(new File(this.includeRootPath, path));
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void resolveBrandingPI() throws XMLStreamException {
        StringTokenizer st = new StringTokenizer(this.data);
        if (st.countTokens() != 5) {
            this.warnUnhandledPI();
            return;
        }
        String brandingHeaderType = st.nextToken();
        String commentType = st.nextToken();
        String componentName = st.nextToken();
        String year1 = st.nextToken();
        String year2 = st.nextToken();
        if (brandingHeaderType.equals("source")) {
            this.emitBrandingForSource(commentType, componentName, year1, year2);
            return;
        }
        if (brandingHeaderType.equals("compiled")) {
            this.emitBrandingForCompiled(commentType, componentName, year1, year2);
            return;
        }
        this.warnUnhandledPI();
    }

    private void emitBrandingForSource(String commentType, String componentName, String year1, String year2) throws XMLStreamException {
        if (!commentType.equals("css")) {
            this.warnUnhandledPI();
            return;
        }
        this.writer.writeCharacters("\n/********************************");
        this.writer.writeCharacters("\n*  Licensed Materials - Property of IBM");
        this.writer.writeCharacters("\n*  ");
        this.writer.writeCharacters(String.format("\n*  IBM Cognos Products: %s", componentName));
        this.writer.writeCharacters("\n*  ");
        this.writer.writeCharacters(String.format("\n*  (C) Copyright IBM Corp. %s, %s", year1, year2));
        this.writer.writeCharacters("\n*  ");
        this.writer.writeCharacters("\n*  US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.");
        this.writer.writeCharacters("\n********************************/");
        this.writer.writeCharacters("\n");
    }

    private void emitBrandingForCompiled(String commentType, String componentName, String year1, String year2) throws XMLStreamException {
        this.warnUnhandledPI();
    }

    public void setRootPathForIncludes(String includeRootPath) {
        this.includeRootPath = includeRootPath;
    }

    public void setInputStreamRetriever(IInputStreamRetriever inputStreamRetriever) {
        this.inputStreamRetriever = inputStreamRetriever;
    }
}

