/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.skin.tools;

import com.cognos.portal.service.IInputStreamRetriever;
import com.cognos.portal.skin.tools.CSSStylesFunction;
import com.cognos.portal.skin.tools.ISkinFunction;
import com.cognos.portal.skin.tools.Skeleton;
import com.cognos.portal.skin.tools.SkeletonXmlPIFilter;
import com.cognos.portal.skin.tools.SkinParseState;
import com.cognos.portal.skin.tools.SkinValueFunction;
import com.cognos.portal.utils.StringUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class SkinGenerator {
    static List<String> SKELETON_EXTENSIONS = new ArrayList<String>();
    public static final String MACRO_SKIN = "$SKIN$";
    public static final String MACRO_WEB = "$WEB$";
    private Map<String, ISkinFunction> skinFunctionMap = new HashMap<String, ISkinFunction>();
    private Element skinRootElement;
    private boolean isKeepVariableMacro;
    private List<VariableInfo> variableList = new ArrayList<VariableInfo>();
    Map<String, SkinOutput> outputMap;
    private Map<String, String> macros;
    private IInputStreamRetriever inputStreamRetriever = null;
    private String rootPath = null;

    static String expandMacros(String str, Map<String, String> macros) {
        if (macros == null) {
            return str;
        }
        String result = str;
        for (Map.Entry<String, String> mapEntry : macros.entrySet()) {
            String macro = mapEntry.getKey();
            String value = mapEntry.getValue();
            result = StringUtils.replaceMacro(result, macro, value);
        }
        return result;
    }

    SkinGenerator(InputStream skin) {
        this.outputMap = new HashMap<String, SkinOutput>();
        this.loadSkinSpecification(skin);
        this.isKeepVariableMacro = true;
        this.initializeFunctions();
        this.initializeScannerPattern();
        this.macros = new HashMap<String, String>();
    }

    public SkinGenerator(String skin, Map<String, String> macros) throws FileNotFoundException {
        this(new FileInputStream(new File(skin)), macros);
    }

    public SkinGenerator(InputStream skin, Map<String, String> macros) {
        this.macros = macros;
        this.outputMap = new HashMap<String, SkinOutput>();
        this.loadSkinSpecification(skin);
        this.isKeepVariableMacro = false;
        this.initializeFunctions();
        this.initializeScannerPattern();
    }

    public List<VariableInfo> getVariables() {
        return this.variableList;
    }

    private void initializeScannerPattern() {
        StringBuilder builder = new StringBuilder();
        builder.append("\\$(");
        Iterator<String> it = this.skinFunctionMap.keySet().iterator();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append("|");
        }
        builder.append(")\\(([^\\)]*)\\)");
    }

    private void initializeFunctions() {
        ISkinFunction function = new SkinValueFunction();
        function.setMacros(this.macros);
        this.skinFunctionMap.put(function.getName(), function);
        function = new CSSStylesFunction();
        function.setMacros(this.macros);
        this.skinFunctionMap.put(function.getName(), function);
    }

    public void generateOutput(String resourceLocation) throws Exception {
        File resourceDirectory = new File(resourceLocation);
        if (!resourceDirectory.exists()) {
            throw new Exception("Skin resource directory not found: " + resourceDirectory.getAbsolutePath());
        }
        this.scanFolderAndGenerateOutputs(resourceDirectory, "");
    }

    public void generateOutput(String resourceLocation, String outputLocation) throws Exception {
        this.generateOutput(resourceLocation);
        for (Map.Entry<String, SkinOutput> outputEntry : this.outputMap.entrySet()) {
            File file = new File(outputLocation + File.separator + outputEntry.getKey());
            File parent = file.getParentFile();
            parent.mkdirs();
            outputEntry.getValue().writeToFile(file);
        }
    }

    private void scanFolderAndGenerateOutputs(File resource, String outputLocation) throws Exception {
        if (resource.isDirectory()) {
            File[] files;
            for (File file : files = resource.listFiles()) {
                if (file.isDirectory()) {
                    this.scanFolderAndGenerateOutputs(file, outputLocation + File.separator + file.getName());
                    continue;
                }
                this.generateOutput(file, outputLocation);
            }
        } else {
            this.generateOutput(resource, outputLocation);
        }
    }

    public void generateOutput(File skeletonFile, String outputDirectory) throws Exception {
        String fileNameWithoutExtension;
        String extension;
        this.rootPath = skeletonFile.getParent();
        String skeletonFileName = skeletonFile.getName();
        int index = skeletonFileName.lastIndexOf(46);
        if (index != -1) {
            extension = skeletonFileName.substring(index + 1);
            fileNameWithoutExtension = skeletonFileName.substring(0, index);
        } else {
            extension = "";
            fileNameWithoutExtension = skeletonFileName;
        }
        if (!SKELETON_EXTENSIONS.contains(extension)) {
            return;
        }
        StringBuffer result = new StringBuffer();
        String type = this.generateOutputFromSkeleton(new Skeleton(skeletonFile), result);
        this.outputMap.put(outputDirectory + File.separator + fileNameWithoutExtension + "." + type, new TextSkinOutput(result.toString()));
    }

    public String generateOutputFromSkeleton(Skeleton skeleton, StringBuffer sb) throws Exception {
        return this.generateOutputFromResolvedSkeletonXML(this.resolveSkeletonXML(skeleton.getXML()), sb);
    }

    private String resolveSkeletonXML(String xml) {
        if (xml != null) {
            try {
                SkeletonXmlPIFilter filter = new SkeletonXmlPIFilter(xml);
                filter.setRootPathForIncludes(this.rootPath);
                filter.setInputStreamRetriever(this.inputStreamRetriever);
                filter.process();
                return filter.getResult();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private String generateOutputFromResolvedSkeletonXML(String strXml, StringBuffer sb) throws Exception {
        XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(new StringReader(strXml));
        String outputType = null;
        boolean isTopLevelElement = true;
        SkinParseState skinStateMap = new SkinParseState();
        ISkinFunction skinFunction = null;
        while (xsr.hasNext()) {
            int event = xsr.next();
            if (event == 4 || event == 12 || event == 6) {
                String xmlStringFragment = new String(xsr.getTextCharacters(), xsr.getTextStart(), xsr.getTextLength());
                if (skinFunction != null) {
                    xmlStringFragment = skinFunction.parseText(xmlStringFragment, skinStateMap);
                }
                sb.append(xmlStringFragment);
                continue;
            }
            if (event != 1) continue;
            if (isTopLevelElement) {
                isTopLevelElement = false;
                outputType = xsr.getLocalName();
                continue;
            }
            skinStateMap.clearState();
            String name = xsr.getLocalName();
            HashMap<String, String> params = new HashMap<String, String>();
            int attributeCount = xsr.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                params.put(xsr.getAttributeLocalName(i), xsr.getAttributeValue(i));
            }
            skinFunction = this.skinFunctionMap.get(name);
            if (skinFunction == null) continue;
            if (this.isKeepVariableMacro) {
                sb.append(skinFunction.generateSmuVariables(this.skinRootElement, params, skinStateMap, this.variableList));
                continue;
            }
            sb.append(skinFunction.execute(this.skinRootElement, params, skinStateMap));
        }
        return outputType;
    }

    private void loadSkinSpecification(InputStream in) throws RuntimeException {
        SAXReader saxreader = new SAXReader();
        try {
            this.skinRootElement = saxreader.read((Reader)new InputStreamReader(in, "UTF-8")).getRootElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static void displayUsage() {
        System.out.println("Usage Options");
        System.out.println("-src=<Skeleton source folder>");
        System.out.println("-dest=<Output destination folder>");
        System.out.println("-skin=<skin specification>");
    }

    public static void main(String[] args) {
        Map<String, String> params = SkinGenerator.getParameters(args);
        String src = params.get("src");
        String dest = params.get("dest");
        String skin = params.get("skin");
        String skinName = params.get("skinName");
        String webcontent = params.get("webcontent");
        if (!SkinGenerator.validateParameters(src, dest, skin)) {
            return;
        }
        HashMap<String, String> macros = new HashMap<String, String>();
        macros.put(MACRO_SKIN, skinName);
        macros.put(MACRO_WEB, webcontent);
        try {
            SkinGenerator g = new SkinGenerator(skin, macros);
            g.generateOutput(src, dest);
            System.out.println("done");
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("An error occured while generating skin files.");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static boolean validateParameters(String src, String dest, String skin) {
        if (src == null && dest == null && skin == null) {
            SkinGenerator.displayUsage();
            return false;
        }
        if (src == null) {
            System.out.println("Missing skeleton source folder");
            SkinGenerator.displayUsage();
            return false;
        }
        if (dest == null) {
            System.out.println("Missing output destination folder");
            SkinGenerator.displayUsage();
            return false;
        }
        if (skin == null) {
            System.out.println("Missing skin specification");
            SkinGenerator.displayUsage();
            return false;
        }
        return true;
    }

    private static Map<String, String> getParameters(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String s : args) {
            String[] nvp = s.split("=");
            if (nvp.length <= 0) continue;
            String name = nvp[0];
            if (name.startsWith("-")) {
                name = name.substring(1);
            }
            String value = nvp.length > 1 ? nvp[1] : "";
            params.put(name, value);
        }
        return params;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setInputStreamRetriever(IInputStreamRetriever retriever) {
        this.inputStreamRetriever = retriever;
    }

    static {
        SKELETON_EXTENSIONS.add("xml");
    }

    class TextSkinOutput
    implements SkinOutput {
        private String value;

        public TextSkinOutput(String value) {
            this.value = value;
        }

        @Override
        public void writeToFile(File file) throws Exception {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(this.value);
            fileWriter.close();
        }

        @Override
        public byte[] getBytes() {
            try {
                return this.value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    static interface SkinOutput {
        public void writeToFile(File var1) throws Exception;

        public byte[] getBytes();
    }

    static class RGBColor {
        int r;
        int g;
        int b;
        float hOffset;
        float sOffset;
        float vOffset;
        float alpha;

        public RGBColor(String value) {
            this(value, 1.0f);
        }

        public RGBColor(String value, float alpha) {
            this(value, 0.0f, 0.0f, 0.0f, alpha);
        }

        public RGBColor(String value, float hOffset, float sOffset, float vOffset, float alpha) {
            this.r = this.hexToR(value);
            this.g = this.hexToG(value);
            this.b = this.hexToB(value);
            this.hOffset = hOffset;
            this.sOffset = sOffset;
            this.vOffset = vOffset;
            this.alpha = alpha;
        }

        public String toString() {
            return this.getValue(this.r, this.g, this.b, this.hOffset, this.sOffset, this.vOffset, this.alpha);
        }

        private String getValue(int r, int g, int b, float hOffset, float sOffset, float vOffset, float alpha) {
            float[] hsvFromRgb = new float[3];
            Color.RGBtoHSB(r, g, b, hsvFromRgb);
            float f = hOffset = hOffset == 360.0f ? 0.0f : hOffset;
            hsvFromRgb[0] = (double)(hsvFromRgb[0] + hOffset) > 359.0 || (double)(hsvFromRgb[0] + hOffset) < 0.0 ? ((double)hOffset < 0.0 ? hsvFromRgb[0] + (360.0f + hOffset / 360.0f) : hsvFromRgb[0] + (hOffset / 360.0f - 360.0f)) : hsvFromRgb[0] + hOffset / 360.0f;
            hsvFromRgb[1] = (double)(hsvFromRgb[1] + sOffset) > 1.0 || (double)(hsvFromRgb[1] + sOffset) < 0.0 ? (sOffset < 0.0f ? 0.0f : 1.0f) : hsvFromRgb[1] + sOffset;
            hsvFromRgb[2] = (double)(hsvFromRgb[2] + vOffset) > 1.0 || (double)(hsvFromRgb[2] + vOffset) < 0.0 ? (vOffset < 0.0f ? 0.0f : 1.0f) : hsvFromRgb[2] + vOffset;
            Color modifiedColor = Color.getHSBColor(hsvFromRgb[0], hsvFromRgb[1], hsvFromRgb[2]);
            if (alpha >= 1.0f) {
                String rgbHex = Integer.toHexString(modifiedColor.getRGB());
                return "#" + rgbHex.substring(2, rgbHex.length());
            }
            if (alpha == 0.0f) {
                return "transparent";
            }
            return "rgba(" + modifiedColor.getRed() + "," + modifiedColor.getGreen() + "," + modifiedColor.getBlue() + "," + alpha + ")";
        }

        private int hexToR(String color) {
            return Integer.parseInt(this.cutHex(color).substring(0, 2), 16);
        }

        private int hexToG(String color) {
            return Integer.parseInt(this.cutHex(color).substring(2, 4), 16);
        }

        private int hexToB(String color) {
            return Integer.parseInt(this.cutHex(color).substring(4, 6), 16);
        }

        private String cutHex(String color) {
            return color.charAt(0) == '#' ? color.substring(1, 7) : color;
        }
    }

    public static class VariableInfo {
        static int count = 0;
        String id = "id" + count++;
        String functionName;
        Map<String, String> parameters;

        public VariableInfo(String functionName, Map<String, String> parameters) {
            this.functionName = functionName;
            this.parameters = parameters;
        }
    }
}

