/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.skin.tools;

import com.cognos.portal.skin.tools.CssUtils;
import com.cognos.portal.skin.tools.ISkinFunction;
import com.cognos.portal.skin.tools.SkinGenerator;
import com.cognos.portal.skin.tools.SkinParseState;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;

class SkinValueFunction
implements ISkinFunction {
    private Map<String, String> macros;

    SkinValueFunction() {
    }

    @Override
    public String execute(Element skinRootElement, Map<String, String> parameters, SkinParseState stateMap) {
        return this.executeImpl(skinRootElement, parameters, stateMap, null);
    }

    @Override
    public String generateSmuVariables(Element skinRootElement, Map<String, String> parameters, SkinParseState stateMap, List<SkinGenerator.VariableInfo> variables) {
        return this.executeImpl(skinRootElement, parameters, stateMap, variables);
    }

    @Override
    public String getName() {
        return "skinValue";
    }

    private String executeImpl(Element skinRootElement, Map<String, String> parameters, SkinParseState stateMap, List<SkinGenerator.VariableInfo> variables) {
        Node node;
        String useVariable = null;
        if (variables != null) {
            SkinGenerator.VariableInfo vi = new SkinGenerator.VariableInfo(this.getName(), parameters);
            variables.add(vi);
            useVariable = "#" + vi.id;
        }
        String value = null;
        String path = parameters.get("path");
        if (path != null && (node = skinRootElement.selectSingleNode(path)) != null) {
            if (node.getNodeType() == 1) {
                Element e = (Element)node;
                String colorRef = e.attributeValue("ref");
                if (colorRef != null) {
                    HashSet<String> referenceChain = new HashSet<String>();
                    referenceChain.add(path);
                    value = useVariable != null ? useVariable : CssUtils.getColor(e, skinRootElement, referenceChain);
                } else if (CssUtils.isImageElement(e)) {
                    value = "none";
                    if (variables == null) {
                        String imageCss = CssUtils.getImageCss(e, skinRootElement, this.macros, parameters);
                        stateMap.setStateValue("additionalCss", imageCss);
                    } else {
                        StringBuilder additionalStyles = new StringBuilder();
                        additionalStyles.append("\n\tbackground-image: ");
                        additionalStyles.append(useVariable);
                        additionalStyles.append(";\n");
                        stateMap.setStateValue("additionalCss", additionalStyles.toString());
                    }
                }
            }
            if (value == null) {
                String string = value = useVariable != null ? useVariable : SkinGenerator.expandMacros(node.getText(), this.macros);
            }
        }
        if (value == null) {
            value = useVariable != null ? useVariable : "#FF0000";
        }
        return value;
    }

    @Override
    public void setMacros(Map<String, String> macros) {
        this.macros = macros;
    }

    @Override
    public String parseText(String xmlStringFragment, SkinParseState stateMap) {
        if (stateMap.getStateValue("additionalCss") == null) {
            return xmlStringFragment;
        }
        boolean containsSemiColon = xmlStringFragment.contains(";");
        if (containsSemiColon) {
            String cssValue = stateMap.getStateValue("additionalCss");
            int indexOfSemiColon = xmlStringFragment.indexOf(";");
            StringBuffer xmlSb = new StringBuffer(xmlStringFragment);
            xmlSb.insert(indexOfSemiColon + 1, "\n" + cssValue);
            stateMap.clearState();
            return xmlSb.toString();
        }
        return xmlStringFragment;
    }
}

