/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.skin.upgrade;

import com.cognos.portal.skin.upgrade.Utils;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class PaletteChecker {
    public void checkSkin(String skinPath) throws FileNotFoundException {
        System.out.println("Skin path: " + skinPath);
        Document skin = Utils.loadDoc(new FileReader(skinPath));
        this.listDuplicatecolours(skin);
        this.listUnusedColours(skin);
    }

    private List selectNodes(Document doc, String xPath) {
        return doc.selectNodes(xPath);
    }

    private void listDuplicatecolours(Document skin) {
        List namedColorNodes = this.selectNodes(skin, "/uiSkin/namedColors/namedColor");
        HashSet<String> uniqueColours = new HashSet<String>();
        for (Element color : namedColorNodes) {
            String colourValue = color.attributeValue("value");
            if (uniqueColours.contains(colourValue)) {
                System.out.println("\tW: Duplicate color: " + color.attributeValue("name"));
                continue;
            }
            uniqueColours.add(colourValue);
        }
    }

    private void listUnusedColours(Document skin) {
        Set<String> paletteColours = this.getUniquePaletteColours(skin);
        Set<String> referencedColours = this.getReferencedColours(skin);
        paletteColours.removeAll(referencedColours);
        if (!paletteColours.isEmpty()) {
            for (String colour : paletteColours) {
                System.out.println("\tW: Unreferenced Color:" + colour);
            }
        }
    }

    private Set<String> getReferencedColours(Document skin) {
        HashSet<String> referencedColours = new HashSet<String>();
        List colorNodes = this.selectNodes(skin, "/uiSkin//color[starts-with(@ref,'/uiSkin/namedColors')]");
        for (Element color : colorNodes) {
            String colorRef = color.attributeValue("ref");
            Node namedColor = skin.selectSingleNode(colorRef);
            if (namedColor == null || namedColor.getNodeType() != 1 || !namedColor.getName().equals("namedColor")) {
                System.out.println("\tE: Invalid reference: " + colorRef);
                continue;
            }
            referencedColours.add(((Element)namedColor).attributeValue("name"));
        }
        return referencedColours;
    }

    private Set<String> getUniquePaletteColours(Document skin) {
        HashSet<String> paletteColours = new HashSet<String>();
        List namedColorNodes = this.selectNodes(skin, "/uiSkin/namedColors/namedColor");
        for (Element color : namedColorNodes) {
            paletteColours.add(color.attribute("name").getValue());
        }
        return paletteColours;
    }

    public static void main(String[] args) {
        try {
            PaletteChecker colorChecker = new PaletteChecker();
            colorChecker.checkSkin("themes/business.xml");
            colorChecker.checkSkin("themes/classic.xml");
            colorChecker.checkSkin("themes/contemporary.xml");
            colorChecker.checkSkin("themes/corporate.xml");
            colorChecker.checkSkin("themes/modern.xml");
            colorChecker.checkSkin("themes/presentation.xml");
            colorChecker.checkSkin("themes/business_old.xml");
            colorChecker.checkSkin("themes/classic_old.xml");
            colorChecker.checkSkin("themes/contemporary_old.xml");
            colorChecker.checkSkin("themes/corporate_old.xml");
            colorChecker.checkSkin("themes/modern_old.xml");
            colorChecker.checkSkin("themes/presentation_old.xml");
            System.out.println("Done checking skins.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

