/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.skin.upgrade;

import com.cognos.portal.skin.upgrade.Utils;
import com.cognos.portal.utils.StringUtils;
import java.io.Reader;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class SkinConverter {
    private static final String MACRO_VALUE = "$value$";
    private Document skinUpgradeMapping = null;
    private Document skinTemplate = null;
    private Document oldSkin = null;
    private Document newSkin = null;

    public SkinConverter(Reader skinUpgradeMapping, Reader skinTemplate) {
        this.skinUpgradeMapping = Utils.loadDoc(skinUpgradeMapping);
        this.skinTemplate = Utils.loadDoc(skinTemplate);
    }

    public String convertSkinString(String skin) {
        this.oldSkin = Utils.loadDocFromString(skin);
        this.newSkin = (Document)this.skinTemplate.clone();
        this.doConversion();
        return this.newSkin.asXML();
    }

    private void doConversion() {
        this.copyCommonAttributes();
        this.copyPalette2NamedColors();
        this.copyMappedItems();
    }

    private void copyCommonAttributes() {
        String name;
        Element oldSkinRootElement = this.oldSkin.getRootElement();
        String baseSkin = oldSkinRootElement.attributeValue("overrides");
        Element newSkinRootElement = this.newSkin.getRootElement();
        if (baseSkin != null) {
            newSkinRootElement.addAttribute("overrides", baseSkin);
        }
        if ((name = oldSkinRootElement.attributeValue("name")) != null) {
            newSkinRootElement.addAttribute("name", name);
        }
    }

    private List selectNodes(Document doc, String xPath) {
        return doc.selectNodes(xPath);
    }

    private void copyPalette2NamedColors() {
        Element namedColorElement = (Element)this.newSkin.selectSingleNode("/uiSkin/namedColors");
        if (namedColorElement != null) {
            List oldSkinColorList = this.selectNodes(this.oldSkin, "/skin/palette/color");
            namedColorElement.clearContent();
            Element nameColorTemplate = this.createNamedColorTemplate();
            for (Element colorElement : oldSkinColorList) {
                String colorName = colorElement.attribute("name").getValue();
                String colorValue = colorElement.getText();
                Element newNamedColor = (Element)nameColorTemplate.clone();
                newNamedColor.attribute("name").setValue(colorName);
                newNamedColor.attribute("value").setValue(colorValue);
                namedColorElement.add(newNamedColor);
            }
            String skinName = this.extractCurrentSkin();
            if (skinName != null) {
                List newColors = this.selectNodes(this.skinUpgradeMapping, "/skinUpgrade/skinPalette[@skinName='" + skinName + "']/namedColor");
                for (Element colorElement : newColors) {
                    namedColorElement.add((Element)colorElement.clone());
                }
            }
        }
    }

    private void copyMappedItems() {
        List mappingItems = this.selectNodes(this.skinUpgradeMapping, "/skinUpgrade/item");
        for (Element mappingElement : mappingItems) {
            Node oldSkinNode;
            String oldXpath;
            String newValue = this.extractOverrideNewValue(mappingElement);
            if (newValue == null && (oldXpath = mappingElement.attributeValue("oldXpath")) != null && (oldSkinNode = this.oldSkin.selectSingleNode(oldXpath)) != null) {
                newValue = oldSkinNode.getText();
            }
            if (newValue == null) continue;
            String newValuePattern = mappingElement.attributeValue("newValue");
            if (newValuePattern == null) {
                newValuePattern = MACRO_VALUE;
            }
            newValue = StringUtils.replaceMacro(newValuePattern, MACRO_VALUE, newValue);
            String newXpathValue = mappingElement.attributeValue("newXpath");
            Node valueNode = this.newSkin.selectSingleNode(newXpathValue);
            if (valueNode == null) continue;
            valueNode.setText(newValue);
        }
    }

    private String extractOverrideNewValue(Element mappingElement) {
        String result = null;
        List mappingChildren = mappingElement.elements("override");
        if (mappingChildren != null && mappingChildren.size() > 0) {
            String currentSkin = this.extractCurrentSkin();
            for (Element overrideElement : mappingChildren) {
                String overrideSkin = overrideElement.attributeValue("skin");
                if (overrideSkin == null || !overrideSkin.equalsIgnoreCase(currentSkin)) continue;
                result = overrideElement.attributeValue("newValue");
                break;
            }
        }
        return result;
    }

    private String extractCurrentSkin() {
        String result = null;
        Element skinElement = (Element)this.oldSkin.selectSingleNode("/skin");
        if (skinElement != null) {
            if (skinElement.attributeValue("overrides") != null) {
                result = skinElement.attributeValue("overrides");
            } else if (skinElement.attributeValue("name") != null) {
                result = skinElement.attributeValue("name");
            }
        }
        return result;
    }

    private Element createNamedColorTemplate() {
        Element result = DocumentHelper.createElement((String)"namedColor");
        result.addAttribute("name", "");
        result.addAttribute("value", "");
        return result;
    }
}

