/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.skin.upgrade;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.service.IInputStreamRetriever;
import com.cognos.portal.skin.upgrade.ISkinUpgrade;
import com.cognos.portal.skin.upgrade.SkinUpgradeException;
import com.cognos.portal.skin.upgrade.Utils;
import com.cognos.portal.skin.upgrade.impl.GenericUpgrade;
import com.cognos.portal.skin.upgrade.impl.Version1To2Upgrade;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Document;

public class UpgradeManager {
    private List<ISkinUpgrade> skinUpgrades = new ArrayList<ISkinUpgrade>();
    private final ServiceLogger serviceLogger = new ServiceLoggerImpl(UpgradeManager.class);
    private IInputStreamRetriever resourceReader;

    public UpgradeManager(IInputStreamRetriever resourceReader) {
        this.resourceReader = resourceReader;
    }

    public void registerUpgrade(ISkinUpgrade upgrade) {
        this.skinUpgrades.add(upgrade);
    }

    public IInputStreamRetriever getResourceLoader() {
        return this.resourceReader;
    }

    public String upgrade(String spec, double targetVersion) throws SkinUpgradeException {
        double version = this.getSkinVersion(spec);
        String upgradedSpec = spec;
        ISkinUpgrade currentUpgrade = null;
        while ((currentUpgrade = this.getUpgradeHandler(version, targetVersion)) != null) {
            upgradedSpec = currentUpgrade.upgrade(upgradedSpec);
            if (!((version = currentUpgrade.getTargetVersion(version)) >= targetVersion)) continue;
            return upgradedSpec;
        }
        return null;
    }

    protected ISkinUpgrade getUpgradeHandler(double version, double targetVersion) {
        for (ISkinUpgrade upgrade : this.skinUpgrades) {
            double newVersion = upgrade.getTargetVersion(version);
            if (!upgrade.canUpgrade(version) || !(newVersion > version) || !(newVersion <= targetVersion)) continue;
            return upgrade;
        }
        return null;
    }

    double getSkinVersion(String spec) throws SkinUpgradeException {
        double version = 0.0;
        try {
            XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(new StringReader(spec));
            if (StaxUtils.moveToNextElement(xsr)) {
                String tagName;
                String versionString = xsr.getAttributeValue("", "version");
                version = versionString != null ? Double.parseDouble(versionString) : ("uiSkin".equals(tagName = xsr.getLocalName()) ? 2.0 : 1.0);
            }
        }
        catch (Exception e) {
            if (this.serviceLogger.isErrorEnabled()) {
                this.serviceLogger.error("Error while extracting version from spec: " + spec, e);
            }
            throw new SkinUpgradeException("pf.skin.read.error", e);
        }
        return version;
    }

    public static void registerDefaultUpgrade(UpgradeManager manager) {
        manager.registerUpgrade(new Version1To2Upgrade(manager.getResourceLoader()));
        manager.registerUpgrade(new GenericUpgrade(manager.getResourceLoader()));
    }

    private void convertSkin(String oldSkinName, String newSkinName) throws FileNotFoundException, SkinUpgradeException {
        Document oldSkin = Utils.loadDoc(new FileReader(oldSkinName));
        String upgraded = this.upgrade(oldSkin.asXML(), 2.1);
        Document newSkin = Utils.loadDocFromString(upgraded);
        Utils.saveDoc(newSkin, newSkinName);
    }

    public static void main(String[] args) {
        try {
            UpgradeManager um = new UpgradeManager(new IInputStreamRetriever(){

                @Override
                public InputStream getInputStreamFromResource(String resource) throws IOException {
                    return new FileInputStream(resource);
                }
            });
            UpgradeManager.registerDefaultUpgrade(um);
            um.convertSkin("skins/business.xml", "themes/business_old.xml");
            um.convertSkin("skins/classic.xml", "themes/classic_old.xml");
            um.convertSkin("skins/contemporary.xml", "themes/contemporary_old.xml");
            um.convertSkin("skins/modern.xml", "themes/modern_old.xml");
            um.convertSkin("skins/presentation.xml", "themes/presentation_old.xml");
            um.convertSkin("skins/corporate.xml", "themes/corporate_old.xml");
            System.out.println("Done upgrading 1.0 skins.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

