/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.skin.upgrade.common;

import com.cognos.portal.service.IInputStreamRetriever;
import com.cognos.portal.skin.upgrade.SkinUpgradeException;
import com.cognos.portal.skin.upgrade.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class UpgradeTool {
    private IInputStreamRetriever resourceLoader;

    public UpgradeTool(IInputStreamRetriever resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public boolean canUpgradeVersion(double version) {
        try {
            InputStream is = this.getUpgradeSpecInputStream(String.valueOf(version));
            return is != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public double getUpgradeTargetVersion(double version) {
        try {
            Document upgradeSpec = this.getUpgradeSpec(String.valueOf(version));
            String versionString = this.getTargetVersion(upgradeSpec);
            return Double.parseDouble(versionString);
        }
        catch (SkinUpgradeException skinUpgradeException) {
            return version;
        }
    }

    public String upgrade(String skinSpec) throws SkinUpgradeException {
        Document skinRoot = Utils.loadDocFromString(skinSpec);
        Document latestBaseSkin = this.getLatestBaseSkin(skinRoot);
        Document upgradeSpec = this.getUpgradeSpec(skinRoot);
        this.updateVersion(skinRoot, upgradeSpec);
        this.addNewPaletteColors(latestBaseSkin, skinRoot);
        this.addNewElements(skinRoot, latestBaseSkin, upgradeSpec);
        this.renameElements(skinRoot, upgradeSpec);
        this.deleteElements(skinRoot, upgradeSpec);
        this.updateElement(skinRoot, upgradeSpec);
        return skinRoot.asXML();
    }

    private InputStream getUpgradeSpecInputStream(String version) throws IOException {
        return this.resourceLoader.getInputStreamFromResource("upgrade/" + version + "/upgradeSpec.xml");
    }

    private void updateElement(Document skinRoot, Document upgradeSpec) {
        List updateOps = upgradeSpec.selectNodes("/upgradeSpec/operations/update");
        for (Element updateOp : updateOps) {
            String path = updateOp.attributeValue("path");
            String select = updateOp.attributeValue("select");
            Node node = skinRoot.selectSingleNode(path);
            if (node == null || select == null) continue;
            String newValue = skinRoot.valueOf(select);
            node.setText(newValue);
        }
    }

    private void renameElements(Document skinRoot, Document upgradeSpec) {
        List renameOps = upgradeSpec.selectNodes("/upgradeSpec/operations/rename");
        for (Element renameOp : renameOps) {
            String path = renameOp.attributeValue("path");
            Node node = skinRoot.selectSingleNode(path);
            String newName = renameOp.attributeValue("newName");
            if (node == null || newName == null || newName.isEmpty()) continue;
            node.setName(newName);
            String newPath = node.getPath();
            this.updateReferences(skinRoot, path, newPath);
        }
    }

    private void updateReferences(Document skinRoot, String oldPath, String newPath) {
        List affectedReferences = skinRoot.selectNodes("//*[@ref='" + oldPath + "']/@ref");
        for (Attribute affectedReference : affectedReferences) {
            affectedReference.setText(newPath);
        }
    }

    private void deleteElements(Document skinRoot, Document upgradeSpec) {
        List deleteOps = upgradeSpec.selectNodes("/upgradeSpec/operations/delete");
        for (Element deleteOp : deleteOps) {
            String replacementPath;
            String path = deleteOp.attributeValue("path");
            Node node = skinRoot.selectSingleNode(path);
            if (node != null) {
                node.detach();
            }
            if ((replacementPath = deleteOp.attributeValue("replacement")) == null) continue;
            this.updateReferences(skinRoot, path, replacementPath);
        }
    }

    private void addNewElements(Document skinRoot, Document latestBaseSkin, Document upgradeSpec) {
        List addOps = upgradeSpec.selectNodes("/upgradeSpec/operations/add");
        for (Element addOp : addOps) {
            List originalElementList;
            int index;
            String parentPath;
            Element targetParent;
            boolean alreadyExists;
            String path = addOp.attributeValue("path");
            Node node = latestBaseSkin.selectSingleNode(path);
            boolean bl = alreadyExists = skinRoot.selectSingleNode(path) != null;
            if (node == null || alreadyExists || (targetParent = (Element)skinRoot.selectSingleNode(parentPath = path.substring(0, path.lastIndexOf(47)))) == null) continue;
            boolean isInserted = false;
            if (node instanceof Element && (index = (originalElementList = node.getParent().elements()).indexOf(node)) != -1) {
                targetParent.elements().add(index, (Element)node.clone());
                isInserted = true;
            }
            if (isInserted) continue;
            targetParent.add((Node)node.clone());
        }
    }

    private void updateVersion(Document skinRoot, Document upgradeSpec) throws SkinUpgradeException {
        String version = this.getTargetVersion(upgradeSpec);
        if (version.length() == 0) {
            throw new SkinUpgradeException("pf.skin.upgrade.invalid.spec");
        }
        skinRoot.getRootElement().addAttribute("version", version);
    }

    private String getTargetVersion(Document upgradeSpec) {
        String version = upgradeSpec.valueOf("/upgradeSpec/target/version");
        return version;
    }

    private Document getUpgradeSpec(Document skinRoot) throws SkinUpgradeException {
        String version = skinRoot.getRootElement().attributeValue("version");
        if (version == null || version.length() == 0) {
            version = "2.0";
        }
        return this.getUpgradeSpec(version);
    }

    private Document getUpgradeSpec(String version) throws SkinUpgradeException {
        try {
            InputStream is = this.getUpgradeSpecInputStream(version);
            if (is == null) {
                throw new SkinUpgradeException("pf.skin.upgrade.spec.read.error");
            }
            return Utils.loadDoc(new InputStreamReader(is, "UTF-8"));
        }
        catch (IOException e) {
            throw new SkinUpgradeException("pf.skin.upgrade.spec.read.error", e);
        }
    }

    private void addNewPaletteColors(Document source, Document target) {
        List nodes = source.selectNodes("/uiSkin/namedColors/namedColor");
        Iterator it = nodes.iterator();
        Element targetColors = (Element)target.selectSingleNode("/uiSkin/namedColors");
        if (targetColors != null) {
            while (it.hasNext()) {
                Element colorElement = (Element)it.next();
                String colorName = colorElement.attributeValue("name");
                Node targetColor = targetColors.selectSingleNode("namedColor[@name='" + colorName + "']");
                if (targetColor != null) continue;
                targetColors.add(colorElement.createCopy());
            }
        }
    }

    private Document getLatestBaseSkin(Document skinRoot) throws SkinUpgradeException {
        try {
            InputStream is;
            String baseSkin = this.getBaseSkin(skinRoot);
            try {
                is = this.resourceLoader.getInputStreamFromResource("themes/" + baseSkin + ".xml");
            }
            catch (Exception e) {
                is = null;
            }
            if (is == null) {
                is = this.resourceLoader.getInputStreamFromResource("themes/corporate.xml");
            }
            if (is == null) {
                throw new SkinUpgradeException("pf.skin.read.error");
            }
            return Utils.loadDoc(new InputStreamReader(is, "UTF-8"));
        }
        catch (IOException e) {
            throw new SkinUpgradeException("pf.skin.read.error", e);
        }
    }

    private String getBaseSkin(Document skinRoot) {
        String baseSkin = skinRoot.getRootElement().attributeValue("overrides");
        if (baseSkin == null || baseSkin.length() == 0) {
            baseSkin = "corporate";
        }
        return baseSkin;
    }
}

