/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.skin.upgrade.impl;

import com.cognos.portal.service.IInputStreamRetriever;
import com.cognos.portal.skin.upgrade.ISkinUpgrade;
import com.cognos.portal.skin.upgrade.SkinConverter;
import com.cognos.portal.skin.upgrade.SkinUpgradeException;
import java.io.InputStreamReader;

public class Version1To2Upgrade
implements ISkinUpgrade {
    private IInputStreamRetriever resouceReader;

    public Version1To2Upgrade(IInputStreamRetriever resouceReader) {
        this.resouceReader = resouceReader;
    }

    @Override
    public boolean canUpgrade(double version) {
        return version < 2.0;
    }

    @Override
    public double getTargetVersion(double version) {
        if (this.canUpgrade(version)) {
            return 2.0;
        }
        return version;
    }

    @Override
    public String upgrade(String spec) throws SkinUpgradeException {
        try {
            InputStreamReader templateReader = new InputStreamReader(this.resouceReader.getInputStreamFromResource("upgrade/1.0/upgrade_template.xml"), "UTF-8");
            InputStreamReader mappingReader = new InputStreamReader(this.resouceReader.getInputStreamFromResource("upgrade/1.0/skin_upgrade_mapping.xml"), "UTF-8");
            SkinConverter skinConverter = new SkinConverter(mappingReader, templateReader);
            return skinConverter.convertSkinString(spec);
        }
        catch (Exception e) {
            throw new SkinUpgradeException("pf.skin.upgrade.error", new String[]{"1", "2"}, e);
        }
    }
}

