/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.soap.impl;

import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.soap.impl.SOAPConnectionImpl;
import com.cognos.portal.utils.EnhancedIOException;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import javax.xml.stream.XMLStreamException;

public class BusConnectionImpl
extends SOAPConnectionImpl {
    public static String BUS_DISPATCHER = "bus://dispatcher";
    public static String BUS_CM = "bus://cm";
    private ServiceLogger logger;
    private ServerConnection conn;
    private String cmPath;
    private String dispatcherPath;

    public BusConnectionImpl(ServiceLogger logger, String cmPath, String dispatcherPath) {
        super(logger);
        this.cmPath = cmPath;
        this.dispatcherPath = dispatcherPath;
        this.logger = logger != null ? logger.cloneForClass(BusConnectionImpl.class) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final SOAPMessage message, String urlString) throws MalformedURLException, SOAPFault, IOException, XMLStreamException {
        String url;
        Object executeTimer = null;
        if (urlString.startsWith(BUS_DISPATCHER)) {
            if (this.logger.isPerfLevelEnabled(1)) {
                executeTimer = this.logger.startTimer(1, "execute", BUS_DISPATCHER, null);
            }
            this.conn = DispatcherConnectionManager.getLocalDispatcherConnection();
            url = this.dispatcherPath + urlString.substring(BUS_DISPATCHER.length());
        } else if (urlString.startsWith(BUS_CM)) {
            if (this.logger.isPerfLevelEnabled(1)) {
                executeTimer = this.logger.startTimer(1, "execute", BUS_CM, null);
            }
            this.conn = DispatcherConnectionManager.getContentManagerConnection();
            url = this.cmPath + urlString.substring(BUS_CM.length());
        } else {
            super.execute(message, urlString);
            return;
        }
        String soapAction = message.getSOAPAction();
        if (soapAction != null) {
            this.conn.setRequestHeader("SOAPAction", soapAction);
        }
        this.conn.addRequestHeader("Content-Type", "text/xml; charset=utf-8");
        this.conn.addRequestHeader("Connection", "Keep-Alive");
        this.conn.setRequestBodySource(new MsgBodyGenerator(){

            public boolean rewind() {
                return false;
            }

            public void writeBody(OutputStream os) throws IOException {
                BufferedWriter writerOutput = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                BusConnectionImpl.this.writeRequest(message, writerOutput, true);
                ((Writer)writerOutput).flush();
            }
        });
        this.logRequest(message);
        try {
            Object sendRequestTimer = null;
            if (this.logger.isPerfLevelEnabled(1)) {
                sendRequestTimer = this.logger.startTimer(1, "execute", "Send SOAP Request", null);
            }
            int result = this.conn.sendRequest(url);
            if (sendRequestTimer != null) {
                this.logger.stopTimer(sendRequestTimer);
            }
            BufferedInputStream input = new BufferedInputStream(this.conn.getInputStream(), 4096);
            if (result >= 400 && result != 500) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.error("SOAP Connection response code: " + result);
                }
                throw new EnhancedIOException("error", new String[]{new String(result + " : " + this.conn.getStatusText()), this.conn.getStatusText()});
            }
            String contentTypeValue = this.conn.getResponseContentType();
            this.processResponse(message, input, contentTypeValue);
        }
        finally {
            this.disconnect();
            if (executeTimer != null) {
                this.logger.stopTimer(executeTimer);
            }
        }
    }

    @Override
    public void disconnect() {
        this.conn.release();
    }
}

