/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.soap.impl;

import com.cognos.pogo.http.mime.MIMEPartParser;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.soap.IAttachmentHandler;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionProperties;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.EnhancedIOException;
import com.cognos.portal.utils.ThreadLocalPropertyManager;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.stream.IsolatedXMLStreamReader;
import com.cognos.portal.xml.stream.PathIterator;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class SOAPConnectionImpl
extends SOAPConnection {
    public static final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    public static final String SOAP_ENV_OPEN = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">";
    public static final String SOAP_ENV_CLOSE = "</SOAP-ENV:Envelope>";
    public static final String SOAP_BODY_OPEN = "<SOAP-ENV:Body>";
    public static final String SOAP_BODY_CLOSE = "</SOAP-ENV:Body>";
    public static final String SOAP_HEADER_OPEN = "<SOAP-ENV:Header>";
    public static final String SOAP_HEADER_CLOSE = "</SOAP-ENV:Header>";
    protected HttpURLConnection m_connection;
    protected PipelineContext context;
    private ServiceLogger logger;
    protected static final String CONTENT_TYPE = "content-type";
    protected static final String MULTIPART_MIME_TYPE = "multipart/related";

    public SOAPConnectionImpl(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(SOAPConnectionImpl.class, "soap") : null;
    }

    @Override
    public void execute(SOAPMessage message, String urlString) throws MalformedURLException, SOAPFault, IOException, XMLStreamException {
        InputStream input;
        Object executeTimer;
        block9: {
            executeTimer = null;
            if (this.logger.isPerfLevelEnabled(1)) {
                executeTimer = this.logger.startTimer(1, "execute", urlString, null);
            }
            URL url = new URL(urlString);
            this.m_connection = (HttpURLConnection)url.openConnection();
            this.m_connection.setRequestMethod("POST");
            this.m_connection.setUseCaches(true);
            this.m_connection.setDoOutput(true);
            this.m_connection.setDoInput(true);
            this.m_connection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            String soapAction = message.getSOAPAction();
            if (soapAction != null) {
                this.m_connection.setRequestProperty("SOAPAction", soapAction);
            }
            Object sendRequestTimer = null;
            if (this.logger.isPerfLevelEnabled(1)) {
                sendRequestTimer = this.logger.startTimer(1, "execute", "Send SOAP Request", null);
            }
            OutputStream output = this.m_connection.getOutputStream();
            BufferedWriter writerOutput = new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
            this.writeRequest(message, writerOutput, true);
            ((Writer)writerOutput).flush();
            output.close();
            if (sendRequestTimer != null) {
                this.logger.stopTimer(sendRequestTimer);
            }
            this.logRequest(message);
            input = null;
            try {
                input = new BufferedInputStream(this.m_connection.getInputStream(), 4096);
            }
            catch (IOException e) {
                input = this.m_connection.getErrorStream();
                if (input != null) break block9;
                throw e;
            }
        }
        if (this.m_connection.getResponseCode() >= 400 && this.m_connection.getResponseCode() != 500) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error("SOAP Connection response code: " + this.m_connection.getResponseCode());
            }
            throw new EnhancedIOException("error", new String[]{new String(this.m_connection.getResponseCode() + " : " + this.m_connection.getResponseMessage()), this.m_connection.getResponseMessage()});
        }
        String contentTypeValue = this.m_connection.getHeaderField(CONTENT_TYPE);
        this.processResponse(message, input, contentTypeValue);
        if (executeTimer != null) {
            this.logger.stopTimer(executeTimer);
        }
    }

    protected void processResponse(SOAPMessage message, InputStream input, String contentTypeValue) throws IOException, SOAPFault, XMLStreamException {
        Object processResponse = null;
        if (this.logger.isPerfLevelEnabled(1)) {
            processResponse = this.logger.startTimer(1, "processResponse", "process SOAP Response", null);
        }
        input = this.logResponse(input, contentTypeValue);
        if (contentTypeValue.regionMatches(true, 0, MULTIPART_MIME_TYPE, 0, MULTIPART_MIME_TYPE.length())) {
            String multiPartBoundary = MIMEPartParser.getBoundaryFromContentType((String)contentTypeValue);
            MIMEPartParser it = new MIMEPartParser(input, multiPartBoundary);
            if (it.hasNext()) {
                input = (InputStream)it.next();
                this.advanceHeaders(input);
                this.readResponse(input, message);
                while (it.hasNext()) {
                    input = (InputStream)it.next();
                    IAttachmentHandler handler = message.getResponseAttachmentHandler();
                    if (handler == null) continue;
                    handler.handle(input, this.advanceHeaders(input));
                }
            }
        } else {
            this.readResponse(input, message);
        }
        if (processResponse != null) {
            this.logger.stopTimer(processResponse);
        }
    }

    protected InternetHeaders advanceHeaders(InputStream input) throws IOException {
        try {
            return new InternetHeaders(input);
        }
        catch (MessagingException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    protected void readResponse(InputStream in, SOAPMessage message) throws IOException, SOAPFault, XMLStreamException {
        int index;
        XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(in, "UTF-8");
        String[] pathArray = new String[]{"/Envelope/Header", "/Envelope/Body", "/Envelope/Body/Fault"};
        PathIterator pathIterator = new PathIterator(xsr, pathArray);
        while ((index = pathIterator.moveToNextPath()) != -1) {
            switch (index) {
                case 0: {
                    IXMLHandler handler = message.getResponseHeaderHandler();
                    if (handler == null) break;
                    IsolatedXMLStreamReader isolatedReader = new IsolatedXMLStreamReader(pathIterator);
                    handler.handle(isolatedReader);
                    break;
                }
                case 1: {
                    if (1 != pathIterator.nextTag()) break;
                    if ("Fault".equals(pathIterator.getLocalName())) {
                        this.handleFault(message, pathIterator);
                        return;
                    }
                    IXMLHandler handler = message.getResponseBodyHandler();
                    if (handler == null) break;
                    IsolatedXMLStreamReader isolatedReader = new IsolatedXMLStreamReader(pathIterator);
                    handler.handle(isolatedReader);
                    break;
                }
                case 2: {
                    this.handleFault(message, pathIterator);
                    return;
                }
            }
        }
    }

    void handleFault(SOAPMessage message, PathIterator pathIterator) throws XMLStreamException, SOAPFault {
        int i;
        IXMLHandler handler = message.getResponseFaultHandler();
        if (handler != null) {
            IsolatedXMLStreamReader isolatedReader = new IsolatedXMLStreamReader(pathIterator);
            handler.handle(isolatedReader);
            return;
        }
        String faultCode = null;
        String faultString = null;
        String faultDetail = null;
        String[] faultElements = new String[]{"/Envelope/Body/Fault/faultcode", "/Envelope/Body/Fault/faultstring", "/Envelope/Body/Fault/faultdetail", "/Envelope/Body/Fault/detail"};
        while ((i = pathIterator.moveToNextPath(faultElements)) != -1) {
            switch (i) {
                case 0: {
                    faultCode = pathIterator.getElementText();
                    break;
                }
                case 1: {
                    faultString = pathIterator.getElementText();
                    break;
                }
                case 2: 
                case 3: {
                    StringWriter writer = new StringWriter();
                    XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(writer);
                    xsw.writeStartElement("detail");
                    StaxUtils.copyChildren(pathIterator, xsw);
                    xsw.writeEndElement();
                    xsw.close();
                    faultDetail = writer.getBuffer().toString();
                }
            }
        }
        SOAPFault fault = new SOAPFault();
        fault.setFaultCode(new QName("", faultCode));
        fault.setFaultString(faultString);
        fault.setDetail(faultDetail);
        throw fault;
    }

    @Override
    public void disconnect() {
        this.m_connection.disconnect();
    }

    protected void writeRequest(SOAPMessage requestMsg, Writer output, boolean includeXmlProlog) throws IOException {
        if (includeXmlProlog) {
            output.write(XML_PROLOG);
        }
        output.write(SOAP_ENV_OPEN);
        output.write(SOAP_HEADER_OPEN);
        requestMsg.writeHeaders(output);
        output.write(SOAP_HEADER_CLOSE);
        output.write(SOAP_BODY_OPEN);
        requestMsg.writeBody(output);
        output.write(SOAP_BODY_CLOSE);
        output.write(SOAP_ENV_CLOSE);
        output.flush();
    }

    protected void logRequest(SOAPMessage message) throws IOException, XMLStreamException {
        this.context = (PipelineContext)ThreadLocalPropertyManager.get(SOAPConnectionProperties.PROP_PIPELINE_CONTEXT);
        if (this.logger.isDebugEnabled() || this.context != null && this.context.isDebugMode()) {
            StringWriter writer = new StringWriter();
            this.writeRequest(message, writer, true);
            writer.write("\n");
            writer.flush();
            String request = writer.toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SOAP Request:\n" + request);
            }
            if (this.context != null && this.context.isDebugMode()) {
                this.context.addTraceXML("soap_request", XMLStreamFactory.createXMLStreamReader(new StringReader(request)));
            }
        }
    }

    private InputStream logResponse(InputStream input, String contentTypeValue) throws IOException, XMLStreamException {
        if (this.logger.isDebugEnabled() || this.context != null && this.context.isDebugMode()) {
            ByteArrayOutputStream bio = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int bytesRead = input.read(buf, 0, 4096);
            while (bytesRead != -1) {
                bio.write(buf, 0, bytesRead);
                bytesRead = input.read(buf, 0, 4096);
            }
            byte[] response = bio.toByteArray();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SOAP Response:\n" + new String(response));
            }
            if (this.context != null && this.context.isDebugMode()) {
                if (contentTypeValue.regionMatches(true, 0, MULTIPART_MIME_TYPE, 0, MULTIPART_MIME_TYPE.length())) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("<response_attachment>");
                    buffer.append("<content_type_value>");
                    EncodingUtils.xmlEncode(contentTypeValue, buffer);
                    buffer.append("</content_type_value>");
                    buffer.append("<attachment>");
                    EncodingUtils.xmlEncode(new String(response, "UTF-8"), buffer);
                    buffer.append("</attachment>");
                    buffer.append("</response_attachment>");
                    this.context.addTraceXML("soap_response_attachment", XMLStreamFactory.createXMLStreamReader(new StringReader(buffer.toString())));
                } else {
                    this.context.addTraceXML("soap_response", XMLStreamFactory.createXMLStreamReader(new StringReader(new String(response, "UTF-8"))));
                }
            }
            input = new ByteArrayInputStream(response);
        }
        return input;
    }
}

