/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.soap.impl;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.soap.impl.BusConnectionImpl;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class TrustedSOAPConnectionImpl
extends BusConnectionImpl {
    private ServiceLogger logger;
    protected CAMFactory camFactory;
    private String serviceID;

    public TrustedSOAPConnectionImpl(CAMFactory camFactory, ServiceLogger logger, String cmPath, String dispatcherPath, String serviceID) {
        super(logger, cmPath, dispatcherPath);
        this.camFactory = camFactory;
        this.logger = logger != null ? logger.cloneForClass(TrustedSOAPConnectionImpl.class) : null;
        this.serviceID = serviceID;
    }

    @Override
    protected void writeRequest(SOAPMessage requestMsg, Writer output, boolean includeXmlProlog) throws IOException {
        byte[] bytes;
        SharedByteArrayOutputStream requestOutput = new SharedByteArrayOutputStream(4096);
        BufferedWriter outputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)requestOutput, "UTF-8"));
        super.writeRequest(requestMsg, outputWriter, includeXmlProlog);
        try {
            bytes = this.signRequest(requestOutput.toByteArray());
        }
        catch (CAMCryptoException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("could not sign request", e);
            }
            throw new RuntimeException("Could not sign request");
        }
        output.write(new String(bytes, "UTF-8"));
    }

    private byte[] signRequest(byte[] bytes) throws CAMCryptoException {
        TrustedRequestSession trs = this.camFactory.createTrustedSession();
        return trs.setMessageTrust(this.serviceID, bytes);
    }
}

