/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.soap.impl.bus;

import com.cognos.portal.soap.SOAPMessage;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class BusCommand
extends SOAPMessage {
    public static final String BUS_NAMESPACE_PREFIX = "bus";
    public static final String BUS_NAMESPACE_URI = "http://developer.cognos.com/schemas/bibus/3/";
    public static final String XSI_NAMESPACE_PREFIX = "xsi";
    public static final String XSI_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSD_NAMESPACE_PREFIX = "xsd";
    public static final String XSD_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    private static final String DEFAULT_BUS_HEADER = "<bus:biBusHeader xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"/>";
    protected Object busHeader;

    public void setBusHeader(Object busHeader) {
        this.busHeader = busHeader;
    }

    @Override
    public void writeHeaders(Writer writer) throws IOException {
        if (this.busHeader != null) {
            writer.write(this.busHeader.toString());
        } else {
            writer.write(DEFAULT_BUS_HEADER);
        }
    }

    protected void writeBusElement(String name, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(BUS_NAMESPACE_PREFIX, name, BUS_NAMESPACE_URI);
        writer.setPrefix(BUS_NAMESPACE_PREFIX, BUS_NAMESPACE_URI);
        writer.writeNamespace(BUS_NAMESPACE_PREFIX, BUS_NAMESPACE_URI);
        writer.setPrefix(XSI_NAMESPACE_PREFIX, XSI_NAMESPACE_URI);
        writer.writeNamespace(XSI_NAMESPACE_PREFIX, XSI_NAMESPACE_URI);
        writer.setPrefix(XSD_NAMESPACE_PREFIX, XSD_NAMESPACE_URI);
        writer.writeNamespace(XSD_NAMESPACE_PREFIX, XSD_NAMESPACE_URI);
    }

    protected void writeStartBusElement(String name, String type, XMLStreamWriter writer) throws XMLStreamException {
        this.writeStartBusElement(name, BUS_NAMESPACE_PREFIX, BUS_NAMESPACE_URI, type, writer);
    }

    protected void writeStartBusElement(String name, String typeNSPrefix, String typeNSUri, String type, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(name);
        if (writer.getPrefix(typeNSUri) == null) {
            writer.setPrefix(typeNSPrefix, typeNSUri);
            writer.writeNamespace(typeNSPrefix, typeNSUri);
        }
        writer.writeAttribute(XSI_NAMESPACE_PREFIX, XSI_NAMESPACE_URI, "type", typeNSPrefix + ":" + type);
    }

    protected void writeBusElementWithValue(String name, String type, String value, String valueType, XMLStreamWriter writer) throws XMLStreamException {
        this.writeBusElementWithValue(name, BUS_NAMESPACE_PREFIX, BUS_NAMESPACE_URI, type, value, BUS_NAMESPACE_PREFIX, BUS_NAMESPACE_URI, valueType, writer);
    }

    protected void writeBusElementWithValue(String name, String typeNSPrefix, String typeNSUri, String type, String value, String valueTypeNSPrefix, String valueTypeNSUri, String valueType, XMLStreamWriter writer) throws XMLStreamException {
        this.writeStartBusElement(name, typeNSPrefix, typeNSUri, type, writer);
        this.writeStartBusElement("value", valueTypeNSPrefix, valueTypeNSUri, valueType, writer);
        writer.writeCharacters(value);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void writerArrayElement(String name, String type, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(name);
        writer.writeAttribute(XSI_NAMESPACE_PREFIX, XSI_NAMESPACE_URI, "type", "SOAP-ENC:Array");
        writer.writeAttribute("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/", "arrayType", "bus:" + type + "[]");
    }

    protected void writeArrayElement(String name, String type, int length, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(name);
        writer.writeAttribute(XSI_NAMESPACE_PREFIX, XSI_NAMESPACE_URI, "type", "SOAP-ENC:Array");
        writer.writeAttribute("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/", "arrayType", "bus:" + type + "[" + length + "]");
    }
}

