/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.soap.impl.bus.cm;

import com.cognos.portal.soap.impl.bus.BusCommand;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Query
extends BusCommand {
    List queries;
    QueryRequest currentRequest = new QueryRequest();

    public Query() {
        this.setSOAPAction("http://www.ibm.com/xmlns/prod/cognos/contentManagerService/201904/");
    }

    public void setSearchPath(String searchPath) {
        this.currentRequest.searchPath = searchPath;
    }

    public void addProperty(String property) {
        if (!this.currentRequest.properties.contains(property)) {
            this.currentRequest.properties.add(property);
        }
    }

    public void addRefPropProperty(String refProp, String property) {
        ArrayList<String> refPropProperties;
        if (this.currentRequest.refProps == null) {
            this.currentRequest.refProps = new HashMap();
        }
        if ((refPropProperties = (ArrayList<String>)this.currentRequest.refProps.get(refProp)) == null) {
            refPropProperties = new ArrayList<String>();
            this.currentRequest.refProps.put(refProp, refPropProperties);
        }
        refPropProperties.add(property);
    }

    public void addNewQuery() {
        if (this.queries == null) {
            this.queries = new ArrayList();
            this.queries.add(this.currentRequest);
        }
        this.currentRequest = new QueryRequest();
        this.queries.add(this.currentRequest);
    }

    @Override
    public void writeBody(Writer writer) throws IOException {
        try {
            XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(writer);
            this.writeBusElement("query", xsw);
            if (this.queries == null) {
                this.writeQuery(this.currentRequest, xsw);
            } else {
                this.writerArrayElement("requests", "queryRequest", xsw);
                Iterator it = this.queries.iterator();
                while (it.hasNext()) {
                    this.writeStartBusElement("item", "queryRequest", xsw);
                    this.writeQuery((QueryRequest)it.next(), xsw);
                    xsw.writeEndElement();
                }
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void writeQuery(QueryRequest current, XMLStreamWriter xsw) throws XMLStreamException {
        this.writeStartBusElement("search", "xsd", "http://www.w3.org/2001/XMLSchema", "string", xsw);
        xsw.writeCharacters(current.searchPath);
        xsw.writeEndElement();
        this.writerArrayElement("properties", "propEnum", xsw);
        if (current.properties != null) {
            for (String prop : current.properties) {
                this.writeStartBusElement("item", "propEnum", xsw);
                xsw.writeCharacters(prop);
                xsw.writeEndElement();
            }
        }
        xsw.writeEndElement();
        if (current.refProps != null) {
            this.writerArrayElement("options", "queryOptions", xsw);
            this.writerArrayElement("refProps", "refProp", xsw);
            for (Map.Entry refProp : current.refProps.entrySet()) {
                String name = (String)refProp.getKey();
                List properties = (List)refProp.getValue();
                this.writeStartBusElement("item", "refProp", xsw);
                this.writeStartBusElement("refPropName", "propEnum", xsw);
                xsw.writeCharacters(name);
                xsw.writeEndElement();
                this.writerArrayElement("properties", "propEnum", xsw);
                for (String prop : properties) {
                    this.writeStartBusElement("item", "propEnum", xsw);
                    xsw.writeCharacters(prop);
                    xsw.writeEndElement();
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndElement();
        }
    }

    class QueryRequest {
        private Map refProps;
        private List properties = new ArrayList();
        private String searchPath;

        public QueryRequest() {
            this.properties.add("searchPath");
        }
    }
}

